<?php

namespace App\Http\Controllers;

use App\Models\LiveCallDuration;
use App\Models\TwilioCallCost;
use App\Models\PackageSupportedCountry;
use Auth;
use Carbon\Carbon;
use Illuminate\Http\Request;

class DialerController extends Controller
{
    public function index()
    {
        return view('backend.dialer.index'); // backend.dialer.index
    }

    /**
     * STORE
     */
    public function store(Request $request)
    {

        if (Auth::user()->role == 'agent') { // agent
            if (check_balance(agent_owner_id()) == false) { // check_balance
                // return an error message
                return response()->json([
                    'status' => 'error',
                    'message' => 'You have insufficient balance to make this call.',
                ]);
            }
        }else {
            if (check_balance(Auth::id()) == false) { // check_balance
                // return an error message
                return response()->json([
                    'status' => 'error',
                    'message' => 'You have insufficient balance to make this call.',
                ]);
            }
        }
        
        if (userRoleByAuthId() != 'admin') { // Auth::user()->role
            $request->validate([ // validate
                'dialer_session_uuid' => 'required',
            ], [
                'dialer_session_uuid.required' => 'Dial Session ID is required',
            ]);

            // check the $request->phone has + sign or not
            if (substr($request->phone, 0, 1) != '+') {
                $request->phone = '+'.$request->phone;
            }

            // check country code exists in package
            $phone = $request->phone;
            $phoneUtil = \libphonenumber\PhoneNumberUtil::getInstance();
            try {
                $NumberProto = $phoneUtil->parse($phone, null);

                // Check country code exists in TwilioCallCost
                $check_TwilioCall_Cost = TwilioCallCost::where('code', $NumberProto->getCountryCode())
                                                    ->first();

                if (!$check_TwilioCall_Cost) { // if !$check_TwilioCall_Cost
                    return response()->json([
                        'status' => 'error',
                        'message' => 'Unsupported number.',
                    ]);
                } 

                // check twilio_call_costs_id in package supported countries
                $check_package_supported_countries = PackageSupportedCountry::where('twilio_call_costs_id', $check_TwilioCall_Cost->id)
                                                                                    ->where('package_id', activePackage()) // activePackage()
                                                                                    ->first(); // get package_id

                    if (!$check_package_supported_countries) { // if !$check_package_supported_countries


                    $check_sessoin_id = LiveCallDuration::where('dialer_session_uuid', $request->dialer_session_uuid)
                                                        ->first(); // get dialer_session_uuid

                        if ($check_sessoin_id) { // if $check_sessoin_id
                            $check_sessoin_id->end_at = Carbon::now();
                            $check_sessoin_id->duration = $check_sessoin_id->end_at->diffInSeconds($check_sessoin_id->start_at);
                            $check_sessoin_id->total_deduction = $check_sessoin_id->duration * $check_sessoin_id->app_deduction; // per sec cost * call seconds
                            $check_sessoin_id->save();

                            live_call_deduct_credit($check_sessoin_id->user_id, $check_sessoin_id->dialer_session_uuid); // deduct credit
                        } else { // else $check_sessoin_id
                            $live_call_duration = new LiveCallDuration;
                            $live_call_duration->user_id = Auth::id();
                            $live_call_duration->phone = $request->phone;
                            $live_call_duration->dialer_session_uuid = $request->dialer_session_uuid;
                            $live_call_duration->start_at = Carbon::now();
                            $live_call_duration->app_deduction = call_cost_per_second(get_country_code_from_number($phone)); // per seconds
                            $live_call_duration->save();
                        }

                    // return an success message
                    return response()->json([
                        'status' => 'success',
                        'message' => 'Call duration has been saved.',
                    ]);


                    return response()->json([
                        'status' => 'success',
                        'message' => 'This phone number is not eligble in your package. This call will be charged extra ' . $check_TwilioCall_Cost->teleman_cost .'/min.' . '<br> To cancel this call, make the call end. Thank you.',
                    ]);
                }
                
            } catch (\libphonenumber\NumberParseException $e) { // catch NumberParseException
                // return an error message
            }

            // check country code exists in package::ENDS
            $check_sessoin_id = LiveCallDuration::where('dialer_session_uuid', $request->dialer_session_uuid)
                                                ->first(); // get dialer_session_uuid

            if ($check_sessoin_id) { // if $check_sessoin_id
                $check_sessoin_id->end_at = Carbon::now();
                $check_sessoin_id->duration = $check_sessoin_id->end_at->diffInSeconds($check_sessoin_id->start_at);
                $check_sessoin_id->total_deduction = $check_sessoin_id->duration * $check_sessoin_id->app_deduction;
                $check_sessoin_id->save();

                live_call_deduct_credit($check_sessoin_id->user_id, $check_sessoin_id->dialer_session_uuid); // deduct credit
            } else { // else $check_sessoin_id
                $live_call_duration = new LiveCallDuration;
                $live_call_duration->user_id = Auth::id();
                $live_call_duration->phone = $request->phone;
                $live_call_duration->dialer_session_uuid = $request->dialer_session_uuid;
                $live_call_duration->start_at = Carbon::now();
                $live_call_duration->app_deduction = call_cost_per_second(get_country_code_from_number($phone));
                $live_call_duration->save();
            }
            // return an success message
            return response()->json([
                'status' => 'success',
                'message' => 'Call duration has been saved.',
            ]);
        } else {
            return response()->json([
                'status' => 'success',
                'message' => 'Call duration has been saved.',
            ]);
        }
    }

    /**
     * dialer.country.code.exists.in.package
     */
    public function country_code_exists_in_package(Request $request)
    {

        // check the $request->phone has + sign or not
        if (substr($request->phone, 0, 1) != '+') {
            $request->phone = '+'.$request->phone;
        }

        $phone = $request->phone;
        $phoneUtil = \libphonenumber\PhoneNumberUtil::getInstance();
        try {
            $NumberProto = $phoneUtil->parse($phone, null);

            // Check country code exists in TwilioCallCost
            $check_TwilioCall_Cost = TwilioCallCost::where('code', $NumberProto->getCountryCode())
                                                ->first();

            if (!$check_TwilioCall_Cost) { // if !$check_TwilioCall_Cost
                return response()->json([
                    'status' => 'error',
                    'message' => 'Unsupported number.',
                ]);
            } 

            if (userRoleByAuthId() != 'admin') { // Auth::user()->role
                // check twilio_call_costs_id in package supported countries
                $check_package_supported_countries = PackageSupportedCountry::where('twilio_call_costs_id', $check_TwilioCall_Cost->id)
                                                                            ->where('package_id', activePackage())
                                                                            ->first(); // get package_id
            }else {
                // check twilio_call_costs_id in package supported countries
                $check_package_supported_countries = PackageSupportedCountry::where('twilio_call_costs_id', $check_TwilioCall_Cost->id)
                                                                            ->first(); // get package_id
            }
            

            if (!$check_package_supported_countries) { // if !$check_package_supported_countries
                return response()->json([
                    'status' => 'error',
                    'message' => 'This phone number is not eligble in your package. This call will be charged extra ' . $check_TwilioCall_Cost->teleman_cost . '<br> To cancel this call, make the call end. Thank you.',
                ]);
            }
            
        } catch (\libphonenumber\NumberParseException $e) { // catch NumberParseException
            return response()->json([
                'status' => 'error',
                'message' => 'warning: ' . $e,
            ]);
        }
        
    }
    //ENDS
}
