<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Ivr;
use Auth;
use Log;
use File;
use Twilio\Rest\Client;
use Twilio\TwiML\VoiceResponse;
use Twilio\TwiML;

class IvrController extends Controller
{

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('backend.ivr.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('backend.ivr.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {

        if (demo()) {
            smilify('warning', 'This feature is disabled in demo mode');
            return back();
        }

        // valiadate the form data
        $this->validate($request, [
            'ivr_name' => 'required|max:255',
            'campaign_id' => 'required',
            'audio_file' => 'required|mimes:mp3',
        ],[
            'ivr_name.required' => 'Please enter an IVR name',
            'ivr_name.max' => 'The IVR name may not be greater than 255 characters',
            'campaign_id.required' => 'Please select a campaign',
            'audio_file.required' => 'Please select an audio file',
            'audio_file.mimes' => 'The audio file must be a MP3 file',
        ]);

        // check user campaign already exists
        $campaign_exists = Ivr::where('campaign_id', $request->campaign_id)
                                ->where('user_id', Auth::id())
                                ->first();

        if ($campaign_exists) {
            smilify('warning', 'Campaign IVR already exists');
            return back();
        }

        $file_name = rand(1000, 9999);
        $xml_file = '/public/voices/ivr_voices/'.$file_name.'.xml';

        $ivr = new Ivr;
        $ivr->ivr_name = $request->ivr_name;
        $ivr->campaign_id = $request->campaign_id;
        $ivr->user_id = Auth::id();
        if ($request->hasFile('audio_file')) {
            $ivr->audio_file = audioUpload($request->audio_file, '/ivr_audio');
        } else {
            $ivr->audio_file = null;
        }
        $ivr->key1 = 1;
        $ivr->key1_value = $request->key1_value ?? null;
        $ivr->key2 = 2;
        $ivr->key2_value = $request->key2_value ?? null;
        $ivr->key3 = 3;
        $ivr->key3_value = $request->key3_value ?? null;
        $ivr->key4 = 4;
        $ivr->key4_value = $request->key4_value ?? null;
        $ivr->key5 = 5;
        $ivr->key5_value = $request->key5_value ?? null;
        $ivr->key6 = 6;
        $ivr->key6_value = $request->key6_value ?? null;
        $ivr->key7 = 7;
        $ivr->key7_value = $request->key7_value ?? null;
        $ivr->key8 = 8;
        $ivr->key8_value = $request->key8_value ?? null;
        $ivr->key9 = 9;
        $ivr->key9_value = $request->key9_value ?? null;
        $ivr->key0 = 0;
        $ivr->key0_value = $request->key0_value ?? null;
        $ivr->key_star = 'star';
        $ivr->key_star_value = $request->key_star_value ?? null;
        $ivr->key_hash = 'hash';
        $ivr->key_hash_value = $request->key_hash_value ?? null;
        $ivr->xml_file = hostwithHttp() . $xml_file;
        $ivr->save();

        $gather = collect(); // collect all the gather nodes

        $keys = Ivr::where('id', 1)->first(); // get the keys from the first ivr

        // create the xml file
        $xml =
        '<?xml version="1.0" encoding="UTF-8"?>
        <Response>
            <Play>' . demo_audio_mp3() .'</Play>
            <Gather method="GET" input="speech dtmf" timeout="5" action="http://4df7-103-59-178-232.ngrok.io/cavy/ivr/log/1" numDigits="1"></Gather>
            <Gather method="GET" input="speech dtmf" timeout="5" action="http://4df7-103-59-178-232.ngrok.io/cavy/ivr/log/2" numDigits="2"></Gather>
            <Gather method="GET" input="speech dtmf" timeout="5" action="http://4df7-103-59-178-232.ngrok.io/cavy/ivr/log/3" numDigits="3"></Gather>
            <Gather method="GET" input="speech dtmf" timeout="5" action="http://4df7-103-59-178-232.ngrok.io/cavy/ivr/log/4" numDigits="4"></Gather>
            <Gather method="GET" input="speech dtmf" timeout="5" action="http://4df7-103-59-178-232.ngrok.io/cavy/ivr/log/5" numDigits="5"></Gather>
            <Gather method="GET" input="speech dtmf" timeout="5" action="http://4df7-103-59-178-232.ngrok.io/cavy/ivr/log/6" numDigits="6"></Gather>
            <Gather method="GET" input="speech dtmf" timeout="5" action="http://4df7-103-59-178-232.ngrok.io/cavy/ivr/log/7" numDigits="7"></Gather>
            <Gather method="GET" input="speech dtmf" timeout="5" action="http://4df7-103-59-178-232.ngrok.io/cavy/ivr/log/8" numDigits="8"></Gather>
            <Gather method="GET" input="speech dtmf" timeout="5" action="http://4df7-103-59-178-232.ngrok.io/cavy/ivr/log/9" numDigits="9"></Gather>
            <Gather method="GET" input="speech dtmf" timeout="5" action="http://4df7-103-59-178-232.ngrok.io/cavy/ivr/log/0" numDigits="0"></Gather>
            <Gather method="GET" input="speech dtmf" timeout="5" action="http://4df7-103-59-178-232.ngrok.io/cavy/ivr/log/star" numDigits="*"></Gather>
            <Gather method="GET" input="speech dtmf" timeout="5" action="http://4df7-103-59-178-232.ngrok.io/cavy/ivr/log/hash" numDigits="#"></Gather>
            <Say>Thank You, Goodbye!</Say>
        </Response>';

        File::put(base_path($xml_file), $xml); // save the xml file

        smilify('success', 'IVR created successfully');
        return back();
    }

    /**
     * calling
     */
    public function calling($campaign_id, $user_id)
    {
        $ivr = Ivr::where('campaign_id', $campaign_id) // campaign id
                    ->where('user_id', $user_id) // user id
                    ->first(); // get the first record
        // get provider from campaign
        $provider = campaign_provider_info($campaign_id); // get provider info

        $account_sid = $provider->account_sid; // get account sid
        $auth_token = $provider->auth_token; // get auth token

        $twilio = new Client($account_sid, $auth_token); // create new twilio client
        $call = $twilio->calls
                    ->create("+8801316170434", // to
                                "+12029000601", // from
                                [
                                    "twiml" => "<Response>
                                                <Say>Hello</Say>
                                                    <Gather input='dtmf' timeout='5' method='GET' numDigits='1' action='http://bd04-103-59-178-232.ngrok.io/cavy/ivr/log/1'>
                                                        <Say>Please press 1 or say sales for sales.</Say>
                                                    </Gather>
                                                    <Gather input='dtmf' timeout='5' method='GET' numDigits='2' action='http://bd04-103-59-178-232.ngrok.io/cavy/ivr/log/2'>
                                                        <Say>Please press 2 or say sales for sales.</Say>
                                                    </Gather>
                                                </Response>"
                                ]
                    );
  
        return $call->sid;
    }

    /**
     * response_log
     */
    public function response_log($digit)
    {
        try {
            Log::info('Pressed button: ' . $digit);
        } catch (\Throwable $th) {
            Log::info('error: ' . $th->getMessage());
        }
        
    }
    

    //ENDS
}
