<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class Campaign extends Model
{
    use HasFactory;

    /**
     * PROVIDER
     */
    public function provider()
    {
        return $this->hasOne(Provider::class, 'id', 'provider');
    }

    /**
     * CampaignSchedule
     */
    public function campaign_schedules()
    {
        return $this->hasMany(CampaignSchedule::class, 'campaign_id', 'id');
    }

    /**
     * CampaignVoice
     */
    public function campaign_voices()
    {
        return $this->hasMany(CampaignVoice::class, 'campaign_id', 'id');
    }

    /**
     * CampaignVoiceStatusLog
     */
    public function campaign_voice_status_logs()
    {
        return $this->hasMany(CampaignVoiceStatusLog::class, 'campaign_id', 'id');
    }

    /**
     * relation with ivr
     */
    public function ivr()
    {
        return $this->hasOne(Ivr::class, 'campaign_id', 'id');
    }

    /**
     * Agent
     */
    public function scopeHasAgent($query)
    {
        if (Auth::user()->role == 'agent') {
            return $query->where('user_id', agent_owner_id());
        }
        return $query->where('user_id', Auth::user()->id);
    }
}
