"use strict";
var env = "customization",
    activeTheme = "core",
    themes = {
        core: {
            primary: "#8c8cf9",
            secondary: "#7F00FF",
            accent: "#ad5cff"
        },
        purple: {
            primary: "#837FCB",
            secondary: "#5551a8",
            accent: "#6A3144"
        },
        teal: {
            primary: "#00D1B2",
            secondary: "#7F00FF",
            accent: "#536dfe"
        },
        green: {
            primary: "#00b289",
            secondary: "#00b289",
            accent: "#00b289"
        },
        azur: {
            primary: "#039be5",
            secondary: "#0084c4",
            accent: "#00D1B2"
        },
        blue: {
            primary: "#0f7cff",
            secondary: "#00edb1",
            accent: "#0062dd"
        },
        night: {
            primary: "#4A00E0",
            secondary: "#23a6d5",
            accent: "#8E2DE2"
        },
        yellow: {
            primary: "#f5c62c",
            secondary: "#8c8cf9",
            accent: "#fe8c00"
        },
        orange: {
            primary: "#f83600",
            secondary: "#8c8cf9",
            accent: "#fe8c00"
        },
        red: {
            primary: "#ff5555",
            secondary: "#ff3131",
            accent: "#1ddba5"
        }
    };
"use strict";

function changeDemoImages() {
    $("*[data-demo-src]").each(function () {
        var a = $(this).attr("data-demo-src");
        void 0 !== a && $(this).attr("src", a)
    }), $("*[data-demo-background]").each(function () {
        var a = $(this).attr("data-demo-background");
        $(this).attr("data-background", a)
    })
}

function initBackgroundImages() {
    $(".has-background-image").length && $(".has-background-image").each(function () {
        var a = $(this).attr("data-background");
        void 0 !== a && $(this).css("background-image", "url(" + a + ")")
    })
}

function initParallax() {
    function a() {
        var a = $("body").height();
        $(".content-b").each(function (t) {
            $(this).innerHeight() > a && $(this).closest(".fullscreen").addClass("overflow")
        })
    }

    function t() {
        var a = $(window).height();
        $(".parallax").each(function (t) {
            var i = $(this),
                e = i.width(),
                o = i.height(),
                n = i.attr("data-img-width"),
                s = i.attr("data-img-height"),
                r = n / s,
                l = 0;
            l = l || 0;
            var c = 0;
            i.hasClass("parallax") && !$("html").hasClass("touch") && (c = a - o), e > (n = (s = o + c + l) * r) && (s = (n = e) / r), i.data("resized-imgW", n), i.data("resized-imgH", s), i.css("background-size", n + "px " + s + "px")
        })
    }

    function i(a) {
        var t = $(window).height(),
            i = $(window).scrollTop(),
            e = i + t,
            o = (i + e) / 2;
        $(".parallax").each(function (a) {
            var n = $(this),
                s = n.height(),
                r = n.offset().top,
                l = r + s;
            if (e > r && i < l) {
                var c = n.data("resized-imgH"),
                    h = -c + t,
                    d = s < t ? c - s : c - t;
                r -= d, l += d;
                var u = 0;
                u = $(".parallax").is(".titlebar") ? 0 + (h - 0) * (o - r) / (l - r) * 2 : 0 + (h - 0) * (o - r) / (l - r);
                var m = n.attr("data-oriz-pos");
                m = m || "50%", $(this).css("background-position", m + " " + u + "px")
            }
        })
    }
    $(".parallax").prepend('<div class="parallax-overlay"></div>'), $(".parallax").each(function () {
        var a = $(this).attr("data-background"),
            t = $(this).attr("data-color"),
            i = $(this).attr("data-color-opacity"),
            e = $(this).attr("data-position-x");
        void 0 !== a && $(this).css("background-image", "url(" + a + ")"), void 0 !== t && $(this).find(".parallax-overlay").css("background-color", "" + t), void 0 !== i && $(this).find(".parallax-overlay").css("opacity", "" + i), void 0 !== e && $(this).css("background-position-x", "" + e)
    }), "ontouchstart" in window && (document.documentElement.className = document.documentElement.className + " touch"), $("html").hasClass("touch") || $(".parallax").css("background-attachment", "fixed"), $(window).resize(a), a(), $(window).resize(t), $(window).focus(t), t(), $("html").hasClass("touch") || ($(window).resize(i), $(window).scroll(i), i()), navigator.userAgent.match(/Trident\/7\./) && $("body").on("mousewheel", function () {
        event.preventDefault();
        var a = event.wheelDelta,
            t = window.pageYOffset;
        window.scrollTo(0, t - a)
    })
}

function initScrollspyNav() {
    $("li.scrollnav-item").on("click", function () {
        $("li.scrollnav-item.is-active").removeClass("is-active"), $(this).addClass("is-active")
    })
}

function initGitem() {
    $(".g-item").on("mouseenter", function () {
        $(this).addClass("gelatine")
    }), $(".g-item").on("mouseleave", function () {
        $(this).removeClass("gelatine")
    })
}

function initScrollToHash() {
    $('a[href*="#"]:not([href="#"])').click(function () {
        if (location.pathname.replace(/^\//, "") === this.pathname.replace(/^\//, "") && location.hostname === this.hostname) {
            var a = $(this.hash);
            if (a = a.length ? a : $("[name=" + this.hash.slice(1) + "]"), $(".nav-primary").hasClass("nav-primary-fixed")) {
                if (a.length) return $("html, body").animate({
                    scrollTop: a.offset().top - 40
                }, 750), !1
            } else if (a.length) return $("html, body").animate({
                scrollTop: a.offset().top - 80
            }, 750), !1
        }
    })
}

function initAnchorScroll() {
    function a(a) {
        if (0 == (a = "string" == typeof a ? a : $(this).attr("href")).indexOf("#")) {
            var t = $(a);
            if (t.length && ($("html, body").animate({
                    scrollTop: t.offset().top - 50
                }), history && "pushState" in history)) return history.pushState({}, document.title, window.location.pathname + a), !1
        }
    }
    a(window.location.hash), $("body").on("click", ".scroll-link", a)
}

function initScrollReveal() {
    $(".is-title-reveal, .is-feature-reveal ").length && (window.sr = ScrollReveal(), sr.reveal(".is-title-reveal", {
        origin: "bottom",
        distance: "20px",
        duration: 600,
        delay: 100,
        rotate: {
            x: 0,
            y: 0,
            z: 0
        },
        opacity: 0,
        scale: 1,
        easing: "cubic-bezier(0.215, 0.61, 0.355, 1)",
        container: window.document.documentElement,
        mobile: !0,
        reset: !1,
        useDelay: "always",
        viewFactor: .2
    }), sr.reveal(".is-feature-reveal", {
        origin: "bottom",
        distance: "20px",
        duration: 600,
        delay: 100,
        rotate: {
            x: 0,
            y: 0,
            z: 0
        },
        opacity: 0,
        scale: 1,
        easing: "cubic-bezier(0.215, 0.61, 0.355, 1)",
        container: window.document.documentElement,
        mobile: !0,
        reset: !0,
        useDelay: "always",
        viewFactor: .2
    }, 160))
}
"use strict";

function initPageLoader() {
    $(".pageloader").toggleClass("is-active"), $(window).on("load", function () {
        var e = setTimeout(function () {
            $(".pageloader").toggleClass("is-active"), $(".infraloader").toggleClass("is-active"), clearTimeout(e), setTimeout(function () {
                $(".rounded-hero, .car-hero .left-image, .car-hero .right-image").addClass("is-active"), $(".shadow-overlay").fadeOut(1e3, function () {
                    $(this).remove()
                })
            }, 350)
        }, 700)
    })
}
"use strict";

function initNavbar() {
    $(".navbar-wrapper.navbar-fade.navbar-light").length && ($(".navbar-wrapper.navbar-fade").wrap('<div class="navbar-placeholder"></div>'), $(".navbar-placeholder").height(jQuery(".navbar-wrapper.navbar-fade").outerHeight()), $(window).on("scroll", function () {
        $(window).scrollTop() > 65 ? $(".navbar-wrapper.navbar-fade.is-transparent").removeClass("is-transparent navbar-light").addClass("navbar-faded") : $(".navbar-wrapper").removeClass("navbar-faded").addClass("is-transparent navbar-light")
    })), $(".navbar-wrapper.navbar-fade.navbar-default").length && ($(".navbar-wrapper.navbar-fade").wrap('<div class="navbar-placeholder"></div>'), $(".navbar-placeholder").height(jQuery(".navbar-wrapper.navbar-fade").outerHeight()), $(window).on("scroll", function () {
        $(window).scrollTop() > 65 ? $(".navbar-wrapper.navbar-fade.is-transparent").removeClass("is-transparent").addClass("navbar-faded") : $(".navbar-wrapper").removeClass("navbar-faded").addClass("is-transparent")
    })), $(".is-cloned").length && $(window).scroll(function () {
        $(window).scrollTop() > 50 ? $(".is-cloned").addClass("is-active") : $(".is-cloned").removeClass("is-active")
    }), $(window).on("scroll", function () {
        $(window).scrollTop()
    }), $(".navbar-light").length && $(window).on("scroll", function () {
        $(window).scrollTop() > 80 ? $(".button-signup").removeClass("light-btn").addClass("primary-btn") : $(".button-signup").removeClass("primary-btn").addClass("light-btn")
    })
}

function initMobileMenu() {
    $(".custom-burger").on("click", function () {
        $(this).toggleClass("is-active"), $(this).closest(".navbar").find(".navbar-menu").hasClass("is-active") ? ($(this).closest(".navbar").find(".navbar-menu").removeClass("is-active"), $(this).closest(".navbar-fade.navbar-light").removeClass("is-dark-mobile")) : ($(this).closest(".navbar").find(".navbar-menu").addClass("is-active"), $(this).closest(".navbar-fade.navbar-light").addClass("is-dark-mobile")), $(this).closest(".navbar-faded").hasClass("is-dark-mobile") && $(this).closest(".navbar-faded").removeClass("is-dark-mobile"), $(this).closest(".navbar.is-static").toggleClass("is-dark-mobile")
    }), $(".custom-burger").on("click", function () {
        $(this).find(".icon-box-toggle").toggleClass("active")
    })
}

function initLandingNavbar() {
    $(window).on("scroll", function () {
        $(window).scrollTop() > 65 ? ($(".navbar-landing").removeClass("is-faded"), $(".navbar-landing").removeClass("is-mobile")) : ($(".navbar-landing").addClass("is-faded"), $(".navbar-landing .navbar-menu").hasClass("is-active") && $(".navbar-landing").addClass("is-mobile"))
    })
}

function initLandingMobileMenu() {
    $(".navbar-landing .navbar-burger").on("click", function () {
        var a = $(window).scrollTop();
        $(this).toggleClass("is-active"), a < 65 ? $(".navbar-landing .navbar-menu").hasClass("is-active") ? ($(".navbar-landing .navbar-brand img").toggleClass("is-hidden"), $(".navbar-landing .navbar-menu").slideToggle().removeClass("is-active"), setTimeout(function () {
            $(".navbar-landing").removeClass("is-mobile")
        }, 400)) : ($(".navbar-landing .navbar-menu").slideToggle().addClass("is-active"), $(".navbar.navbar-landing ").addClass("is-mobile"), $(".navbar-landing .navbar-brand img").toggleClass("is-hidden")) : $(".navbar-landing .navbar-menu").hasClass("is-active") ? $(".navbar-landing .navbar-menu").slideToggle().removeClass("is-active") : $(".navbar-landing .navbar-menu").slideToggle().addClass("is-active")
    })
}

function initEcommerceNavbar() {
    $(".is-cart .cart-button").on("click", function () {
        $(this).closest(".is-cart").find(".shopping-cart").addClass("is-active"), setTimeout(function () {
            $(".is-cart .navbar-cart-loader").removeClass("is-active")
        }, 800)
    }), $(".is-wishlist .wishlist-button").on("click", function () {
        $(this).closest(".is-wishlist").find(".shopping-wishlist").addClass("is-active"), setTimeout(function () {
            $(".is-wishlist .navbar-cart-loader").removeClass("is-active")
        }, 800)
    }), $(document).click(function (a) {
        var s = a.target;
        $(s).is(".is-cart .cart-button") || $(s).parents().is(".is-cart") || ($(".shopping-cart").removeClass("is-active"), setTimeout(function () {
            $(".is-cart .navbar-cart-loader").addClass("is-active")
        }, 300))
    }), $(document).click(function (a) {
        var s = a.target;
        $(s).is(".is-wishlist .wishlist-button") || $(s).parents().is(".is-wishlist") || ($(".shopping-wishlist").removeClass("is-active"), setTimeout(function () {
            $(".is-wishlist .navbar-cart-loader").addClass("is-active")
        }, 300))
    })
}
"use strict";

function initSidebar() {
    $(".navigation-menu > li.has-children a.parent-link").on("click", function (i) {
        i.preventDefault(), $(this).parent().hasClass("active") ? ($(this).next().slideToggle(), $(".navigation-menu li").removeClass("active")) : ($(".navigation-menu li ul").slideUp(), $(this).next().slideToggle(), $(".navigation-menu li").removeClass("active"), $(this).parent().addClass("active"))
    }), $(".category-link").on("click", function () {
        $(".category-link.is-active").removeClass("is-active"), $(this).addClass("is-active")
    }), $(".hamburger-btn").on("click", function () {
        $("#navigation-trigger .menu-toggle .icon-box-toggle, .navigation-close .menu-toggle .icon-box-toggle, .navigation-trigger .menu-toggle .icon-box-toggle, .navigation-close .menu-toggle .icon-box-toggle").toggleClass("active")
    }), $("#navigation-trigger, .navigation-trigger, .navigation-close").on("click", function () {
        $(".side-navigation-menu").toggleClass("is-active")
    }), $(".category-link").on("click", function () {
        var i = $(this).attr("data-navigation-menu");
        $(".navigation-menu-wrapper").addClass("is-hidden"), $("#" + i).removeClass("is-hidden")
    }), $(".side-navigation-menu").on("mouseenter", function () {
        $("#navigation-trigger").css("opacity", "0"), $(".navigation-close").css("opacity", "1")
    }), $(".side-navigation-menu").on("mouseleave", function () {
        $("#navigation-trigger").css("opacity", "1"), $(".navigation-close").css("opacity", "0")
    })
}
"use strict";
$(document).ready(function (n) {
    n("#bulkit-landing").length && (n(".navbar-light").length && n(window).on("scroll", function () {
        n(window).scrollTop() > 80 ? n(".button-signup").removeClass("light-btn").addClass("secondary-btn") : n(".button-signup").removeClass("secondary-btn").addClass("light-btn")
    }), function () {
        for (var n = 0, t = ["ms", "moz", "webkit", "o"], e = 0; e < t.length && !window.requestAnimationFrame; ++e) window.requestAnimationFrame = window[t[e] + "RequestAnimationFrame"], window.cancelAnimationFrame = window[t[e] + "CancelAnimationFrame"] || window[t[e] + "CancelRequestAnimationFrame"];
        window.requestAnimationFrame || (window.requestAnimationFrame = function (t, e) {
            var i = (new Date).getTime(),
                o = Math.max(0, 16 - (i - n)),
                a = window.setTimeout(function () {
                    t(i + o)
                }, o);
            return n = i + o, a
        }), window.cancelAnimationFrame || (window.cancelAnimationFrame = function (n) {
            clearTimeout(n)
        })
    }(), function () {
        var n, t, e, i, o, a, r = !0;

        function d() {
            r = !(document.body.scrollTop > t)
        }

        function l() {
            n = window.innerWidth, t = window.innerHeight, e.style.height = t + "px", i.width = n, i.height = t
        }

        function s() {
            if (r)
                for (var e in o.clearRect(0, 0, n, t), a) a[e].draw();
            requestAnimationFrame(s)
        }

        function w() {
            var e = this;

            function i() {
                e.pos.x = Math.random() * n, e.pos.y = t + 100 * Math.random(), e.alpha = .1 + .3 * Math.random(), e.scale = .3 + .3 * Math.random(), e.velocity = Math.random()
            }
            e.pos = {}, i(), console.log(e), this.draw = function () {
                e.alpha <= 0 && i(), e.pos.y -= e.velocity, e.alpha -= 5e-4, o.beginPath(), o.arc(e.pos.x, e.pos.y, 10 * e.scale, 0, 2 * Math.PI, !1), o.fillStyle = "rgba(255,255,255," + e.alpha + ")", o.fill()
            }
        }! function () {
            n = window.innerWidth, t = window.innerHeight, {
                x: 0,
                y: t
            }, (e = document.getElementById("bulkit-landing")).style.height = t + "px", (i = document.getElementById("demo-canvas")).width = n, i.height = t, o = i.getContext("2d"), a = [];
            for (var r = 0; r < .5 * n; r++) {
                var d = new w;
                a.push(d)
            }
            s()
        }(), window.addEventListener("scroll", d), window.addEventListener("resize", l)
    }())
});
"use strict";

function initDemo() {
    if ($("pre code").each(function (s, i) {
            hljs.highlightBlock(i)
        }), $("#scrollnav").length) {
        new Waypoint.Sticky({
            element: $("#scrollnav")[0]
        });
        $(".scrollnav-tabs").scrollspy({
            offset: -25,
            activeClass: "is-active"
        })
    }
    $(".accordion-wrapper .trigger a").on("click", function () {
        $(this).html('<i class="im im-icon-Coding is-icon-2x"></i> HIDE CODE<i class="im im-icon-Add"></i>'), $(".trigger.active a").html('<i class="im im-icon-Coding is-icon-2x"></i> SHOW CODE<i class="im im-icon-Add"></i>')
    }), $("#buttons").length && new Vivus("buttons", {
        duration: 300,
        file: "assets/img/graphics/components/buttons.svg"
    }), $("#tabs-ill").length && new Vivus("tabs-ill", {
        duration: 300,
        file: "assets/img/graphics/components/tabs.svg"
    }), $("#inputs-ill").length && new Vivus("inputs-ill", {
        duration: 300,
        file: "assets/img/graphics/components/inputs.svg"
    }), $("#cards-ill").length && new Vivus("cards-ill", {
        duration: 300,
        file: "assets/img/graphics/components/cards.svg"
    }), $("#modals-ill").length && new Vivus("modals-ill", {
        duration: 300,
        file: "assets/img/graphics/components/modals.svg"
    }), $("#accordion-ill").length && new Vivus("accordion-ill", {
        duration: 300,
        file: "assets/img/graphics/components/accordion.svg"
    }), $("#dropdowns-ill").length && new Vivus("dropdowns-ill", {
        duration: 300,
        file: "assets/img/graphics/components/dropdowns.svg"
    }), $("#lists-ill").length && new Vivus("lists-ill", {
        duration: 300,
        file: "assets/img/graphics/components/lists.svg"
    }), $("#badges-ill").length && new Vivus("badges-ill", {
        duration: 300,
        file: "assets/img/graphics/components/badges.svg"
    }), $("#popups-ill").length && new Vivus("popups-ill", {
        duration: 300,
        file: "assets/img/graphics/components/popups.svg"
    }), $("#tables-ill").length && new Vivus("tables-ill", {
        duration: 300,
        file: "assets/img/graphics/components/tables.svg"
    }), $("#timeline-ill").length && new Vivus("timeline-ill", {
        duration: 300,
        file: "assets/img/graphics/components/timeline.svg"
    }), $("#boxes-ill").length && new Vivus("boxes-ill", {
        duration: 300,
        file: "assets/img/graphics/components/boxes.svg"
    }), $("#messages-ill").length && new Vivus("messages-ill", {
        duration: 300,
        file: "assets/img/graphics/components/messages.svg"
    }), $("#calendar-ill").length && new Vivus("calendar-ill", {
        duration: 300,
        file: "assets/img/graphics/components/calendar.svg"
    }), $("#controls-ill").length && new Vivus("controls-ill", {
        duration: 300,
        file: "assets/img/graphics/components/controls.svg"
    }), $("#forms-ill").length && new Vivus("forms-ill", {
        duration: 300,
        file: "assets/img/graphics/components/forms.svg"
    }), $("#steps-ill").length && new Vivus("steps-ill", {
        duration: 300,
        file: "assets/img/graphics/components/steps.svg"
    }), $("#uploader-ill").length && new Vivus("uploader-ill", {
        duration: 300,
        file: "assets/img/graphics/components/uploader.svg"
    }), $("#icons-ill").length && new Vivus("icons-ill", {
        duration: 300,
        file: "assets/img/graphics/components/icons.svg"
    }), $("#iconpicker-ill").length && new Vivus("iconpicker-ill", {
        duration: 300,
        file: "assets/img/graphics/components/iconpicker.svg"
    }), $("#features-ill").length && new Vivus("features-ill", {
        duration: 300,
        file: "assets/img/graphics/components/features.svg"
    }), $("#pricing-ill").length && new Vivus("pricing-ill", {
        duration: 300,
        file: "assets/img/graphics/components/pricing.svg"
    }), $("#team-ill").length && new Vivus("team-ill", {
        duration: 300,
        file: "assets/img/graphics/components/team.svg"
    }), $("#testimonials-ill").length && new Vivus("testimonials-ill", {
        duration: 300,
        file: "assets/img/graphics/components/testimonials.svg"
    }), $("#clients-ill").length && new Vivus("clients-ill", {
        duration: 300,
        file: "assets/img/graphics/components/clients.svg"
    }), $("#counters-ill").length && new Vivus("counters-ill", {
        duration: 300,
        file: "assets/img/graphics/components/counters.svg"
    }), $("#carousel-ill").length && new Vivus("carousel-ill", {
        duration: 300,
        file: "assets/img/graphics/components/carousel.svg"
    }), $("#grid-ill").length && new Vivus("grid-ill", {
        duration: 300,
        file: "assets/img/graphics/components/grid.svg"
    }), $("#footer-ill").length && new Vivus("footer-ill", {
        duration: 300,
        file: "assets/img/graphics/components/footer.svg"
    }), $("#typography-ill").length && new Vivus("typography-ill", {
        duration: 300,
        file: "assets/img/graphics/components/typography.svg"
    }), $("#colors-ill").length && new Vivus("colors-ill", {
        duration: 300,
        file: "assets/img/graphics/components/colors.svg"
    }), $("#faqs-ill").length && new Vivus("faqs-ill", {
        duration: 300,
        file: "assets/img/graphics/components/faq.svg"
    }), $("#cta-ill").length && new Vivus("cta-ill", {
        duration: 300,
        file: "assets/img/graphics/components/cta.svg"
    }), $("#posts-ill").length && new Vivus("posts-ill", {
        duration: 300,
        file: "assets/img/graphics/components/posts.svg"
    }), $("#videos-ill").length && new Vivus("videos-ill", {
        duration: 300,
        file: "assets/img/graphics/components/videos.svg"
    }), $(".nav-switch").length && ($("#nav-solid").on("click", function () {
        $("#demo-nav").removeClass("navbar-inverse").addClass("is-solid"), $("#demo-nav .button-cta").addClass("secondary-btn").removeClass("light-btn"), $("#demo-nav .navbar-brand img").attr("src", "assets/img/logos/bulkit-purple.svg")
    }), $("#nav-reverse").on("click", function () {
        $("#demo-nav").addClass("navbar-inverse is-reverse").removeClass("is-solid is-blue is-purple is-red")
    }), $("#nav-blue").on("click", function () {
        $("#demo-nav").addClass("navbar-inverse is-blue").removeClass("is-solid is-reverse is-purple is-red")
    }), $("#nav-purple").on("click", function () {
        $("#demo-nav").addClass("navbar-inverse is-purple").removeClass("is-solid is-reverse is-blue is-red")
    }), $("#nav-red").on("click", function () {
        $("#demo-nav").addClass("navbar-inverse is-red").removeClass("is-solid is-reverse is-blue is-purple")
    }), $(".is-variation").on("click", function () {
        $("#demo-nav .button-cta").addClass("light-btn").removeClass("secondary-btn"), $("#demo-nav .navbar-brand img").attr("src", "assets/img/logos/bulkit-white.svg")
    }))
}
"use strict";

function initThemeSwitcher() {
    var e = "is-theme-core is-theme-teal is-theme-green is-theme-blue is-theme-azur is-theme-night is-theme-purple is-theme-yellow is-theme-orange is-theme-red";
    if ($(window).on("scroll", function () {
            $(window).scrollTop() >= 60 ? $("#style-switcher").addClass("visible") : $("#style-switcher").removeClass("visible")
        }), $("#style-switcher input").on("change", function () {
            var s = $(this).attr("id");
            $("#theme-sheet").attr("href", "assets/css/" + s + ".css"), $("body").removeClass(e).addClass("is-theme-" + s), activeTheme = s, $("[data-base-url]").each(function () {
                var e = $(this).attr("data-base-url"),
                    t = $(this).attr("data-extension");
                $(this).attr("src", e + "-" + s + t)
            }), $(".switcher-logo").attr("src", "assets/img/logos/logo/bulkit-" + s + ".svg"), $(".switcher-logo-w").attr("src", "assets/img/logos/logo/bulkit-" + s + "-w.svg"), $(".switcher-logo-square").attr("src", "assets/img/logos/logo/bulkit-square-" + s + ".svg")
        }), $(".switcher-close").on("click", function () {
            $("#style-switcher").addClass("away")
        }), "development" === env && $("[data-page-theme]").length) {
        $("body").append('\n        <div class="shadow-overlay" style="position:fixed;top:0;left:0;width:100%;height:100%;background:#fff;pointer-events:none;z-index:9999;"></div>\n      ');
        var s = $("[data-page-theme]").attr("data-page-theme");
        $("#theme-sheet").attr("href", "assets/css/" + s + ".css"), $("body").removeClass(e).addClass("is-theme-" + s), activeTheme = s, $("[data-base-url]").each(function () {
            var e = $(this).attr("data-base-url"),
                t = $(this).attr("data-extension");
            $(this).attr("src", e + "-" + s + t)
        }), $(".switcher-logo").attr("src", "assets/img/logos/logo/bulkit-" + s + ".svg"), $(".switcher-logo-w").attr("src", "assets/img/logos/logo/bulkit-" + s + "-w.svg"), $(".switcher-logo-square").attr("src", "assets/img/logos/logo/bulkit-square-" + s + ".svg"), $("#style-switcher #" + s).prop("checked", !0)
    }
}
"use strict";

function initAnimations() {
    if ($("#features-1").length) new Waypoint({
        element: document.getElementById("features-1"),
        handler: function (t) {
            $(".shadow-side-image").addClass("is-active")
        },
        offset: 150
    });
    var t = document.querySelector(".primary-circle"),
        e = document.querySelector(".primary-bold-circle"),
        i = document.querySelector(".accent-circle");
    if ($(".primary-circle, .primary-bold-circle, .accent-circle").length && anime({
            targets: [t, e, i],
            translateY: [{
                value: 800,
                duration: 500
            }]
        }), $("#features-2").length) new Waypoint({
        element: document.getElementById("features-2"),
        handler: function (n) {
            anime({
                targets: t,
                translateY: [{
                    value: 0,
                    duration: 1100
                }]
            }), anime({
                targets: e,
                translateY: [{
                    value: 0,
                    duration: 1100,
                    delay: 200
                }]
            }), anime({
                targets: i,
                translateY: [{
                    value: 0,
                    duration: 1100,
                    delay: 400
                }]
            })
        },
        offset: 150
    });
    if ($("#features-3").length) new Waypoint({
        element: document.getElementById("features-3"),
        handler: function (t) {
            $("#features-3 .side-image").removeClass("is-pulled")
        },
        offset: 150
    })
}

function initCanvas() {
    if ($("#geo-canvas").length) {
        var t = document.getElementById("geo-canvas"),
            e = t.getContext("2d"),
            i = function () {
                t.width = t.clientWidth, t.height = t.clientHeight
            };
        window.addEventListener("resize", i), i();
        for (var n = [], a = {
                o: function (t, e, i, n, a) {
                    return {
                        x: t,
                        y: e,
                        r: 12 * i,
                        w: 5 * i,
                        dx: n,
                        dy: a,
                        draw: function (e, i) {
                            this.x += this.dx, this.y += this.dy, e.beginPath(), e.arc(this.x + 3 * +Math.sin((50 + t + i / 10) / 100), this.y + 4 * +Math.sin((45 + t + i / 10) / 100), this.r, 0, 2 * Math.PI, !1), e.lineWidth = this.w, e.strokeStyle = "#fff", e.stroke()
                        }
                    }
                },
                x: function (t, e, i, n, a, o, r) {
                    return {
                        x: t,
                        y: e,
                        s: 20 * i,
                        w: 5 * i,
                        r: r = r || 0,
                        dx: n,
                        dy: a,
                        dr: o,
                        draw: function (e, i) {
                            this.x += this.dx, this.y += this.dy, this.r += this.dr;
                            var n = this,
                                a = function (t, i, a, o, r, s) {
                                    s = s || 0, e.beginPath(), e.moveTo(-s + n.s / 2 * t, s + n.s / 2 * i), e.lineTo(-s + n.s / 2 * a, s + n.s / 2 * o), e.lineWidth = n.w, e.strokeStyle = r, e.stroke()
                                };
                            e.save(), e.translate(this.x + 5 * Math.sin((t + i / 10) / 100), this.y + 2 * Math.sin((10 + t + i / 10) / 100)), e.rotate(this.r * Math.PI / 180), a(-1, -1, 1, 1, "#fff"), a(1, -1, -1, 1, "#fff"), e.restore()
                        }
                    }
                }
            }, o = 0; o < t.width; o++)
            for (var r = 0; r < t.height; r++)
                if (1 == Math.round(8e3 * Math.random())) {
                    var s = (5 * Math.random() + 1) / 10;
                    1 == Math.round(Math.random()) ? n.push(a.o(o, r, s, 0, 0)) : n.push(a.x(o, r, s, 0, 0, (3 * Math.random() - 1) / 10, 360 * Math.random()))
                } setInterval(function () {
            e.clearRect(0, 0, t.width, t.height);
            var i = (new Date).getTime();
            for (var a in n) n[a].draw(e, i)
        }, 10)
    }
}

function initAnimatedSvg() {
    $("#chat-widget-ui, #chat-ui").length && (new Vivus("chat-widget-ui", {
        duration: 150,
        file: "assets/img/graphics/compositions/chat-widget-core.svg"
    }), new Vivus("chat-ui", {
        duration: 150,
        file: "assets/img/graphics/compositions/chat-profile-core.svg"
    }))
}

function initChatWidget() {
    $(window).on("scroll", function () {
        $(window).scrollTop() >= 100 ? $("#bulchat").addClass("visible") : $("#bulchat").removeClass("visible")
    }), $("#bulchat div, .close-chat img").on("click", function () {
        $("#chat-widget").slideToggle(), $(".chat-widget-body").toggleClass("is-opened is-closed"), $("#bulchat div").toggleClass("close open"), $("#bulchat, .close-chat img").toggleClass("close open")
    })
}

function initParticles() {
    var t = document.getElementById("particles"),
        e = ["50%", "0%"],
        i = ["#FF6B6B", "#FFE66D", "#4472CA"];
    if ($("#particles").length) {
        function n(e) {
            var n = e.clientX,
                a = e.clientY,
                o = Math.floor(3 * Math.random()),
                r = document.createElement("div");
            r.style.position = "absolute", r.style.marginLeft = n + "px", r.style.marginTop = a + "px", r.style.width = "10px", r.style.borderTop = "5px solid transparent", r.style.borderRight = "5px solid transparent", r.style.borderLeft = "5px solid transparent", r.style.borderBottom = "10px solid " + i[o], r.style.animation = "move 5s ease-in infinite", t.appendChild(r), setTimeout(function () {
                r.remove()
            }, 5e3)
        }

        function a(a) {
            ! function () {
                var n = document.documentElement.clientWidth / 40;
                t.innerHTML = "";
                for (var a = 0; a < n; a++) {
                    var o = document.documentElement.clientWidth,
                        r = document.documentElement.clientHeight,
                        s = Math.floor(Math.random() * o) + 1,
                        l = Math.floor(Math.random() * r) + 1,
                        d = Math.floor(8 * Math.random()) + 5,
                        c = Math.floor(4 * Math.random()) + 1,
                        h = Math.floor(12 * Math.random()) + 8,
                        u = Math.floor(2 * Math.random()),
                        m = Math.floor(3 * Math.random()),
                        f = document.createElement("div");
                    f.style.position = "absolute", f.style.marginLeft = s + "px", f.style.marginTop = l + "px", f.style.width = d + "px", f.style.height = d + "px", f.style.opacity = c, f.style.backgroundColor = i[m], f.style.borderRadius = e[u], f.style.animation = "move " + h + "s ease-in infinite", t.appendChild(f)
                }
            }(), t.addEventListener("click", n)
        }
        window.addEventListener("resize", a), window.addEventListener("load", a)
    }
}
"use strict";

function initSimpleAccordion() {
    $(".accordion-section > a").on("click", function () {
        $(this).hasClass("active") ? ($(this).removeClass("active"), $(this).siblings(".accordion-content").slideUp(200), $(".accordion-section > a i").removeClass("fa-minus").addClass("fa-plus")) : ($(".accordion-section > a i").removeClass("fa-minus").addClass("fa-plus"), $(this).find("i").removeClass("fa-plus").addClass("fa-minus"), $(".accordion-section > a").removeClass("active"), $(this).addClass("active"), $(".accordion-content").slideUp(200), $(this).siblings(".accordion-content").slideDown(200))
    })
}

function initAccordions() {
    var i = $(".accordion");
    i.each(function () {
        $(this).toggleClass("ui-accordion ui-widget ui-helper-reset"), $(this).find("h3").addClass("ui-accordion-header ui-helper-reset ui-state-default ui-accordion-icons ui-corner-all"), $(this).find("div").addClass("ui-accordion-content ui-helper-reset ui-widget-content ui-corner-bottom"), $(this).find("div").hide()
    }), i.find("h3").on("click", function (i) {
        var e = $(this).parent();
        if ($(this).next().is(":hidden")) {
            var n = $("h3", e);
            n.removeClass("ui-accordion-header-active ui-state-active ui-corner-top").next().slideUp(300), n.find("span").removeClass("ui-accordion-icon-active"), $(this).find("span").addClass("ui-accordion-icon-active"), $(this).addClass("ui-accordion-header-active ui-state-active ui-corner-top").next().slideDown(300)
        }
        i.preventDefault()
    }), $(".toggle-container").hide(), $(".trigger, .trigger.opened").on("click", function (i) {
        $(this).toggleClass("active"), i.preventDefault()
    }), $(".trigger").on("click", function () {
        $(this).next(".toggle-container").slideToggle(300)
    }), $(".trigger.opened").addClass("active").next(".toggle-container").show()
}
"use strict";

function initBackToTop() {
    $(window).on("scroll", function () {
        $(window).scrollTop() >= 600 ? $("#backtotop").addClass("visible") : $("#backtotop").removeClass("visible")
    }), $("#backtotop a").on("click", function () {
        return $("html, body").animate({
            scrollTop: 0
        }, 500), !1
    })
}
"use strict";

function initMediaCards() {
    $(".media-card-image").length && $(".media-card-image").each(function () {
        var a = $(this).attr("data-background");
        void 0 !== a && $(this).css("background-image", "url(" + a + ")")
    })
}
"use strict";

function initBasicCarousel() {
    $(".testimonials").length && $(".testimonials").slick({
        dots: !0,
        infinite: !0,
        speed: 500,
        cssEase: "cubic-bezier(0.645, 0.045, 0.355, 1.000)",
        autoplay: !0
    })
}

function initVerticalCarousel() {
    $(".vertical-testimonials").length && $(".vertical-testimonials").slick({
        autoplay: !0,
        arrows: !1,
        dots: !1,
        slidesToShow: 4,
        centerPadding: "0",
        centerMode: !0,
        draggable: !1,
        infinite: !0,
        pauseOnHover: !1,
        swipe: !1,
        touchMove: !1,
        vertical: !0,
        speed: 1e3,
        autoplaySpeed: 2500,
        useTransform: !0,
        cssEase: "cubic-bezier(0.645, 0.045, 0.355, 1.000)",
        adaptiveHeight: !0
    })
}

function initFlatCarousel() {
    $(".flat-testimonials").length && $(".flat-testimonials").slick({
        dots: !0,
        infinite: !0,
        speed: 500,
        cssEase: "cubic-bezier(0.645, 0.045, 0.355, 1.000)",
        autoplay: !0,
        autoplaySpeed: 5e3,
        arrows: !0
    })
}

function initImageCarousel() {
    $(".image-carousel").length && $(".image-carousel").slick({
        centerMode: !0,
        dots: !0,
        infinite: !0,
        autoplay: !0,
        autoplaySpeed: 2e3,
        centerPadding: "60px",
        prevArrow: "<div class='slick-custom is-prev'><i class='fa fa-chevron-left'></i></div>",
        nextArrow: "<div class='slick-custom is-next'><i class='fa fa-chevron-right'></i></div>",
        slidesToShow: 3,
        responsive: [{
            breakpoint: 768,
            settings: {
                arrows: !1,
                centerMode: !0,
                centerPadding: "40px",
                slidesToShow: 3
            }
        }, {
            breakpoint: 480,
            settings: {
                arrows: !1,
                centerMode: !0,
                centerPadding: "40px",
                slidesToShow: 1
            }
        }]
    })
}

function initSingleImageCarousel() {
    $(".single-image-carousel").length && $(".single-image-carousel").slick({
        infinite: !0,
        dots: !0,
        autoplay: !0,
        autoplaySpeed: 2e3,
        slidesToShow: 1,
        slidesToScroll: 1,
        prevArrow: "<div class='slick-custom is-prev'><i class='fa fa-chevron-left'></i></div>",
        nextArrow: "<div class='slick-custom is-next'><i class='fa fa-chevron-right'></i></div>",
        responsive: [{
            breakpoint: 768,
            settings: {
                arrows: !1,
                centerMode: !1,
                slidesToShow: 1
            }
        }, {
            breakpoint: 480,
            settings: {
                arrows: !1,
                centerMode: !1,
                slidesToShow: 1
            }
        }]
    })
}

function initMultipleImagesCarousel() {
    $(".multiple-image-carousel").length && $(".multiple-image-carousel").slick({
        infinite: !0,
        dots: !0,
        slidesToShow: 3,
        slidesToScroll: 3,
        prevArrow: "<div class='slick-custom is-prev'><i class='fa fa-chevron-left'></i></div>",
        nextArrow: "<div class='slick-custom is-next'><i class='fa fa-chevron-right'></i></div>",
        responsive: [{
            breakpoint: 768,
            settings: {
                arrows: !1,
                centerMode: !0,
                centerPadding: "40px",
                slidesToShow: 3
            }
        }, {
            breakpoint: 480,
            settings: {
                arrows: !1,
                centerMode: !0,
                centerPadding: "40px",
                slidesToShow: 1
            }
        }]
    })
}

function initClientsCarousel() {
    $(".clients-logo-carousel").length && $(".clients-logo-carousel").slick({
        infinite: !0,
        dots: !0,
        autoplay: !0,
        autoplaySpeed: 2e3,
        slidesToShow: 4,
        slidesToScroll: 4,
        prevArrow: "<div class='slick-custom is-prev'><i class='fa fa-chevron-left'></i></div>",
        nextArrow: "<div class='slick-custom is-next'><i class='fa fa-chevron-right'></i></div>",
        responsive: [{
            breakpoint: 768,
            settings: {
                arrows: !1,
                centerMode: !0,
                centerPadding: "40px",
                slidesToShow: 3
            }
        }, {
            breakpoint: 480,
            settings: {
                arrows: !1,
                centerMode: !0,
                centerPadding: "20px",
                slidesToShow: 2
            }
        }]
    })
}

function initPeopleCarousel() {
    $(".people-carousel").length && $(".people-carousel").slick({
        infinite: !0,
        dots: !0,
        autoplay: !0,
        slidesToShow: 1,
        slidesToScroll: 1,
        autoplaySpeed: 5e3,
        appendDots: $(".people-carousel")
    })
}

function initTestimonials() {
    $(".styled-testimonials").length && $(".styled-testimonials").slick({
        dots: !0,
        infinite: !0,
        speed: 500,
        cssEase: "cubic-bezier(0.645, 0.045, 0.355, 1.000)",
        autoplay: !0,
        arrows: !1
    })
}

function initNavigationDots() {
    $(".slide-dot").on("click", function () {
        var e = $(this).attr("data-feature-text"),
            s = $(this).attr("data-feature");
        $(".showcase-wrap").removeClass("is-active"), $(".showcase-text-wrapper").addClass("is-hidden"), $("#" + e).removeClass("is-hidden"), $("#" + s).addClass("is-active"), $(".slide-dot.is-active").removeClass("is-active"), $(this).addClass("is-active")
    })
}

function initCustomCarousel() {
    $(".css-carousel input").on("change", function () {
        var e = $(this).attr("data-testimonial-image");
        $(".testimonials-cover.is-active").removeClass("is-active"), $("#" + e).addClass("is-active")
    });
    var e = 1;
    setInterval(function () {
        (e += 1) < 5 ? $(".css-carousel label:nth-child(" + e + ")").trigger("click") : (e = 1, $(".css-carousel label:first-child").trigger("click"))
    }, 3e3)
}

function initCarousel() {
    $(".testimonials-solo-carousel").slick({
        infinite: !0,
        dots: !0,
        autoplay: !0,
        autoplaySpeed: 5e3,
        slidesToShow: 1,
        slidesToScroll: 1,
        prevArrow: "<div class='slick-custom is-prev'><i class='fa fa-chevron-left'></i></div>",
        nextArrow: "<div class='slick-custom is-next'><i class='fa fa-chevron-right'></i></div>",
        responsive: [{
            breakpoint: 768,
            settings: {
                arrows: !1,
                centerMode: !1,
                slidesToShow: 1
            }
        }, {
            breakpoint: 480,
            settings: {
                arrows: !1,
                centerMode: !1,
                slidesToShow: 1
            }
        }]
    })
}

function initPricingCarousel() {
    $(".feature-carousel").slick({
        infinite: !0,
        dots: !0,
        autoplay: !0,
        autoplaySpeed: 2500,
        slidesToShow: 1,
        slidesToScroll: 1,
        prevArrow: "<div class='slick-custom is-prev'><i class='fa fa-chevron-left'></i></div>",
        nextArrow: "<div class='slick-custom is-next'><i class='fa fa-chevron-right'></i></div>",
        responsive: [{
            breakpoint: 768,
            settings: {
                arrows: !1,
                centerMode: !1,
                slidesToShow: 1
            }
        }, {
            breakpoint: 480,
            settings: {
                arrows: !1,
                centerMode: !1,
                slidesToShow: 1
            }
        }]
    })
}

function initLandingCarousel() {
    $(".carousel").slick({
        centerMode: !0,
        dots: !0,
        arrows: !1,
        infinite: !0,
        autoplay: !0,
        dots: !0,
        autoplaySpeed: 5e3,
        centerPadding: "60px",
        prevArrow: "<div class='slick-contacts-btn is-prev'><i class='fa fa-chevron-left'></i></div>",
        nextArrow: "<div class='slick-contacts-btn is-next'><i class='fa fa-chevron-right'></i></div>",
        slidesToShow: 1,
        responsive: [{
            breakpoint: 768,
            settings: {
                arrows: !1,
                centerMode: !0,
                centerPadding: "10px",
                slidesToShow: 1
            }
        }, {
            breakpoint: 480,
            settings: {
                arrows: !1,
                centerMode: !0,
                centerPadding: "10px",
                slidesToShow: 1
            }
        }]
    })
}

function initCharacterTestimonials() {
    $(".customer-testimonials").slick({
        dots: !0,
        infinite: !0,
        speed: 300,
        autoplay: !0,
        slidesToShow: 1,
        slidesToScroll: 1
    })
}
"use strict";

function initCounters() {
    $(".counter").length && $(".counter").counterUp({
        delay: 10,
        time: 1e3
    })
}
"use strict";

function initCountdown() {
    if ($("#countdown").length) {
        const e = 1e3,
            t = 60 * e,
            n = 60 * t,
            o = 24 * n;
        let l = new Date("Sep 30, 2021 00:00:00").getTime(),
            i = setInterval(function () {
                let r = (new Date).getTime(),
                    d = l - r;
                document.getElementById("days").innerText = Math.floor(d / o), document.getElementById("hours").innerText = Math.floor(d % o / n), document.getElementById("minutes").innerText = Math.floor(d % n / t), document.getElementById("seconds").innerText = Math.floor(d % t / e), d < 0 && clearInterval(i)
            }, 0)
    }
}
"use strict";

function initNavbarDropdown() {
    $(".mobile-drop").on("click", function () {
        $(this).toggleClass("is-active"), $(this).find(".child-menu").slideToggle()
    })
}

function initDropdowns() {
    $(".dropdown-trigger").on("click", function () {
        $(".dropdown").removeClass("is-active"), $(this).closest(".dropdown").addClass("is-active")
    }), $(document).on("click", function (i) {
        var o = i.target;
        $(o).is(".dropdown-trigger img") || $(o).parents().is(".dropdown") || $(".dropdown").removeClass("is-active")
    })
}
"use strict";

function initFaq() {
    $(".faq-block .block-header").on("click", function () {
        $(this).toggleClass("is-active"), $(this).closest(".faq-block").find(".block-body").slideToggle("fast")
    })
}
"use strict";

function initGoogleMap() {
    $("#google-map").length && $("#google-map").gMap({
        latitude: 40.7143528,
        longitude: -74.0059731,
        maptype: "ROADMAP",
        zoom: 13,
        markers: [{
            latitude: 40.71771,
            longitude: -74.003245,
            html: '<div style="width: 300px;"><h4 style="margin-bottom: 8px;"></h4><div style="align-items:center!important;" class="content content-flex"><div><img style="height:60px;border-radius:100px;" src="assets/img/logos/cssninja.svg"></div><div style="margin-left:20px;"> Iam very happy if you like this template. If you need any support, please feel free to contact us at <strong>hello@cssninja.io</strong></div></div></div>',
            icon: {
                image: "assets/img/graphics/markers/marker-purple.png",
                iconsize: [56, 82],
                iconanchor: [32, 39]
            }
        }],
        doubleclickzoom: !0,
        controls: {
            panControl: !0,
            zoomControl: !0,
            mapTypeControl: !0,
            scaleControl: !1,
            streetViewControl: !1,
            overviewMapControl: !1
        }
    }), $("#half-map").length && $("#half-map").gMap({
        latitude: 40.7143528,
        longitude: -74.0059731,
        maptype: "ROADMAP",
        zoom: 13,
        markers: [{
            latitude: 40.71771,
            longitude: -74.003245,
            html: '<div style="width: 300px;"><h4 style="margin-bottom: 8px;"></h4><div style="align-items:center!important;" class="content content-flex"><div><img style="height:60px;border-radius:100px;" src="assets/img/logos/cssninja.svg"></div><div style="margin-left:20px;"> Iam very happy if you like this template. If you need any support, please feel free to contact us at <strong>hello@cssninja.io</strong></div></div></div>',
            icon: {
                image: "assets/img/graphics/markers/marker-purple.png",
                iconsize: [56, 82],
                iconanchor: [32, 39]
            }
        }],
        doubleclickzoom: !0,
        controls: {
            panControl: !0,
            zoomControl: !0,
            mapTypeControl: !0,
            scaleControl: !1,
            streetViewControl: !1,
            overviewMapControl: !1
        }
    })
}

function initMapBox() {
    var e = "pk.eyJ1IjoiY3NzbmluamEiLCJhIjoiY2toZW1nYm0zMDAxODJycXFzZ3g4cnZ6diJ9.9ebfrGREuwkauRr_afDTgA",
        o = {
            color: "red"
        };
    if ($("#mapbox-1").length) {
        mapboxgl.accessToken = e;
        var a = new mapboxgl.Map({
            container: "mapbox-1",
            style: "mapbox://styles/mapbox/streets-v11",
            center: [12.550343, 55.665957],
            zoom: 8
        });
        new mapboxgl.Marker(o).setLngLat([12.550343, 55.665957]).addTo(a)
    } else if ($("#mapbox-2").length) {
        mapboxgl.accessToken = e;
        var t = new mapboxgl.Map({
            container: "mapbox-2",
            style: "mapbox://styles/mapbox/light-v10",
            center: [12.550343, 55.665957],
            zoom: 8
        });
        new mapboxgl.Marker(o).setLngLat([12.550343, 55.665957]).addTo(t)
    } else if ($("#mapbox-3").length) {
        mapboxgl.accessToken = e;
        var n = new mapboxgl.Map({
            container: "mapbox-3",
            style: "mapbox://styles/mapbox/dark-v10",
            center: [12.550343, 55.665957],
            zoom: 8
        });
        new mapboxgl.Marker(o).setLngLat([12.550343, 55.665957]).addTo(n)
    } else if ($("#mapbox-4").length) {
        mapboxgl.accessToken = e;
        n = new mapboxgl.Map({
            container: "mapbox-2",
            style: "mapbox://styles/mapbox/light-v10",
            center: [12.550343, 55.665957],
            zoom: 8
        }), new mapboxgl.Marker(o).setLngLat([12.550343, 55.665957]).addTo(n)
    } else if ($("#mapbox-5").length) {
        mapboxgl.accessToken = e;
        a = new mapboxgl.Map({
            container: "mapbox-5",
            style: "mapbox://styles/mapbox/light-v10",
            center: [12.550343, 55.665957],
            zoom: 16
        }), new mapboxgl.Marker(o).setLngLat([12.550343, 55.665957]).addTo(a)
    }
}
"use strict";

function initMarquee() {
    $(".crypto-marquee").length && $(".crypto-marquee").marquee({
        duration: 15e3,
        gap: 30,
        delayBeforeStart: 0,
        direction: "left",
        duplicated: !0,
        startVisible: !0
    }), $(".app-marquee").length && ($(".app-marquee-left").marquee({
        duration: 24e3,
        gap: 0,
        delayBeforeStart: 0,
        direction: "left",
        duplicated: !0,
        startVisible: !0
    }), $(".app-marquee-right").marquee({
        duration: 28e3,
        gap: 0,
        delayBeforeStart: 0,
        direction: "right",
        duplicated: !0,
        startVisible: !0
    }))
}
"use strict";

function initMockup() {
    $("#show-video, #show-mockup").on("click", function () {
        $("#show-video, #show-mockup").toggleClass("is-hidden"), $("#video, #mockup").toggleClass("is-hidden")
    })
}
"use strict";

function initModals() {
    var i;
    if ($(".modal-trigger").on("click", function () {
            i = $(this).attr("data-modal"), $("#" + i).toggleClass("is-active"), $("#" + i + " .modal-background").toggleClass("scaleInCircle"), $("#" + i + " .modal-content").toggleClass("scaleIn"), $("#" + i + " .modal-close").toggleClass("is-hidden"), $("#scrollnav, #backtotop").toggleClass("is-hidden"), setTimeout(function () {
                $(".dashboard-wrapper").length && $("body").addClass("is-fixed")
            }, 700)
        }), $(".modal-close, .modal-dismiss").on("click", function () {
            $("#" + i + " .modal-background").toggleClass("scaleInCircle"), $("#" + i + " .modal-content").toggleClass("scaleIn"), $("#" + i + " .modal-close").toggleClass("is-hidden"), $(".dashboard-wrapper").length && $("body").removeClass("is-fixed"), setTimeout(function () {
                $(".modal.is-active").removeClass("is-active"), $("#scrollnav, #backtotop").toggleClass("is-hidden")
            }, 500)
        }), $(".modal-card-body .card-select i").on("click", function () {
            $(this).toggleClass("is-active"), $(this).closest(".flex-card").toggleClass("is-active"), $(".save-btn").removeClass("is-disabled")
        }), $(".modal-trigger.gallery-trigger").on("click", function () {
            setTimeout(function () {
                $(".slick-gallery").slick({
                    slidesToShow: 1,
                    arrows: !1,
                    dots: !0,
                    cssEase: "cubic-bezier(0.645, 0.045, 0.355, 1.000)",
                    autoplay: !0,
                    infinite: !1
                })
            }, 100)
        }), $("#success-icon").length) {
        var s = $("#success-icon svg");
        $(".success-trigger").on("click", function () {
            setTimeout(function () {
                new Vivus("success-icon", {
                    type: "oneByOne",
                    duration: 60,
                    delay: 300,
                    animTimingFunction: Vivus.EASE_OUT_BOUNCE,
                    selfDestroy: !0,
                    file: "assets/img/graphics/icons/modals/success.svg"
                })
            }, 300)
        }), $(".modal-close, .modal-dismiss").on("click", function () {
            $("#success-icon svg").replaceWith(s)
        })
    }
    if ($("#error-icon").length) {
        var o = $("#error-icon svg");
        $(".error-trigger").on("click", function () {
            setTimeout(function () {
                new Vivus("error-icon", {
                    type: "oneByOne",
                    duration: 60,
                    animTimingFunction: Vivus.EASE_OUT_BOUNCE,
                    selfDestroy: !0,
                    file: "assets/img/graphics/icons/modals/error.svg"
                })
            }, 300)
        }), $(".modal-close, .modal-dismiss").on("click", function () {
            $("#error-icon svg").replaceWith(o)
        })
    }
    if ($("#warning-icon").length) {
        var n = $("#warning-icon svg");
        $(".warning-trigger").on("click", function () {
            setTimeout(function () {
                new Vivus("warning-icon", {
                    type: "oneByOne",
                    duration: 60,
                    animTimingFunction: Vivus.EASE_OUT_BOUNCE,
                    selfDestroy: !0,
                    file: "assets/img/graphics/icons/modals/warning.svg"
                })
            }, 300)
        }), $(".modal-close, .modal-dismiss").on("click", function () {
            $("#warning-icon svg").replaceWith(n)
        })
    }
    if ($("#info-icon").length) {
        var e = $("#info-icon svg");
        $(".info-trigger").on("click", function () {
            setTimeout(function () {
                new Vivus("info-icon", {
                    type: "oneByOne",
                    duration: 60,
                    animTimingFunction: Vivus.EASE_OUT_BOUNCE,
                    selfDestroy: !0,
                    file: "assets/img/graphics/icons/modals/info.svg"
                })
            }, 1e3)
        }), $(".modal-close, .modal-dismiss").on("click", function () {
            $("#info-icon svg").replaceWith(e)
        })
    }
}
"use strict";

function initPopovers() {
    $('[data-toggle="popover"]').length && $('[data-toggle="popover"]').ggpopover()
}

function initTooltips() {
    $('[data-toggle="tooltip"]').length && $('[data-toggle="tooltip"]').ggtooltip()
}
"use strict";

function initPricing() {
    $(".pricing-tabs .tab-item").on("click", function () {
        var i = $(this).attr("data-tab");
        $(this).siblings(".tab-item").removeClass("is-active"), $(this).addClass("is-active"), $(".pricing-container").removeClass("is-active"), $("#" + i).addClass("is-active"), $(".feature-carousel").slick("setPosition")
    })
}

function initTabbedPricing() {
    $(".header-pricing").length && ($(".pricing-picker span").on("click", function () {
        $(".pricing-picker span.is-active").removeClass("is-active"), $(this).addClass("is-active")
    }), $("#show-monthly").on("click", function () {
        $(".per-year").addClass("is-hidden"), $(".per-month").removeClass("is-hidden")
    }), $("#show-annualy").on("click", function () {
        $(".per-month").addClass("is-hidden"), $(".per-year").removeClass("is-hidden")
    }))
}

function initFreelancerPricing() {
    $(".plan-controls span").on("click", function () {
        $(".plan-controls span").toggleClass("is-active")
    }), $(".period-select span").on("click", function () {
        $(".period-select span").toggleClass("is-active"), $(".month-price, .year-price").toggleClass("is-hidden")
    }), $("#show-freelance").on("click", function () {
        $("#freelance-pricing").removeClass("is-hidden"), $("#business-pricing").addClass("is-hidden")
    }), $("#show-business").on("click", function () {
        $("#business-pricing").removeClass("is-hidden"), $("#freelance-pricing").addClass("is-hidden")
    })
}

function initBoxedPricing() {
    $("#price-switch").length && $("#price-switch").on("click", function () {
        $(".by-year, .by-month").toggleClass("is-active"), $(".condensed-plan").toggleClass("is-switched")
    })
}

function initSwitchPricing() {
    $(".switch-pricing-wrapper").length && $(".pricing-switcher input").on("change", function () {
        $(".plan-price").toggleClass("is-active")
    })
}

function initOnePagePricing() {
    $(".combo-button .button").on("click", function () {
        $(".combo-button .button.is-active").removeClass("is-active"), $(this).addClass("is-active"), $(".plan-price, .price-per").toggleClass("is-hidden")
    })
}
"use strict";

function initQuickview() {
    var e = document.querySelectorAll('[data-show="quickview"]');
    [].forEach.call(e, function (e) {
        var t = document.getElementById(e.dataset.target);
        t && e.addEventListener("click", function (e) {
            t.classList.add("is-active")
        })
    });
    var t = document.querySelectorAll('[data-dismiss="quickview"]');
    [].forEach.call(t, function (e) {
        var t = closest(e, ".quickview");
        t && e.addEventListener("click", function (e) {
            t.classList.remove("is-active")
        })
    })
}

function closest(e, t) {
    var c, i;
    for (["matches", "webkitMatchesSelector", "mozMatchesSelector", "msMatchesSelector", "oMatchesSelector"].some(function (e) {
            return "function" == typeof document.body[e] && (c = e, !0)
        }); e;) {
        if ((i = e.parentElement) && i[c](t)) return i;
        e = i
    }
    return null
}
"use strict";

function initSearchBox() {
    $(".price-block a").on("click", function () {
        $(".price-block").find(".dropdown-container").toggleClass("is-open")
    })
}
"use strict";

function initSlider() {
    if ($(".Wallop").length) {
        var e = document.querySelector(".Wallop"),
            t = new Wallop(e),
            n = Array.prototype.slice.call(document.querySelectorAll(".Wallop-dot"));
        n.forEach(function (e, n) {
                e.addEventListener("click", function () {
                    t.goTo(n)
                })
            }), t.on("change", function (e) {
                ! function (e, t) {
                    if (!e) return;
                    e.className = e.className.replace(t, "")
                }(document.querySelector(".Wallop-dot--current"), "Wallop-dot--current"),
                function (e, t) {
                    if (!e) return;
                    e.className = e.className.replace(/\s+$/gi, "") + " " + t
                }(n[e.detail.currentItemIndex], "Wallop-dot--current")
            }),
            function (e) {
                var n = 0;
                requestAnimationFrame(function r(o) {
                    var l = o - n >= e;
                    l && (t.next(), n = o);
                    requestAnimationFrame(r)
                })
            }(5e3)
    }
}
"use strict";

function initVerticalTabs() {
    $(".vertical-tabs-wrapper ul li").on("click", function () {
        var a = $(this).attr("data-target");
        $(this).siblings("li").removeClass("is-active"), $(this).addClass("is-active"), $(this).closest(".vertical-tabs-wrapper").find(".tab-content").removeClass("is-active"), $("#" + a).addClass("is-active")
    })
}

function initTabsNav() {
    var a = $(".tabs-nav"),
        t = a.children("li");
    a.each(function () {
        $(this).next().children(".tab-content").stop(!0, !0).hide().first().show()
    }), t.on("click", function (a) {
        var t = $(this);
        t.siblings().removeClass("active").end().addClass("active"), t.parent().next().children(".tab-content").stop(!0, !0).hide().siblings(t.find("a").attr("href")).fadeIn(), a.preventDefault()
    });
    var i = window.location.hash,
        s = $('.tabs-nav a[href="' + i + '"]');
    0 === s.length ? ($(".tabs-nav li:first").addClass("active").show(), $(".tab-content:first").show()) : s.parent("li").click()
}

function initNavigationTabs() {
    $(".navigation-tabs ul li").on("click", function () {
        var a = $(this).attr("data-tab");
        $(this).siblings("li").removeClass("is-active"), $(this).closest(".navigation-tabs").children(".navtab-content").removeClass("is-active"), $(this).addClass("is-active"), $("#" + a).addClass("is-active")
    })
}

function initCodeTabs() {
    $(".backend-code-container .tab-codesnippets li").on("click", function () {
        var a = $(this).attr("data-language");
        $(this).closest(".column").find(".tab-codesnippets li").removeClass("is-active"), $(this).addClass("is-active"), $(this).closest(".column").find("[data-backend-sample]").removeClass("active"), console.log(a), $("[data-backend-sample=" + a + "]").addClass("active")
    }), $(".frontend-code-container .tab-codesnippets li").on("click", function () {
        var a = $(this).attr("data-language");
        $(this).closest(".column").find(".tab-codesnippets li").removeClass("is-active"), $(this).addClass("is-active"), $(this).closest(".column").find("[data-frontend-sample]").removeClass("active"), console.log(a), $("[data-frontend-sample=" + a + "]").addClass("active")
    })
}
"use strict";

function initTiltCards() {
    $(".tilt-card").tilt()
}
$.fn.tilt = function () {
    var t = this.width(),
        i = this.height(),
        s = t / 2,
        e = i / 2;
    return this.on({
        mousemove: function (t) {
            var i = $(this).offset(),
                o = t.pageX - i.left,
                a = t.pageY - i.top,
                n = s - o,
                r = e - a;
            $(this).css("transform", "perspective(300px) rotateX(" + r / 20 + "deg) rotateY(" + -n / 20 + "deg)"), $(this).removeClass("is-out")
        },
        mouseleave: function () {
            $(this).addClass("is-out")
        }
    }), this
};
"use strict";

function initToasts() {
    $("#top-left-toast").on("click", function () {
        iziToast.show({
            title: "Hello,",
            message: "Iam a very simple Toast !",
            position: "topLeft",
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#8c8cf9"
        })
    }), $("#top-center-toast").on("click", function () {
        iziToast.show({
            title: "Hello,",
            message: "Iam a very simple Toast !",
            position: "topCenter",
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#8c8cf9"
        })
    }), $("#top-right-toast").on("click", function () {
        iziToast.show({
            title: "Hello,",
            message: "Iam a very simple Toast !",
            position: "topRight",
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#8c8cf9"
        })
    }), $("#center-toast").on("click", function () {
        iziToast.show({
            title: "Hello,",
            message: "Iam a very simple Toast !",
            position: "center",
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#8c8cf9"
        })
    }), $("#bottom-left-toast").on("click", function () {
        iziToast.show({
            title: "Hello,",
            message: "Iam a very simple Toast !",
            position: "bottomLeft",
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#8c8cf9"
        })
    }), $("#bottom-center-toast").on("click", function () {
        iziToast.show({
            title: "Hello,",
            message: "Iam a very simple Toast !",
            position: "bottomCenter",
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#8c8cf9"
        })
    }), $("#bottom-right-toast").on("click", function () {
        iziToast.show({
            title: "Hello,",
            message: "Iam a very simple Toast !",
            position: "bottomRight",
            zindex: 99999,
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#8c8cf9"
        })
    }), $("#info-toast").on("click", function () {
        iziToast.show({
            class: "info-toast",
            icon: "sl sl-icon-info",
            title: "Hello,",
            message: "This is an info notification !",
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#039BE5",
            progressBarColor: "#444F60",
            position: "topRight",
            transitionIn: "fadeInDown",
            close: !1,
            zindex: 99999
        })
    }), $("#success-toast").on("click", function () {
        iziToast.show({
            class: "success-toast",
            icon: "sl sl-icon-check",
            title: "Hello,",
            message: "This is a success notification !",
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#00b289",
            progressBarColor: "#444F60",
            position: "topRight",
            transitionIn: "fadeInDown",
            close: !1,
            zindex: 99999
        })
    }), $("#warning-toast").on("click", function () {
        iziToast.show({
            class: "warning-toast",
            icon: "sl sl-icon-lock",
            title: "Hello,",
            message: "This is a warning notification !",
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#eda514",
            progressBarColor: "#444F60",
            position: "topRight",
            transitionIn: "fadeInDown",
            close: !1,
            zindex: 99999
        })
    }), $("#danger-toast").on("click", function () {
        iziToast.show({
            class: "danger-toast",
            icon: "sl sl-icon-close",
            title: "Hello,",
            message: "This is a danger notification !",
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#FF7273",
            progressBarColor: "#444F60",
            position: "topRight",
            transitionIn: "fadeInDown",
            close: !1,
            zindex: 99999
        })
    }), $("#fade-toast").on("click", function () {
        iziToast.show({
            icon: "sl sl-icon-rocket",
            title: "Hello,",
            message: "This is an animated Toast !",
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#7F00FF",
            progressBarColor: "#444F60",
            position: "topRight",
            transitionIn: "fadeIn",
            transitionOut: "fadeOut",
            close: !1,
            zindex: 99999
        })
    }), $("#fadeUp-toast").on("click", function () {
        iziToast.show({
            icon: "sl sl-icon-rocket",
            title: "Hello,",
            message: "This is an animated Toast !",
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#7F00FF",
            progressBarColor: "#444F60",
            position: "topRight",
            transitionIn: "fadeInUp",
            transitionOut: "fadeOutUp",
            close: !1,
            zindex: 99999
        })
    }), $("#fadeDown-toast").on("click", function () {
        iziToast.show({
            icon: "sl sl-icon-rocket",
            title: "Hello,",
            message: "This is an animated Toast !",
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#7F00FF",
            progressBarColor: "#444F60",
            position: "topRight",
            transitionIn: "fadeInDown",
            transitionOut: "fadeOutDown",
            close: !1,
            zindex: 99999
        })
    }), $("#fadeLeft-toast").on("click", function () {
        iziToast.show({
            icon: "sl sl-icon-rocket",
            title: "Hello,",
            message: "This is an animated Toast !",
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#7F00FF",
            progressBarColor: "#444F60",
            position: "topRight",
            transitionIn: "fadeInLeft",
            transitionOut: "fadeOutLeft",
            close: !1,
            zindex: 99999
        })
    }), $("#fadeRight-toast").on("click", function () {
        iziToast.show({
            icon: "sl sl-icon-rocket",
            title: "Hello,",
            message: "This is an animated Toast !",
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#7F00FF",
            progressBarColor: "#444F60",
            position: "topRight",
            transitionIn: "fadeInRight",
            transitionOut: "fadeOutRight",
            close: !1,
            zindex: 99999
        })
    }), $("#bounceUp-toast").on("click", function () {
        iziToast.show({
            icon: "sl sl-icon-rocket",
            title: "Hello,",
            message: "This is an animated Toast !",
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#7F00FF",
            progressBarColor: "#444F60",
            position: "topRight",
            transitionIn: "bounceInUp",
            transitionOut: "bounceOutUp",
            close: !1,
            zindex: 99999
        })
    }), $("#bounceDown-toast").on("click", function () {
        iziToast.show({
            icon: "sl sl-icon-rocket",
            title: "Hello,",
            message: "This is an animated Toast !",
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#7F00FF",
            progressBarColor: "#444F60",
            position: "topRight",
            transitionIn: "bounceInDown",
            transitionOut: "bounceOutDown",
            close: !1,
            zindex: 99999
        })
    }), $("#bounceLeft-toast").on("click", function () {
        iziToast.show({
            icon: "sl sl-icon-rocket",
            title: "Hello,",
            message: "This is an animated Toast !",
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#7F00FF",
            progressBarColor: "#444F60",
            position: "topRight",
            transitionIn: "bounceInLeft",
            transitionOut: "bounceOutLeft",
            close: !1,
            zindex: 99999
        })
    }), $("#bounceRight-toast").on("click", function () {
        iziToast.show({
            icon: "sl sl-icon-rocket",
            title: "Hello,",
            message: "This is an animated Toast !",
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#7F00FF",
            progressBarColor: "#444F60",
            position: "topRight",
            transitionIn: "bounceInRight",
            transitionOut: "bounceOutRight",
            close: !1,
            zindex: 99999
        })
    }), $("#flip-toast").on("click", function () {
        iziToast.show({
            icon: "sl sl-icon-rocket",
            title: "Hello,",
            message: "This is an animated Toast !",
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#7F00FF",
            progressBarColor: "#444F60",
            position: "topRight",
            transitionIn: "flipInX",
            transitionOut: "flipOutX",
            close: !1,
            zindex: 99999
        })
    }), $("#question-toast").on("click", function () {
        iziToast.show({
            timeout: 1e4,
            close: !1,
            overlay: !0,
            toastOnce: !0,
            id: "question",
            zindex: 999,
            title: "Hey,",
            message: "Are you sure about that?",
            titleColor: "#fff",
            messageColor: "#fff",
            iconColor: "#fff",
            backgroundColor: "#7F00FF",
            progressBarColor: "#444F60",
            position: "center",
            buttons: [
                ['<button class="button btn-align is-small light-btn btn-outlined"><b class="light-text">YES</b></button>', function (o, t) {
                    o.hide(t, {
                        transitionOut: "fadeOut"
                    }, "button"), iziToast.show({
                        class: "success-toast",
                        title: "",
                        message: "Successfully saved modifications !",
                        titleColor: "#fff",
                        messageColor: "#fff",
                        backgroundColor: "#00b289",
                        progressBarColor: "#444F60",
                        position: "center",
                        transitionIn: "fadeInDown",
                        close: !1,
                        zindex: 99999,
                        timeout: 1500,
                        pauseOnHover: !1
                    })
                }, !0],
                ['<button class="button btn-align is-small light-btn btn-outlined"><b class="light-text">NO</b></button>', function (o, t) {
                    o.hide(t, {
                        transitionOut: "fadeOut"
                    }, "button")
                }]
            ],
            onClosing: function (o, t, i) {},
            onClosed: function (o, t, i) {
                console.info("Closed | closedBy: " + i)
            }
        })
    }), $("#balloon-toast").on("click", function () {
        iziToast.show({
            id: "show",
            title: "Hey",
            icon: "icon-drafts",
            class: "custom1",
            titleColor: "#fff",
            theme: "dark",
            progressBarColor: "#4FC1EA",
            message: "This is a Balloon example with buttons",
            position: "center",
            image: "assets/img/avatars/funny1.svg",
            balloon: !0,
            buttons: [
                ["<button>Photo</button>", function (o, t) {
                    iziToast.show({
                        theme: "dark",
                        icon: "fa fa-photo",
                        title: "OK",
                        message: "Callback Photo!",
                        position: "bottomCenter"
                    })
                }, !0],
                ["<button>Video</button>", function (o, t) {
                    iziToast.show({
                        theme: "dark",
                        icon: "fa fa-video-camera",
                        title: "OK",
                        message: "Callback Video!",
                        position: "bottomCenter"
                    })
                }],
                ["<button>Text</button>", function (o, t) {
                    iziToast.show({
                        theme: "dark",
                        icon: "fa fa-pencil",
                        title: "OK",
                        message: "Callback Text!",
                        position: "bottomCenter"
                    })
                }]
            ]
        })
    }), $("#custom-toast").on("click", function () {
        iziToast.show({
            theme: "dark",
            icon: "fa fa-envelope",
            title: "Helen Miller",
            message: "Sent you <b>3</b> new messages",
            position: "topCenter",
            transitionIn: "flipInX",
            transitionOut: "flipOutX",
            progressBarColor: "#4FC1EA",
            image: "assets/img/avatars/funny2.svg",
            imageWidth: 70,
            layout: 2,
            onClosing: function () {
                console.info("onClosing")
            },
            onClosed: function (o, t, i) {
                console.info("Closed | closedBy: " + i)
            },
            iconColor: "#fff"
        })
    })
}
"use strict";

function initFileUploader() {
    $('input[name="onebutton"]').fileuploader({
        theme: "onebutton"
    }), $('input[name="fielduploader"]').fileuploader({
        addMore: !0
    }), $('input[name="thumbnails"]').fileuploader({
        extensions: ["jpg", "jpeg", "png", "gif", "bmp"],
        changeInput: " ",
        theme: "thumbnails",
        enableApi: !0,
        addMore: !0,
        thumbnails: {
            box: '<div class="fileuploader-items"><ul class="fileuploader-items-list"><li class="fileuploader-thumbnails-input"><div class="fileuploader-thumbnails-input-inner"><span>+</span></div></li></ul></div>',
            item: '<li class="fileuploader-item"><div class="fileuploader-item-inner"><div class="thumbnail-holder">${image}</div><div class="actions-holder"><a class="fileuploader-action fileuploader-action-remove" title="${captions.remove}"><i class="remove"></i></a><span class="fileuploader-action-popup"></span></div><div class="progress-holder">${progressBar}</div></div></li>',
            item2: '<li class="fileuploader-item"><div class="fileuploader-item-inner"><div class="thumbnail-holder">${image}</div><div class="actions-holder"><a class="fileuploader-action fileuploader-action-remove" title="${captions.remove}"><i class="remove"></i></a><span class="fileuploader-action-popup"></span></div></div></li>',
            startImageRenderer: !0,
            canvasImage: !1,
            _selectors: {
                list: ".fileuploader-items-list",
                item: ".fileuploader-item",
                start: ".fileuploader-action-start",
                retry: ".fileuploader-action-retry",
                remove: ".fileuploader-action-remove"
            },
            onItemShow: function (e, i) {
                i.find(".fileuploader-thumbnails-input").insertAfter(e.html), "image" == e.format && e.html.find(".fileuploader-item-icon").hide()
            }
        },
        afterRender: function (e, i, a, l) {
            var n = e.find(".fileuploader-thumbnails-input"),
                r = $.fileuploader.getInstance(l.get(0));
            n.on("click", function () {
                r.open()
            })
        }
    }), $('input[name="dragndrop"]').fileuploader({
        changeInput: '<div class="fileuploader-input"><div class="fileuploader-input-inner"><img src="assets/img/fileuploader-dragdrop-icon.png"><h3 class="fileuploader-input-caption"><span>Drag and drop invoices here</span></h3><p>or</p><div class="fileuploader-input-button"><span>Browse Files</span></div></div></div>',
        theme: "dragdrop",
        upload: {
            url: "php/ajax_upload_file.php",
            data: null,
            type: "POST",
            enctype: "multipart/form-data",
            start: !0,
            synchron: !0,
            beforeSend: null,
            onSuccess: function (e, i) {
                var a = {};
                try {
                    a = JSON.parse(e)
                } catch (e) {
                    a.hasWarnings = !0
                }
                if (a.isSuccess && a.files[0] && (i.name = a.files[0].name, i.html.find(".column-title > div:first-child").text(a.files[0].name).attr("title", a.files[0].name)), a.hasWarnings) {
                    for (var l in a.warnings) alert(a.warnings);
                    return i.html.removeClass("upload-successful").addClass("upload-failed"), this.onError ? this.onError(i) : null
                }
                i.html.find(".column-actions").append('<a class="fileuploader-action fileuploader-action-remove fileuploader-action-success" title="Remove"><i></i></a>'), setTimeout(function () {
                    i.html.find(".progress-bar2").fadeOut(400)
                }, 400)
            },
            onError: function (e) {
                var i = e.html.find(".progress-bar2");
                i.length > 0 && (i.find("span").html("0%"), i.find(".fileuploader-progressbar .bar").width("0%"), e.html.find(".progress-bar2").fadeOut(400)), "cancelled" != e.upload.status && 0 == e.html.find(".fileuploader-action-retry").length && e.html.find(".column-actions").prepend('<a class="fileuploader-action fileuploader-action-retry" title="Retry"><i></i></a>')
            },
            onProgress: function (e, i) {
                var a = i.html.find(".progress-bar2");
                a.length > 0 && (a.show(), a.find("span").html(e.percentage + "%"), a.find(".fileuploader-progressbar .bar").width(e.percentage + "%"))
            },
            onComplete: null
        },
        onRemove: function (e) {
            $.post("./php/ajax_remove_file.php", {
                file: e.name
            })
        },
        captions: {
            feedback: "Drag and drop files here",
            feedback2: "Drag and drop files here",
            drop: "Drag and drop files here"
        }
    })
}
"use strict";

function initVideoEmbed() {
    $("#video-embed").length && embedVideo("#video-embed")
}

function initBackgroundVideo() {
    $(".covervid-video").length && $(".covervid-video").coverVid(1920, 1080)
}

function initPlayers() {
    if ($(".bulkit-player").length)
        if ("development" === env) {
            $("[data-demo-poster]").each(function () {
                var e = $(this).attr("data-demo-poster");
                void 0 !== e && $(this).attr("data-poster", e)
            });
            Array.from(document.querySelectorAll(".bulkit-player")).map(e => new Plyr(e))
        } else {
            Array.from(document.querySelectorAll(".bulkit-player")).map(e => new Plyr(e))
        }
}
"use strict";

function initAutocompletes() {
    if ($("#basic-autocpl").length) {
        var e = {
            url: "assets/data/persons.json",
            getValue: function (e) {
                return e.name
            },
            highlightPhrase: !1,
            list: {
                maxNumberOfElements: 5,
                showAnimation: {
                    type: "fade",
                    time: 400,
                    callback: function () {}
                },
                match: {
                    enabled: !0
                }
            }
        };
        $("#basic-autocpl").easyAutocomplete(e)
    }
    if ($("#desc-autocpl").length) {
        e = {
            url: "assets/data/persons.json",
            getValue: function (e) {
                return e.name
            },
            template: {
                type: "description",
                fields: {
                    description: "position"
                }
            },
            highlightPhrase: !1,
            list: {
                maxNumberOfElements: 5,
                showAnimation: {
                    type: "fade",
                    time: 400,
                    callback: function () {}
                },
                match: {
                    enabled: !0
                }
            }
        };
        $("#desc-autocpl").easyAutocomplete(e)
    }
    if ($("#users-autocpl").length) {
        $("#users-autocpl").easyAutocomplete({
            url: "assets/data/persons.json",
            getValue: "name",
            template: {
                type: "custom",
                method: function (e, t) {
                    return "<div class=template-wrapper><img class=autocpl-avatar src='" + t.pic + "' /><div class=entry-text>" + e + "<br><span>" + t.email + "</span></div></div> "
                }
            },
            highlightPhrase: !1,
            list: {
                maxNumberOfElements: 3,
                showAnimation: {
                    type: "fade",
                    time: 400,
                    callback: function () {}
                },
                match: {
                    enabled: !0
                }
            }
        })
    }
}
"use strict";

function initBulmaTags() {
    $(".bulma-tags").length && bulmaTagsinput.attach()
}

function initBulmaSteps() {
    $(".steps-wrapper").length && bulmaSteps.attach()
}

function initBulmaIconpicker() {
    $(".iconpicker-wrapper").length && bulmaIconpicker.attach()
}

function initBulmaCalendar() {
    $("#calendar-demo").length && (bulmaCalendar.attach("#datepickerDemoDefault", {
        color: "#7F00FF",
        lang: "en"
    }), bulmaCalendar.attach("#datepickerDemoDialog", {
        displayMode: "dialog",
        startDate: new Date("02/11/2018"),
        minDate: "01/01/2018",
        maxDate: "12/31/2018",
        color: "#7F00FF",
        lang: "en"
    }), bulmaCalendar.attach("#datepickerDemoInline", {
        displayMode: "inline",
        startDate: new Date("02/11/2018"),
        minDate: "01/01/2018",
        maxDate: "12/31/2018",
        color: "#7F00FF",
        lang: "en"
    }), bulmaCalendar.attach("#datepickerDemoRange", {
        color: "#7F00FF",
        lang: "en"
    }), bulmaCalendar.attach("#timepickerDemoDefault", {
        color: "#7F00FF",
        lang: "en"
    }), bulmaCalendar.attach("#timepickerDemoRange", {
        color: "#7F00FF",
        lang: "en"
    }), bulmaCalendar.attach("#timepickerDemoInline", {
        displayMode: "inline",
        color: "#7F00FF",
        lang: "en"
    }), bulmaCalendar.attach("#datetimepickerDemoDefault", {
        color: "#7F00FF",
        lang: "en"
    }), bulmaCalendar.attach("#datetimepickerDemoDialog", {
        displayMode: "dialog",
        startDate: new Date("02/11/2018"),
        minDate: "01/01/2018",
        maxDate: "12/31/2018",
        color: "#7F00FF",
        lang: "en"
    }), bulmaCalendar.attach("#datetimepickerDemoInline", {
        displayMode: "inline",
        startDate: new Date("02/11/2018"),
        minDate: "01/01/2018",
        maxDate: "12/31/2018",
        color: "#7F00FF",
        lang: "en"
    }))
}
"use strict";

function initComboBox() {
    $(".is-combo .combo-box").on("click", function () {
        $(this).toggleClass("is-active")
    }), $(".combo-box .box-dropdown li").on("click", function (o) {
        var i = o.target,
            s = $(this).find(".item-icon i").attr("class"),
            t = $(this).find(".item-icon i"),
            e = (s = $(this).find(".item-icon i").attr("class"), $(this).find(".item-icon").html()),
            c = $(this).find(".item-name").text(),
            n = '<i class="' + s + '"></i>';
        console.log(e), $(i).is(".box-dropdown li, body") || $(i).parents().is(".box-dropdown") || $(".box-dropdown").removeClass("is-active"), $(i).is("body") && $(".box-dropdown").removeClass("is-active"), $(this).siblings("li.is-active").removeClass("is-active"), $(this).addClass("is-active"), t.length ? ($(this).closest(".combo-box").find(".combo-item i").remove(), $(this).closest(".combo-box").find(".combo-item svg").remove(), $(this).closest(".combo-box").find(".combo-item").prepend(n), $(this).closest(".combo-box").find(".combo-item .selected-item").text(c)) : ($(this).closest(".combo-box").find(".combo-item i").remove(), $(this).closest(".combo-box").find(".combo-item").prepend(e), $(this).closest(".combo-box").find(".combo-item .selected-item").text(c))
    })
}

function initImageComboBox() {
    $(".is-combo .image-combo-box").on("click", function () {
        $(this).toggleClass("is-active")
    }), $(".image-combo-box .box-dropdown li").on("click", function (o) {
        var i = o.target,
            s = $(this).find(".item-icon img").attr("src"),
            t = $(this).find(".item-name").text();
        $(i).is(".box-dropdown li, body") || $(i).parents().is(".box-dropdown") || $(".box-dropdown").removeClass("is-active"), $(i).is("body") && $(".box-dropdown").removeClass("is-active"), $(this).siblings("li.is-active").removeClass("is-active"), $(this).addClass("is-active"), $(this).closest(".image-combo-box").find(".combo-item img").attr("src", s), $(this).closest(".image-combo-box").find(".combo-item .selected-item").text(t)
    })
}

function initStackedComboBox() {
    $(".is-combo .stacked-combo-box").on("click", function () {
        $(this).toggleClass("is-active")
    }), $(".stacked-combo-box .box-dropdown li").on("click", function (o) {
        var i = o.target,
            s = $(this).find(".item-icon img").attr("src"),
            t = ($(this).find(".item-name").text(), $(this).attr("data-skill")),
            e = `\n                  <img id="${t}" class="is-stacked" src="${s}">\n              `;
        $(i).is(".box-dropdown li, body") || $(i).parents().is(".box-dropdown") || $(".box-dropdown").removeClass("is-active"), $(i).is("body") && $(".box-dropdown").removeClass("is-active"), $(this).toggleClass("is-active"), console.log(e), 0 == $(".stacked-combo-box li.is-active").length ? ($("#" + t).remove(), $("#img-placeholder").removeClass("is-hidden"), $(this).closest(".stacked-combo-box").find(".selected-item").text("Select one or more skills")) : ($("#img-placeholder").addClass("is-hidden"), $(this).closest(".stacked-combo-box").find(".selected-item").text(""), $("#" + t).length ? $("#" + t).remove() : $(this).closest(".stacked-combo-box").find(".combo-item").prepend(e))
    })
}
"use strict";

function initDatepicker() {
    $("#is-datepicker").length && $("#is-datepicker").dateDropper()
}

function initTimepicker() {
    $("#is-timepicker").length && $("#is-timepicker").timeDropper({
        primaryColor: "#4FC1EA",
        borderColor: "#4FC1EA",
        backgroundColor: "#FFF",
        init_animation: "fadeIn"
    })
}

function initDatepickerAlt() {
    $('[data-toggle="datepicker"]').datepicker()
}
"use strict";

function initFileInputs() {
    var t = document.querySelectorAll(".inputfile");
    Array.prototype.forEach.call(t, function (t) {
        var e = t.nextElementSibling,
            n = e.innerHTML;
        t.addEventListener("change", function (t) {
            var i = "";
            (i = this.files && this.files.length > 1 ? (this.getAttribute("data-multiple-caption") || "").replace("{count}", this.files.length) : t.target.value.split("\\").pop()) ? e.querySelector("span").innerHTML = i: e.innerHTML = n
        })
    });
    for (var e = document.querySelectorAll(".field-input"), n = 0, i = e.length; n < i; n++) a(e[n]);

    function a(t) {
        const e = t.querySelector('[type="file"]'),
            n = t.querySelector("[data-js-label]");
        e.onchange = e.onmouseout = function () {
            if (e.value) {
                var i = e.value.replace(/^.*[\\\/]/, "");
                t.className += " -chosen", n.innerText = i
            }
        }
    }
}

function initRangeInput() {
    if ($("#input-range").length) {
        var t = $("#input-range");

        function e(e) {
            var n = $(e).val();
            $(".value").text(n), $(".range").attr("data-value", n), t.attr("value", n)
        }
        t.bind("input", function () {
            e(t)
        }).bind("change", function () {
            e(t)
        })
    }
}

function initJqueryTagInput() {
    $(".tag-input").length && $(".tag-input").tagsInput({
        width: "100%",
        height: "120px",
        defaultText: "Add a tag",
        placeholderColor: "#999"
    })
}

function findOutputForSlider(t) {
    for (var e = t.id, n = document.getElementsByTagName("output"), i = 0; i < n.length; i++)
        if (n[i].htmlFor == e) return n[i]
}

function getSliderOutputPosition(t) {
    var e, n = window.getComputedStyle(t, null),
        i = parseInt(n.getPropertyValue("width"), 10);
    e = t.getAttribute("min") ? t.getAttribute("min") : 0;
    var a = (t.value - e) / (t.getAttribute("max") - e);
    return {
        position: (a < 0 ? 0 : a > 1 ? i : i * a) - 20 + "px"
    }
}

function initRangeInputs() {
    var t = document.querySelectorAll('input[type="range"].slider');
    [].forEach.call(t, function (t) {
        var e = findOutputForSlider(t);
        if (e) {
            if (t.classList.contains("has-output-tooltip")) {
                var n = getSliderOutputPosition(t);
                e.style.left = n.position
            }
            t.addEventListener("input", function (t) {
                if (t.target.classList.contains("has-output-tooltip")) {
                    var n = getSliderOutputPosition(t.target);
                    e.style.left = n.position
                }
                e.value = t.target.value
            })
        }
    })
}

function initContactToggler() {
    $(".tabbed-links li").on("click", function () {
        var t = $(this).attr("data-contact");
        $(".contact-block").addClass("is-hidden"), $("#" + t).removeClass("is-hidden"), $(".tabbed-links li.is-active").removeClass("is-active"), $(this).addClass("is-active")
    })
}
"use strict";

function initChosenSelects() {
    $(".chosen-select").length && $(".chosen-select").chosen({
        disable_search_threshold: 6,
        width: "100%"
    }), $(".chosen-multiple").length && $(".chosen-multiple").chosen({
        disable_search_threshold: 10,
        max_selected_options: 5,
        width: "100%"
    })
}

function initMaterialSelect() {
    $(".material-select").length && ($(".material-select .material-input").on("focus", function () {
        $(this).closest(".material-select").addClass("is-active")
    }), $(".material-select .dropdown-list .option").on("click", function () {
        var e = $(this).text();
        console.log(e), $(this).siblings(".option").removeClass("selected"), $(this).addClass("selected"), $(this).closest(".material-select").find(".material-input").val(e), $(this).closest(".material-select").removeClass("is-active").addClass("has-value")
    }), $(document).click(function (e) {
        var t = e.target;
        $(t).is(".material-select") || $(t).parents().is(".field, .control-material") || $(".material-select").removeClass("is-active")
    }))
}
"use strict";

function initAuth() {
    $("#contacted").on("click", function () {
        $(this).addClass("is-hidden"), $("#signup-form, #signup-intro").addClass("is-hidden"), $("#back-to-signup, #contacted-form, #contacted-intro").removeClass("is-hidden")
    }), $("#back-to-signup").on("click", function () {
        $(this).addClass("is-hidden"), $("#contacted-form, #contacted-intro").addClass("is-hidden"), $("#contacted, #signup-form, #signup-intro").removeClass("is-hidden")
    }), $("#recover").on("click", function () {
        $(this).addClass("is-hidden"), $("#signin-form").addClass("is-hidden"), $("#back-to-login, #recover-form").removeClass("is-hidden")
    }), $("#back-to-login").on("click", function () {
        $(this).addClass("is-hidden"), $("#recover-form").addClass("is-hidden"), $("#recover, #signin-form").removeClass("is-hidden")
    }), $(".action-btn").on("click", function () {
        var i = $(this);
        i.addClass("is-loading"), setTimeout(function () {
            "Register" === i.text() ? i.removeClass("is-loading").html("Login") : i.removeClass("is-loading").html("Register"), $(".form-wrapper").toggleClass("is-active")
        }, 1200)
    })
}
"use strict";
$(document).ready(function () {
    if ($(".product-page-v1").length && ($(".color-selector input, .product-thumb img").on("click", function () {
            var s = $(this).attr("data-image");
            $(".product-image.is-active").fadeOut(500).removeClass("is-active"), $(".left img[data-image = " + s + "]").fadeIn(250).addClass("is-active"), $(this).addClass("active"), $(".product-thumb.is-active").removeClass("is-active"), $(".product-thumb img[data-image = " + s + "]").parent().addClass("is-active")
        }), $(".related-products-inner").slick({
            dots: !1,
            infinite: !0,
            speed: 500,
            cssEase: "cubic-bezier(0.645, 0.045, 0.355, 1.000)",
            autoplay: !0,
            slidesToShow: 5,
            prevArrow: "<div class='slick-custom is-prev'><i class='fa fa-chevron-left'></i></div>",
            nextArrow: "<div class='slick-custom is-next'><i class='fa fa-chevron-right'></i></div>",
            responsive: [{
                breakpoint: 1025,
                settings: {
                    arrows: !1,
                    slidesToShow: 4
                }
            }, {
                breakpoint: 769,
                settings: {
                    arrows: !1,
                    slidesToShow: 3
                }
            }, {
                breakpoint: 480,
                settings: {
                    arrows: !1,
                    slidesToShow: 1
                }
            }]
        })), $(".grid-products").length && $(".grid-products-inner.is-carousel").slick({
            dots: !1,
            infinite: !0,
            speed: 500,
            cssEase: "cubic-bezier(0.645, 0.045, 0.355, 1.000)",
            autoplay: !0,
            slidesToShow: 4,
            prevArrow: "<div class='slick-custom is-prev'><i class='fa fa-chevron-left'></i></div>",
            nextArrow: "<div class='slick-custom is-next'><i class='fa fa-chevron-right'></i></div>",
            responsive: [{
                breakpoint: 1025,
                settings: {
                    arrows: !1,
                    slidesToShow: 3
                }
            }, {
                breakpoint: 769,
                settings: {
                    arrows: !1,
                    slidesToShow: 2
                }
            }, {
                breakpoint: 480,
                settings: {
                    arrows: !1,
                    slidesToShow: 1
                }
            }]
        }), $("#checkout-flow").length) {
        var s = 0,
            e = $("#checkout-next .button"),
            i = $("#submit-payment");
        e.on("click", function () {
            s += 1;
            var e = $(this);
            e.addClass("is-loading"), setTimeout(function () {
                e.removeClass("is-loading").addClass("is-disabled"), $("#checkout-flow-step-" + s).removeClass("is-hidden")
            }, 1500), setTimeout(function () {
                $("html, body").animate({
                    scrollTop: $("#checkout-flow-step-" + s).offset().top
                }, 500), 3 === s && $("#checkout-next").remove()
            }, 1600)
        }), i.one("click", function () {
            s += 1;
            var e = $(this);
            e.addClass("is-loading"), setTimeout(function () {
                e.removeClass("is-loading primary-btn").text("Payment Success!").addClass("no-click is-success"), $("#checkout-flow-step-" + s).removeClass("is-hidden")
            }, 1500), setTimeout(function () {
                $("html, body").animate({
                    scrollTop: $("#checkout-flow-step-" + s).offset().top
                }, 500), setTimeout(function () {
                    $(".SuccessAnimation").removeClass("is-hidden")
                }, 800)
            }, 1600)
        }), $(".method-card input").on("change", function () {
            $("#checkout-next .button").removeClass("is-disabled")
        })
    }
});
! function (e, t) {
    "object" == typeof exports && "object" == typeof module ? module.exports = t() : "function" == typeof define && define.amd ? define([], t) : "object" == typeof exports ? exports.bulmaCalendar = t() : e.bulmaCalendar = t()
}("undefined" != typeof self ? self : this, function () {
    return function (e) {
        var t = {};

        function n(o) {
            if (t[o]) return t[o].exports;
            var i = t[o] = {
                i: o,
                l: !1,
                exports: {}
            };
            return e[o].call(i.exports, i, i.exports, n), i.l = !0, i.exports
        }
        return n.m = e, n.c = t, n.d = function (e, t, o) {
            n.o(e, t) || Object.defineProperty(e, t, {
                configurable: !1,
                enumerable: !0,
                get: o
            })
        }, n.n = function (e) {
            var t = e && e.__esModule ? function () {
                return e.default
            } : function () {
                return e
            };
            return n.d(t, "a", t), t
        }, n.o = function (e, t) {
            return Object.prototype.hasOwnProperty.call(e, t)
        }, n.p = "", n(n.s = 232)
    }([function (e, t, n) {
        var o = n(120),
            i = 36e5,
            r = 6e4,
            a = /[T ]/,
            s = /:/,
            u = /^(\d{2})$/,
            c = [/^([+-]\d{2})$/, /^([+-]\d{3})$/, /^([+-]\d{4})$/],
            d = /^(\d{4})/,
            l = [/^([+-]\d{4})/, /^([+-]\d{5})/, /^([+-]\d{6})/],
            f = /^-(\d{2})$/,
            h = /^-?(\d{3})$/,
            m = /^-?(\d{2})-?(\d{2})$/,
            p = /^-?W(\d{2})$/,
            v = /^-?W(\d{2})-?(\d{1})$/,
            g = /^(\d{2}([.,]\d*)?)$/,
            _ = /^(\d{2}):?(\d{2}([.,]\d*)?)$/,
            b = /^(\d{2}):?(\d{2}):?(\d{2}([.,]\d*)?)$/,
            M = /([Z+-].*)$/,
            y = /^(Z)$/,
            k = /^([+-])(\d{2})$/,
            x = /^([+-])(\d{2}):?(\d{2})$/;

        function D(e, t, n) {
            t = t || 0, n = n || 0;
            var o = new Date(0);
            o.setUTCFullYear(e, 0, 4);
            var i = 7 * t + n + 1 - (o.getUTCDay() || 7);
            return o.setUTCDate(o.getUTCDate() + i), o
        }
        e.exports = function (e, t) {
            if (o(e)) return new Date(e.getTime());
            if ("string" != typeof e) return new Date(e);
            var n = (t || {}).additionalDigits;
            n = null == n ? 2 : Number(n);
            var j = function (e) {
                    var t, n = {},
                        o = e.split(a);
                    if (t = s.test(o[0]) ? (n.date = null, o[0]) : (n.date = o[0], o[1])) {
                        var i = M.exec(t);
                        i ? (n.time = t.replace(i[1], ""), n.timezone = i[1]) : n.time = t
                    }
                    return n
                }(e),
                w = function (e, t) {
                    var n, o = c[t],
                        i = l[t];
                    if (n = d.exec(e) || i.exec(e)) {
                        var r = n[1];
                        return {
                            year: parseInt(r, 10),
                            restDateString: e.slice(r.length)
                        }
                    }
                    if (n = u.exec(e) || o.exec(e)) {
                        var a = n[1];
                        return {
                            year: 100 * parseInt(a, 10),
                            restDateString: e.slice(a.length)
                        }
                    }
                    return {
                        year: null
                    }
                }(j.date, n),
                T = w.year,
                S = function (e, t) {
                    if (null === t) return null;
                    var n, o, i;
                    if (0 === e.length) return (o = new Date(0)).setUTCFullYear(t), o;
                    if (n = f.exec(e)) return o = new Date(0), i = parseInt(n[1], 10) - 1, o.setUTCFullYear(t, i), o;
                    if (n = h.exec(e)) {
                        o = new Date(0);
                        var r = parseInt(n[1], 10);
                        return o.setUTCFullYear(t, 0, r), o
                    }
                    if (n = m.exec(e)) {
                        o = new Date(0), i = parseInt(n[1], 10) - 1;
                        var a = parseInt(n[2], 10);
                        return o.setUTCFullYear(t, i, a), o
                    }
                    return (n = p.exec(e)) ? D(t, parseInt(n[1], 10) - 1) : (n = v.exec(e)) ? D(t, parseInt(n[1], 10) - 1, parseInt(n[2], 10) - 1) : null
                }(w.restDateString, T);
            if (S) {
                var P, H = S.getTime(),
                    Y = 0;
                return j.time && (Y = function (e) {
                    var t, n, o;
                    if (t = g.exec(e)) return (n = parseFloat(t[1].replace(",", "."))) % 24 * i;
                    if (t = _.exec(e)) return n = parseInt(t[1], 10), o = parseFloat(t[2].replace(",", ".")), n % 24 * i + o * r;
                    if (t = b.exec(e)) {
                        n = parseInt(t[1], 10), o = parseInt(t[2], 10);
                        var a = parseFloat(t[3].replace(",", "."));
                        return n % 24 * i + o * r + 1e3 * a
                    }
                    return null
                }(j.time)), P = j.timezone ? function (e) {
                    var t, n;
                    return (t = y.exec(e)) ? 0 : (t = k.exec(e)) ? (n = 60 * parseInt(t[2], 10), "+" === t[1] ? -n : n) : (t = x.exec(e)) ? (n = 60 * parseInt(t[2], 10) + parseInt(t[3], 10), "+" === t[1] ? -n : n) : 0
                }(j.timezone) : (P = new Date(H + Y).getTimezoneOffset(), new Date(H + Y + P * r).getTimezoneOffset()), new Date(H + Y + P * r)
            }
            return new Date(e)
        }
    }, function (e, t, n) {
        var o;
        ! function (i) {
            "use strict";
            var r = {},
                a = "en",
                s = {
                    en: {
                        MMMM: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
                        MMM: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
                        dddd: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
                        ddd: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
                        dd: ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"],
                        A: ["a.m.", "p.m."],
                        formatter: {
                            YYYY: function (e) {
                                return ("000" + e.getFullYear()).slice(-4)
                            },
                            YY: function (e) {
                                return ("0" + e.getFullYear()).slice(-2)
                            },
                            Y: function (e) {
                                return "" + e.getFullYear()
                            },
                            MMMM: function (e) {
                                return this.MMMM[e.getMonth()]
                            },
                            MMM: function (e) {
                                return this.MMM[e.getMonth()]
                            },
                            MM: function (e) {
                                return ("0" + (e.getMonth() + 1)).slice(-2)
                            },
                            M: function (e) {
                                return "" + (e.getMonth() + 1)
                            },
                            DD: function (e) {
                                return ("0" + e.getDate()).slice(-2)
                            },
                            D: function (e) {
                                return "" + e.getDate()
                            },
                            HH: function (e) {
                                return ("0" + e.getHours()).slice(-2)
                            },
                            H: function (e) {
                                return "" + e.getHours()
                            },
                            A: function (e) {
                                return this.A[11 < e.getHours() | 0]
                            },
                            hh: function (e) {
                                return ("0" + (e.getHours() % 12 || 12)).slice(-2)
                            },
                            h: function (e) {
                                return "" + (e.getHours() % 12 || 12)
                            },
                            mm: function (e) {
                                return ("0" + e.getMinutes()).slice(-2)
                            },
                            m: function (e) {
                                return "" + e.getMinutes()
                            },
                            ss: function (e) {
                                return ("0" + e.getSeconds()).slice(-2)
                            },
                            s: function (e) {
                                return "" + e.getSeconds()
                            },
                            SSS: function (e) {
                                return ("00" + e.getMilliseconds()).slice(-3)
                            },
                            SS: function (e) {
                                return ("0" + (e.getMilliseconds() / 10 | 0)).slice(-2)
                            },
                            S: function (e) {
                                return "" + (e.getMilliseconds() / 100 | 0)
                            },
                            dddd: function (e) {
                                return this.dddd[e.getDay()]
                            },
                            ddd: function (e) {
                                return this.ddd[e.getDay()]
                            },
                            dd: function (e) {
                                return this.dd[e.getDay()]
                            },
                            Z: function (e) {
                                var t = e.utc ? 0 : e.getTimezoneOffset() / .6;
                                return (0 < t ? "-" : "+") + ("000" + Math.abs(t - t % 100 * .4)).slice(-4)
                            },
                            post: function (e) {
                                return e
                            }
                        },
                        parser: {
                            find: function (e, t) {
                                for (var n, o = -1, i = 0, r = 0, a = e.length; r < a; r++) n = e[r], !t.indexOf(n) && n.length > i && (o = r, i = n.length);
                                return {
                                    index: o,
                                    length: i
                                }
                            },
                            MMMM: function (e) {
                                return this.parser.find(this.MMMM, e)
                            },
                            MMM: function (e) {
                                return this.parser.find(this.MMM, e)
                            },
                            A: function (e) {
                                return this.parser.find(this.A, e)
                            },
                            h: function (e, t) {
                                return (12 === e ? 0 : e) + 12 * t
                            },
                            pre: function (e) {
                                return e
                            }
                        }
                    }
                };
            r.format = function (e, t, n) {
                var o = r.addMinutes(e, n ? e.getTimezoneOffset() : 0),
                    i = s[a],
                    u = i.formatter;
                return o.utc = n, t.replace(/(\[[^\[\]]*]|\[.*\][^\[]*\]|YYYY|YY|MMM?M?|DD|HH|hh|mm|ss|SSS?|ddd?d?|.)/g, function (e) {
                    var n = u[e];
                    return n ? u.post(n.call(i, o, t)) : e.replace(/\[(.*)]/, "$1")
                })
            }, r.parse = function (e, t, n) {
                for (var o, i, u, c, d, l, f, h, m = s[a], p = m.parser.pre(e), v = 0, g = /(MMMM?|A)|(YYYY)|(SSS)|(MM|DD|HH|hh|mm|ss)|(YY|M|D|H|h|m|s|SS)|(S)|(.)/g, _ = {
                        2: /^\d{1,4}/,
                        3: /^\d{1,3}/,
                        4: /^\d\d/,
                        5: /^\d\d?/,
                        6: /^\d/
                    }, b = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31], M = {
                        Y: 1970,
                        M: 1,
                        D: 1,
                        H: 0,
                        m: 0,
                        s: 0,
                        S: 0
                    }; o = g.exec(t);) {
                    for (i = 0, c = 1, u = ""; !u;) u = o[++i];
                    if (d = u.charAt(0), l = p.slice(v), i < 2) f = m.parser[u].call(m, l, t), M[d] = f.index, "M" === d && M[d]++, c = f.length;
                    else if (i < 7) f = (l.match(_[i]) || [""])[0], M[d] = 0 | ("S" === d ? (f + "000").slice(0, -u.length) : f), c = f.length;
                    else if (" " !== d && d !== l[0]) return NaN;
                    if (!c) return NaN;
                    v += c
                }
                return v === p.length && f ? (M.Y += M.Y < 70 ? 2e3 : M.Y < 100 ? 1900 : 0, M.H = M.H || m.parser.h(M.h || 0, M.A || 0), h = new Date(M.Y, M.M - 1, M.D, M.H, M.m, M.s, M.S), b[1] += 0 | r.isLeapYear(h), M.M < 1 || 12 < M.M || M.D < 1 || M.D > b[M.M - 1] || 23 < M.H || 59 < M.m || 59 < M.s ? NaN : n ? r.addMinutes(h, -h.getTimezoneOffset()) : h) : NaN
            }, r.isValid = function (e, t) {
                return !!r.parse(e, t)
            }, r.addYears = function (e, t) {
                return r.addMonths(e, 12 * t)
            }, r.addMonths = function (e, t) {
                var n = new Date(e.getTime());
                return n.setMonth(n.getMonth() + t), n
            }, r.addDays = function (e, t) {
                var n = new Date(e.getTime());
                return n.setDate(n.getDate() + t), n
            }, r.addHours = function (e, t) {
                return r.addMilliseconds(e, 36e5 * t)
            }, r.addMinutes = function (e, t) {
                return r.addMilliseconds(e, 6e4 * t)
            }, r.addSeconds = function (e, t) {
                return r.addMilliseconds(e, 1e3 * t)
            }, r.addMilliseconds = function (e, t) {
                return new Date(e.getTime() + t)
            }, r.subtract = function (e, t) {
                var n = e.getTime() - t.getTime();
                return {
                    toMilliseconds: function () {
                        return n
                    },
                    toSeconds: function () {
                        return n / 1e3 | 0
                    },
                    toMinutes: function () {
                        return n / 6e4 | 0
                    },
                    toHours: function () {
                        return n / 36e5 | 0
                    },
                    toDays: function () {
                        return n / 864e5 | 0
                    }
                }
            }, r.isLeapYear = function (e) {
                var t = e.getFullYear();
                return !((t % 4 || !(t % 100)) && t % 400)
            }, r.isSameDay = function (e, t) {
                return r.format(e, "YYYYMMDD") === r.format(t, "YYYYMMDD")
            }, r.locale = function (e) {
                return e && (!s[e] && i && n(331)("./" + e), a = e), a
            }, r.getLocales = function (e) {
                return s[e || a]
            }, r.setLocales = function (e, t) {
                var n = function (e, t) {
                        var n, o, i = function () {};
                        for (o in i.prototype = t, n = new i, e) e.hasOwnProperty(o) && (n[o] = e[o]);
                        return n
                    },
                    o = s[e] || s.en,
                    i = n(t, o);
                t.formatter && (i.formatter = n(t.formatter, o.formatter)), t.parser && (i.parser = n(t.parser, o.parser)), s[e] = i
            }, "object" == typeof e && "object" == typeof e.exports ? e.exports = r : void 0 === (o = function () {
                return r
            }.apply(t, [])) || (e.exports = o)
        }(this)
    }, function (e, t) {
        var n = ["M", "MM", "Q", "D", "DD", "DDD", "DDDD", "d", "E", "W", "WW", "YY", "YYYY", "GG", "GGGG", "H", "HH", "h", "hh", "m", "mm", "s", "ss", "S", "SS", "SSS", "Z", "ZZ", "X", "x"];
        e.exports = function (e) {
            var t = [];
            for (var o in e) e.hasOwnProperty(o) && t.push(o);
            var i = n.concat(t).sort().reverse();
            return new RegExp("(\\[[^\\[]*\\])|(\\\\)?(" + i.join("|") + "|.)", "g")
        }
    }, function (e, t, n) {
        var o = n(0),
            i = n(4);
        e.exports = function (e) {
            var t = o(e),
                n = t.getFullYear(),
                r = new Date(0);
            r.setFullYear(n + 1, 0, 4), r.setHours(0, 0, 0, 0);
            var a = i(r),
                s = new Date(0);
            s.setFullYear(n, 0, 4), s.setHours(0, 0, 0, 0);
            var u = i(s);
            return t.getTime() >= a.getTime() ? n + 1 : t.getTime() >= u.getTime() ? n : n - 1
        }
    }, function (e, t, n) {
        var o = n(80);
        e.exports = function (e) {
            return o(e, {
                weekStartsOn: 1
            })
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e);
            return t.setHours(0, 0, 0, 0), t
        }
    }, function (e, t, n) {
        var o = n(12),
            i = n(13);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        e.exports = {
            addDays: n(8),
            addHours: n(130),
            addISOYears: n(131),
            addMilliseconds: n(9),
            addMinutes: n(133),
            addMonths: n(82),
            addQuarters: n(134),
            addSeconds: n(135),
            addWeeks: n(122),
            addYears: n(136),
            areRangesOverlapping: n(233),
            closestIndexTo: n(234),
            closestTo: n(235),
            compareAsc: n(11),
            compareDesc: n(123),
            differenceInCalendarDays: n(81),
            differenceInCalendarISOWeeks: n(236),
            differenceInCalendarISOYears: n(137),
            differenceInCalendarMonths: n(138),
            differenceInCalendarQuarters: n(237),
            differenceInCalendarWeeks: n(238),
            differenceInCalendarYears: n(140),
            differenceInDays: n(141),
            differenceInHours: n(239),
            differenceInISOYears: n(240),
            differenceInMilliseconds: n(83),
            differenceInMinutes: n(241),
            differenceInMonths: n(124),
            differenceInQuarters: n(242),
            differenceInSeconds: n(125),
            differenceInWeeks: n(243),
            differenceInYears: n(244),
            distanceInWords: n(143),
            distanceInWordsStrict: n(245),
            distanceInWordsToNow: n(246),
            eachDay: n(247),
            endOfDay: n(126),
            endOfHour: n(248),
            endOfISOWeek: n(249),
            endOfISOYear: n(250),
            endOfMinute: n(251),
            endOfMonth: n(145),
            endOfQuarter: n(252),
            endOfSecond: n(253),
            endOfToday: n(254),
            endOfTomorrow: n(255),
            endOfWeek: n(144),
            endOfYear: n(256),
            endOfYesterday: n(257),
            format: n(258),
            getDate: n(259),
            getDay: n(260),
            getDayOfYear: n(146),
            getDaysInMonth: n(121),
            getDaysInYear: n(261),
            getHours: n(262),
            getISODay: n(150),
            getISOWeek: n(127),
            getISOWeeksInYear: n(263),
            getISOYear: n(3),
            getMilliseconds: n(264),
            getMinutes: n(265),
            getMonth: n(266),
            getOverlappingDaysInRanges: n(267),
            getQuarter: n(139),
            getSeconds: n(268),
            getTime: n(269),
            getYear: n(270),
            isAfter: n(271),
            isBefore: n(272),
            isDate: n(120),
            isEqual: n(273),
            isFirstDayOfMonth: n(274),
            isFriday: n(275),
            isFuture: n(276),
            isLastDayOfMonth: n(277),
            isLeapYear: n(149),
            isMonday: n(278),
            isPast: n(279),
            isSameDay: n(280),
            isSameHour: n(151),
            isSameISOWeek: n(153),
            isSameISOYear: n(154),
            isSameMinute: n(155),
            isSameMonth: n(157),
            isSameQuarter: n(158),
            isSameSecond: n(160),
            isSameWeek: n(128),
            isSameYear: n(162),
            isSaturday: n(281),
            isSunday: n(282),
            isThisHour: n(283),
            isThisISOWeek: n(284),
            isThisISOYear: n(285),
            isThisMinute: n(286),
            isThisMonth: n(287),
            isThisQuarter: n(288),
            isThisSecond: n(289),
            isThisWeek: n(290),
            isThisYear: n(291),
            isThursday: n(292),
            isToday: n(293),
            isTomorrow: n(294),
            isTuesday: n(295),
            isValid: n(148),
            isWednesday: n(296),
            isWeekend: n(297),
            isWithinRange: n(298),
            isYesterday: n(299),
            lastDayOfISOWeek: n(300),
            lastDayOfISOYear: n(301),
            lastDayOfMonth: n(302),
            lastDayOfQuarter: n(303),
            lastDayOfWeek: n(163),
            lastDayOfYear: n(304),
            max: n(305),
            min: n(306),
            parse: n(0),
            setDate: n(307),
            setDay: n(308),
            setDayOfYear: n(309),
            setHours: n(310),
            setISODay: n(311),
            setISOWeek: n(312),
            setISOYear: n(132),
            setMilliseconds: n(313),
            setMinutes: n(314),
            setMonth: n(164),
            setQuarter: n(315),
            setSeconds: n(316),
            setYear: n(317),
            startOfDay: n(5),
            startOfHour: n(152),
            startOfISOWeek: n(4),
            startOfISOYear: n(10),
            startOfMinute: n(156),
            startOfMonth: n(318),
            startOfQuarter: n(159),
            startOfSecond: n(161),
            startOfToday: n(319),
            startOfTomorrow: n(320),
            startOfWeek: n(80),
            startOfYear: n(147),
            startOfYesterday: n(321),
            subDays: n(322),
            subHours: n(323),
            subISOYears: n(142),
            subMilliseconds: n(324),
            subMinutes: n(325),
            subMonths: n(326),
            subQuarters: n(327),
            subSeconds: n(328),
            subWeeks: n(329),
            subYears: n(330)
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = o(e),
                i = Number(t);
            return n.setDate(n.getDate() + i), n
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = o(e).getTime(),
                i = Number(t);
            return new Date(n + i)
        }
    }, function (e, t, n) {
        var o = n(3),
            i = n(4);
        e.exports = function (e) {
            var t = o(e),
                n = new Date(0);
            return n.setFullYear(t, 0, 4), n.setHours(0, 0, 0, 0), i(n)
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = o(e).getTime(),
                i = o(t).getTime();
            return n < i ? -1 : i < n ? 1 : 0
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "less than a second",
                    other: "less than {{count}} seconds"
                },
                xSeconds: {
                    one: "1 second",
                    other: "{{count}} seconds"
                },
                halfAMinute: "half a minute",
                lessThanXMinutes: {
                    one: "less than a minute",
                    other: "less than {{count}} minutes"
                },
                xMinutes: {
                    one: "1 minute",
                    other: "{{count}} minutes"
                },
                aboutXHours: {
                    one: "about 1 hour",
                    other: "about {{count}} hours"
                },
                xHours: {
                    one: "1 hour",
                    other: "{{count}} hours"
                },
                xDays: {
                    one: "1 day",
                    other: "{{count}} days"
                },
                aboutXMonths: {
                    one: "about 1 month",
                    other: "about {{count}} months"
                },
                xMonths: {
                    one: "1 month",
                    other: "{{count}} months"
                },
                aboutXYears: {
                    one: "about 1 year",
                    other: "about {{count}} years"
                },
                xYears: {
                    one: "1 year",
                    other: "{{count}} years"
                },
                overXYears: {
                    one: "over 1 year",
                    other: "over {{count}} years"
                },
                almostXYears: {
                    one: "almost 1 year",
                    other: "almost {{count}} years"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "in " + i : i + " ago" : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
                t = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
                n = ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"],
                i = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
                r = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
                a = ["AM", "PM"],
                s = ["am", "pm"],
                u = ["a.m.", "p.m."],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        var t = e % 100;
                        if (20 < t || t < 10) switch (t % 10) {
                            case 1:
                                return e + "st";
                            case 2:
                                return e + "nd";
                            case 3:
                                return e + "rd"
                        }
                        return e + "th"
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "أقل من ثانية واحدة",
                    other: "أقل من {{count}} ثواني"
                },
                xSeconds: {
                    one: "ثانية واحدة",
                    other: "{{count}} ثواني"
                },
                halfAMinute: "نصف دقيقة",
                lessThanXMinutes: {
                    one: "أقل من دقيقة",
                    other: "أقل من {{count}} دقيقة"
                },
                xMinutes: {
                    one: "دقيقة واحدة",
                    other: "{{count}} دقائق"
                },
                aboutXHours: {
                    one: "ساعة واحدة تقريباً",
                    other: "{{count}} ساعات تقريباً"
                },
                xHours: {
                    one: "ساعة واحدة",
                    other: "{{count}} ساعات"
                },
                xDays: {
                    one: "يوم واحد",
                    other: "{{count}} أيام"
                },
                aboutXMonths: {
                    one: "شهر واحد تقريباً",
                    other: "{{count}} أشهر تقريباً"
                },
                xMonths: {
                    one: "شهر واحد",
                    other: "{{count}} أشهر"
                },
                aboutXYears: {
                    one: "عام واحد تقريباً",
                    other: "{{count}} أعوام تقريباً"
                },
                xYears: {
                    one: "عام واحد",
                    other: "{{count}} أعوام"
                },
                overXYears: {
                    one: "أكثر من عام",
                    other: "أكثر من {{count}} أعوام"
                },
                almostXYears: {
                    one: "عام واحد تقريباً",
                    other: "{{count}} أعوام تقريباً"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "في خلال " + i : "منذ " + i : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"],
                t = ["كانون الثاني يناير", "شباط فبراير", "آذار مارس", "نيسان أبريل", "أيار مايو", "حزيران يونيو", "تموز يوليو", "آب أغسطس", "أيلول سبتمبر", "تشرين الأول أكتوبر", "تشرين الثاني نوفمبر", "كانون الأول ديسمبر"],
                n = ["ح", "ن", "ث", "ر", "خ", "ج", "س"],
                i = ["أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"],
                r = ["الأحد", "الإثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"],
                a = ["صباح", "مساء"],
                s = ["ص", "م"],
                u = ["صباحاً", "مساءاً"],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        return String(e)
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "по-малко от секунда",
                    other: "по-малко от {{count}} секунди"
                },
                xSeconds: {
                    one: "1 секунда",
                    other: "{{count}} секунди"
                },
                halfAMinute: "половин минута",
                lessThanXMinutes: {
                    one: "по-малко от минута",
                    other: "по-малко от {{count}} минути"
                },
                xMinutes: {
                    one: "1 минута",
                    other: "{{count}} минути"
                },
                aboutXHours: {
                    one: "около час",
                    other: "около {{count}} часа"
                },
                xHours: {
                    one: "1 час",
                    other: "{{count}} часа"
                },
                xDays: {
                    one: "1 ден",
                    other: "{{count}} дни"
                },
                aboutXMonths: {
                    one: "около месец",
                    other: "около {{count}} месеца"
                },
                xMonths: {
                    one: "1 месец",
                    other: "{{count}} месеца"
                },
                aboutXYears: {
                    one: "около година",
                    other: "около {{count}} години"
                },
                xYears: {
                    one: "1 година",
                    other: "{{count}} години"
                },
                overXYears: {
                    one: "над година",
                    other: "над {{count}} години"
                },
                almostXYears: {
                    one: "почти година",
                    other: "почти {{count}} години"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "след " + i : "преди " + i : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["яну", "фев", "мар", "апр", "май", "юни", "юли", "авг", "сеп", "окт", "ное", "дек"],
                t = ["януари", "февруари", "март", "април", "май", "юни", "юли", "август", "септември", "октомври", "ноември", "декември"],
                n = ["нд", "пн", "вт", "ср", "чт", "пт", "сб"],
                i = ["нед", "пон", "вто", "сря", "чет", "пет", "съб"],
                r = ["неделя", "понеделник", "вторник", "сряда", "четвъртък", "петък", "събота"],
                a = ["сутринта", "на обяд", "следобед", "вечерта"],
                s = function (e) {
                    var t = e.getHours();
                    return 4 <= t && t < 12 ? a[0] : 12 <= t && t < 14 ? a[1] : 14 <= t && t < 17 ? a[2] : a[3]
                },
                u = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: s,
                    a: s,
                    aa: s
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                u[e + "o"] = function (t, n) {
                    return function (e) {
                        var t = e % 100;
                        if (20 < t || t < 10) switch (t % 10) {
                            case 1:
                                return e + "-ви";
                            case 2:
                                return e + "-ри"
                        }
                        return e + "-и"
                    }(n[e](t))
                }
            }), {
                formatters: u,
                formattingTokensRegExp: o(u)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "menys d'un segon",
                    other: "menys de {{count}} segons"
                },
                xSeconds: {
                    one: "1 segon",
                    other: "{{count}} segons"
                },
                halfAMinute: "mig minut",
                lessThanXMinutes: {
                    one: "menys d'un minut",
                    other: "menys de {{count}} minuts"
                },
                xMinutes: {
                    one: "1 minut",
                    other: "{{count}} minuts"
                },
                aboutXHours: {
                    one: "aproximadament una hora",
                    other: "aproximadament {{count}} hores"
                },
                xHours: {
                    one: "1 hora",
                    other: "{{count}} hores"
                },
                xDays: {
                    one: "1 dia",
                    other: "{{count}} dies"
                },
                aboutXMonths: {
                    one: "aproximadament un mes",
                    other: "aproximadament {{count}} mesos"
                },
                xMonths: {
                    one: "1 mes",
                    other: "{{count}} mesos"
                },
                aboutXYears: {
                    one: "aproximadament un any",
                    other: "aproximadament {{count}} anys"
                },
                xYears: {
                    one: "1 any",
                    other: "{{count}} anys"
                },
                overXYears: {
                    one: "més d'un any",
                    other: "més de {{count}} anys"
                },
                almostXYears: {
                    one: "gairebé un any",
                    other: "gairebé {{count}} anys"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "en " + i : "fa " + i : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["gen", "feb", "mar", "abr", "mai", "jun", "jul", "ago", "set", "oct", "nov", "des"],
                t = ["gener", "febrer", "març", "abril", "maig", "juny", "juliol", "agost", "setembre", "octobre", "novembre", "desembre"],
                n = ["dg", "dl", "dt", "dc", "dj", "dv", "ds"],
                i = ["dge", "dls", "dts", "dcs", "djs", "dvs", "dss"],
                r = ["diumenge", "dilluns", "dimarts", "dimecres", "dijous", "divendres", "dissabte"],
                a = ["AM", "PM"],
                s = ["am", "pm"],
                u = ["a.m.", "p.m."],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        switch (e) {
                            case 1:
                                return "1r";
                            case 2:
                                return "2n";
                            case 3:
                                return "3r";
                            case 4:
                                return "4t";
                            default:
                                return e + "è"
                        }
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        function n(e, t, n) {
            var o = function (e, t) {
                return 1 === t ? e.one : 2 <= t && t <= 4 ? e.twoFour : e.other
            }(e, t);
            return (o[n] || o).replace("{{count}}", t)
        }

        function o(e) {
            var t = "";
            return "almost" === e && (t = "skoro"), "about" === e && (t = "přibližně"), 0 < t.length ? t + " " : ""
        }

        function i(e) {
            var t = "";
            return "lessThan" === e && (t = "méně než"), "over" === e && (t = "více než"), 0 < t.length ? t + " " : ""
        }
        e.exports = function () {
            var e = {
                xSeconds: {
                    one: {
                        regular: "vteřina",
                        past: "vteřinou",
                        future: "vteřinu"
                    },
                    twoFour: {
                        regular: "{{count}} vteřiny",
                        past: "{{count}} vteřinami",
                        future: "{{count}} vteřiny"
                    },
                    other: {
                        regular: "{{count}} vteřin",
                        past: "{{count}} vteřinami",
                        future: "{{count}} vteřin"
                    }
                },
                halfAMinute: {
                    other: {
                        regular: "půl minuty",
                        past: "půl minutou",
                        future: "půl minuty"
                    }
                },
                xMinutes: {
                    one: {
                        regular: "minuta",
                        past: "minutou",
                        future: "minutu"
                    },
                    twoFour: {
                        regular: "{{count}} minuty",
                        past: "{{count}} minutami",
                        future: "{{count}} minuty"
                    },
                    other: {
                        regular: "{{count}} minut",
                        past: "{{count}} minutami",
                        future: "{{count}} minut"
                    }
                },
                xHours: {
                    one: {
                        regular: "hodina",
                        past: "hodinou",
                        future: "hodinu"
                    },
                    twoFour: {
                        regular: "{{count}} hodiny",
                        past: "{{count}} hodinami",
                        future: "{{count}} hodiny"
                    },
                    other: {
                        regular: "{{count}} hodin",
                        past: "{{count}} hodinami",
                        future: "{{count}} hodin"
                    }
                },
                xDays: {
                    one: {
                        regular: "den",
                        past: "dnem",
                        future: "den"
                    },
                    twoFour: {
                        regular: "{{count}} dni",
                        past: "{{count}} dny",
                        future: "{{count}} dni"
                    },
                    other: {
                        regular: "{{count}} dní",
                        past: "{{count}} dny",
                        future: "{{count}} dní"
                    }
                },
                xMonths: {
                    one: {
                        regular: "měsíc",
                        past: "měsícem",
                        future: "měsíc"
                    },
                    twoFour: {
                        regular: "{{count}} měsíce",
                        past: "{{count}} měsíci",
                        future: "{{count}} měsíce"
                    },
                    other: {
                        regular: "{{count}} měsíců",
                        past: "{{count}} měsíci",
                        future: "{{count}} měsíců"
                    }
                },
                xYears: {
                    one: {
                        regular: "rok",
                        past: "rokem",
                        future: "rok"
                    },
                    twoFour: {
                        regular: "{{count}} roky",
                        past: "{{count}} roky",
                        future: "{{count}} roky"
                    },
                    other: {
                        regular: "{{count}} roků",
                        past: "{{count}} roky",
                        future: "{{count}} roků"
                    }
                }
            };
            return {
                localize: function (t, r, a) {
                    a = a || {};
                    var s = function (e) {
                            return ["lessThan", "about", "over", "almost"].filter(function (t) {
                                return !!e.match(new RegExp("^" + t))
                            })[0]
                        }(t) || "",
                        u = function (e) {
                            return e.charAt(0).toLowerCase() + e.slice(1)
                        }(t.substring(s.length)),
                        c = e[u];
                    return a.addSuffix ? 0 < a.comparison ? o(s) + "za " + i(s) + n(c, r, "future") : o(s) + "před " + i(s) + n(c, r, "past") : o(s) + i(s) + n(c, r, "regular")
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["led", "úno", "bře", "dub", "kvě", "čvn", "čvc", "srp", "zář", "říj", "lis", "pro"],
                t = ["leden", "únor", "březen", "duben", "květen", "červen", "červenec", "srpen", "září", "říjen", "listopad", "prosinec"],
                n = ["ne", "po", "út", "st", "čt", "pá", "so"],
                i = ["ned", "pon", "úte", "stř", "čtv", "pát", "sob"],
                r = ["neděle", "pondělí", "úterý", "středa", "čtvrtek", "pátek", "sobota"],
                a = ["DOP.", "ODP."],
                s = ["dop.", "odp."],
                u = ["dopoledne", "odpoledne"],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        return e + "."
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "mindre end et sekund",
                    other: "mindre end {{count}} sekunder"
                },
                xSeconds: {
                    one: "1 sekund",
                    other: "{{count}} sekunder"
                },
                halfAMinute: "et halvt minut",
                lessThanXMinutes: {
                    one: "mindre end et minut",
                    other: "mindre end {{count}} minutter"
                },
                xMinutes: {
                    one: "1 minut",
                    other: "{{count}} minutter"
                },
                aboutXHours: {
                    one: "cirka 1 time",
                    other: "cirka {{count}} timer"
                },
                xHours: {
                    one: "1 time",
                    other: "{{count}} timer"
                },
                xDays: {
                    one: "1 dag",
                    other: "{{count}} dage"
                },
                aboutXMonths: {
                    one: "cirka 1 måned",
                    other: "cirka {{count}} måneder"
                },
                xMonths: {
                    one: "1 måned",
                    other: "{{count}} måneder"
                },
                aboutXYears: {
                    one: "cirka 1 år",
                    other: "cirka {{count}} år"
                },
                xYears: {
                    one: "1 år",
                    other: "{{count}} år"
                },
                overXYears: {
                    one: "over 1 år",
                    other: "over {{count}} år"
                },
                almostXYears: {
                    one: "næsten 1 år",
                    other: "næsten {{count}} år"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "om " + i : i + " siden" : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["jan", "feb", "mar", "apr", "maj", "jun", "jul", "aug", "sep", "okt", "nov", "dec"],
                t = ["januar", "februar", "marts", "april", "maj", "juni", "juli", "august", "september", "oktober", "november", "december"],
                n = ["sø", "ma", "ti", "on", "to", "fr", "lø"],
                i = ["søn", "man", "tir", "ons", "tor", "fre", "lør"],
                r = ["søndag", "mandag", "tirsdag", "onsdag", "torsdag", "fredag", "lørdag"],
                a = ["AM", "PM"],
                s = ["am", "pm"],
                u = ["a.m.", "p.m."],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        return e + "."
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    standalone: {
                        one: "weniger als eine Sekunde",
                        other: "weniger als {{count}} Sekunden"
                    },
                    withPreposition: {
                        one: "weniger als einer Sekunde",
                        other: "weniger als {{count}} Sekunden"
                    }
                },
                xSeconds: {
                    standalone: {
                        one: "eine Sekunde",
                        other: "{{count}} Sekunden"
                    },
                    withPreposition: {
                        one: "einer Sekunde",
                        other: "{{count}} Sekunden"
                    }
                },
                halfAMinute: {
                    standalone: "eine halbe Minute",
                    withPreposition: "einer halben Minute"
                },
                lessThanXMinutes: {
                    standalone: {
                        one: "weniger als eine Minute",
                        other: "weniger als {{count}} Minuten"
                    },
                    withPreposition: {
                        one: "weniger als einer Minute",
                        other: "weniger als {{count}} Minuten"
                    }
                },
                xMinutes: {
                    standalone: {
                        one: "eine Minute",
                        other: "{{count}} Minuten"
                    },
                    withPreposition: {
                        one: "einer Minute",
                        other: "{{count}} Minuten"
                    }
                },
                aboutXHours: {
                    standalone: {
                        one: "etwa eine Stunde",
                        other: "etwa {{count}} Stunden"
                    },
                    withPreposition: {
                        one: "etwa einer Stunde",
                        other: "etwa {{count}} Stunden"
                    }
                },
                xHours: {
                    standalone: {
                        one: "eine Stunde",
                        other: "{{count}} Stunden"
                    },
                    withPreposition: {
                        one: "einer Stunde",
                        other: "{{count}} Stunden"
                    }
                },
                xDays: {
                    standalone: {
                        one: "ein Tag",
                        other: "{{count}} Tage"
                    },
                    withPreposition: {
                        one: "einem Tag",
                        other: "{{count}} Tagen"
                    }
                },
                aboutXMonths: {
                    standalone: {
                        one: "etwa ein Monat",
                        other: "etwa {{count}} Monate"
                    },
                    withPreposition: {
                        one: "etwa einem Monat",
                        other: "etwa {{count}} Monaten"
                    }
                },
                xMonths: {
                    standalone: {
                        one: "ein Monat",
                        other: "{{count}} Monate"
                    },
                    withPreposition: {
                        one: "einem Monat",
                        other: "{{count}} Monaten"
                    }
                },
                aboutXYears: {
                    standalone: {
                        one: "etwa ein Jahr",
                        other: "etwa {{count}} Jahre"
                    },
                    withPreposition: {
                        one: "etwa einem Jahr",
                        other: "etwa {{count}} Jahren"
                    }
                },
                xYears: {
                    standalone: {
                        one: "ein Jahr",
                        other: "{{count}} Jahre"
                    },
                    withPreposition: {
                        one: "einem Jahr",
                        other: "{{count}} Jahren"
                    }
                },
                overXYears: {
                    standalone: {
                        one: "mehr als ein Jahr",
                        other: "mehr als {{count}} Jahre"
                    },
                    withPreposition: {
                        one: "mehr als einem Jahr",
                        other: "mehr als {{count}} Jahren"
                    }
                },
                almostXYears: {
                    standalone: {
                        one: "fast ein Jahr",
                        other: "fast {{count}} Jahre"
                    },
                    withPreposition: {
                        one: "fast einem Jahr",
                        other: "fast {{count}} Jahren"
                    }
                }
            };
            return {
                localize: function (t, n, o) {
                    var i, r = (o = o || {}).addSuffix ? e[t].withPreposition : e[t].standalone;
                    return i = "string" == typeof r ? r : 1 === n ? r.one : r.other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "in " + i : "vor " + i : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["Jan", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"],
                t = ["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"],
                n = ["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"],
                i = ["Son", "Mon", "Die", "Mit", "Don", "Fre", "Sam"],
                r = ["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"],
                a = ["AM", "PM"],
                s = ["am", "pm"],
                u = ["a.m.", "p.m."],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        return e + "."
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "λιγότερο από ένα δευτερόλεπτο",
                    other: "λιγότερο από {{count}} δευτερόλεπτα"
                },
                xSeconds: {
                    one: "1 δευτερόλεπτο",
                    other: "{{count}} δευτερόλεπτα"
                },
                halfAMinute: "μισό λεπτό",
                lessThanXMinutes: {
                    one: "λιγότερο από ένα λεπτό",
                    other: "λιγότερο από {{count}} λεπτά"
                },
                xMinutes: {
                    one: "1 λεπτό",
                    other: "{{count}} λεπτά"
                },
                aboutXHours: {
                    one: "περίπου 1 ώρα",
                    other: "περίπου {{count}} ώρες"
                },
                xHours: {
                    one: "1 ώρα",
                    other: "{{count}} ώρες"
                },
                xDays: {
                    one: "1 ημέρα",
                    other: "{{count}} ημέρες"
                },
                aboutXMonths: {
                    one: "περίπου 1 μήνας",
                    other: "περίπου {{count}} μήνες"
                },
                xMonths: {
                    one: "1 μήνας",
                    other: "{{count}} μήνες"
                },
                aboutXYears: {
                    one: "περίπου 1 χρόνο",
                    other: "περίπου {{count}} χρόνια"
                },
                xYears: {
                    one: "1 χρόνο",
                    other: "{{count}} χρόνια"
                },
                overXYears: {
                    one: "πάνω από 1 χρόνο",
                    other: "πάνω από {{count}} χρόνια"
                },
                almostXYears: {
                    one: "περίπου 1 χρόνο",
                    other: "περίπου {{count}} χρόνια"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "σε " + i : i + " πρίν" : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["Ιαν", "Φεβ", "Μαρ", "Απρ", "Μαϊ", "Ιουν", "Ιουλ", "Αυγ", "Σεπ", "Οκτ", "Νοε", "Δεκ"],
                t = ["Ιανουάριος", "Φεβρουάριος", "Μάρτιος", "Απρίλιος", "Μάιος", "Ιούνιος", "Ιούλιος", "Αύγουστος", "Σεπτέμβριος", "Οκτώβριος", "Νοέμβριος", "Δεκέμβριος"],
                n = ["Ιανουαρίου", "Φεβρουαρίου", "Μαρτίου", "Απριλίου", "Μαΐου", "Ιουνίου", "Ιουλίου", "Αυγούστου", "Σεπτεμβρίου", "Οκτωβρίου", "Νοεμβρίου", "Δεκεμβρίου"],
                i = ["Κυ", "Δε", "Τρ", "Τε", "Πέ", "Πα", "Σά"],
                r = ["Κυρ", "Δευ", "Τρί", "Τετ", "Πέμ", "Παρ", "Σάβ"],
                a = ["Κυριακή", "Δευτέρα", "Τρίτη", "Τετάρτη", "Πέμπτη", "Παρασκευή", "Σάββατο"],
                s = ["ΠΜ", "ΜΜ"],
                u = ["πμ", "μμ"],
                c = ["π.μ.", "μ.μ."],
                d = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return i[e.getDay()]
                    },
                    ddd: function (e) {
                        return r[e.getDay()]
                    },
                    dddd: function (e) {
                        return a[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? c[1] : c[0]
                    }
                },
                l = {
                    M: "ος",
                    D: "η",
                    DDD: "η",
                    d: "η",
                    Q: "ο",
                    W: "η"
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                d[e + "o"] = function (t, n) {
                    return n[e](t) + l[e]
                }
            }), ["D", "Do", "DD"].forEach(function (e) {
                d[e + " MMMM"] = function (t, o) {
                    return (d[e] || o[e])(t, o) + " " + n[t.getMonth()]
                }
            }), {
                formatters: d,
                formattingTokensRegExp: o(d)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "malpli ol sekundo",
                    other: "malpli ol {{count}} sekundoj"
                },
                xSeconds: {
                    one: "1 sekundo",
                    other: "{{count}} sekundoj"
                },
                halfAMinute: "duonminuto",
                lessThanXMinutes: {
                    one: "malpli ol minuto",
                    other: "malpli ol {{count}} minutoj"
                },
                xMinutes: {
                    one: "1 minuto",
                    other: "{{count}} minutoj"
                },
                aboutXHours: {
                    one: "proksimume 1 horo",
                    other: "proksimume {{count}} horoj"
                },
                xHours: {
                    one: "1 horo",
                    other: "{{count}} horoj"
                },
                xDays: {
                    one: "1 tago",
                    other: "{{count}} tagoj"
                },
                aboutXMonths: {
                    one: "proksimume 1 monato",
                    other: "proksimume {{count}} monatoj"
                },
                xMonths: {
                    one: "1 monato",
                    other: "{{count}} monatoj"
                },
                aboutXYears: {
                    one: "proksimume 1 jaro",
                    other: "proksimume {{count}} jaroj"
                },
                xYears: {
                    one: "1 jaro",
                    other: "{{count}} jaroj"
                },
                overXYears: {
                    one: "pli ol 1 jaro",
                    other: "pli ol {{count}} jaroj"
                },
                almostXYears: {
                    one: "preskaŭ 1 jaro",
                    other: "preskaŭ {{count}} jaroj"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "post " + i : "antaŭ " + i : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["jan", "feb", "mar", "apr", "maj", "jun", "jul", "aŭg", "sep", "okt", "nov", "dec"],
                t = ["januaro", "februaro", "marto", "aprilo", "majo", "junio", "julio", "aŭgusto", "septembro", "oktobro", "novembro", "decembro"],
                n = ["di", "lu", "ma", "me", "ĵa", "ve", "sa"],
                i = ["dim", "lun", "mar", "mer", "ĵaŭ", "ven", "sab"],
                r = ["dimanĉo", "lundo", "mardo", "merkredo", "ĵaŭdo", "vendredo", "sabato"],
                a = ["A.T.M.", "P.T.M."],
                s = ["a.t.m.", "p.t.m."],
                u = ["antaŭtagmeze", "posttagmeze"],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return n[e](t) + "-a"
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "menos de un segundo",
                    other: "menos de {{count}} segundos"
                },
                xSeconds: {
                    one: "1 segundo",
                    other: "{{count}} segundos"
                },
                halfAMinute: "medio minuto",
                lessThanXMinutes: {
                    one: "menos de un minuto",
                    other: "menos de {{count}} minutos"
                },
                xMinutes: {
                    one: "1 minuto",
                    other: "{{count}} minutos"
                },
                aboutXHours: {
                    one: "alrededor de 1 hora",
                    other: "alrededor de {{count}} horas"
                },
                xHours: {
                    one: "1 hora",
                    other: "{{count}} horas"
                },
                xDays: {
                    one: "1 día",
                    other: "{{count}} días"
                },
                aboutXMonths: {
                    one: "alrededor de 1 mes",
                    other: "alrededor de {{count}} meses"
                },
                xMonths: {
                    one: "1 mes",
                    other: "{{count}} meses"
                },
                aboutXYears: {
                    one: "alrededor de 1 año",
                    other: "alrededor de {{count}} años"
                },
                xYears: {
                    one: "1 año",
                    other: "{{count}} años"
                },
                overXYears: {
                    one: "más de 1 año",
                    other: "más de {{count}} años"
                },
                almostXYears: {
                    one: "casi 1 año",
                    other: "casi {{count}} años"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "en " + i : "hace " + i : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"],
                t = ["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"],
                n = ["do", "lu", "ma", "mi", "ju", "vi", "sa"],
                i = ["dom", "lun", "mar", "mié", "jue", "vie", "sáb"],
                r = ["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"],
                a = ["AM", "PM"],
                s = ["am", "pm"],
                u = ["a.m.", "p.m."],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        return e + "º"
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            function e(e) {
                return e.replace(/sekuntia?/, "sekunnin")
            }

            function t(e) {
                return e.replace(/minuuttia?/, "minuutin")
            }

            function n(e) {
                return e.replace(/tuntia?/, "tunnin")
            }

            function o(e) {
                return e.replace(/(kuukausi|kuukautta)/, "kuukauden")
            }

            function i(e) {
                return e.replace(/(vuosi|vuotta)/, "vuoden")
            }
            var r = {
                lessThanXSeconds: {
                    one: "alle sekunti",
                    other: "alle {{count}} sekuntia",
                    futureTense: e
                },
                xSeconds: {
                    one: "sekunti",
                    other: "{{count}} sekuntia",
                    futureTense: e
                },
                halfAMinute: {
                    one: "puoli minuuttia",
                    other: "puoli minuuttia",
                    futureTense: function (e) {
                        return "puolen minuutin"
                    }
                },
                lessThanXMinutes: {
                    one: "alle minuutti",
                    other: "alle {{count}} minuuttia",
                    futureTense: t
                },
                xMinutes: {
                    one: "minuutti",
                    other: "{{count}} minuuttia",
                    futureTense: t
                },
                aboutXHours: {
                    one: "noin tunti",
                    other: "noin {{count}} tuntia",
                    futureTense: n
                },
                xHours: {
                    one: "tunti",
                    other: "{{count}} tuntia",
                    futureTense: n
                },
                xDays: {
                    one: "päivä",
                    other: "{{count}} päivää",
                    futureTense: function (e) {
                        return e.replace(/päivää?/, "päivän")
                    }
                },
                aboutXMonths: {
                    one: "noin kuukausi",
                    other: "noin {{count}} kuukautta",
                    futureTense: o
                },
                xMonths: {
                    one: "kuukausi",
                    other: "{{count}} kuukautta",
                    futureTense: o
                },
                aboutXYears: {
                    one: "noin vuosi",
                    other: "noin {{count}} vuotta",
                    futureTense: i
                },
                xYears: {
                    one: "vuosi",
                    other: "{{count}} vuotta",
                    futureTense: i
                },
                overXYears: {
                    one: "yli vuosi",
                    other: "yli {{count}} vuotta",
                    futureTense: i
                },
                almostXYears: {
                    one: "lähes vuosi",
                    other: "lähes {{count}} vuotta",
                    futureTense: i
                }
            };
            return {
                localize: function (e, t, n) {
                    n = n || {};
                    var o = r[e],
                        i = 1 === t ? o.one : o.other.replace("{{count}}", t);
                    return n.addSuffix ? 0 < n.comparison ? o.futureTense(i) + " kuluttua" : i + " sitten" : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["tammi", "helmi", "maalis", "huhti", "touko", "kesä", "heinä", "elo", "syys", "loka", "marras", "joulu"],
                t = ["tammikuu", "helmikuu", "maaliskuu", "huhtikuu", "toukokuu", "kesäkuu", "heinäkuu", "elokuu", "syyskuu", "lokakuu", "marraskuu", "joulukuu"],
                n = ["su", "ma", "ti", "ke", "to", "pe", "la"],
                i = ["sunnuntai", "maanantai", "tiistai", "keskiviikko", "torstai", "perjantai", "lauantai"];

            function r(e) {
                return e.getHours() < 12 ? "AP" : "IP"
            }
            var a = {
                MMM: function (t) {
                    return e[t.getMonth()]
                },
                MMMM: function (e) {
                    return t[e.getMonth()]
                },
                dd: function (e) {
                    return n[e.getDay()]
                },
                ddd: function (e) {
                    return n[e.getDay()]
                },
                dddd: function (e) {
                    return i[e.getDay()]
                },
                A: r,
                a: r,
                aa: r
            };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                a[e + "o"] = function (t, n) {
                    return n[e](t).toString() + "."
                }
            }), {
                formatters: a,
                formattingTokensRegExp: o(a)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "mas maliit sa isang segundo",
                    other: "mas maliit sa {{count}} segundo"
                },
                xSeconds: {
                    one: "1 segundo",
                    other: "{{count}} segundo"
                },
                halfAMinute: "kalahating minuto",
                lessThanXMinutes: {
                    one: "mas maliit sa isang minuto",
                    other: "mas maliit sa {{count}} minuto"
                },
                xMinutes: {
                    one: "1 minuto",
                    other: "{{count}} minuto"
                },
                aboutXHours: {
                    one: "mga 1 oras",
                    other: "mga {{count}} oras"
                },
                xHours: {
                    one: "1 oras",
                    other: "{{count}} oras"
                },
                xDays: {
                    one: "1 araw",
                    other: "{{count}} araw"
                },
                aboutXMonths: {
                    one: "mga 1 buwan",
                    other: "mga {{count}} buwan"
                },
                xMonths: {
                    one: "1 buwan",
                    other: "{{count}} buwan"
                },
                aboutXYears: {
                    one: "mga 1 taon",
                    other: "mga {{count}} taon"
                },
                xYears: {
                    one: "1 taon",
                    other: "{{count}} taon"
                },
                overXYears: {
                    one: "higit sa 1 taon",
                    other: "higit sa {{count}} taon"
                },
                almostXYears: {
                    one: "halos 1 taon",
                    other: "halos {{count}} taon"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "sa loob ng " + i : i + " ang nakalipas" : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["Ene", "Peb", "Mar", "Abr", "May", "Hun", "Hul", "Ago", "Set", "Okt", "Nob", "Dis"],
                t = ["Enero", "Pebrero", "Marso", "Abril", "Mayo", "Hunyo", "Hulyo", "Agosto", "Setyembre", "Oktubre", "Nobyembre", "Disyembre"],
                n = ["Li", "Lu", "Ma", "Mi", "Hu", "Bi", "Sa"],
                i = ["Lin", "Lun", "Mar", "Miy", "Huw", "Biy", "Sab"],
                r = ["Linggo", "Lunes", "Martes", "Miyerkules", "Huwebes", "Biyernes", "Sabado"],
                a = ["NU", "NT", "NH", "NG"],
                s = ["nu", "nt", "nh", "ng"],
                u = ["ng umaga", "ng tanghali", "ng hapon", "ng gabi"],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 12 < e.getHours() ? e.getHours() % 12 < 6 ? a[2] : a[3] : e.getHours() < 12 ? a[0] : a[1]
                    },
                    a: function (e) {
                        return 12 < e.getHours() ? e.getHours() % 12 < 6 ? s[2] : s[3] : e.getHours() < 12 ? s[0] : s[1]
                    },
                    aa: function (e) {
                        return 12 < e.getHours() ? e.getHours() % 12 < 6 ? u[2] : u[3] : e.getHours() < 12 ? u[0] : u[1]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        return "ika-" + e
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "moins d’une seconde",
                    other: "moins de {{count}} secondes"
                },
                xSeconds: {
                    one: "1 seconde",
                    other: "{{count}} secondes"
                },
                halfAMinute: "30 secondes",
                lessThanXMinutes: {
                    one: "moins d’une minute",
                    other: "moins de {{count}} minutes"
                },
                xMinutes: {
                    one: "1 minute",
                    other: "{{count}} minutes"
                },
                aboutXHours: {
                    one: "environ 1 heure",
                    other: "environ {{count}} heures"
                },
                xHours: {
                    one: "1 heure",
                    other: "{{count}} heures"
                },
                xDays: {
                    one: "1 jour",
                    other: "{{count}} jours"
                },
                aboutXMonths: {
                    one: "environ 1 mois",
                    other: "environ {{count}} mois"
                },
                xMonths: {
                    one: "1 mois",
                    other: "{{count}} mois"
                },
                aboutXYears: {
                    one: "environ 1 an",
                    other: "environ {{count}} ans"
                },
                xYears: {
                    one: "1 an",
                    other: "{{count}} ans"
                },
                overXYears: {
                    one: "plus d’un an",
                    other: "plus de {{count}} ans"
                },
                almostXYears: {
                    one: "presqu’un an",
                    other: "presque {{count}} ans"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "dans " + i : "il y a " + i : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["janv.", "févr.", "mars", "avr.", "mai", "juin", "juill.", "août", "sept.", "oct.", "nov.", "déc."],
                t = ["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"],
                n = ["di", "lu", "ma", "me", "je", "ve", "sa"],
                i = ["dim.", "lun.", "mar.", "mer.", "jeu.", "ven.", "sam."],
                r = ["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"],
                a = ["AM", "PM"],
                s = ["am", "pm"],
                u = ["du matin", "de l’après-midi", "du soir"],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        var t = e.getHours();
                        return t <= 12 ? u[0] : t <= 16 ? u[1] : u[2]
                    },
                    Wo: function (e, t) {
                        return function (e) {
                            return 1 !== e ? e + "e" : "1re"
                        }(t.W(e))
                    }
                };
            return ["M", "D", "DDD", "d", "Q"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        return 1 !== e ? e + "e" : "1er"
                    }(n[e](t))
                }
            }), ["MMM", "MMMM"].forEach(function (e) {
                c["Do " + e] = function (t, n) {
                    var o = 1 === t.getDate() ? "Do" : "D";
                    return (c[o] || n[o])(t, n) + " " + c[e](t)
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: {
                        standalone: "manje od 1 sekunde",
                        withPrepositionAgo: "manje od 1 sekunde",
                        withPrepositionIn: "manje od 1 sekundu"
                    },
                    dual: "manje od {{count}} sekunde",
                    other: "manje od {{count}} sekundi"
                },
                xSeconds: {
                    one: {
                        standalone: "1 sekunda",
                        withPrepositionAgo: "1 sekunde",
                        withPrepositionIn: "1 sekundu"
                    },
                    dual: "{{count}} sekunde",
                    other: "{{count}} sekundi"
                },
                halfAMinute: "pola minute",
                lessThanXMinutes: {
                    one: {
                        standalone: "manje od 1 minute",
                        withPrepositionAgo: "manje od 1 minute",
                        withPrepositionIn: "manje od 1 minutu"
                    },
                    dual: "manje od {{count}} minute",
                    other: "manje od {{count}} minuta"
                },
                xMinutes: {
                    one: {
                        standalone: "1 minuta",
                        withPrepositionAgo: "1 minute",
                        withPrepositionIn: "1 minutu"
                    },
                    dual: "{{count}} minute",
                    other: "{{count}} minuta"
                },
                aboutXHours: {
                    one: {
                        standalone: "oko 1 sat",
                        withPrepositionAgo: "oko 1 sat",
                        withPrepositionIn: "oko 1 sat"
                    },
                    dual: "oko {{count}} sata",
                    other: "oko {{count}} sati"
                },
                xHours: {
                    one: {
                        standalone: "1 sat",
                        withPrepositionAgo: "1 sat",
                        withPrepositionIn: "1 sat"
                    },
                    dual: "{{count}} sata",
                    other: "{{count}} sati"
                },
                xDays: {
                    one: {
                        standalone: "1 dan",
                        withPrepositionAgo: "1 dan",
                        withPrepositionIn: "1 dan"
                    },
                    dual: "{{count}} dana",
                    other: "{{count}} dana"
                },
                aboutXMonths: {
                    one: {
                        standalone: "oko 1 mjesec",
                        withPrepositionAgo: "oko 1 mjesec",
                        withPrepositionIn: "oko 1 mjesec"
                    },
                    dual: "oko {{count}} mjeseca",
                    other: "oko {{count}} mjeseci"
                },
                xMonths: {
                    one: {
                        standalone: "1 mjesec",
                        withPrepositionAgo: "1 mjesec",
                        withPrepositionIn: "1 mjesec"
                    },
                    dual: "{{count}} mjeseca",
                    other: "{{count}} mjeseci"
                },
                aboutXYears: {
                    one: {
                        standalone: "oko 1 godinu",
                        withPrepositionAgo: "oko 1 godinu",
                        withPrepositionIn: "oko 1 godinu"
                    },
                    dual: "oko {{count}} godine",
                    other: "oko {{count}} godina"
                },
                xYears: {
                    one: {
                        standalone: "1 godina",
                        withPrepositionAgo: "1 godine",
                        withPrepositionIn: "1 godinu"
                    },
                    dual: "{{count}} godine",
                    other: "{{count}} godina"
                },
                overXYears: {
                    one: {
                        standalone: "preko 1 godinu",
                        withPrepositionAgo: "preko 1 godinu",
                        withPrepositionIn: "preko 1 godinu"
                    },
                    dual: "preko {{count}} godine",
                    other: "preko {{count}} godina"
                },
                almostXYears: {
                    one: {
                        standalone: "gotovo 1 godinu",
                        withPrepositionAgo: "gotovo 1 godinu",
                        withPrepositionIn: "gotovo 1 godinu"
                    },
                    dual: "gotovo {{count}} godine",
                    other: "gotovo {{count}} godina"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? o.addSuffix ? 0 < o.comparison ? e[t].one.withPrepositionIn : e[t].one.withPrepositionAgo : e[t].one.standalone : 1 < n % 10 && n % 10 < 5 && "1" !== String(n).substr(-2, 1) ? e[t].dual.replace("{{count}}", n) : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "za " + i : "prije " + i : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["sij", "velj", "ožu", "tra", "svi", "lip", "srp", "kol", "ruj", "lis", "stu", "pro"],
                t = ["siječanj", "veljača", "ožujak", "travanj", "svibanj", "lipanj", "srpanj", "kolovoz", "rujan", "listopad", "studeni", "prosinac"],
                n = ["siječnja", "veljače", "ožujka", "travnja", "svibnja", "lipnja", "srpnja", "kolovoza", "rujna", "listopada", "studenog", "prosinca"],
                i = ["ne", "po", "ut", "sr", "če", "pe", "su"],
                r = ["ned", "pon", "uto", "sri", "čet", "pet", "sub"],
                a = ["nedjelja", "ponedjeljak", "utorak", "srijeda", "četvrtak", "petak", "subota"],
                s = ["ujutro", "popodne"],
                u = ["ujutro", "popodne"],
                c = ["ujutro", "popodne"],
                d = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return i[e.getDay()]
                    },
                    ddd: function (e) {
                        return r[e.getDay()]
                    },
                    dddd: function (e) {
                        return a[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? c[1] : c[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                d[e + "o"] = function (t, n) {
                    return function (e) {
                        return e + "."
                    }(n[e](t))
                }
            }), ["D", "Do", "DD"].forEach(function (e) {
                d[e + " MMM"] = function (t, o) {
                    return (d[e] || o[e])(t, o) + " " + n[t.getMonth()]
                }
            }), {
                formatters: d,
                formattingTokensRegExp: o(d)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "kevesebb, mint egy másodperce",
                    other: "kevesebb, mint {{count}} másodperce"
                },
                xSeconds: {
                    one: "1 másodperce",
                    other: "{{count}} másodperce"
                },
                halfAMinute: "fél perce",
                lessThanXMinutes: {
                    one: "kevesebb, mint egy perce",
                    other: "kevesebb, mint {{count}} perce"
                },
                xMinutes: {
                    one: "1 perce",
                    other: "{{count}} perce"
                },
                aboutXHours: {
                    one: "közel 1 órája",
                    other: "közel {{count}} órája"
                },
                xHours: {
                    one: "1 órája",
                    other: "{{count}} órája"
                },
                xDays: {
                    one: "1 napja",
                    other: "{{count}} napja"
                },
                aboutXMonths: {
                    one: "közel 1 hónapja",
                    other: "közel {{count}} hónapja"
                },
                xMonths: {
                    one: "1 hónapja",
                    other: "{{count}} hónapja"
                },
                aboutXYears: {
                    one: "közel 1 éve",
                    other: "közel {{count}} éve"
                },
                xYears: {
                    one: "1 éve",
                    other: "{{count}} éve"
                },
                overXYears: {
                    one: "több, mint 1 éve",
                    other: "több, mint {{count}} éve"
                },
                almostXYears: {
                    one: "majdnem 1 éve",
                    other: "majdnem {{count}} éve"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "" + i : i + "" : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["Jan", "Feb", "Már", "Ápr", "Máj", "Jún", "Júl", "Aug", "Sze", "Okt", "Nov", "Dec"],
                t = ["Január", "Február", "Március", "Április", "Május", "Június", "Július", "Augusztus", "Szeptember", "Október", "November", "December"],
                n = ["Va", "Hé", "Ke", "Sze", "Cs", "Pé", "Szo"],
                i = ["Vas", "Hét", "Ked", "Sze", "Csü", "Pén", "Szo"],
                r = ["Vasárnap", "Hétfő", "Kedd", "Szerda", "Csütörtök", "Péntek", "Szombat"],
                a = ["DE", "DU"],
                s = ["de", "du"],
                u = ["délelőtt", "délután"],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        var t = e % 100;
                        if (20 < t || t < 10) switch (t % 10) {
                            case 1:
                                return e + "st";
                            case 2:
                                return e + "nd";
                            case 3:
                                return e + "rd"
                        }
                        return e + "th"
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "kurang dari 1 detik",
                    other: "kurang dari {{count}} detik"
                },
                xSeconds: {
                    one: "1 detik",
                    other: "{{count}} detik"
                },
                halfAMinute: "setengah menit",
                lessThanXMinutes: {
                    one: "kurang dari 1 menit",
                    other: "kurang dari {{count}} menit"
                },
                xMinutes: {
                    one: "1 menit",
                    other: "{{count}} menit"
                },
                aboutXHours: {
                    one: "sekitar 1 jam",
                    other: "sekitar {{count}} jam"
                },
                xHours: {
                    one: "1 jam",
                    other: "{{count}} jam"
                },
                xDays: {
                    one: "1 hari",
                    other: "{{count}} hari"
                },
                aboutXMonths: {
                    one: "sekitar 1 bulan",
                    other: "sekitar {{count}} bulan"
                },
                xMonths: {
                    one: "1 bulan",
                    other: "{{count}} bulan"
                },
                aboutXYears: {
                    one: "sekitar 1 tahun",
                    other: "sekitar {{count}} tahun"
                },
                xYears: {
                    one: "1 tahun",
                    other: "{{count}} tahun"
                },
                overXYears: {
                    one: "lebih dari 1 tahun",
                    other: "lebih dari {{count}} tahun"
                },
                almostXYears: {
                    one: "hampir 1 tahun",
                    other: "hampir {{count}} tahun"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "dalam waktu " + i : i + " yang lalu" : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["Jan", "Feb", "Mar", "Apr", "Mei", "Jun", "Jul", "Agu", "Sep", "Okt", "Nov", "Des"],
                t = ["Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember"],
                n = ["Mi", "Sn", "Sl", "Ra", "Ka", "Ju", "Sa"],
                i = ["Min", "Sen", "Sel", "Rab", "Kam", "Jum", "Sab"],
                r = ["Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"],
                a = ["AM", "PM"],
                s = ["am", "pm"],
                u = ["a.m.", "p.m."],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        switch (e) {
                            case 1:
                                return "pertama";
                            case 2:
                                return "kedua";
                            case 3:
                                return "ketiga";
                            default:
                                return "ke-" + e
                        }
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "minna en 1 sekúnda",
                    other: "minna en {{count}} sekúndur"
                },
                xSeconds: {
                    one: "1 sekúnda",
                    other: "{{count}} sekúndur"
                },
                halfAMinute: "hálf mínúta",
                lessThanXMinutes: {
                    one: "minna en 1 mínúta",
                    other: "minna en {{count}} mínútur"
                },
                xMinutes: {
                    one: "1 mínúta",
                    other: "{{count}} mínútur"
                },
                aboutXHours: {
                    one: "u.þ.b. 1 klukkustund",
                    other: "u.þ.b. {{count}} klukkustundir"
                },
                xHours: {
                    one: "1 klukkustund",
                    other: "{{count}} klukkustundir"
                },
                xDays: {
                    one: "1 dagur",
                    other: "{{count}} dagar"
                },
                aboutXMonths: {
                    one: "u.þ.b. 1 mánuður",
                    other: "u.þ.b. {{count}} mánuðir"
                },
                xMonths: {
                    one: "1 mánuður",
                    other: "{{count}} mánuðir"
                },
                aboutXYears: {
                    one: "u.þ.b. 1 ár",
                    other: "u.þ.b. {{count}} ár"
                },
                xYears: {
                    one: "1 ár",
                    other: "{{count}} ár"
                },
                overXYears: {
                    one: "meira en 1 ár",
                    other: "meira en {{count}} ár"
                },
                almostXYears: {
                    one: "næstum 1 ár",
                    other: "næstum {{count}} ár"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "í " + i : i + " síðan" : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["jan", "feb", "mar", "apr", "maí", "jún", "júl", "ágú", "sep", "okt", "nóv", "des"],
                t = ["janúar", "febrúar", "mars", "apríl", "maí", "júní", "júlí", "ágúst", "september", "október", "nóvember", "desember"],
                n = ["su", "má", "þr", "mi", "fi", "fö", "la"],
                i = ["sun", "mán", "þri", "mið", "fim", "fös", "lau"],
                r = ["sunnudaginn", "mánudaginn", "þriðjudaginn", "miðvikudaginn", "fimmtudaginn", "föstudaginn", "laugardaginn"],
                a = ["AM", "PM"],
                s = ["am", "pm"],
                u = ["a.m.", "p.m."],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        return "" + e
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "meno di un secondo",
                    other: "meno di {{count}} secondi"
                },
                xSeconds: {
                    one: "un secondo",
                    other: "{{count}} secondi"
                },
                halfAMinute: "alcuni secondi",
                lessThanXMinutes: {
                    one: "meno di un minuto",
                    other: "meno di {{count}} minuti"
                },
                xMinutes: {
                    one: "un minuto",
                    other: "{{count}} minuti"
                },
                aboutXHours: {
                    one: "circa un'ora",
                    other: "circa {{count}} ore"
                },
                xHours: {
                    one: "un'ora",
                    other: "{{count}} ore"
                },
                xDays: {
                    one: "un giorno",
                    other: "{{count}} giorni"
                },
                aboutXMonths: {
                    one: "circa un mese",
                    other: "circa {{count}} mesi"
                },
                xMonths: {
                    one: "un mese",
                    other: "{{count}} mesi"
                },
                aboutXYears: {
                    one: "circa un anno",
                    other: "circa {{count}} anni"
                },
                xYears: {
                    one: "un anno",
                    other: "{{count}} anni"
                },
                overXYears: {
                    one: "più di un anno",
                    other: "più di {{count}} anni"
                },
                almostXYears: {
                    one: "quasi un anno",
                    other: "quasi {{count}} anni"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "tra " + i : i + " fa" : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["gen", "feb", "mar", "apr", "mag", "giu", "lug", "ago", "set", "ott", "nov", "dic"],
                t = ["gennaio", "febbraio", "marzo", "aprile", "maggio", "giugno", "luglio", "agosto", "settembre", "ottobre", "novembre", "dicembre"],
                n = ["do", "lu", "ma", "me", "gi", "ve", "sa"],
                i = ["dom", "lun", "mar", "mer", "gio", "ven", "sab"],
                r = ["domenica", "lunedì", "martedì", "mercoledì", "giovedì", "venerdì", "sabato"],
                a = ["AM", "PM"],
                s = ["am", "pm"],
                u = ["a.m.", "p.m."],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        return e + "º"
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "1秒以下",
                    other: "{{count}}秒以下"
                },
                xSeconds: {
                    one: "1秒",
                    other: "{{count}}秒"
                },
                halfAMinute: "30秒ぐらい",
                lessThanXMinutes: {
                    one: "1分以下",
                    other: "{{count}}分以下"
                },
                xMinutes: {
                    one: "1分",
                    other: "{{count}}分"
                },
                aboutXHours: {
                    one: "1時間ぐらい",
                    other: "{{count}}時間ぐらい"
                },
                xHours: {
                    one: "1時間",
                    other: "{{count}}時間"
                },
                xDays: {
                    one: "1日",
                    other: "{{count}}日"
                },
                aboutXMonths: {
                    one: "1ヶ月ぐらい",
                    other: "{{count}}ヶ月ぐらい"
                },
                xMonths: {
                    one: "1ヶ月",
                    other: "{{count}}ヶ月"
                },
                aboutXYears: {
                    one: "1年ぐらい",
                    other: "{{count}}年ぐらい"
                },
                xYears: {
                    one: "1年",
                    other: "{{count}}年"
                },
                overXYears: {
                    one: "1年以上",
                    other: "{{count}}年以上"
                },
                almostXYears: {
                    one: "1年以下",
                    other: "{{count}}年以下"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? i + "後" : i + "前" : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"],
                t = ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"],
                n = ["日", "月", "火", "水", "木", "金", "土"],
                i = ["日曜", "月曜", "火曜", "水曜", "木曜", "金曜", "土曜"],
                r = ["日曜日", "月曜日", "火曜日", "水曜日", "木曜日", "金曜日", "土曜日"],
                a = ["午前", "午後"],
                s = ["午前", "午後"],
                u = ["午前", "午後"],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        return e + "日"
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "1초 미만",
                    other: "{{count}}초 미만"
                },
                xSeconds: {
                    one: "1초",
                    other: "{{count}}초"
                },
                halfAMinute: "30초",
                lessThanXMinutes: {
                    one: "1분 미만",
                    other: "{{count}}분 미만"
                },
                xMinutes: {
                    one: "1분",
                    other: "{{count}}분"
                },
                aboutXHours: {
                    one: "약 1시간",
                    other: "약 {{count}}시간"
                },
                xHours: {
                    one: "1시간",
                    other: "{{count}}시간"
                },
                xDays: {
                    one: "1일",
                    other: "{{count}}일"
                },
                aboutXMonths: {
                    one: "약 1개월",
                    other: "약 {{count}}개월"
                },
                xMonths: {
                    one: "1개월",
                    other: "{{count}}개월"
                },
                aboutXYears: {
                    one: "약 1년",
                    other: "약 {{count}}년"
                },
                xYears: {
                    one: "1년",
                    other: "{{count}}년"
                },
                overXYears: {
                    one: "1년 이상",
                    other: "{{count}}년 이상"
                },
                almostXYears: {
                    one: "거의 1년",
                    other: "거의 {{count}}년"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? i + " 후" : i + " 전" : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["1월", "2월", "3월", "4월", "5월", "6월", "7월", "8월", "9월", "10월", "11월", "12월"],
                t = ["1월", "2월", "3월", "4월", "5월", "6월", "7월", "8월", "9월", "10월", "11월", "12월"],
                n = ["일", "월", "화", "수", "목", "금", "토"],
                i = ["일", "월", "화", "수", "목", "금", "토"],
                r = ["일요일", "월요일", "화요일", "수요일", "목요일", "금요일", "토요일"],
                a = ["오전", "오후"],
                s = ["오전", "오후"],
                u = ["오전", "오후"],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        return e + "일"
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "помалку од секунда",
                    other: "помалку од {{count}} секунди"
                },
                xSeconds: {
                    one: "1 секунда",
                    other: "{{count}} секунди"
                },
                halfAMinute: "половина минута",
                lessThanXMinutes: {
                    one: "помалку од минута",
                    other: "помалку од {{count}} минути"
                },
                xMinutes: {
                    one: "1 минута",
                    other: "{{count}} минути"
                },
                aboutXHours: {
                    one: "околу 1 час",
                    other: "околу {{count}} часа"
                },
                xHours: {
                    one: "1 час",
                    other: "{{count}} часа"
                },
                xDays: {
                    one: "1 ден",
                    other: "{{count}} дена"
                },
                aboutXMonths: {
                    one: "околу 1 месец",
                    other: "околу {{count}} месеци"
                },
                xMonths: {
                    one: "1 месец",
                    other: "{{count}} месеци"
                },
                aboutXYears: {
                    one: "околу 1 година",
                    other: "околу {{count}} години"
                },
                xYears: {
                    one: "1 година",
                    other: "{{count}} години"
                },
                overXYears: {
                    one: "повеќе од 1 година",
                    other: "повеќе од {{count}} години"
                },
                almostXYears: {
                    one: "безмалку 1 година",
                    other: "безмалку {{count}} години"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "за " + i : "пред " + i : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["јан", "фев", "мар", "апр", "мај", "јун", "јул", "авг", "сеп", "окт", "ное", "дек"],
                t = ["јануари", "февруари", "март", "април", "мај", "јуни", "јули", "август", "септември", "октомври", "ноември", "декември"],
                n = ["не", "по", "вт", "ср", "че", "пе", "са"],
                i = ["нед", "пон", "вто", "сре", "чет", "пет", "саб"],
                r = ["недела", "понеделник", "вторник", "среда", "четврток", "петок", "сабота"],
                a = ["претпладне", "попладне"],
                s = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                s[e + "o"] = function (t, n) {
                    return function (e) {
                        var t = e % 100;
                        if (20 < t || t < 10) switch (t % 10) {
                            case 1:
                                return e + "-ви";
                            case 2:
                                return e + "-ри";
                            case 7:
                            case 8:
                                return e + "-ми"
                        }
                        return e + "-ти"
                    }(n[e](t))
                }
            }), {
                formatters: s,
                formattingTokensRegExp: o(s)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "mindre enn ett sekund",
                    other: "mindre enn {{count}} sekunder"
                },
                xSeconds: {
                    one: "ett sekund",
                    other: "{{count}} sekunder"
                },
                halfAMinute: "et halvt minutt",
                lessThanXMinutes: {
                    one: "mindre enn ett minutt",
                    other: "mindre enn {{count}} minutter"
                },
                xMinutes: {
                    one: "ett minutt",
                    other: "{{count}} minutter"
                },
                aboutXHours: {
                    one: "rundt en time",
                    other: "rundt {{count}} timer"
                },
                xHours: {
                    one: "en time",
                    other: "{{count}} timer"
                },
                xDays: {
                    one: "en dag",
                    other: "{{count}} dager"
                },
                aboutXMonths: {
                    one: "rundt en måned",
                    other: "rundt {{count}} måneder"
                },
                xMonths: {
                    one: "en måned",
                    other: "{{count}} måneder"
                },
                aboutXYears: {
                    one: "rundt ett år",
                    other: "rundt {{count}} år"
                },
                xYears: {
                    one: "ett år",
                    other: "{{count}} år"
                },
                overXYears: {
                    one: "over ett år",
                    other: "over {{count}} år"
                },
                almostXYears: {
                    one: "nesten ett år",
                    other: "nesten {{count}} år"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "om " + i : i + " siden" : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["jan.", "feb.", "mars", "april", "mai", "juni", "juli", "aug.", "sep.", "okt.", "nov.", "des."],
                t = ["januar", "februar", "mars", "april", "mai", "juni", "juli", "august", "september", "oktober", "november", "desember"],
                n = ["sø", "ma", "ti", "on", "to", "fr", "lø"],
                i = ["sø.", "ma.", "ti.", "on.", "to.", "fr.", "lø."],
                r = ["søndag", "mandag", "tirsdag", "onsdag", "torsdag", "fredag", "lørdag"],
                a = ["AM", "PM"],
                s = ["am", "pm"],
                u = ["a.m.", "p.m."],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        return e + "."
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "minder dan een seconde",
                    other: "minder dan {{count}} seconden"
                },
                xSeconds: {
                    one: "1 seconde",
                    other: "{{count}} seconden"
                },
                halfAMinute: "een halve minuut",
                lessThanXMinutes: {
                    one: "minder dan een minuut",
                    other: "minder dan {{count}} minuten"
                },
                xMinutes: {
                    one: "een minuut",
                    other: "{{count}} minuten"
                },
                aboutXHours: {
                    one: "ongeveer 1 uur",
                    other: "ongeveer {{count}} uur"
                },
                xHours: {
                    one: "1 uur",
                    other: "{{count}} uur"
                },
                xDays: {
                    one: "1 dag",
                    other: "{{count}} dagen"
                },
                aboutXMonths: {
                    one: "ongeveer 1 maand",
                    other: "ongeveer {{count}} maanden"
                },
                xMonths: {
                    one: "1 maand",
                    other: "{{count}} maanden"
                },
                aboutXYears: {
                    one: "ongeveer 1 jaar",
                    other: "ongeveer {{count}} jaar"
                },
                xYears: {
                    one: "1 jaar",
                    other: "{{count}} jaar"
                },
                overXYears: {
                    one: "meer dan 1 jaar",
                    other: "meer dan {{count}} jaar"
                },
                almostXYears: {
                    one: "bijna 1 jaar",
                    other: "bijna {{count}} jaar"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "over " + i : i + " geleden" : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["jan", "feb", "mar", "apr", "mei", "jun", "jul", "aug", "sep", "okt", "nov", "dec"],
                t = ["januari", "februari", "maart", "april", "mei", "juni", "juli", "augustus", "september", "oktober", "november", "december"],
                n = ["zo", "ma", "di", "wo", "do", "vr", "za"],
                i = ["zon", "maa", "din", "woe", "don", "vri", "zat"],
                r = ["zondag", "maandag", "dinsdag", "woensdag", "donderdag", "vrijdag", "zaterdag"],
                a = ["AM", "PM"],
                s = ["am", "pm"],
                u = ["a.m.", "p.m."],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        return e + "e"
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        function n(e, t, n) {
            n = n || "regular";
            var o = function (e, t) {
                if (1 === t) return e.one;
                var n = t % 100;
                if (n <= 20 && 10 < n) return e.other;
                var o = n % 10;
                return 2 <= o && o <= 4 ? e.twoFour : e.other
            }(e, t);
            return (o[n] || o).replace("{{count}}", t)
        }
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: {
                        regular: "mniej niż sekunda",
                        past: "mniej niż sekundę",
                        future: "mniej niż sekundę"
                    },
                    twoFour: "mniej niż {{count}} sekundy",
                    other: "mniej niż {{count}} sekund"
                },
                xSeconds: {
                    one: {
                        regular: "sekunda",
                        past: "sekundę",
                        future: "sekundę"
                    },
                    twoFour: "{{count}} sekundy",
                    other: "{{count}} sekund"
                },
                halfAMinute: {
                    one: "pół minuty",
                    twoFour: "pół minuty",
                    other: "pół minuty"
                },
                lessThanXMinutes: {
                    one: {
                        regular: "mniej niż minuta",
                        past: "mniej niż minutę",
                        future: "mniej niż minutę"
                    },
                    twoFour: "mniej niż {{count}} minuty",
                    other: "mniej niż {{count}} minut"
                },
                xMinutes: {
                    one: {
                        regular: "minuta",
                        past: "minutę",
                        future: "minutę"
                    },
                    twoFour: "{{count}} minuty",
                    other: "{{count}} minut"
                },
                aboutXHours: {
                    one: {
                        regular: "około godzina",
                        past: "około godziny",
                        future: "około godzinę"
                    },
                    twoFour: "około {{count}} godziny",
                    other: "około {{count}} godzin"
                },
                xHours: {
                    one: {
                        regular: "godzina",
                        past: "godzinę",
                        future: "godzinę"
                    },
                    twoFour: "{{count}} godziny",
                    other: "{{count}} godzin"
                },
                xDays: {
                    one: {
                        regular: "dzień",
                        past: "dzień",
                        future: "1 dzień"
                    },
                    twoFour: "{{count}} dni",
                    other: "{{count}} dni"
                },
                aboutXMonths: {
                    one: "około miesiąc",
                    twoFour: "około {{count}} miesiące",
                    other: "około {{count}} miesięcy"
                },
                xMonths: {
                    one: "miesiąc",
                    twoFour: "{{count}} miesiące",
                    other: "{{count}} miesięcy"
                },
                aboutXYears: {
                    one: "około rok",
                    twoFour: "około {{count}} lata",
                    other: "około {{count}} lat"
                },
                xYears: {
                    one: "rok",
                    twoFour: "{{count}} lata",
                    other: "{{count}} lat"
                },
                overXYears: {
                    one: "ponad rok",
                    twoFour: "ponad {{count}} lata",
                    other: "ponad {{count}} lat"
                },
                almostXYears: {
                    one: "prawie rok",
                    twoFour: "prawie {{count}} lata",
                    other: "prawie {{count}} lat"
                }
            };
            return {
                localize: function (t, o, i) {
                    var r = e[t];
                    return (i = i || {}).addSuffix ? 0 < i.comparison ? "za " + n(r, o, "future") : n(r, o, "past") + " temu" : n(r, o)
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["sty", "lut", "mar", "kwi", "maj", "cze", "lip", "sie", "wrz", "paź", "lis", "gru"],
                t = ["styczeń", "luty", "marzec", "kwiecień", "maj", "czerwiec", "lipiec", "sierpień", "wrzesień", "październik", "listopad", "grudzień"],
                n = ["nd", "pn", "wt", "śr", "cz", "pt", "sb"],
                i = ["niedz.", "pon.", "wt.", "śr.", "czw.", "piąt.", "sob."],
                r = ["niedziela", "poniedziałek", "wtorek", "środa", "czwartek", "piątek", "sobota"],
                a = ["w nocy", "rano", "po południu", "wieczorem"],
                s = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        var t = e.getHours();
                        return 17 <= t ? a[3] : 12 <= t ? a[2] : 4 <= t ? a[1] : a[0]
                    }
                };
            return s.a = s.A, s.aa = s.A, ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                s[e + "o"] = function (t, n) {
                    return n[e](t).toString()
                }
            }), {
                formatters: s,
                formattingTokensRegExp: o(s)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "menos de um segundo",
                    other: "menos de {{count}} segundos"
                },
                xSeconds: {
                    one: "1 segundo",
                    other: "{{count}} segundos"
                },
                halfAMinute: "meio minuto",
                lessThanXMinutes: {
                    one: "menos de um minuto",
                    other: "menos de {{count}} minutos"
                },
                xMinutes: {
                    one: "1 minuto",
                    other: "{{count}} minutos"
                },
                aboutXHours: {
                    one: "aproximadamente 1 hora",
                    other: "aproximadamente {{count}} horas"
                },
                xHours: {
                    one: "1 hora",
                    other: "{{count}} horas"
                },
                xDays: {
                    one: "1 dia",
                    other: "{{count}} dias"
                },
                aboutXMonths: {
                    one: "aproximadamente 1 mês",
                    other: "aproximadamente {{count}} meses"
                },
                xMonths: {
                    one: "1 mês",
                    other: "{{count}} meses"
                },
                aboutXYears: {
                    one: "aproximadamente 1 ano",
                    other: "aproximadamente {{count}} anos"
                },
                xYears: {
                    one: "1 ano",
                    other: "{{count}} anos"
                },
                overXYears: {
                    one: "mais de 1 ano",
                    other: "mais de {{count}} anos"
                },
                almostXYears: {
                    one: "quase 1 ano",
                    other: "quase {{count}} anos"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "daqui a " + i : "há " + i : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["jan", "fev", "mar", "abr", "mai", "jun", "jul", "ago", "set", "out", "nov", "dez"],
                t = ["janeiro", "fevereiro", "março", "abril", "maio", "junho", "julho", "agosto", "setembro", "outubro", "novembro", "dezembro"],
                n = ["do", "se", "te", "qa", "qi", "se", "sa"],
                i = ["dom", "seg", "ter", "qua", "qui", "sex", "sáb"],
                r = ["domingo", "segunda-feira", "terça-feira", "quarta-feira", "quinta-feira", "sexta-feira", "sábado"],
                a = ["AM", "PM"],
                s = ["am", "pm"],
                u = ["a.m.", "p.m."],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        return e + "º"
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "mai puțin de o secundă",
                    other: "mai puțin de {{count}} secunde"
                },
                xSeconds: {
                    one: "1 secundă",
                    other: "{{count}} secunde"
                },
                halfAMinute: "jumătate de minut",
                lessThanXMinutes: {
                    one: "mai puțin de un minut",
                    other: "mai puțin de {{count}} minute"
                },
                xMinutes: {
                    one: "1 minut",
                    other: "{{count}} minute"
                },
                aboutXHours: {
                    one: "circa 1 oră",
                    other: "circa {{count}} ore"
                },
                xHours: {
                    one: "1 oră",
                    other: "{{count}} ore"
                },
                xDays: {
                    one: "1 zi",
                    other: "{{count}} zile"
                },
                aboutXMonths: {
                    one: "circa 1 lună",
                    other: "circa {{count}} luni"
                },
                xMonths: {
                    one: "1 lună",
                    other: "{{count}} luni"
                },
                aboutXYears: {
                    one: "circa 1 an",
                    other: "circa {{count}} ani"
                },
                xYears: {
                    one: "1 an",
                    other: "{{count}} ani"
                },
                overXYears: {
                    one: "peste 1 an",
                    other: "peste {{count}} ani"
                },
                almostXYears: {
                    one: "aproape 1 an",
                    other: "aproape {{count}} ani"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "în " + i : i + " în urmă" : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["ian", "feb", "mar", "apr", "mai", "iun", "iul", "aug", "sep", "oct", "noi", "dec"],
                t = ["ianuarie", "februarie", "martie", "aprilie", "mai", "iunie", "iulie", "august", "septembrie", "octombrie", "noiembrie", "decembrie"],
                n = ["du", "lu", "ma", "mi", "jo", "vi", "sâ"],
                i = ["dum", "lun", "mar", "mie", "joi", "vin", "sâm"],
                r = ["duminică", "luni", "marți", "miercuri", "joi", "vineri", "sâmbăta"],
                a = ["AM", "PM"],
                s = ["am", "pm"],
                u = ["a.m.", "p.m."],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        return e.toString()
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        function n(e, t) {
            if (void 0 !== e.one && 1 === t) return e.one;
            var n = t % 10,
                o = t % 100;
            return 1 === n && 11 !== o ? e.singularNominative.replace("{{count}}", t) : 2 <= n && n <= 4 && (o < 10 || 20 < o) ? e.singularGenitive.replace("{{count}}", t) : e.pluralGenitive.replace("{{count}}", t)
        }

        function o(e) {
            return function (t, o) {
                return o.addSuffix ? 0 < o.comparison ? e.future ? n(e.future, t) : "через " + n(e.regular, t) : e.past ? n(e.past, t) : n(e.regular, t) + " назад" : n(e.regular, t)
            }
        }
        e.exports = function () {
            var e = {
                lessThanXSeconds: o({
                    regular: {
                        one: "меньше секунды",
                        singularNominative: "меньше {{count}} секунды",
                        singularGenitive: "меньше {{count}} секунд",
                        pluralGenitive: "меньше {{count}} секунд"
                    },
                    future: {
                        one: "меньше, чем через секунду",
                        singularNominative: "меньше, чем через {{count}} секунду",
                        singularGenitive: "меньше, чем через {{count}} секунды",
                        pluralGenitive: "меньше, чем через {{count}} секунд"
                    }
                }),
                xSeconds: o({
                    regular: {
                        singularNominative: "{{count}} секунда",
                        singularGenitive: "{{count}} секунды",
                        pluralGenitive: "{{count}} секунд"
                    },
                    past: {
                        singularNominative: "{{count}} секунду назад",
                        singularGenitive: "{{count}} секунды назад",
                        pluralGenitive: "{{count}} секунд назад"
                    },
                    future: {
                        singularNominative: "через {{count}} секунду",
                        singularGenitive: "через {{count}} секунды",
                        pluralGenitive: "через {{count}} секунд"
                    }
                }),
                halfAMinute: function (e, t) {
                    return t.addSuffix ? 0 < t.comparison ? "через полминуты" : "полминуты назад" : "полминуты"
                },
                lessThanXMinutes: o({
                    regular: {
                        one: "меньше минуты",
                        singularNominative: "меньше {{count}} минуты",
                        singularGenitive: "меньше {{count}} минут",
                        pluralGenitive: "меньше {{count}} минут"
                    },
                    future: {
                        one: "меньше, чем через минуту",
                        singularNominative: "меньше, чем через {{count}} минуту",
                        singularGenitive: "меньше, чем через {{count}} минуты",
                        pluralGenitive: "меньше, чем через {{count}} минут"
                    }
                }),
                xMinutes: o({
                    regular: {
                        singularNominative: "{{count}} минута",
                        singularGenitive: "{{count}} минуты",
                        pluralGenitive: "{{count}} минут"
                    },
                    past: {
                        singularNominative: "{{count}} минуту назад",
                        singularGenitive: "{{count}} минуты назад",
                        pluralGenitive: "{{count}} минут назад"
                    },
                    future: {
                        singularNominative: "через {{count}} минуту",
                        singularGenitive: "через {{count}} минуты",
                        pluralGenitive: "через {{count}} минут"
                    }
                }),
                aboutXHours: o({
                    regular: {
                        singularNominative: "около {{count}} часа",
                        singularGenitive: "около {{count}} часов",
                        pluralGenitive: "около {{count}} часов"
                    },
                    future: {
                        singularNominative: "приблизительно через {{count}} час",
                        singularGenitive: "приблизительно через {{count}} часа",
                        pluralGenitive: "приблизительно через {{count}} часов"
                    }
                }),
                xHours: o({
                    regular: {
                        singularNominative: "{{count}} час",
                        singularGenitive: "{{count}} часа",
                        pluralGenitive: "{{count}} часов"
                    }
                }),
                xDays: o({
                    regular: {
                        singularNominative: "{{count}} день",
                        singularGenitive: "{{count}} дня",
                        pluralGenitive: "{{count}} дней"
                    }
                }),
                aboutXMonths: o({
                    regular: {
                        singularNominative: "около {{count}} месяца",
                        singularGenitive: "около {{count}} месяцев",
                        pluralGenitive: "около {{count}} месяцев"
                    },
                    future: {
                        singularNominative: "приблизительно через {{count}} месяц",
                        singularGenitive: "приблизительно через {{count}} месяца",
                        pluralGenitive: "приблизительно через {{count}} месяцев"
                    }
                }),
                xMonths: o({
                    regular: {
                        singularNominative: "{{count}} месяц",
                        singularGenitive: "{{count}} месяца",
                        pluralGenitive: "{{count}} месяцев"
                    }
                }),
                aboutXYears: o({
                    regular: {
                        singularNominative: "около {{count}} года",
                        singularGenitive: "около {{count}} лет",
                        pluralGenitive: "около {{count}} лет"
                    },
                    future: {
                        singularNominative: "приблизительно через {{count}} год",
                        singularGenitive: "приблизительно через {{count}} года",
                        pluralGenitive: "приблизительно через {{count}} лет"
                    }
                }),
                xYears: o({
                    regular: {
                        singularNominative: "{{count}} год",
                        singularGenitive: "{{count}} года",
                        pluralGenitive: "{{count}} лет"
                    }
                }),
                overXYears: o({
                    regular: {
                        singularNominative: "больше {{count}} года",
                        singularGenitive: "больше {{count}} лет",
                        pluralGenitive: "больше {{count}} лет"
                    },
                    future: {
                        singularNominative: "больше, чем через {{count}} год",
                        singularGenitive: "больше, чем через {{count}} года",
                        pluralGenitive: "больше, чем через {{count}} лет"
                    }
                }),
                almostXYears: o({
                    regular: {
                        singularNominative: "почти {{count}} год",
                        singularGenitive: "почти {{count}} года",
                        pluralGenitive: "почти {{count}} лет"
                    },
                    future: {
                        singularNominative: "почти через {{count}} год",
                        singularGenitive: "почти через {{count}} года",
                        pluralGenitive: "почти через {{count}} лет"
                    }
                })
            };
            return {
                localize: function (t, n, o) {
                    return o = o || {}, e[t](n, o)
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["янв.", "фев.", "март", "апр.", "май", "июнь", "июль", "авг.", "сент.", "окт.", "нояб.", "дек."],
                t = ["январь", "февраль", "март", "апрель", "май", "июнь", "июль", "август", "сентябрь", "октябрь", "ноябрь", "декабрь"],
                n = ["января", "февраля", "марта", "апреля", "мая", "июня", "июля", "августа", "сентября", "октября", "ноября", "декабря"],
                i = ["вс", "пн", "вт", "ср", "чт", "пт", "сб"],
                r = ["вск", "пнд", "втр", "срд", "чтв", "птн", "суб"],
                a = ["воскресенье", "понедельник", "вторник", "среда", "четверг", "пятница", "суббота"],
                s = ["ночи", "утра", "дня", "вечера"],
                u = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return i[e.getDay()]
                    },
                    ddd: function (e) {
                        return r[e.getDay()]
                    },
                    dddd: function (e) {
                        return a[e.getDay()]
                    },
                    A: function (e) {
                        var t = e.getHours();
                        return 17 <= t ? s[3] : 12 <= t ? s[2] : 4 <= t ? s[1] : s[0]
                    },
                    Do: function (e, t) {
                        return t.D(e) + "-е"
                    },
                    Wo: function (e, t) {
                        return t.W(e) + "-я"
                    }
                };
            return u.a = u.A, u.aa = u.A, ["M", "DDD", "d", "Q"].forEach(function (e) {
                u[e + "o"] = function (t, n) {
                    return n[e](t) + "-й"
                }
            }), ["D", "Do", "DD"].forEach(function (e) {
                u[e + " MMMM"] = function (t, o) {
                    return (u[e] || o[e])(t, o) + " " + n[t.getMonth()]
                }
            }), {
                formatters: u,
                formattingTokensRegExp: o(u)
            }
        }
    }, function (e, t) {
        function n(e, t, n) {
            var o = function (e, t) {
                return 1 === t ? e.one : 2 <= t && t <= 4 ? e.twoFour : e.other
            }(e, t);
            return (o[n] || o).replace("{{count}}", t)
        }

        function o(e) {
            var t = "";
            return "almost" === e && (t = "takmer"), "about" === e && (t = "približne"), 0 < t.length ? t + " " : ""
        }

        function i(e) {
            var t = "";
            return "lessThan" === e && (t = "menej než"), "over" === e && (t = "viac než"), 0 < t.length ? t + " " : ""
        }
        e.exports = function () {
            var e = {
                xSeconds: {
                    one: {
                        regular: "sekunda",
                        past: "sekundou",
                        future: "sekundu"
                    },
                    twoFour: {
                        regular: "{{count}} sekundy",
                        past: "{{count}} sekundami",
                        future: "{{count}} sekundy"
                    },
                    other: {
                        regular: "{{count}} sekúnd",
                        past: "{{count}} sekundami",
                        future: "{{count}} sekúnd"
                    }
                },
                halfAMinute: {
                    other: {
                        regular: "pol minúty",
                        past: "pol minútou",
                        future: "pol minúty"
                    }
                },
                xMinutes: {
                    one: {
                        regular: "minúta",
                        past: "minútou",
                        future: "minútu"
                    },
                    twoFour: {
                        regular: "{{count}} minúty",
                        past: "{{count}} minútami",
                        future: "{{count}} minúty"
                    },
                    other: {
                        regular: "{{count}} minút",
                        past: "{{count}} minútami",
                        future: "{{count}} minút"
                    }
                },
                xHours: {
                    one: {
                        regular: "hodina",
                        past: "hodinou",
                        future: "hodinu"
                    },
                    twoFour: {
                        regular: "{{count}} hodiny",
                        past: "{{count}} hodinami",
                        future: "{{count}} hodiny"
                    },
                    other: {
                        regular: "{{count}} hodín",
                        past: "{{count}} hodinami",
                        future: "{{count}} hodín"
                    }
                },
                xDays: {
                    one: {
                        regular: "deň",
                        past: "dňom",
                        future: "deň"
                    },
                    twoFour: {
                        regular: "{{count}} dni",
                        past: "{{count}} dňami",
                        future: "{{count}} dni"
                    },
                    other: {
                        regular: "{{count}} dní",
                        past: "{{count}} dňami",
                        future: "{{count}} dní"
                    }
                },
                xMonths: {
                    one: {
                        regular: "mesiac",
                        past: "mesiacom",
                        future: "mesiac"
                    },
                    twoFour: {
                        regular: "{{count}} mesiace",
                        past: "{{count}} mesiacmi",
                        future: "{{count}} mesiace"
                    },
                    other: {
                        regular: "{{count}} mesiacov",
                        past: "{{count}} mesiacmi",
                        future: "{{count}} mesiacov"
                    }
                },
                xYears: {
                    one: {
                        regular: "rok",
                        past: "rokom",
                        future: "rok"
                    },
                    twoFour: {
                        regular: "{{count}} roky",
                        past: "{{count}} rokmi",
                        future: "{{count}} roky"
                    },
                    other: {
                        regular: "{{count}} rokov",
                        past: "{{count}} rokmi",
                        future: "{{count}} rokov"
                    }
                }
            };
            return {
                localize: function (t, r, a) {
                    a = a || {};
                    var s = function (e) {
                            return ["lessThan", "about", "over", "almost"].filter(function (t) {
                                return !!e.match(new RegExp("^" + t))
                            })[0]
                        }(t) || "",
                        u = function (e) {
                            return e.charAt(0).toLowerCase() + e.slice(1)
                        }(t.substring(s.length)),
                        c = e[u];
                    return a.addSuffix ? 0 < a.comparison ? o(s) + "za " + i(s) + n(c, r, "future") : o(s) + "pred " + i(s) + n(c, r, "past") : o(s) + i(s) + n(c, r, "regular")
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["jan", "feb", "mar", "apr", "máj", "jún", "júl", "aug", "sep", "okt", "nov", "dec"],
                t = ["január", "február", "marec", "apríl", "máj", "jún", "júl", "august", "september", "október", "november", "december"],
                n = ["ne", "po", "ut", "st", "št", "pi", "so"],
                i = ["neď", "pon", "uto", "str", "štv", "pia", "sob"],
                r = ["nedeľa", "pondelok", "utorok", "streda", "štvrtok", "piatok", "sobota"],
                a = ["AM", "PM"],
                s = ["am", "pm"],
                u = ["a.m.", "p.m."],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        return e + "."
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "manj kot sekunda",
                    two: "manj kot 2 sekundi",
                    three: "manj kot {{count}} sekunde",
                    other: "manj kot {{count}} sekund"
                },
                xSeconds: {
                    one: "1 sekunda",
                    two: "2 sekundi",
                    three: "{{count}} sekunde",
                    other: "{{count}} sekund"
                },
                halfAMinute: "pol minute",
                lessThanXMinutes: {
                    one: "manj kot minuta",
                    two: "manj kot 2 minuti",
                    three: "manj kot {{count}} minute",
                    other: "manj kot {{count}} minut"
                },
                xMinutes: {
                    one: "1 minuta",
                    two: "2 minuti",
                    three: "{{count}} minute",
                    other: "{{count}} minut"
                },
                aboutXHours: {
                    one: "približno 1 ura",
                    two: "približno 2 uri",
                    three: "približno {{count}} ure",
                    other: "približno {{count}} ur"
                },
                xHours: {
                    one: "1 ura",
                    two: "2 uri",
                    three: "{{count}} ure",
                    other: "{{count}} ur"
                },
                xDays: {
                    one: "1 dan",
                    two: "2 dni",
                    three: "{{count}} dni",
                    other: "{{count}} dni"
                },
                aboutXMonths: {
                    one: "približno 1 mesec",
                    two: "približno 2 meseca",
                    three: "približno {{count}} mesece",
                    other: "približno {{count}} mesecev"
                },
                xMonths: {
                    one: "1 mesec",
                    two: "2 meseca",
                    three: "{{count}} meseci",
                    other: "{{count}} mesecev"
                },
                aboutXYears: {
                    one: "približno 1 leto",
                    two: "približno 2 leti",
                    three: "približno {{count}} leta",
                    other: "približno {{count}} let"
                },
                xYears: {
                    one: "1 leto",
                    two: "2 leti",
                    three: "{{count}} leta",
                    other: "{{count}} let"
                },
                overXYears: {
                    one: "več kot 1 leto",
                    two: "več kot 2 leti",
                    three: "več kot {{count}} leta",
                    other: "več kot {{count}} let"
                },
                almostXYears: {
                    one: "skoraj 1 leto",
                    two: "skoraj 2 leti",
                    three: "skoraj {{count}} leta",
                    other: "skoraj {{count}} let"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : 2 === n ? e[t].two : 3 === n || 4 === n ? e[t].three.replace("{{count}}", n) : e[t].other.replace("{{count}}", n), o.addSuffix ? (i = i.replace(/(minut|sekund|ur)(a)/, "$1o"), "xMonths" === t && (i = i.replace(/(mesec)(i)/, "$1e")), 0 < o.comparison ? "čez " + i : i + " nazaj") : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["jan", "feb", "mar", "apr", "maj", "jun", "jul", "avg", "sep", "okt", "nov", "dec"],
                t = ["januar", "februar", "marec", "april", "maj", "junij", "julij", "avgust", "september", "oktober", "november", "december"],
                n = ["ne", "po", "to", "sr", "če", "pe", "so"],
                i = ["ned", "pon", "tor", "sre", "čet", "pet", "sob"],
                r = ["nedelja", "ponedeljek", "torek", "sreda", "četrtek", "petek", "sobota"],
                a = ["AM", "PM"],
                s = ["am", "pm"],
                u = ["a.m.", "p.m."],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        return e + "."
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                    lessThanXSeconds: {
                        singular: "mindre än en sekund",
                        plural: "mindre än {{count}} sekunder"
                    },
                    xSeconds: {
                        singular: "en sekund",
                        plural: "{{count}} sekunder"
                    },
                    halfAMinute: "en halv minut",
                    lessThanXMinutes: {
                        singular: "mindre än en minut",
                        plural: "mindre än {{count}} minuter"
                    },
                    xMinutes: {
                        singular: "en minut",
                        plural: "{{count}} minuter"
                    },
                    aboutXHours: {
                        singular: "ungefär en timme",
                        plural: "ungefär {{count}} timmar"
                    },
                    xHours: {
                        singular: "en timme",
                        plural: "{{count}} timmar"
                    },
                    xDays: {
                        singular: "en dag",
                        plural: "{{count}} dagar"
                    },
                    aboutXMonths: {
                        singular: "ungefär en månad",
                        plural: "ungefär {{count}} månader"
                    },
                    xMonths: {
                        singular: "en månad",
                        plural: "{{count}} månader"
                    },
                    aboutXYears: {
                        singular: "ungefär ett år",
                        plural: "ungefär {{count}} år"
                    },
                    xYears: {
                        singular: "ett år",
                        plural: "{{count}} år"
                    },
                    overXYears: {
                        singular: "över ett år",
                        plural: "över {{count}} år"
                    },
                    almostXYears: {
                        singular: "nästan ett år",
                        plural: "nästan {{count}} år"
                    }
                },
                t = ["noll", "en", "två", "tre", "fyra", "fem", "sex", "sju", "åtta", "nio", "tio", "elva", "tolv"];
            return {
                localize: function (n, o, i) {
                    i = i || {};
                    var r, a = e[n];
                    return r = "string" == typeof a ? a : 0 === o || 1 < o ? a.plural.replace("{{count}}", o < 13 ? t[o] : o) : a.singular, i.addSuffix ? 0 < i.comparison ? "om " + r : r + " sedan" : r
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["jan", "feb", "mar", "apr", "maj", "jun", "jul", "aug", "sep", "okt", "nov", "dec"],
                t = ["januari", "februari", "mars", "april", "maj", "juni", "juli", "augusti", "september", "oktober", "november", "december"],
                n = ["sö", "må", "ti", "on", "to", "fr", "lö"],
                i = ["sön", "mån", "tis", "ons", "tor", "fre", "lör"],
                r = ["söndag", "måndag", "tisdag", "onsdag", "torsdag", "fredag", "lördag"],
                a = ["f.m.", "e.m."],
                s = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    }
                };
            return s.A = s.aa, s.a = s.aa, ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                s[e + "o"] = function (t, n) {
                    return function (e) {
                        var t = e % 100;
                        if (20 < t || t < 10) switch (t % 10) {
                            case 1:
                            case 2:
                                return e + ":a"
                        }
                        return e + ":e"
                    }(n[e](t))
                }
            }), {
                formatters: s,
                formattingTokensRegExp: o(s)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "น้อยกว่า 1 วินาที",
                    other: "น้อยกว่า {{count}} วินาที"
                },
                xSeconds: {
                    one: "1 วินาที",
                    other: "{{count}} วินาที"
                },
                halfAMinute: "ครึ่งนาที",
                lessThanXMinutes: {
                    one: "น้อยกว่า 1 นาที",
                    other: "น้อยกว่า {{count}} นาที"
                },
                xMinutes: {
                    one: "1 นาที",
                    other: "{{count}} นาที"
                },
                aboutXHours: {
                    one: "ประมาณ 1 ชั่วโมง",
                    other: "ประมาณ {{count}} ชั่วโมง"
                },
                xHours: {
                    one: "1 ชั่วโมง",
                    other: "{{count}} ชั่วโมง"
                },
                xDays: {
                    one: "1 วัน",
                    other: "{{count}} วัน"
                },
                aboutXMonths: {
                    one: "ประมาณ 1 เดือน",
                    other: "ประมาณ {{count}} เดือน"
                },
                xMonths: {
                    one: "1 เดือน",
                    other: "{{count}} เดือน"
                },
                aboutXYears: {
                    one: "ประมาณ 1 ปี",
                    other: "ประมาณ {{count}} ปี"
                },
                xYears: {
                    one: "1 ปี",
                    other: "{{count}} ปี"
                },
                overXYears: {
                    one: "มากกว่า 1 ปี",
                    other: "มากกว่า {{count}} ปี"
                },
                almostXYears: {
                    one: "เกือบ 1 ปี",
                    other: "เกือบ {{count}} ปี"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? "halfAMinute" === t ? "ใน" + i : "ใน " + i : i + "ที่ผ่านมา" : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["ม.ค.", "ก.พ.", "มี.ค.", "เม.ย.", "พ.ค.", "มิ.ย.", "ก.ค.", "ส.ค.", "ก.ย.", "ต.ค.", "พ.ย.", "ธ.ค."],
                t = ["มกราคาม", "กุมภาพันธ์", "มีนาคม", "เมษายน", "พฤษภาคม", "มิถุนายน", "กรกฎาคม", "สิงหาคม", "กันยายน", "ตุลาคม", "พฤศจิกายน", "ธันวาคม"],
                n = ["อา.", "จ.", "อ.", "พ.", "พฤ.", "ศ.", "ส."],
                i = ["อา.", "จ.", "อ.", "พ.", "พฤ.", "ศ.", "ส."],
                r = ["อาทิตย์", "จันทร์", "อังคาร", "พุธ", "พฤหัสบดี", "ศุกร์", "เสาร์"],
                a = ["น."],
                s = ["น."],
                u = ["นาฬิกา"],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return a[0]
                    },
                    a: function (e) {
                        return s[0]
                    },
                    aa: function (e) {
                        return u[0]
                    }
                };
            return {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                    lessThanXSeconds: {
                        one: "bir saniyeden az",
                        other: "{{count}} saniyeden az"
                    },
                    xSeconds: {
                        one: "1 saniye",
                        other: "{{count}} saniye"
                    },
                    halfAMinute: "yarım dakika",
                    lessThanXMinutes: {
                        one: "bir dakikadan az",
                        other: "{{count}} dakikadan az"
                    },
                    xMinutes: {
                        one: "1 dakika",
                        other: "{{count}} dakika"
                    },
                    aboutXHours: {
                        one: "yaklaşık 1 saat",
                        other: "yaklaşık {{count}} saat"
                    },
                    xHours: {
                        one: "1 saat",
                        other: "{{count}} saat"
                    },
                    xDays: {
                        one: "1 gün",
                        other: "{{count}} gün"
                    },
                    aboutXMonths: {
                        one: "yaklaşık 1 ay",
                        other: "yaklaşık {{count}} ay"
                    },
                    xMonths: {
                        one: "1 ay",
                        other: "{{count}} ay"
                    },
                    aboutXYears: {
                        one: "yaklaşık 1 yıl",
                        other: "yaklaşık {{count}} yıl"
                    },
                    xYears: {
                        one: "1 yıl",
                        other: "{{count}} yıl"
                    },
                    overXYears: {
                        one: "1 yıldan fazla",
                        other: "{{count}} yıldan fazla"
                    },
                    almostXYears: {
                        one: "neredeyse 1 yıl",
                        other: "neredeyse {{count}} yıl"
                    }
                },
                t = ["lessThanXSeconds", "lessThanXMinutes", "overXYears"];
            return {
                localize: function (n, o, i) {
                    var r;
                    if (i = i || {}, r = "string" == typeof e[n] ? e[n] : 1 === o ? e[n].one : e[n].other.replace("{{count}}", o), i.addSuffix) {
                        var a = "";
                        return -1 < t.indexOf(n) && (a = " bir süre"), 0 < i.comparison ? r + a + " içinde" : r + a + " önce"
                    }
                    return r
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["Oca", "Şub", "Mar", "Nis", "May", "Haz", "Tem", "Ağu", "Eyl", "Eki", "Kas", "Ara"],
                t = ["Ocak", "Şubat", "Mart", "Nisan", "Mayıs", "Haziran", "Temmuz", "Ağustos", "Eylül", "Ekim", "Kasım", "Aralık"],
                n = ["Pz", "Pt", "Sa", "Ça", "Pe", "Cu", "Ct"],
                i = ["Paz", "Pts", "Sal", "Çar", "Per", "Cum", "Cts"],
                r = ["Pazar", "Pazartesi", "Salı", "Çarşamba", "Perşembe", "Cuma", "Cumartesi"],
                a = ["ÖÖ", "ÖS"],
                s = ["öö", "ös"],
                u = ["ö.ö.", "ö.s."],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        var t = {
                            1: "'inci",
                            2: "'inci",
                            3: "'üncü",
                            4: "'üncü",
                            5: "'inci",
                            6: "'ıncı",
                            7: "'inci",
                            8: "'inci",
                            9: "'uncu",
                            10: "'uncu",
                            20: "'inci",
                            30: "'uncu",
                            50: "'inci",
                            60: "'ıncı",
                            70: "'inci",
                            80: "'inci",
                            90: "'ıncı",
                            100: "'üncü"
                        };
                        if (0 === e) return "0'ıncı";
                        var n = e % 10;
                        return e + (t[n] || t[e % 100 - n] || t[100 <= e ? 100 : null])
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "不到 1 秒",
                    other: "不到 {{count}} 秒"
                },
                xSeconds: {
                    one: "1 秒",
                    other: "{{count}} 秒"
                },
                halfAMinute: "半分钟",
                lessThanXMinutes: {
                    one: "不到 1 分钟",
                    other: "不到 {{count}} 分钟"
                },
                xMinutes: {
                    one: "1 分钟",
                    other: "{{count}} 分钟"
                },
                xHours: {
                    one: "1 小时",
                    other: "{{count}} 小时"
                },
                aboutXHours: {
                    one: "大约 1 小时",
                    other: "大约 {{count}} 小时"
                },
                xDays: {
                    one: "1 天",
                    other: "{{count}} 天"
                },
                aboutXMonths: {
                    one: "大约 1 个月",
                    other: "大约 {{count}} 个月"
                },
                xMonths: {
                    one: "1 个月",
                    other: "{{count}} 个月"
                },
                aboutXYears: {
                    one: "大约 1 年",
                    other: "大约 {{count}} 年"
                },
                xYears: {
                    one: "1 年",
                    other: "{{count}} 年"
                },
                overXYears: {
                    one: "超过 1 年",
                    other: "超过 {{count}} 年"
                },
                almostXYears: {
                    one: "将近 1 年",
                    other: "将近 {{count}} 年"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? i + "内" : i + "前" : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"],
                t = ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"],
                n = ["日", "一", "二", "三", "四", "五", "六"],
                i = ["周日", "周一", "周二", "周三", "周四", "周五", "周六"],
                r = ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"],
                a = ["上午", "下午"],
                s = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    }
                };
            return s.a = s.aa = s.A = function (e) {
                return 1 <= e.getHours() / 12 ? a[1] : a[0]
            }, ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                s[e + "o"] = function (t, n) {
                    return function (e) {
                        return e.toString()
                    }(n[e](t))
                }
            }), {
                formatters: s,
                formattingTokensRegExp: o(s)
            }
        }
    }, function (e, t) {
        e.exports = function () {
            var e = {
                lessThanXSeconds: {
                    one: "少於 1 秒",
                    other: "少於 {{count}} 秒"
                },
                xSeconds: {
                    one: "1 秒",
                    other: "{{count}} 秒"
                },
                halfAMinute: "半分鐘",
                lessThanXMinutes: {
                    one: "少於 1 分鐘",
                    other: "少於 {{count}} 分鐘"
                },
                xMinutes: {
                    one: "1 分鐘",
                    other: "{{count}} 分鐘"
                },
                xHours: {
                    one: "1 小時",
                    other: "{{count}} 小時"
                },
                aboutXHours: {
                    one: "大約 1 小時",
                    other: "大約 {{count}} 小時"
                },
                xDays: {
                    one: "1 天",
                    other: "{{count}} 天"
                },
                aboutXMonths: {
                    one: "大約 1 個月",
                    other: "大約 {{count}} 個月"
                },
                xMonths: {
                    one: "1 個月",
                    other: "{{count}} 個月"
                },
                aboutXYears: {
                    one: "大約 1 年",
                    other: "大約 {{count}} 年"
                },
                xYears: {
                    one: "1 年",
                    other: "{{count}} 年"
                },
                overXYears: {
                    one: "超過 1 年",
                    other: "超過 {{count}} 年"
                },
                almostXYears: {
                    one: "將近 1 年",
                    other: "將近 {{count}} 年"
                }
            };
            return {
                localize: function (t, n, o) {
                    var i;
                    return o = o || {}, i = "string" == typeof e[t] ? e[t] : 1 === n ? e[t].one : e[t].other.replace("{{count}}", n), o.addSuffix ? 0 < o.comparison ? i + "內" : i + "前" : i
                }
            }
        }
    }, function (e, t, n) {
        var o = n(2);
        e.exports = function () {
            var e = ["1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"],
                t = ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"],
                n = ["日", "一", "二", "三", "四", "五", "六"],
                i = ["周日", "周一", "周二", "周三", "周四", "周五", "周六"],
                r = ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"],
                a = ["AM", "PM"],
                s = ["am", "pm"],
                u = ["上午", "下午"],
                c = {
                    MMM: function (t) {
                        return e[t.getMonth()]
                    },
                    MMMM: function (e) {
                        return t[e.getMonth()]
                    },
                    dd: function (e) {
                        return n[e.getDay()]
                    },
                    ddd: function (e) {
                        return i[e.getDay()]
                    },
                    dddd: function (e) {
                        return r[e.getDay()]
                    },
                    A: function (e) {
                        return 1 <= e.getHours() / 12 ? a[1] : a[0]
                    },
                    a: function (e) {
                        return 1 <= e.getHours() / 12 ? s[1] : s[0]
                    },
                    aa: function (e) {
                        return 1 <= e.getHours() / 12 ? u[1] : u[0]
                    }
                };
            return ["M", "D", "DDD", "d", "Q", "W"].forEach(function (e) {
                c[e + "o"] = function (t, n) {
                    return function (e) {
                        return e.toString()
                    }(n[e](t))
                }
            }), {
                formatters: c,
                formattingTokensRegExp: o(c)
            }
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = t && Number(t.weekStartsOn) || 0,
                i = o(e),
                r = i.getDay(),
                a = (r < n ? 7 : 0) + r - n;
            return i.setDate(i.getDate() - a), i.setHours(0, 0, 0, 0), i
        }
    }, function (e, t, n) {
        var o = n(5);
        e.exports = function (e, t) {
            var n = o(e),
                i = o(t),
                r = n.getTime() - 6e4 * n.getTimezoneOffset(),
                a = i.getTime() - 6e4 * i.getTimezoneOffset();
            return Math.round((r - a) / 864e5)
        }
    }, function (e, t, n) {
        var o = n(0),
            i = n(121);
        e.exports = function (e, t) {
            var n = o(e),
                r = Number(t),
                a = n.getMonth() + r,
                s = new Date(0);
            s.setFullYear(n.getFullYear(), a, 1), s.setHours(0, 0, 0, 0);
            var u = i(s);
            return n.setMonth(a, Math.min(u, n.getDate())), n
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = o(e),
                i = o(t);
            return n.getTime() - i.getTime()
        }
    }, function (e, t, n) {
        var o = {
            "./_lib/build_formatting_tokens_reg_exp": 2,
            "./_lib/build_formatting_tokens_reg_exp/": 2,
            "./_lib/build_formatting_tokens_reg_exp/index": 2,
            "./_lib/build_formatting_tokens_reg_exp/index.js": 2,
            "./_lib/package": 196,
            "./_lib/package.json": 196,
            "./ar": 85,
            "./ar/": 85,
            "./ar/build_distance_in_words_locale": 14,
            "./ar/build_distance_in_words_locale/": 14,
            "./ar/build_distance_in_words_locale/index": 14,
            "./ar/build_distance_in_words_locale/index.js": 14,
            "./ar/build_format_locale": 15,
            "./ar/build_format_locale/": 15,
            "./ar/build_format_locale/index": 15,
            "./ar/build_format_locale/index.js": 15,
            "./ar/index": 85,
            "./ar/index.js": 85,
            "./ar/package": 197,
            "./ar/package.json": 197,
            "./bg": 86,
            "./bg/": 86,
            "./bg/build_distance_in_words_locale": 16,
            "./bg/build_distance_in_words_locale/": 16,
            "./bg/build_distance_in_words_locale/index": 16,
            "./bg/build_distance_in_words_locale/index.js": 16,
            "./bg/build_format_locale": 17,
            "./bg/build_format_locale/": 17,
            "./bg/build_format_locale/index": 17,
            "./bg/build_format_locale/index.js": 17,
            "./bg/index": 86,
            "./bg/index.js": 86,
            "./bg/package": 198,
            "./bg/package.json": 198,
            "./ca": 87,
            "./ca/": 87,
            "./ca/build_distance_in_words_locale": 18,
            "./ca/build_distance_in_words_locale/": 18,
            "./ca/build_distance_in_words_locale/index": 18,
            "./ca/build_distance_in_words_locale/index.js": 18,
            "./ca/build_format_locale": 19,
            "./ca/build_format_locale/": 19,
            "./ca/build_format_locale/index": 19,
            "./ca/build_format_locale/index.js": 19,
            "./ca/index": 87,
            "./ca/index.js": 87,
            "./ca/package": 199,
            "./ca/package.json": 199,
            "./cs": 88,
            "./cs/": 88,
            "./cs/build_distance_in_words_locale": 20,
            "./cs/build_distance_in_words_locale/": 20,
            "./cs/build_distance_in_words_locale/index": 20,
            "./cs/build_distance_in_words_locale/index.js": 20,
            "./cs/build_format_locale": 21,
            "./cs/build_format_locale/": 21,
            "./cs/build_format_locale/index": 21,
            "./cs/build_format_locale/index.js": 21,
            "./cs/index": 88,
            "./cs/index.js": 88,
            "./cs/package": 200,
            "./cs/package.json": 200,
            "./da": 89,
            "./da/": 89,
            "./da/build_distance_in_words_locale": 22,
            "./da/build_distance_in_words_locale/": 22,
            "./da/build_distance_in_words_locale/index": 22,
            "./da/build_distance_in_words_locale/index.js": 22,
            "./da/build_format_locale": 23,
            "./da/build_format_locale/": 23,
            "./da/build_format_locale/index": 23,
            "./da/build_format_locale/index.js": 23,
            "./da/index": 89,
            "./da/index.js": 89,
            "./da/package": 201,
            "./da/package.json": 201,
            "./de": 90,
            "./de/": 90,
            "./de/build_distance_in_words_locale": 24,
            "./de/build_distance_in_words_locale/": 24,
            "./de/build_distance_in_words_locale/index": 24,
            "./de/build_distance_in_words_locale/index.js": 24,
            "./de/build_format_locale": 25,
            "./de/build_format_locale/": 25,
            "./de/build_format_locale/index": 25,
            "./de/build_format_locale/index.js": 25,
            "./de/index": 90,
            "./de/index.js": 90,
            "./de/package": 202,
            "./de/package.json": 202,
            "./el": 91,
            "./el/": 91,
            "./el/build_distance_in_words_locale": 26,
            "./el/build_distance_in_words_locale/": 26,
            "./el/build_distance_in_words_locale/index": 26,
            "./el/build_distance_in_words_locale/index.js": 26,
            "./el/build_format_locale": 27,
            "./el/build_format_locale/": 27,
            "./el/build_format_locale/index": 27,
            "./el/build_format_locale/index.js": 27,
            "./el/index": 91,
            "./el/index.js": 91,
            "./el/package": 203,
            "./el/package.json": 203,
            "./en": 6,
            "./en/": 6,
            "./en/build_distance_in_words_locale": 12,
            "./en/build_distance_in_words_locale/": 12,
            "./en/build_distance_in_words_locale/index": 12,
            "./en/build_distance_in_words_locale/index.js": 12,
            "./en/build_format_locale": 13,
            "./en/build_format_locale/": 13,
            "./en/build_format_locale/index": 13,
            "./en/build_format_locale/index.js": 13,
            "./en/index": 6,
            "./en/index.js": 6,
            "./en/package": 204,
            "./en/package.json": 204,
            "./eo": 92,
            "./eo/": 92,
            "./eo/build_distance_in_words_locale": 28,
            "./eo/build_distance_in_words_locale/": 28,
            "./eo/build_distance_in_words_locale/index": 28,
            "./eo/build_distance_in_words_locale/index.js": 28,
            "./eo/build_format_locale": 29,
            "./eo/build_format_locale/": 29,
            "./eo/build_format_locale/index": 29,
            "./eo/build_format_locale/index.js": 29,
            "./eo/index": 92,
            "./eo/index.js": 92,
            "./eo/package": 205,
            "./eo/package.json": 205,
            "./es": 93,
            "./es/": 93,
            "./es/build_distance_in_words_locale": 30,
            "./es/build_distance_in_words_locale/": 30,
            "./es/build_distance_in_words_locale/index": 30,
            "./es/build_distance_in_words_locale/index.js": 30,
            "./es/build_format_locale": 31,
            "./es/build_format_locale/": 31,
            "./es/build_format_locale/index": 31,
            "./es/build_format_locale/index.js": 31,
            "./es/index": 93,
            "./es/index.js": 93,
            "./es/package": 206,
            "./es/package.json": 206,
            "./fi": 94,
            "./fi/": 94,
            "./fi/build_distance_in_words_locale": 32,
            "./fi/build_distance_in_words_locale/": 32,
            "./fi/build_distance_in_words_locale/index": 32,
            "./fi/build_distance_in_words_locale/index.js": 32,
            "./fi/build_format_locale": 33,
            "./fi/build_format_locale/": 33,
            "./fi/build_format_locale/index": 33,
            "./fi/build_format_locale/index.js": 33,
            "./fi/index": 94,
            "./fi/index.js": 94,
            "./fi/package": 207,
            "./fi/package.json": 207,
            "./fil": 95,
            "./fil/": 95,
            "./fil/build_distance_in_words_locale": 34,
            "./fil/build_distance_in_words_locale/": 34,
            "./fil/build_distance_in_words_locale/index": 34,
            "./fil/build_distance_in_words_locale/index.js": 34,
            "./fil/build_format_locale": 35,
            "./fil/build_format_locale/": 35,
            "./fil/build_format_locale/index": 35,
            "./fil/build_format_locale/index.js": 35,
            "./fil/index": 95,
            "./fil/index.js": 95,
            "./fil/package": 208,
            "./fil/package.json": 208,
            "./fr": 96,
            "./fr/": 96,
            "./fr/build_distance_in_words_locale": 36,
            "./fr/build_distance_in_words_locale/": 36,
            "./fr/build_distance_in_words_locale/index": 36,
            "./fr/build_distance_in_words_locale/index.js": 36,
            "./fr/build_format_locale": 37,
            "./fr/build_format_locale/": 37,
            "./fr/build_format_locale/index": 37,
            "./fr/build_format_locale/index.js": 37,
            "./fr/index": 96,
            "./fr/index.js": 96,
            "./fr/package": 209,
            "./fr/package.json": 209,
            "./hr": 97,
            "./hr/": 97,
            "./hr/build_distance_in_words_locale": 38,
            "./hr/build_distance_in_words_locale/": 38,
            "./hr/build_distance_in_words_locale/index": 38,
            "./hr/build_distance_in_words_locale/index.js": 38,
            "./hr/build_format_locale": 39,
            "./hr/build_format_locale/": 39,
            "./hr/build_format_locale/index": 39,
            "./hr/build_format_locale/index.js": 39,
            "./hr/index": 97,
            "./hr/index.js": 97,
            "./hr/package": 210,
            "./hr/package.json": 210,
            "./hu": 98,
            "./hu/": 98,
            "./hu/build_distance_in_words_locale": 40,
            "./hu/build_distance_in_words_locale/": 40,
            "./hu/build_distance_in_words_locale/index": 40,
            "./hu/build_distance_in_words_locale/index.js": 40,
            "./hu/build_format_locale": 41,
            "./hu/build_format_locale/": 41,
            "./hu/build_format_locale/index": 41,
            "./hu/build_format_locale/index.js": 41,
            "./hu/index": 98,
            "./hu/index.js": 98,
            "./hu/package": 211,
            "./hu/package.json": 211,
            "./id": 99,
            "./id/": 99,
            "./id/build_distance_in_words_locale": 42,
            "./id/build_distance_in_words_locale/": 42,
            "./id/build_distance_in_words_locale/index": 42,
            "./id/build_distance_in_words_locale/index.js": 42,
            "./id/build_format_locale": 43,
            "./id/build_format_locale/": 43,
            "./id/build_format_locale/index": 43,
            "./id/build_format_locale/index.js": 43,
            "./id/index": 99,
            "./id/index.js": 99,
            "./id/package": 212,
            "./id/package.json": 212,
            "./is": 100,
            "./is/": 100,
            "./is/build_distance_in_words_locale": 44,
            "./is/build_distance_in_words_locale/": 44,
            "./is/build_distance_in_words_locale/index": 44,
            "./is/build_distance_in_words_locale/index.js": 44,
            "./is/build_format_locale": 45,
            "./is/build_format_locale/": 45,
            "./is/build_format_locale/index": 45,
            "./is/build_format_locale/index.js": 45,
            "./is/index": 100,
            "./is/index.js": 100,
            "./is/package": 213,
            "./is/package.json": 213,
            "./it": 101,
            "./it/": 101,
            "./it/build_distance_in_words_locale": 46,
            "./it/build_distance_in_words_locale/": 46,
            "./it/build_distance_in_words_locale/index": 46,
            "./it/build_distance_in_words_locale/index.js": 46,
            "./it/build_format_locale": 47,
            "./it/build_format_locale/": 47,
            "./it/build_format_locale/index": 47,
            "./it/build_format_locale/index.js": 47,
            "./it/index": 101,
            "./it/index.js": 101,
            "./it/package": 214,
            "./it/package.json": 214,
            "./ja": 102,
            "./ja/": 102,
            "./ja/build_distance_in_words_locale": 48,
            "./ja/build_distance_in_words_locale/": 48,
            "./ja/build_distance_in_words_locale/index": 48,
            "./ja/build_distance_in_words_locale/index.js": 48,
            "./ja/build_format_locale": 49,
            "./ja/build_format_locale/": 49,
            "./ja/build_format_locale/index": 49,
            "./ja/build_format_locale/index.js": 49,
            "./ja/index": 102,
            "./ja/index.js": 102,
            "./ja/package": 215,
            "./ja/package.json": 215,
            "./ko": 103,
            "./ko/": 103,
            "./ko/build_distance_in_words_locale": 50,
            "./ko/build_distance_in_words_locale/": 50,
            "./ko/build_distance_in_words_locale/index": 50,
            "./ko/build_distance_in_words_locale/index.js": 50,
            "./ko/build_format_locale": 51,
            "./ko/build_format_locale/": 51,
            "./ko/build_format_locale/index": 51,
            "./ko/build_format_locale/index.js": 51,
            "./ko/index": 103,
            "./ko/index.js": 103,
            "./ko/package": 216,
            "./ko/package.json": 216,
            "./mk": 104,
            "./mk/": 104,
            "./mk/build_distance_in_words_locale": 52,
            "./mk/build_distance_in_words_locale/": 52,
            "./mk/build_distance_in_words_locale/index": 52,
            "./mk/build_distance_in_words_locale/index.js": 52,
            "./mk/build_format_locale": 53,
            "./mk/build_format_locale/": 53,
            "./mk/build_format_locale/index": 53,
            "./mk/build_format_locale/index.js": 53,
            "./mk/index": 104,
            "./mk/index.js": 104,
            "./mk/package": 217,
            "./mk/package.json": 217,
            "./nb": 105,
            "./nb/": 105,
            "./nb/build_distance_in_words_locale": 54,
            "./nb/build_distance_in_words_locale/": 54,
            "./nb/build_distance_in_words_locale/index": 54,
            "./nb/build_distance_in_words_locale/index.js": 54,
            "./nb/build_format_locale": 55,
            "./nb/build_format_locale/": 55,
            "./nb/build_format_locale/index": 55,
            "./nb/build_format_locale/index.js": 55,
            "./nb/index": 105,
            "./nb/index.js": 105,
            "./nb/package": 218,
            "./nb/package.json": 218,
            "./nl": 106,
            "./nl/": 106,
            "./nl/build_distance_in_words_locale": 56,
            "./nl/build_distance_in_words_locale/": 56,
            "./nl/build_distance_in_words_locale/index": 56,
            "./nl/build_distance_in_words_locale/index.js": 56,
            "./nl/build_format_locale": 57,
            "./nl/build_format_locale/": 57,
            "./nl/build_format_locale/index": 57,
            "./nl/build_format_locale/index.js": 57,
            "./nl/index": 106,
            "./nl/index.js": 106,
            "./nl/package": 219,
            "./nl/package.json": 219,
            "./package": 220,
            "./package.json": 220,
            "./pl": 107,
            "./pl/": 107,
            "./pl/build_distance_in_words_locale": 58,
            "./pl/build_distance_in_words_locale/": 58,
            "./pl/build_distance_in_words_locale/index": 58,
            "./pl/build_distance_in_words_locale/index.js": 58,
            "./pl/build_format_locale": 59,
            "./pl/build_format_locale/": 59,
            "./pl/build_format_locale/index": 59,
            "./pl/build_format_locale/index.js": 59,
            "./pl/index": 107,
            "./pl/index.js": 107,
            "./pl/package": 221,
            "./pl/package.json": 221,
            "./pt": 108,
            "./pt/": 108,
            "./pt/build_distance_in_words_locale": 60,
            "./pt/build_distance_in_words_locale/": 60,
            "./pt/build_distance_in_words_locale/index": 60,
            "./pt/build_distance_in_words_locale/index.js": 60,
            "./pt/build_format_locale": 61,
            "./pt/build_format_locale/": 61,
            "./pt/build_format_locale/index": 61,
            "./pt/build_format_locale/index.js": 61,
            "./pt/index": 108,
            "./pt/index.js": 108,
            "./pt/package": 222,
            "./pt/package.json": 222,
            "./ro": 109,
            "./ro/": 109,
            "./ro/build_distance_in_words_locale": 62,
            "./ro/build_distance_in_words_locale/": 62,
            "./ro/build_distance_in_words_locale/index": 62,
            "./ro/build_distance_in_words_locale/index.js": 62,
            "./ro/build_format_locale": 63,
            "./ro/build_format_locale/": 63,
            "./ro/build_format_locale/index": 63,
            "./ro/build_format_locale/index.js": 63,
            "./ro/index": 109,
            "./ro/index.js": 109,
            "./ro/package": 223,
            "./ro/package.json": 223,
            "./ru": 110,
            "./ru/": 110,
            "./ru/build_distance_in_words_locale": 64,
            "./ru/build_distance_in_words_locale/": 64,
            "./ru/build_distance_in_words_locale/index": 64,
            "./ru/build_distance_in_words_locale/index.js": 64,
            "./ru/build_format_locale": 65,
            "./ru/build_format_locale/": 65,
            "./ru/build_format_locale/index": 65,
            "./ru/build_format_locale/index.js": 65,
            "./ru/index": 110,
            "./ru/index.js": 110,
            "./ru/package": 224,
            "./ru/package.json": 224,
            "./sk": 111,
            "./sk/": 111,
            "./sk/build_distance_in_words_locale": 66,
            "./sk/build_distance_in_words_locale/": 66,
            "./sk/build_distance_in_words_locale/index": 66,
            "./sk/build_distance_in_words_locale/index.js": 66,
            "./sk/build_format_locale": 67,
            "./sk/build_format_locale/": 67,
            "./sk/build_format_locale/index": 67,
            "./sk/build_format_locale/index.js": 67,
            "./sk/index": 111,
            "./sk/index.js": 111,
            "./sk/package": 225,
            "./sk/package.json": 225,
            "./sl": 112,
            "./sl/": 112,
            "./sl/build_distance_in_words_locale": 68,
            "./sl/build_distance_in_words_locale/": 68,
            "./sl/build_distance_in_words_locale/index": 68,
            "./sl/build_distance_in_words_locale/index.js": 68,
            "./sl/build_format_locale": 69,
            "./sl/build_format_locale/": 69,
            "./sl/build_format_locale/index": 69,
            "./sl/build_format_locale/index.js": 69,
            "./sl/index": 112,
            "./sl/index.js": 112,
            "./sl/package": 226,
            "./sl/package.json": 226,
            "./sv": 113,
            "./sv/": 113,
            "./sv/build_distance_in_words_locale": 70,
            "./sv/build_distance_in_words_locale/": 70,
            "./sv/build_distance_in_words_locale/index": 70,
            "./sv/build_distance_in_words_locale/index.js": 70,
            "./sv/build_format_locale": 71,
            "./sv/build_format_locale/": 71,
            "./sv/build_format_locale/index": 71,
            "./sv/build_format_locale/index.js": 71,
            "./sv/index": 113,
            "./sv/index.js": 113,
            "./sv/package": 227,
            "./sv/package.json": 227,
            "./th": 114,
            "./th/": 114,
            "./th/build_distance_in_words_locale": 72,
            "./th/build_distance_in_words_locale/": 72,
            "./th/build_distance_in_words_locale/index": 72,
            "./th/build_distance_in_words_locale/index.js": 72,
            "./th/build_format_locale": 73,
            "./th/build_format_locale/": 73,
            "./th/build_format_locale/index": 73,
            "./th/build_format_locale/index.js": 73,
            "./th/index": 114,
            "./th/index.js": 114,
            "./th/package": 228,
            "./th/package.json": 228,
            "./tr": 115,
            "./tr/": 115,
            "./tr/build_distance_in_words_locale": 74,
            "./tr/build_distance_in_words_locale/": 74,
            "./tr/build_distance_in_words_locale/index": 74,
            "./tr/build_distance_in_words_locale/index.js": 74,
            "./tr/build_format_locale": 75,
            "./tr/build_format_locale/": 75,
            "./tr/build_format_locale/index": 75,
            "./tr/build_format_locale/index.js": 75,
            "./tr/index": 115,
            "./tr/index.js": 115,
            "./tr/package": 229,
            "./tr/package.json": 229,
            "./zh_cn": 116,
            "./zh_cn/": 116,
            "./zh_cn/build_distance_in_words_locale": 76,
            "./zh_cn/build_distance_in_words_locale/": 76,
            "./zh_cn/build_distance_in_words_locale/index": 76,
            "./zh_cn/build_distance_in_words_locale/index.js": 76,
            "./zh_cn/build_format_locale": 77,
            "./zh_cn/build_format_locale/": 77,
            "./zh_cn/build_format_locale/index": 77,
            "./zh_cn/build_format_locale/index.js": 77,
            "./zh_cn/index": 116,
            "./zh_cn/index.js": 116,
            "./zh_cn/package": 230,
            "./zh_cn/package.json": 230,
            "./zh_tw": 117,
            "./zh_tw/": 117,
            "./zh_tw/build_distance_in_words_locale": 78,
            "./zh_tw/build_distance_in_words_locale/": 78,
            "./zh_tw/build_distance_in_words_locale/index": 78,
            "./zh_tw/build_distance_in_words_locale/index.js": 78,
            "./zh_tw/build_format_locale": 79,
            "./zh_tw/build_format_locale/": 79,
            "./zh_tw/build_format_locale/index": 79,
            "./zh_tw/build_format_locale/index.js": 79,
            "./zh_tw/index": 117,
            "./zh_tw/index.js": 117,
            "./zh_tw/package": 231,
            "./zh_tw/package.json": 231
        };

        function i(e) {
            return n(r(e))
        }

        function r(e) {
            var t = o[e];
            if (!(t + 1)) throw new Error("Cannot find module '" + e + "'.");
            return t
        }
        i.keys = function () {
            return Object.keys(o)
        }, i.resolve = r, (e.exports = i).id = 84
    }, function (e, t, n) {
        var o = n(14),
            i = n(15);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(16),
            i = n(17);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(18),
            i = n(19);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(20),
            i = n(21);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(22),
            i = n(23);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(24),
            i = n(25);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(26),
            i = n(27);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(28),
            i = n(29);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(30),
            i = n(31);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(32),
            i = n(33);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(34),
            i = n(35);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(36),
            i = n(37);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(38),
            i = n(39);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(40),
            i = n(41);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(42),
            i = n(43);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(44),
            i = n(45);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(46),
            i = n(47);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(48),
            i = n(49);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(50),
            i = n(51);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(52),
            i = n(53);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(54),
            i = n(55);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(56),
            i = n(57);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(58),
            i = n(59);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(60),
            i = n(61);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(62),
            i = n(63);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(64),
            i = n(65);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(66),
            i = n(67);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(68),
            i = n(69);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(70),
            i = n(71);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(72),
            i = n(73);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(74),
            i = n(75);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(76),
            i = n(77);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        var o = n(78),
            i = n(79);
        e.exports = {
            distanceInWords: o(),
            format: i()
        }
    }, function (e, t, n) {
        "use strict";
        n.d(t, "b", function () {
            return o
        }), n.d(t, "a", function () {
            return i
        }), Object.assign;
        var o = function () {
                return (0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : "") + ([1e7] + -1e3 + -4e3 + -8e3 + -1e11).replace(/[018]/g, function (e) {
                    return (e ^ crypto.getRandomValues(new Uint8Array(1))[0] & 15 >> e / 4).toString(16)
                })
            },
            i = function () {
                var e = !1;
                try {
                    var t = Object.defineProperty({}, "passive", {
                        get: function () {
                            e = !0
                        }
                    });
                    window.addEventListener("testPassive", null, t), window.removeEventListener("testPassive", null, t)
                } catch (e) {}
                return e
            }
    }, function (e, t, n) {
        "use strict";
        n.d(t, "c", function () {
            return i
        }), n.d(t, "e", function () {
            return r
        }), n.d(t, "b", function () {
            return a
        }), n.d(t, "d", function () {
            return s
        }), n.d(t, "a", function () {
            return c
        });
        var o = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (e) {
                return typeof e
            } : function (e) {
                return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
            },
            i = function (e) {
                return "function" == typeof e
            },
            r = function (e) {
                return "string" == typeof e || !!e && "object" === (void 0 === e ? "undefined" : o(e)) && "[object String]" === Object.prototype.toString.call(e)
            },
            a = function (e) {
                return ("[object Date]" === Object.prototype.toString.call(e) || e instanceof Date) && !isNaN(e.valueOf())
            },
            s = function (e) {
                return ("function" == typeof e || "object" === (void 0 === e ? "undefined" : o(e)) && !!e) && !Array.isArray(e)
            },
            u = /^(?:f(?:alse)?|no?|0+)$/i,
            c = function (e) {
                return !u.test(e) && !!e
            }
    }, function (e, t) {
        e.exports = function (e) {
            return e instanceof Date
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e),
                n = t.getFullYear(),
                i = t.getMonth(),
                r = new Date(0);
            return r.setFullYear(n, i + 1, 0), r.setHours(0, 0, 0, 0), r.getDate()
        }
    }, function (e, t, n) {
        var o = n(8);
        e.exports = function (e, t) {
            var n = Number(t);
            return o(e, 7 * n)
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = o(e).getTime(),
                i = o(t).getTime();
            return i < n ? -1 : n < i ? 1 : 0
        }
    }, function (e, t, n) {
        var o = n(0),
            i = n(138),
            r = n(11);
        e.exports = function (e, t) {
            var n = o(e),
                a = o(t),
                s = r(n, a),
                u = Math.abs(i(n, a));
            return n.setMonth(n.getMonth() - s * u), s * (u - (r(n, a) === -s))
        }
    }, function (e, t, n) {
        var o = n(83);
        e.exports = function (e, t) {
            var n = o(e, t) / 1e3;
            return 0 < n ? Math.floor(n) : Math.ceil(n)
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e);
            return t.setHours(23, 59, 59, 999), t
        }
    }, function (e, t, n) {
        var o = n(0),
            i = n(4),
            r = n(10);
        e.exports = function (e) {
            var t = o(e),
                n = i(t).getTime() - r(t).getTime();
            return Math.round(n / 6048e5) + 1
        }
    }, function (e, t, n) {
        var o = n(80);
        e.exports = function (e, t, n) {
            var i = o(e, n),
                r = o(t, n);
            return i.getTime() === r.getTime()
        }
    }, function (e, t, n) {
        "use strict";
        var o = function () {
                function e(e, t) {
                    for (var n = 0; n < t.length; n++) {
                        var o = t[n];
                        o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, o.key, o)
                    }
                }
                return function (t, n, o) {
                    return n && e(t.prototype, n), o && e(t, o), t
                }
            }(),
            i = function () {
                function e() {
                    var t = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : [];
                    ! function (e, t) {
                        if (!(e instanceof t)) throw new TypeError("Cannot call a class as a function")
                    }(this, e), this._listeners = new Map(t), this._middlewares = new Map
                }
                return o(e, [{
                    key: "listenerCount",
                    value: function (e) {
                        return this._listeners.has(e) ? this._listeners.get(e).length : 0
                    }
                }, {
                    key: "removeListeners",
                    value: function () {
                        var e = this,
                            t = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : null,
                            n = 1 < arguments.length && void 0 !== arguments[1] && arguments[1];
                        null !== t ? Array.isArray(t) ? name.forEach(function (t) {
                            return e.removeListeners(t, n)
                        }) : (this._listeners.delete(t), n && this.removeMiddleware(t)) : this._listeners = new Map
                    }
                }, {
                    key: "middleware",
                    value: function (e, t) {
                        var n = this;
                        Array.isArray(e) ? name.forEach(function (e) {
                            return n.middleware(e, t)
                        }) : (Array.isArray(this._middlewares.get(e)) || this._middlewares.set(e, []), this._middlewares.get(e).push(t))
                    }
                }, {
                    key: "removeMiddleware",
                    value: function () {
                        var e = this,
                            t = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : null;
                        null !== t ? Array.isArray(t) ? name.forEach(function (t) {
                            return e.removeMiddleware(t)
                        }) : this._middlewares.delete(t) : this._middlewares = new Map
                    }
                }, {
                    key: "on",
                    value: function (e, t) {
                        var n = this,
                            o = 2 < arguments.length && void 0 !== arguments[2] && arguments[2];
                        if (Array.isArray(e)) e.forEach(function (e) {
                            return n.on(e, t)
                        });
                        else {
                            var i = (e = e.toString()).split(/,|, | /);
                            1 < i.length ? i.forEach(function (e) {
                                return n.on(e, t)
                            }) : (Array.isArray(this._listeners.get(e)) || this._listeners.set(e, []), this._listeners.get(e).push({
                                once: o,
                                callback: t
                            }))
                        }
                    }
                }, {
                    key: "once",
                    value: function (e, t) {
                        this.on(e, t, !0)
                    }
                }, {
                    key: "emit",
                    value: function (e, t) {
                        var n = this,
                            o = 2 < arguments.length && void 0 !== arguments[2] && arguments[2];
                        e = e.toString();
                        var i = this._listeners.get(e),
                            r = null,
                            a = 0,
                            s = o;
                        if (Array.isArray(i))
                            for (i.forEach(function (u, c) {
                                    o || (r = n._middlewares.get(e), Array.isArray(r) ? (r.forEach(function (n) {
                                        n(t, function () {
                                            var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : null;
                                            null !== e && (t = e), a++
                                        }, e)
                                    }), a >= r.length && (s = !0)) : s = !0), s && (u.once && (i[c] = null), u.callback({
                                        type: e,
                                        timeStamp: (new Date).getTime(),
                                        data: t
                                    }))
                                }); - 1 !== i.indexOf(null);) i.splice(i.indexOf(null), 1)
                    }
                }]), e
            }();
        t.a = i
    }, function (e, t, n) {
        var o = n(9);
        e.exports = function (e, t) {
            var n = Number(t);
            return o(e, 36e5 * n)
        }
    }, function (e, t, n) {
        var o = n(3),
            i = n(132);
        e.exports = function (e, t) {
            var n = Number(t);
            return i(e, o(e) + n)
        }
    }, function (e, t, n) {
        var o = n(0),
            i = n(10),
            r = n(81);
        e.exports = function (e, t) {
            var n = o(e),
                a = Number(t),
                s = r(n, i(n)),
                u = new Date(0);
            return u.setFullYear(a, 0, 4), u.setHours(0, 0, 0, 0), (n = i(u)).setDate(n.getDate() + s), n
        }
    }, function (e, t, n) {
        var o = n(9);
        e.exports = function (e, t) {
            var n = Number(t);
            return o(e, 6e4 * n)
        }
    }, function (e, t, n) {
        var o = n(82);
        e.exports = function (e, t) {
            var n = Number(t);
            return o(e, 3 * n)
        }
    }, function (e, t, n) {
        var o = n(9);
        e.exports = function (e, t) {
            var n = Number(t);
            return o(e, 1e3 * n)
        }
    }, function (e, t, n) {
        var o = n(82);
        e.exports = function (e, t) {
            var n = Number(t);
            return o(e, 12 * n)
        }
    }, function (e, t, n) {
        var o = n(3);
        e.exports = function (e, t) {
            return o(e) - o(t)
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = o(e),
                i = o(t);
            return 12 * (n.getFullYear() - i.getFullYear()) + (n.getMonth() - i.getMonth())
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e);
            return Math.floor(t.getMonth() / 3) + 1
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = o(e),
                i = o(t);
            return n.getFullYear() - i.getFullYear()
        }
    }, function (e, t, n) {
        var o = n(0),
            i = n(81),
            r = n(11);
        e.exports = function (e, t) {
            var n = o(e),
                a = o(t),
                s = r(n, a),
                u = Math.abs(i(n, a));
            return n.setDate(n.getDate() - s * u), s * (u - (r(n, a) === -s))
        }
    }, function (e, t, n) {
        var o = n(131);
        e.exports = function (e, t) {
            var n = Number(t);
            return o(e, -n)
        }
    }, function (e, t, n) {
        var o = n(123),
            i = n(0),
            r = n(125),
            a = n(124),
            s = n(6);
        e.exports = function (e, t, n) {
            var u = n || {},
                c = o(e, t),
                d = u.locale,
                l = s.distanceInWords.localize;
            d && d.distanceInWords && d.distanceInWords.localize && (l = d.distanceInWords.localize);
            var f, h, m = {
                addSuffix: Boolean(u.addSuffix),
                comparison: c
            };
            h = 0 < c ? (f = i(e), i(t)) : (f = i(t), i(e));
            var p, v = r(h, f),
                g = h.getTimezoneOffset() - f.getTimezoneOffset(),
                _ = Math.round(v / 60) - g;
            if (_ < 2) return u.includeSeconds ? v < 5 ? l("lessThanXSeconds", 5, m) : v < 10 ? l("lessThanXSeconds", 10, m) : v < 20 ? l("lessThanXSeconds", 20, m) : v < 40 ? l("halfAMinute", null, m) : l(v < 60 ? "lessThanXMinutes" : "xMinutes", 1, m) : 0 === _ ? l("lessThanXMinutes", 1, m) : l("xMinutes", _, m);
            if (_ < 45) return l("xMinutes", _, m);
            if (_ < 90) return l("aboutXHours", 1, m);
            if (_ < 1440) return l("aboutXHours", Math.round(_ / 60), m);
            if (_ < 2520) return l("xDays", 1, m);
            if (_ < 43200) return l("xDays", Math.round(_ / 1440), m);
            if (_ < 86400) return l("aboutXMonths", p = Math.round(_ / 43200), m);
            if ((p = a(h, f)) < 12) return l("xMonths", Math.round(_ / 43200), m);
            var b = p % 12,
                M = Math.floor(p / 12);
            return b < 3 ? l("aboutXYears", M, m) : b < 9 ? l("overXYears", M, m) : l("almostXYears", M + 1, m)
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = t && Number(t.weekStartsOn) || 0,
                i = o(e),
                r = i.getDay(),
                a = 6 + (r < n ? -7 : 0) - (r - n);
            return i.setDate(i.getDate() + a), i.setHours(23, 59, 59, 999), i
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e),
                n = t.getMonth();
            return t.setFullYear(t.getFullYear(), n + 1, 0), t.setHours(23, 59, 59, 999), t
        }
    }, function (e, t, n) {
        var o = n(0),
            i = n(147),
            r = n(81);
        e.exports = function (e) {
            var t = o(e);
            return r(t, i(t)) + 1
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e),
                n = new Date(0);
            return n.setFullYear(t.getFullYear(), 0, 1), n.setHours(0, 0, 0, 0), n
        }
    }, function (e, t, n) {
        var o = n(120);
        e.exports = function (e) {
            if (o(e)) return !isNaN(e);
            throw new TypeError(toString.call(e) + " is not an instance of Date")
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e).getFullYear();
            return t % 400 == 0 || t % 4 == 0 && t % 100 != 0
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e).getDay();
            return 0 === t && (t = 7), t
        }
    }, function (e, t, n) {
        var o = n(152);
        e.exports = function (e, t) {
            var n = o(e),
                i = o(t);
            return n.getTime() === i.getTime()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e);
            return t.setMinutes(0, 0, 0), t
        }
    }, function (e, t, n) {
        var o = n(128);
        e.exports = function (e, t) {
            return o(e, t, {
                weekStartsOn: 1
            })
        }
    }, function (e, t, n) {
        var o = n(10);
        e.exports = function (e, t) {
            var n = o(e),
                i = o(t);
            return n.getTime() === i.getTime()
        }
    }, function (e, t, n) {
        var o = n(156);
        e.exports = function (e, t) {
            var n = o(e),
                i = o(t);
            return n.getTime() === i.getTime()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e);
            return t.setSeconds(0, 0), t
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = o(e),
                i = o(t);
            return n.getFullYear() === i.getFullYear() && n.getMonth() === i.getMonth()
        }
    }, function (e, t, n) {
        var o = n(159);
        e.exports = function (e, t) {
            var n = o(e),
                i = o(t);
            return n.getTime() === i.getTime()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e),
                n = t.getMonth(),
                i = n - n % 3;
            return t.setMonth(i, 1), t.setHours(0, 0, 0, 0), t
        }
    }, function (e, t, n) {
        var o = n(161);
        e.exports = function (e, t) {
            var n = o(e),
                i = o(t);
            return n.getTime() === i.getTime()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e);
            return t.setMilliseconds(0), t
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = o(e),
                i = o(t);
            return n.getFullYear() === i.getFullYear()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = t && Number(t.weekStartsOn) || 0,
                i = o(e),
                r = i.getDay(),
                a = 6 + (r < n ? -7 : 0) - (r - n);
            return i.setHours(0, 0, 0, 0), i.setDate(i.getDate() + a), i
        }
    }, function (e, t, n) {
        var o = n(0),
            i = n(121);
        e.exports = function (e, t) {
            var n = o(e),
                r = Number(t),
                a = n.getFullYear(),
                s = n.getDate(),
                u = new Date(0);
            u.setFullYear(a, r, 15), u.setHours(0, 0, 0, 0);
            var c = i(u);
            return n.setMonth(r, Math.min(s, c)), n
        }
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                var t = ["٠", "١", "٢", "٣", "٤", "٥", "٦", "٧", "٨", "٩"],
                    n = {
                        "٠": 0,
                        "١": 1,
                        "٢": 2,
                        "٣": 3,
                        "٤": 4,
                        "٥": 5,
                        "٦": 6,
                        "٧": 7,
                        "٨": 8,
                        "٩": 9
                    };
                e.setLocales("ar", {
                    MMMM: ["كانون الثاني يناير", "شباط فبراير", "آذار مارس", "نيسان أبريل", "أيار مايو", "حزيران يونيو", "تموز يوليو", "آب أغسطس", "أيلول سبتمبر", "تشرين الأول أكتوبر", "تشرين الثاني نوفمبر", "كانون الأول ديسمبر"],
                    MMM: ["كانون الثاني يناير", "شباط فبراير", "آذار مارس", "نيسان أبريل", "أيار مايو", "حزيران يونيو", "تموز يوليو", "آب أغسطس", "أيلول سبتمبر", "تشرين الأول أكتوبر", "تشرين الثاني نوفمبر", "كانون الأول ديسمبر"],
                    dddd: ["الأحد", "الإثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"],
                    ddd: ["أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"],
                    dd: ["ح", "ن", "ث", "ر", "خ", "ج", "س"],
                    A: ["ص", "م"],
                    formatter: {
                        post: function (e) {
                            return e.replace(/\d/g, function (e) {
                                return t[0 | e]
                            })
                        }
                    },
                    parser: {
                        pre: function (e) {
                            return e.replace(/[٠١٢٣٤٥٦٧٨٩]/g, function (e) {
                                return "" + n[e]
                            })
                        }
                    }
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("az", {
                    MMMM: ["yanvar", "fevral", "mart", "aprel", "may", "iyun", "iyul", "avqust", "sentyabr", "oktyabr", "noyabr", "dekabr"],
                    MMM: ["yan", "fev", "mar", "apr", "may", "iyn", "iyl", "avq", "sen", "okt", "noy", "dek"],
                    dddd: ["Bazar", "Bazar ertəsi", "Çərşənbə axşamı", "Çərşənbə", "Cümə axşamı", "Cümə", "Şənbə"],
                    ddd: ["Baz", "BzE", "ÇAx", "Çər", "CAx", "Cüm", "Şən"],
                    dd: ["Bz", "BE", "ÇA", "Çə", "CA", "Cü", "Şə"],
                    A: ["gecə", "səhər", "gündüz", "axşam"],
                    formatter: {
                        A: function (e) {
                            var t = e.getHours();
                            return t < 4 ? this.A[0] : t < 12 ? this.A[1] : t < 17 ? this.A[2] : this.A[3]
                        }
                    },
                    parser: {
                        h: function (e, t) {
                            return t < 2 ? e : 11 < e ? e : e + 12
                        }
                    }
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("bn", {
                    MMMM: ["জানুয়ারী", "ফেবুয়ারী", "মার্চ", "এপ্রিল", "মে", "জুন", "জুলাই", "অগাস্ট", "সেপ্টেম্বর", "অক্টোবর", "নভেম্বর", "ডিসেম্বর"],
                    MMM: ["জানু", "ফেব", "মার্চ", "এপর", "মে", "জুন", "জুল", "অগ", "সেপ্ট", "অক্টো", "নভ", "ডিসেম্"],
                    dddd: ["রবিবার", "সোমবার", "মঙ্গলবার", "বুধবার", "বৃহস্পত্তিবার", "শুক্রবার", "শনিবার"],
                    ddd: ["রবি", "সোম", "মঙ্গল", "বুধ", "বৃহস্পত্তি", "শুক্র", "শনি"],
                    dd: ["রব", "সম", "মঙ্গ", "বু", "ব্রিহ", "শু", "শনি"],
                    A: ["রাত", "সকাল", "দুপুর", "বিকাল"],
                    formatter: {
                        A: function (e) {
                            var t = e.getHours();
                            return t < 4 ? this.A[0] : t < 10 ? this.A[1] : t < 17 ? this.A[2] : t < 20 ? this.A[3] : this.A[0]
                        }
                    },
                    parser: {
                        h: function (e, t) {
                            return t < 1 ? e < 4 || 11 < e ? e : e + 12 : t < 2 ? e : t < 3 && 9 < e ? e : e + 12
                        }
                    }
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("cs", {
                    MMMM: ["leden", "únor", "březen", "duben", "květen", "červen", "červenec", "srpen", "září", "říjen", "listopad", "prosinec"],
                    MMM: ["led", "úno", "bře", "dub", "kvě", "čvn", "čvc", "srp", "zář", "říj", "lis", "pro"],
                    dddd: ["neděle", "pondělí", "úterý", "středa", "čtvrtek", "pátek", "sobota"],
                    ddd: ["ne", "po", "út", "st", "čt", "pá", "so"],
                    dd: ["ne", "po", "út", "st", "čt", "pá", "so"]
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("de", {
                    MMMM: ["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"],
                    MMM: ["Jan.", "Febr.", "Mrz.", "Apr.", "Mai", "Jun.", "Jul.", "Aug.", "Sept.", "Okt.", "Nov.", "Dez."],
                    dddd: ["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"],
                    ddd: ["So.", "Mo.", "Di.", "Mi.", "Do.", "Fr.", "Sa."],
                    dd: ["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"],
                    A: ["Uhr nachmittags", "Uhr morgens"]
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("el", {
                    MMMM: {
                        nominative: ["Ιανουάριος", "Φεβρουάριος", "Μάρτιος", "Απρίλιος", "Μάιος", "Ιούνιος", "Ιούλιος", "Αύγουστος", "Σεπτέμβριος", "Οκτώβριος", "Νοέμβριος", "Δεκέμβριος"],
                        genitive: ["Ιανουαρίου", "Φεβρουαρίου", "Μαρτίου", "Απριλίου", "Μαΐου", "Ιουνίου", "Ιουλίου", "Αυγούστου", "Σεπτεμβρίου", "Οκτωβρίου", "Νοεμβρίου", "Δεκεμβρίου"]
                    },
                    MMM: ["Ιαν", "Φεβ", "Μαρ", "Απρ", "Μαϊ", "Ιουν", "Ιουλ", "Αυγ", "Σεπ", "Οκτ", "Νοε", "Δεκ"],
                    dddd: ["Κυριακή", "Δευτέρα", "Τρίτη", "Τετάρτη", "Πέμπτη", "Παρασκευή", "Σάββατο"],
                    ddd: ["Κυρ", "Δευ", "Τρι", "Τετ", "Πεμ", "Παρ", "Σαβ"],
                    dd: ["Κυ", "Δε", "Τρ", "Τε", "Πε", "Πα", "Σα"],
                    A: ["πμ", "μμ"],
                    formatter: {
                        MMMM: function (e, t) {
                            return this.MMMM[/D.*MMMM/.test(t) ? "genitive" : "nominative"][e.getMonth()]
                        },
                        hh: function (e) {
                            return ("0" + e.getHours() % 12).slice(-2)
                        },
                        h: function (e) {
                            return e.getHours() % 12
                        }
                    },
                    parser: {
                        MMMM: function (e, t) {
                            return this.parser.find(this.MMMM[/D.*MMMM/.test(t) ? "genitive" : "nominative"], e)
                        }
                    }
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("es", {
                    MMMM: ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"],
                    MMM: ["Ene.", "Feb.", "Mar.", "Abr.", "May.", "Jun.", "Jul.", "Ago.", "Sep.", "Oct.", "Nov.", "Dic."],
                    dddd: ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"],
                    ddd: ["Dom.", "Lun.", "Mar.", "Mié.", "Jue.", "Vie.", "Sáb."],
                    dd: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sá"],
                    A: ["de la mañana", "de la tarde", "de la noche"],
                    formatter: {
                        A: function (e) {
                            var t = e.getHours();
                            return t < 12 ? this.A[0] : t < 19 ? this.A[1] : this.A[2]
                        }
                    },
                    parser: {
                        h: function (e, t) {
                            return t < 1 ? e : 11 < e ? e : e + 12
                        }
                    }
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                var t = ["۰", "۱", "۲", "۳", "۴", "۵", "۶", "۷", "۸", "۹"],
                    n = {
                        "۰": 0,
                        "۱": 1,
                        "۲": 2,
                        "۳": 3,
                        "۴": 4,
                        "۵": 5,
                        "۶": 6,
                        "۷": 7,
                        "۸": 8,
                        "۹": 9
                    };
                e.setLocales("fa", {
                    MMMM: ["ژانویه", "فوریه", "مارس", "آوریل", "مه", "ژوئن", "ژوئیه", "اوت", "سپتامبر", "اکتبر", "نوامبر", "دسامبر"],
                    MMM: ["ژانویه", "فوریه", "مارس", "آوریل", "مه", "ژوئن", "ژوئیه", "اوت", "سپتامبر", "اکتبر", "نوامبر", "دسامبر"],
                    dddd: ["یک‌شنبه", "دوشنبه", "سه‌شنبه", "چهارشنبه", "پنج‌شنبه", "جمعه", "شنبه"],
                    ddd: ["یک‌شنبه", "دوشنبه", "سه‌شنبه", "چهارشنبه", "پنج‌شنبه", "جمعه", "شنبه"],
                    dd: ["ی", "د", "س", "چ", "پ", "ج", "ش"],
                    A: ["قبل از ظهر", "بعد از ظهر"],
                    formatter: {
                        post: function (e) {
                            return e.replace(/\d/g, function (e) {
                                return t[0 | e]
                            })
                        }
                    },
                    parser: {
                        pre: function (e) {
                            return e.replace(/[۰۱۲۳۴۵۶۷۸۹]/g, function (e) {
                                return "" + n[e]
                            })
                        }
                    }
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("fr", {
                    MMMM: ["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"],
                    MMM: ["janv.", "févr.", "mars", "avr.", "mai", "juin", "juil.", "août", "sept.", "oct.", "nov.", "déc."],
                    dddd: ["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"],
                    ddd: ["dim.", "lun.", "mar.", "mer.", "jeu.", "ven.", "sam."],
                    dd: ["Di", "Lu", "Ma", "Me", "Je", "Ve", "Sa"],
                    A: ["matin", "l'après-midi"]
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("hi", {
                    MMMM: ["जनवरी", "फ़रवरी", "मार्च", "अप्रैल", "मई", "जून", "जुलाई", "अगस्त", "सितम्बर", "अक्टूबर", "नवम्बर", "दिसम्बर"],
                    MMM: ["जन.", "फ़र.", "मार्च", "अप्रै.", "मई", "जून", "जुल.", "अग.", "सित.", "अक्टू.", "नव.", "दिस."],
                    dddd: ["रविवार", "सोमवार", "मंगलवार", "बुधवार", "गुरूवार", "शुक्रवार", "शनिवार"],
                    ddd: ["रवि", "सोम", "मंगल", "बुध", "गुरू", "शुक्र", "शनि"],
                    dd: ["र", "सो", "मं", "बु", "गु", "शु", "श"],
                    A: ["रात", "सुबह", "दोपहर", "शाम"],
                    formatter: {
                        A: function (e) {
                            var t = e.getHours();
                            return t < 4 ? this.A[0] : t < 10 ? this.A[1] : t < 17 ? this.A[2] : t < 20 ? this.A[3] : this.A[0]
                        }
                    },
                    parser: {
                        h: function (e, t) {
                            return t < 1 ? e < 4 || 11 < e ? e : e + 12 : t < 2 ? e : t < 3 && 9 < e ? e : e + 12
                        }
                    }
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("hu", {
                    MMMM: ["január", "február", "március", "április", "május", "június", "július", "augusztus", "szeptember", "október", "november", "december"],
                    MMM: ["jan", "feb", "márc", "ápr", "máj", "jún", "júl", "aug", "szept", "okt", "nov", "dec"],
                    dddd: ["vasárnap", "hétfő", "kedd", "szerda", "csütörtök", "péntek", "szombat"],
                    ddd: ["vas", "hét", "kedd", "sze", "csüt", "pén", "szo"],
                    dd: ["v", "h", "k", "sze", "cs", "p", "szo"],
                    A: ["de", "du"]
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("id", {
                    MMMM: ["Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember"],
                    MMM: ["Jan", "Feb", "Mar", "Apr", "Mei", "Jun", "Jul", "Ags", "Sep", "Okt", "Nov", "Des"],
                    dddd: ["Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"],
                    ddd: ["Min", "Sen", "Sel", "Rab", "Kam", "Jum", "Sab"],
                    dd: ["Mg", "Sn", "Sl", "Rb", "Km", "Jm", "Sb"],
                    A: ["pagi", "siang", "sore", "malam"],
                    formatter: {
                        A: function (e) {
                            var t = e.getHours();
                            return t < 11 ? this.A[0] : t < 15 ? this.A[1] : t < 19 ? this.A[2] : this.A[3]
                        }
                    },
                    parser: {
                        h: function (e, t) {
                            return t < 1 ? e : t < 2 && 11 <= e ? e : e + 12
                        }
                    }
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("it", {
                    MMMM: ["gennaio", "febbraio", "marzo", "aprile", "maggio", "giugno", "luglio", "agosto", "settembre", "ottobre", "novembre", "dicembre"],
                    MMM: ["gen", "feb", "mar", "apr", "mag", "giu", "lug", "ago", "set", "ott", "nov", "dic"],
                    dddd: ["Domenica", "Lunedì", "Martedì", "Mercoledì", "Giovedì", "Venerdì", "Sabato"],
                    ddd: ["Dom", "Lun", "Mar", "Mer", "Gio", "Ven", "Sab"],
                    dd: ["Do", "Lu", "Ma", "Me", "Gi", "Ve", "Sa"],
                    A: ["di mattina", "di pomerrigio"]
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("ja", {
                    MMMM: ["1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"],
                    MMM: ["1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"],
                    dddd: ["日曜日", "月曜日", "火曜日", "水曜日", "木曜日", "金曜日", "土曜日"],
                    ddd: ["日", "月", "火", "水", "木", "金", "土"],
                    dd: ["日", "月", "火", "水", "木", "金", "土"],
                    A: ["午前", "午後"],
                    formatter: {
                        hh: function (e) {
                            return ("0" + e.getHours() % 12).slice(-2)
                        },
                        h: function (e) {
                            return e.getHours() % 12
                        }
                    }
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("jv", {
                    MMMM: ["Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "Nopember", "Desember"],
                    MMM: ["Jan", "Feb", "Mar", "Apr", "Mei", "Jun", "Jul", "Ags", "Sep", "Okt", "Nop", "Des"],
                    dddd: ["Minggu", "Senen", "Seloso", "Rebu", "Kemis", "Jemuwah", "Septu"],
                    ddd: ["Min", "Sen", "Sel", "Reb", "Kem", "Jem", "Sep"],
                    dd: ["Mg", "Sn", "Sl", "Rb", "Km", "Jm", "Sp"],
                    A: ["enjing", "siyang", "sonten", "ndalu"],
                    formatter: {
                        A: function (e) {
                            var t = e.getHours();
                            return t < 11 ? this.A[0] : t < 15 ? this.A[1] : t < 19 ? this.A[2] : this.A[3]
                        }
                    },
                    parser: {
                        h: function (e, t) {
                            return t < 1 ? e : t < 2 && 11 <= e ? e : e + 12
                        }
                    }
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("ko", {
                    MMMM: ["1월", "2월", "3월", "4월", "5월", "6월", "7월", "8월", "9월", "10월", "11월", "12월"],
                    MMM: ["1월", "2월", "3월", "4월", "5월", "6월", "7월", "8월", "9월", "10월", "11월", "12월"],
                    dddd: ["일요일", "월요일", "화요일", "수요일", "목요일", "금요일", "토요일"],
                    ddd: ["일", "월", "화", "수", "목", "금", "토"],
                    dd: ["일", "월", "화", "수", "목", "금", "토"],
                    A: ["오전", "오후"]
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                var t = ["၀", "၁", "၂", "၃", "၄", "၅", "၆", "၇", "၈", "၉"],
                    n = {
                        "၀": 0,
                        "၁": 1,
                        "၂": 2,
                        "၃": 3,
                        "၄": 4,
                        "၅": 5,
                        "၆": 6,
                        "၇": 7,
                        "၈": 8,
                        "၉": 9
                    };
                e.setLocales("my", {
                    MMMM: ["ဇန်နဝါရီ", "ဖေဖော်ဝါရီ", "မတ်", "ဧပြီ", "မေ", "ဇွန်", "ဇူလိုင်", "သြဂုတ်", "စက်တင်ဘာ", "အောက်တိုဘာ", "နိုဝင်ဘာ", "ဒီဇင်ဘာ"],
                    MMM: ["ဇန်", "ဖေ", "မတ်", "ပြီ", "မေ", "ဇွန်", "လိုင်", "သြ", "စက်", "အောက်", "နို", "ဒီ"],
                    dddd: ["တနင်္ဂနွေ", "တနင်္လာ", "အင်္ဂါ", "ဗုဒ္ဓဟူး", "ကြာသပတေး", "သောကြာ", "စနေ"],
                    ddd: ["နွေ", "လာ", "ဂါ", "ဟူး", "ကြာ", "သော", "နေ"],
                    dd: ["နွေ", "လာ", "ဂါ", "ဟူး", "ကြာ", "သော", "နေ"],
                    formatter: {
                        post: function (e) {
                            return e.replace(/\d/g, function (e) {
                                return t[0 | e]
                            })
                        }
                    },
                    parser: {
                        pre: function (e) {
                            return e.replace(/[၀၁၂၃၄၅၆၇၈၉]/g, function (e) {
                                return "" + n[e]
                            })
                        }
                    }
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("nl", {
                    MMMM: ["januari", "februari", "maart", "april", "mei", "juni", "juli", "augustus", "september", "oktober", "november", "december"],
                    MMM: {
                        withdots: ["jan.", "feb.", "mrt.", "apr.", "mei", "jun.", "jul.", "aug.", "sep.", "okt.", "nov.", "dec."],
                        withoutdots: ["jan", "feb", "mrt", "apr", "mei", "jun", "jul", "aug", "sep", "okt", "nov", "dec"]
                    },
                    dddd: ["zondag", "maandag", "dinsdag", "woensdag", "donderdag", "vrijdag", "zaterdag"],
                    ddd: ["zo.", "ma.", "di.", "wo.", "do.", "vr.", "za."],
                    dd: ["Zo", "Ma", "Di", "Wo", "Do", "Vr", "Za"],
                    formatter: {
                        MMM: function (e, t) {
                            return this.MMM[/-MMM-/.test(t) ? "withoutdots" : "withdots"][e.getMonth()]
                        }
                    },
                    parser: {
                        MMM: function (e, t) {
                            return this.parser.find(this.MMM[/-MMM-/.test(t) ? "withoutdots" : "withdots"], e)
                        }
                    }
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                var t = ["੦", "੧", "੨", "੩", "੪", "੫", "੬", "੭", "੮", "੯"],
                    n = {
                        "੦": 0,
                        "੧": 1,
                        "੨": 2,
                        "੩": 3,
                        "੪": 4,
                        "੫": 5,
                        "੬": 6,
                        "੭": 7,
                        "੮": 8,
                        "੯": 9
                    };
                e.setLocales("pa-in", {
                    MMMM: ["ਜਨਵਰੀ", "ਫ਼ਰਵਰੀ", "ਮਾਰਚ", "ਅਪ੍ਰੈਲ", "ਮਈ", "ਜੂਨ", "ਜੁਲਾਈ", "ਅਗਸਤ", "ਸਤੰਬਰ", "ਅਕਤੂਬਰ", "ਨਵੰਬਰ", "ਦਸੰਬਰ"],
                    MMM: ["ਜਨਵਰੀ", "ਫ਼ਰਵਰੀ", "ਮਾਰਚ", "ਅਪ੍ਰੈਲ", "ਮਈ", "ਜੂਨ", "ਜੁਲਾਈ", "ਅਗਸਤ", "ਸਤੰਬਰ", "ਅਕਤੂਬਰ", "ਨਵੰਬਰ", "ਦਸੰਬਰ"],
                    dddd: ["ਐਤਵਾਰ", "ਸੋਮਵਾਰ", "ਮੰਗਲਵਾਰ", "ਬੁਧਵਾਰ", "ਵੀਰਵਾਰ", "ਸ਼ੁੱਕਰਵਾਰ", "ਸ਼ਨੀਚਰਵਾਰ"],
                    ddd: ["ਐਤ", "ਸੋਮ", "ਮੰਗਲ", "ਬੁਧ", "ਵੀਰ", "ਸ਼ੁਕਰ", "ਸ਼ਨੀ"],
                    dd: ["ਐਤ", "ਸੋਮ", "ਮੰਗਲ", "ਬੁਧ", "ਵੀਰ", "ਸ਼ੁਕਰ", "ਸ਼ਨੀ"],
                    A: ["ਰਾਤ", "ਸਵੇਰ", "ਦੁਪਹਿਰ", "ਸ਼ਾਮ"],
                    formatter: {
                        A: function (e) {
                            var t = e.getHours();
                            return t < 4 ? this.A[0] : t < 10 ? this.A[1] : t < 17 ? this.A[2] : t < 20 ? this.A[3] : this.A[0]
                        },
                        post: function (e) {
                            return e.replace(/\d/g, function (e) {
                                return t[0 | e]
                            })
                        }
                    },
                    parser: {
                        h: function (e, t) {
                            return t < 1 ? e < 4 || 11 < e ? e : e + 12 : t < 2 ? e : t < 3 && 10 <= e ? e : e + 12
                        },
                        pre: function (e) {
                            return e.replace(/[੦੧੨੩੪੫੬੭੮੯]/g, function (e) {
                                return "" + n[e]
                            })
                        }
                    }
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("pl", {
                    MMMM: {
                        nominative: ["styczeń", "luty", "marzec", "kwiecień", "maj", "czerwiec", "lipiec", "sierpień", "wrzesień", "październik", "listopad", "grudzień"],
                        subjective: ["stycznia", "lutego", "marca", "kwietnia", "maja", "czerwca", "lipca", "sierpnia", "września", "października", "listopada", "grudnia"]
                    },
                    MMM: ["sty", "lut", "mar", "kwi", "maj", "cze", "lip", "sie", "wrz", "paź", "lis", "gru"],
                    dddd: ["niedziela", "poniedziałek", "wtorek", "środa", "czwartek", "piątek", "sobota"],
                    ddd: ["nie", "pon", "wt", "śr", "czw", "pt", "sb"],
                    dd: ["Nd", "Pn", "Wt", "Śr", "Cz", "Pt", "So"],
                    formatter: {
                        MMMM: function (e, t) {
                            return this.MMMM[/D MMMM/.test(t) ? "subjective" : "nominative"][e.getMonth()]
                        }
                    },
                    parser: {
                        MMMM: function (e, t) {
                            return this.parser.find(this.MMMM[/D MMMM/.test(t) ? "subjective" : "nominative"], e)
                        }
                    }
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("pt", {
                    MMMM: ["Janeiro", "Fevereiro", "Março", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"],
                    MMM: ["Jan", "Fev", "Mar", "Abr", "Mai", "Jun", "Jul", "Ago", "Set", "Out", "Nov", "Dez"],
                    dddd: ["Domingo", "Segunda-Feira", "Terça-Feira", "Quarta-Feira", "Quinta-Feira", "Sexta-Feira", "Sábado"],
                    ddd: ["Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sáb"],
                    dd: ["Dom", "2ª", "3ª", "4ª", "5ª", "6ª", "Sáb"],
                    A: ["da madrugada", "da manhã", "da tarde", "da noite"],
                    formatter: {
                        A: function (e) {
                            var t = e.getHours();
                            return t < 5 ? this.A[0] : t < 12 ? this.A[1] : t < 19 ? this.A[2] : this.A[3]
                        }
                    },
                    parser: {
                        h: function (e, t) {
                            return t < 2 ? e : 11 < e ? e : e + 12
                        }
                    }
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("ro", {
                    MMMM: ["ianuarie", "februarie", "martie", "aprilie", "mai", "iunie", "iulie", "august", "septembrie", "octombrie", "noiembrie", "decembrie"],
                    MMM: ["ian.", "febr.", "mart.", "apr.", "mai", "iun.", "iul.", "aug.", "sept.", "oct.", "nov.", "dec."],
                    dddd: ["duminică", "luni", "marți", "miercuri", "joi", "vineri", "sâmbătă"],
                    ddd: ["Dum", "Lun", "Mar", "Mie", "Joi", "Vin", "Sâm"],
                    dd: ["Du", "Lu", "Ma", "Mi", "Jo", "Vi", "Sâ"]
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("ru", {
                    MMMM: ["Января", "Февраля", "Марта", "Апреля", "Мая", "Июня", "Июля", "Августа", "Сентября", "Октября", "Ноября", "Декабря"],
                    MMM: ["янв", "фев", "мар", "апр", "мая", "июня", "июля", "авг", "сен", "окт", "ноя", "дек"],
                    dddd: ["Воскресенье", "Понедельник", "Вторник", "Среду", "Четверг", "Пятницу", "Субботу"],
                    ddd: ["Вс", "Пн", "Вт", "Ср", "Чт", "Пт", "Сб"],
                    dd: ["Вс", "Пн", "Вт", "Ср", "Чт", "Пт", "Сб"],
                    A: ["ночи", "утра", "дня", "вечера"],
                    formatter: {
                        A: function (e) {
                            var t = e.getHours();
                            return t < 4 ? this.A[0] : t < 12 ? this.A[1] : t < 17 ? this.A[2] : this.A[3]
                        }
                    },
                    parser: {
                        h: function (e, t) {
                            return t < 2 ? e : 11 < e ? e : e + 12
                        }
                    }
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("sr", {
                    MMMM: ["januar", "februar", "mart", "april", "maj", "jun", "jul", "avgust", "septembar", "oktobar", "novembar", "decembar"],
                    MMM: ["jan.", "feb.", "mar.", "apr.", "maj", "jun", "jul", "avg.", "sep.", "okt.", "nov.", "dec."],
                    dddd: ["nedelja", "ponedeljak", "utorak", "sreda", "četvrtak", "petak", "subota"],
                    ddd: ["ned.", "pon.", "uto.", "sre.", "čet.", "pet.", "sub."],
                    dd: ["ne", "po", "ut", "sr", "če", "pe", "su"]
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("th", {
                    MMMM: ["มกราคม", "กุมภาพันธ์", "มีนาคม", "เมษายน", "พฤษภาคม", "มิถุนายน", "กรกฎาคม", "สิงหาคม", "กันยายน", "ตุลาคม", "พฤศจิกายน", "ธันวาคม"],
                    MMM: ["ม.ค.", "ก.พ.", "มี.ค.", "เม.ย.", "พ.ค.", "มิ.ย.", "ก.ค.", "ส.ค.", "ก.ย.", "ต.ค.", "พ.ย.", "ธ.ค."],
                    dddd: ["อาทิตย์", "จันทร์", "อังคาร", "พุธ", "พฤหัสบดี", "ศุกร์", "เสาร์"],
                    ddd: ["อาทิตย์", "จันทร์", "อังคาร", "พุธ", "พฤหัส", "ศุกร์", "เสาร์"],
                    dd: ["อา.", "จ.", "อ.", "พ.", "พฤ.", "ศ.", "ส."],
                    A: ["ก่อนเที่ยง", "หลังเที่ยง"]
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("tr", {
                    MMMM: ["Ocak", "Şubat", "Mart", "Nisan", "Mayıs", "Haziran", "Temmuz", "Ağustos", "Eylül", "Ekim", "Kasım", "Aralık"],
                    MMM: ["Oca", "Şub", "Mar", "Nis", "May", "Haz", "Tem", "Ağu", "Eyl", "Eki", "Kas", "Ara"],
                    dddd: ["Pazar", "Pazartesi", "Salı", "Çarşamba", "Perşembe", "Cuma", "Cumartesi"],
                    ddd: ["Paz", "Pts", "Sal", "Çar", "Per", "Cum", "Cts"],
                    dd: ["Pz", "Pt", "Sa", "Ça", "Pe", "Cu", "Ct"]
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("uk", {
                    MMMM: ["січня", "лютого", "березня", "квітня", "травня", "червня", "липня", "серпня", "вересня", "жовтня", "листопада", "грудня"],
                    MMM: ["січ", "лют", "бер", "квіт", "трав", "черв", "лип", "серп", "вер", "жовт", "лист", "груд"],
                    dddd: {
                        nominative: ["неділя", "понеділок", "вівторок", "середа", "четвер", "п’ятниця", "субота"],
                        accusative: ["неділю", "понеділок", "вівторок", "середу", "четвер", "п’ятницю", "суботу"],
                        genitive: ["неділі", "понеділка", "вівторка", "середи", "четверга", "п’ятниці", "суботи"]
                    },
                    ddd: ["нд", "пн", "вт", "ср", "чт", "пт", "сб"],
                    dd: ["нд", "пн", "вт", "ср", "чт", "пт", "сб"],
                    A: ["ночі", "ранку", "дня", "вечора"],
                    formatter: {
                        A: function (e) {
                            var t = e.getHours();
                            return t < 4 ? this.A[0] : t < 12 ? this.A[1] : t < 17 ? this.A[2] : this.A[3]
                        },
                        dddd: function (e, t) {
                            var n = "nominative";
                            return /(\[[ВвУу]\]) ?dddd/.test(t) ? n = "accusative" : /\[?(?:минулої|наступної)? ?\] ?dddd/.test(t) && (n = "genitive"), this.dddd[n][e.getDay()]
                        }
                    },
                    parser: {
                        h: function (e, t) {
                            return t < 2 ? e : 11 < e ? e : e + 12
                        }
                    }
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("uz", {
                    MMMM: ["январ", "феврал", "март", "апрел", "май", "июн", "июл", "август", "сентябр", "октябр", "ноябр", "декабр"],
                    MMM: ["янв", "фев", "мар", "апр", "май", "июн", "июл", "авг", "сен", "окт", "ноя", "дек"],
                    dddd: ["Якшанба", "Душанба", "Сешанба", "Чоршанба", "Пайшанба", "Жума", "Шанба"],
                    ddd: ["Якш", "Душ", "Сеш", "Чор", "Пай", "Жум", "Шан"],
                    dd: ["Як", "Ду", "Се", "Чо", "Па", "Жу", "Ша"]
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("vi", {
                    MMMM: ["tháng 1", "tháng 2", "tháng 3", "tháng 4", "tháng 5", "tháng 6", "tháng 7", "tháng 8", "tháng 9", "tháng 10", "tháng 11", "tháng 12"],
                    MMM: ["Th01", "Th02", "Th03", "Th04", "Th05", "Th06", "Th07", "Th08", "Th09", "Th10", "Th11", "Th12"],
                    dddd: ["chủ nhật", "thứ hai", "thứ ba", "thứ tư", "thứ năm", "thứ sáu", "thứ bảy"],
                    ddd: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
                    dd: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
                    A: ["sa", "ch"]
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("zh-cn", {
                    MMMM: ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"],
                    MMM: ["1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"],
                    dddd: ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"],
                    ddd: ["周日", "周一", "周二", "周三", "周四", "周五", "周六"],
                    dd: ["日", "一", "二", "三", "四", "五", "六"],
                    A: ["凌晨", "早上", "上午", "中午", "下午", "晚上"],
                    formatter: {
                        A: function (e) {
                            var t = 100 * e.getHours() + e.getMinutes();
                            return t < 600 ? this.A[0] : t < 900 ? this.A[1] : t < 1130 ? this.A[2] : t < 1230 ? this.A[3] : t < 1800 ? this.A[4] : this.A[5]
                        }
                    },
                    parser: {
                        h: function (e, t) {
                            return t < 4 ? e : 11 < e ? e : e + 12
                        }
                    }
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t, n) {
        var o, i, r;
        ! function (a) {
            "use strict";
            var s = function (e) {
                e.setLocales("zh-tw", {
                    MMMM: ["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"],
                    MMM: ["1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"],
                    dddd: ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"],
                    ddd: ["周日", "周一", "周二", "周三", "周四", "周五", "周六"],
                    dd: ["日", "一", "二", "三", "四", "五", "六"],
                    A: ["早上", "上午", "中午", "下午", "晚上"],
                    formatter: {
                        A: function (e) {
                            var t = 100 * e.getHours() + e.getMinutes();
                            return t < 900 ? this.A[0] : t < 1130 ? this.A[1] : t < 1230 ? this.A[2] : t < 1800 ? this.A[3] : this.A[4]
                        }
                    },
                    parser: {
                        h: function (e, t) {
                            return t < 3 ? e : 11 < e ? e : e + 12
                        }
                    }
                })
            };
            "object" == typeof e && "object" == typeof e.exports ? s(n(1)) : (i = [n(1)], void 0 === (r = "function" == typeof (o = s) ? o.apply(t, i) : o) || (e.exports = r))
        }()
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t) {
        e.exports = {
            typings: "../../typings.d.ts"
        }
    }, function (e, t, n) {
        "use strict";
        Object.defineProperty(t, "__esModule", {
            value: !0
        });
        var o = n(118),
            i = n(119),
            r = n(7),
            a = (n.n(r), n(1)),
            s = n.n(a),
            u = n(129),
            c = n(332),
            d = n(339),
            l = n(342),
            f = n(343),
            h = n(344),
            m = n(345),
            p = Object.assign || function (e) {
                for (var t = 1; t < arguments.length; t++) {
                    var n = arguments[t];
                    for (var o in n) Object.prototype.hasOwnProperty.call(n, o) && (e[o] = n[o])
                }
                return e
            },
            v = function () {
                function e(e, t) {
                    for (var n = 0; n < t.length; n++) {
                        var o = t[n];
                        o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, o.key, o)
                    }
                }
                return function (t, n, o) {
                    return n && e(t.prototype, n), o && e(t, o), t
                }
            }(),
            g = function (e) {
                function t(e) {
                    var n = 1 < arguments.length && void 0 !== arguments[1] ? arguments[1] : {};
                    ! function (e, t) {
                        if (!(e instanceof t)) throw new TypeError("Cannot call a class as a function")
                    }(this, t);
                    var r = function (e, t) {
                        if (!e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
                        return !t || "object" != typeof t && "function" != typeof t ? e : t
                    }(this, (t.__proto__ || Object.getPrototypeOf(t)).call(this));
                    if (r.element = i.e(e) ? document.querySelector(e) : e, !r.element) throw new Error("An invalid selector or non-DOM node has been provided.");
                    r._clickEvents = ["click", "touch"], r._supportsPassive = o.a();
                    var a = r.element.dataset ? Object.keys(r.element.dataset).filter(function (e) {
                        return Object.keys(l.a).includes(e)
                    }).reduce(function (e, t) {
                        return p({}, e, function (e, t, n) {
                            return t in e ? Object.defineProperty(e, t, {
                                value: n,
                                enumerable: !0,
                                configurable: !0,
                                writable: !0
                            }) : e[t] = n, e
                        }({}, t, r.element.dataset[t]))
                    }, {}) : {};
                    if (r.options = p({}, l.a, n, a), void 0 === r.options.type) switch (r.element.getAttribute("type")) {
                        case "date":
                            r.options.type = "date";
                            break;
                        case "time":
                            r.options.type = "time";
                            break;
                        default:
                            r.options.type = "datetime"
                    }
                    return r._id = o.b("datetimePicker"), r.onToggleDateTimePicker = r.onToggleDateTimePicker.bind(r), r.onCloseDateTimePicker = r.onCloseDateTimePicker.bind(r), r.onDocumentClickDateTimePicker = r.onDocumentClickDateTimePicker.bind(r), r.onValidateClickDateTimePicker = r.onValidateClickDateTimePicker.bind(r), r.onTodayClickDateTimePicker = r.onTodayClickDateTimePicker.bind(r), r.onClearClickDateTimePicker = r.onClearClickDateTimePicker.bind(r), r.onCancelClickDateTimePicker = r.onCancelClickDateTimePicker.bind(r), r.onSelectDateTimePicker = r.onSelectDateTimePicker.bind(r), r._init(), r
                }
                return function (e, t) {
                    if ("function" != typeof t && null !== t) throw new TypeError("Super expression must either be null or a function, not " + typeof t);
                    e.prototype = Object.create(t && t.prototype, {
                        constructor: {
                            value: e,
                            enumerable: !1,
                            writable: !0,
                            configurable: !0
                        }
                    }), t && (Object.setPrototypeOf ? Object.setPrototypeOf(e, t) : e.__proto__ = t)
                }(t, u.a), v(t, [{
                    key: "onSelectDateTimePicker",
                    value: function (e) {
                        this.refresh(), this.save(), "select" === e.type && this.options.closeOnSelect && "inline" !== this.options.displayMode && this.hide(), this.emit(e.type, this)
                    }
                }, {
                    key: "onDocumentClickDateTimePicker",
                    value: function (e) {
                        var t = e.target || e.srcElement;
                        !this._ui.wrapper.contains(t) && "inline" !== this.options.displayMode && this._open && this.onCloseDateTimePicker(e)
                    }
                }, {
                    key: "onToggleDateTimePicker",
                    value: function (e) {
                        this._supportsPassive || e.preventDefault(), e.stopPropagation(), this._open ? this.hide() : this.show()
                    }
                }, {
                    key: "onValidateClickDateTimePicker",
                    value: function (e) {
                        this._supportsPassive || e.preventDefault(), e.stopPropagation(), this.save(), this.emit("select", this), "inline" !== this.options.displayMode && this.onCloseDateTimePicker(e)
                    }
                }, {
                    key: "onTodayClickDateTimePicker",
                    value: function (e) {
                        this._supportsPassive || e.preventDefault(), e.stopPropagation(), this.datePicker.value(new Date), this.datePicker.refresh(), this.timePicker.value(new Date), this.timePicker.refresh(), this.save()
                    }
                }, {
                    key: "onClearClickDateTimePicker",
                    value: function (e) {
                        this._supportsPassive || e.preventDefault(), e.stopPropagation(), this.clear(), this.emit("clear", this)
                    }
                }, {
                    key: "onCancelClickDateTimePicker",
                    value: function (e) {
                        this._supportsPassive || e.preventDefault(), e.stopPropagation(), this._snapshots.length && (this.datePicker = this._snapshots[0].datePicker, this.timePicker = this._snapshots[0].timePicker), this.save(), "inline" !== this.options.displayMode && this.onCloseDateTimePicker(e)
                    }
                }, {
                    key: "onCloseDateTimePicker",
                    value: function (e) {
                        this._supportsPassive || e.preventDefault(), e.stopPropagation(), this.hide()
                    }
                }, {
                    key: "isRange",
                    value: function () {
                        return this.options.isRange
                    }
                }, {
                    key: "isOpen",
                    value: function () {
                        return this._open
                    }
                }, {
                    key: "value",
                    value: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : null;
                        if (!e) {
                            var t = "";
                            switch (this.options.type) {
                                case "date":
                                    t = this.datePicker.value();
                                    break;
                                case "time":
                                    t = this.timePicker.value();
                                    break;
                                case "datetime":
                                    var n = this.datePicker.start ? r.getTime(r.addMinutes(r.addHours(this.datePicker.start, r.getHours(this.timePicker.start)), r.getMinutes(this.timePicker.start))) : void 0,
                                        o = this.datePicker.end ? r.getTime(this.datePicker.end) : void 0;
                                    o && this.options.isRange && (o = r.getTime(r.addMinutes(r.addHours(this.datePicker.end, r.getHours(this.timePicker.end)), r.getMinutes(this.timePicker.end)))), t = n ? r.format(new Date(n), this.format, {
                                        locale: this.locale
                                    }) : "", o && (t += " - " + (o ? r.format(new Date(o), this.format, {
                                        locale: this.locale
                                    }) : ""))
                            }
                            return t
                        }
                        this.datePicker.value(e), this.timePicker.value(e)
                    }
                }, {
                    key: "refresh",
                    value: function () {
                        this._ui.header.start.day.innerHTML = this.datePicker.start ? r.format(this.datePicker.start, "DD", {
                            locale: this.locale
                        }) : "--", this._ui.header.start.month.innerHTML = this.datePicker.start ? r.format(this.datePicker.start, "MMMM YYYY", {
                            locale: this.locale
                        }) : "", this.datePicker.start ? (this._ui.header.start.weekday.classList.remove("is-hidden"), this._ui.header.start.weekday.innerHTML = this.datePicker.start ? r.format(this.datePicker.start, "dddd", {
                            locale: this.locale
                        }) : "") : this._ui.header.start.weekday.classList.add("is-hidden"), this._ui.header.start.hour && (this._ui.header.start.hour.innerHTML = this.timePicker.start ? r.format(this.timePicker.start, "HH:mm", {
                            locale: this.locale
                        }) : "--:--"), this._ui.header.end && (this._ui.header.end.day.innerHTML = this.options.isRange && this.datePicker.end ? r.format(this.datePicker.end, "DD", {
                            locale: this.locale
                        }) : "--", this._ui.header.end.month.innerHTML = this.options.isRange && this.datePicker.end ? r.format(this.datePicker.end, "MMMM YYYY", {
                            locale: this.locale
                        }) : "", this.datePicker.end ? (this._ui.header.end.weekday.classList.remove("is-hidden"), this._ui.header.end.weekday.innerHTML = this.datePicker.end ? r.format(this.datePicker.end, "dddd", {
                            locale: this.locale
                        }) : "") : this._ui.header.end.weekday.classList.add("is-hidden"), this._ui.header.end && this._ui.header.end.hour && (this._ui.header.end.hour.innerHTML = this.timePicker.end ? r.format(this.timePicker.end, "HH:mm", {
                            locale: this.locale
                        }) : "--:--")), this.emit("refresh", this)
                    }
                }, {
                    key: "clear",
                    value: function () {
                        this.datePicker.clear(), this.timePicker.clear(), this.refresh(), this.element.value = "", this._ui.dummy.dummy_1.value = "", this._ui.dummy.dummy_2 && (this._ui.dummy.dummy_2.value = ""), this.emit("clear", this)
                    }
                }, {
                    key: "show",
                    value: function () {
                        this._snapshots = [], this.snapshot(), this.element.value && (this.datePicker.value(this.element.value), this.timePicker.value(this.element.value)), this.datePicker.show(), this.timePicker.hide(), this._ui.modal && this._ui.modal.classList.add("is-active"), this._ui.wrapper.classList.add("is-active"), this._open = !0, this.emit("show", this)
                    }
                }, {
                    key: "hide",
                    value: function () {
                        this._open = !1, this._focus = !1, this._ui.modal && this._ui.modal.classList.remove("is-active"), this._ui.wrapper.classList.remove("is-active"), this.emit("hide", this)
                    }
                }, {
                    key: "save",
                    value: function () {
                        var e = this.value(),
                            t = function (e, t) {
                                if (Array.isArray(e)) return e;
                                if (Symbol.iterator in Object(e)) return function (e, t) {
                                    var n = [],
                                        o = !0,
                                        i = !1,
                                        r = void 0;
                                    try {
                                        for (var a, s = e[Symbol.iterator](); !(o = (a = s.next()).done) && (n.push(a.value), !t || n.length !== t); o = !0);
                                    } catch (e) {
                                        i = !0, r = e
                                    } finally {
                                        try {
                                            !o && s.return && s.return()
                                        } finally {
                                            if (i) throw r
                                        }
                                    }
                                    return n
                                }(e, t);
                                throw new TypeError("Invalid attempt to destructure non-iterable instance")
                            }(e.split(" - "), 2),
                            n = t[0],
                            o = t[1];
                        this.element.value = e, this._ui.dummy.dummy_1.value = n || "", this._ui.dummy.dummy_2 && (this._ui.dummy.dummy_2.value = o || "")
                    }
                }, {
                    key: "snapshot",
                    value: function () {}
                }, {
                    key: "destroy",
                    value: function () {
                        this._ui.wrapper.remove()
                    }
                }, {
                    key: "_init",
                    value: function () {
                        this._open = !1, this._snapshots = [], this._type = -1 < ["date", "time", "datetime"].indexOf(this.options.type.toLowerCase()) ? this.options.type.toLowerCase() : "date", this.element.setAttribute("type", "text"), this.datePicker = new c.a(p({}, this.options, {
                            lang: this.lang
                        })), this.timePicker = new d.a(p({}, this.options, {
                            lang: this.lang
                        })), this.element.value && (this.datePicker.value(this.element.value), this.timePicker.value(this.element.value)), this.lang = this.options.lang, this.format = "date" === this._type ? this.options.dateFormat : "time" === this._type ? this.options.timeFormat : this.options.dateFormat + " " + this.options.timeFormat, "default" === this.options.displayMode && window.matchMedia("screen and (max-width: 768px)").matches && (this.options.displayMode = "dialog"), window.matchMedia("screen and (max-width: 768px)").matches && ("default" === this.options.displayMode && (this.options.displayMode = "dialog"), this.options.displayDual = !1), this._build(), this._bindEvents(), this.save(), i.c(this.options.onReady) && this.on("ready", this.options.onReady), this.emit("ready", this)
                    }
                }, {
                    key: "_build",
                    value: function () {
                        var e = document.createRange().createContextualFragment(Object(h.a)(p({}, this.options, {
                                type: this._type,
                                datePicker: "time" !== this.options.type,
                                timePicker: "date" !== this.options.type
                            }))),
                            t = document.createRange().createContextualFragment(Object(m.a)(this.options)),
                            n = document.createRange().createContextualFragment(Object(f.a)(p({}, this.options, {
                                id: this.id
                            })));
                        switch (this._ui = {
                            modal: n.querySelector(".modal"),
                            wrapper: n.querySelector(".datetimepicker"),
                            container: n.querySelector(".datetimepicker-container"),
                            dummy: {
                                container: n.querySelector(".datetimepicker-dummy"),
                                wrapper: n.querySelector(".datetimepicker-dummy-wrapper"),
                                dummy_1: n.querySelector(".datetimepicker-dummy .datetimepicker-dummy-input:nth-child(1)"),
                                dummy_2: n.querySelector(".datetimepicker-dummy .datetimepicker-dummy-input:nth-child(2)"),
                                clear: n.querySelector(".datetimepicker-dummy .datetimepicker-clear-button")
                            },
                            calendar: n.querySelector(".datetimepicker"),
                            overlay: "dialog" === this.options.displayMode ? {
                                background: n.querySelector(".modal-background"),
                                close: n.querySelector(".modal-close")
                            } : void 0,
                            header: {
                                container: e.querySelector(".datetimepicker-header"),
                                start: {
                                    container: e.querySelector(".datetimepicker-selection-start"),
                                    day: e.querySelector(".datetimepicker-selection-start .datetimepicker-selection-day"),
                                    month: e.querySelector(".datetimepicker-selection-start .datetimepicker-selection-month"),
                                    weekday: e.querySelector(".datetimepicker-selection-start .datetimepicker-selection-weekday"),
                                    hour: e.querySelector(".datetimepicker-selection-start .datetimepicker-selection-hour"),
                                    empty: e.querySelector(".datetimepicker-selection-start .empty")
                                },
                                end: this.options.isRange ? {
                                    container: e.querySelector(".datetimepicker-selection-end"),
                                    day: e.querySelector(".datetimepicker-selection-end .datetimepicker-selection-day"),
                                    month: e.querySelector(".datetimepicker-selection-end .datetimepicker-selection-month"),
                                    weekday: e.querySelector(".datetimepicker-selection-end .datetimepicker-selection-weekday"),
                                    hour: e.querySelector(".datetimepicker-selection-end .datetimepicker-selection-hour"),
                                    empty: e.querySelector(".datetimepicker-selection-start .empty")
                                } : void 0
                            },
                            footer: {
                                container: t.querySelector(".datetimepicker-footer"),
                                validate: t.querySelector(".datetimepicker-footer-validate"),
                                today: t.querySelector(".datetimepicker-footer-today"),
                                clear: t.querySelector(".datetimepicker-footer-clear"),
                                cancel: t.querySelector(".datetimepicker-footer-cancel")
                            }
                        }, i.a(this.options.showHeader) || this._ui.header.container.classList.add("is-hidden"), i.a(this.options.showFooter) || this._ui.footer.container.classList.add("is-hidden"), i.a(this.options.showTodayButton) || this._ui.footer.today.classList.add("is-hidden"), i.a(this.options.showClearButton) || this._ui.footer.clear.classList.add("is-hidden"), this.options.closeOnSelect && this._ui.footer.validate && this._ui.footer.validate.classList.add("is-hidden"), this._ui.container.appendChild(e), this._type) {
                            case "date":
                                this._ui.container.appendChild(this.datePicker.render());
                                break;
                            case "time":
                                this._ui.container.appendChild(this.timePicker.render()), this._ui.footer.validate && this._ui.footer.validate.classList.remove("is-hidden"), this._ui.footer.today && this._ui.footer.today.classList.add("is-hidden");
                                break;
                            case "datetime":
                                this.options.closeOnSelect = !1, this._ui.footer.validate && this._ui.footer.validate.classList.remove("is-hidden"), this._ui.container.appendChild(this.datePicker.render()), this._ui.container.appendChild(this.timePicker.render())
                        }
                        this._ui.wrapper.appendChild(t), this._ui.wrapper.classList.add("is-" + this.options.color), this._ui.dummy.container.classList.add("is-" + this.options.color), this.element.parentNode.insertBefore(n, this.element.nextSibling), this._ui.dummy.wrapper.appendChild(this.element), this.element.classList.add("is-hidden"), "inline" === this.options.displayMode ? this._ui.wrapper.classList.add("is-active") : (this._ui.dummy.container.classList.remove("is-hidden"), this._ui.wrapper.style.position = "absolute", this._ui.wrapper.classList.add("is-datetimepicker-default")), this.refresh()
                    }
                }, {
                    key: "_bindEvents",
                    value: function () {
                        var e = this;
                        this._clickEvents.forEach(function (t) {
                            document.body.addEventListener(t, e.onDocumentClickDateTimePicker)
                        }), this.datePicker.on("select", this.onSelectDateTimePicker), this.datePicker.on("select:start", this.onSelectDateTimePicker), this.datePicker.on("select:end", this.onSelectDateTimePicker), this.timePicker.on("select", this.onSelectDateTimePicker), this.timePicker.on("select:start", this.onSelectDateTimePicker), this.timePicker.on("select:end", this.onSelectDateTimePicker), !0 === this.options.toggleOnInputClick && this._clickEvents.forEach(function (t) {
                            e._ui.dummy.wrapper.addEventListener(t, e.onToggleDateTimePicker), e.element.addEventListener(t, e.onToggleDateTimePicker)
                        }), "dialog" === this.options.displayMode && this._ui.overlay && (this._ui.overlay.close && this._clickEvents.forEach(function (t) {
                            e.this._ui.overlay.close.addEventListener(t, e.onCloseDateTimePicker)
                        }), this.options.closeOnOverlayClick && this._ui.overlay.background && this._clickEvents.forEach(function (t) {
                            e._ui.overlay.background.addEventListener(t, e.onCloseDateTimePicker)
                        })), this._ui.footer.validate && this._clickEvents.forEach(function (t) {
                            e._ui.footer.validate.addEventListener(t, e.onValidateClickDateTimePicker)
                        }), this._ui.footer.today && this._clickEvents.forEach(function (t) {
                            e._ui.footer.today.addEventListener(t, e.onTodayClickDateTimePicker)
                        }), this._ui.footer.clear && this._clickEvents.forEach(function (t) {
                            e._ui.footer.clear.addEventListener(t, e.onClearClickDateTimePicker)
                        }), this._clickEvents.forEach(function (t) {
                            e._ui.dummy.clear.addEventListener(t, e.onClearClickDateTimePicker)
                        }), this._ui.footer.cancel && this._clickEvents.forEach(function (t) {
                            e._ui.footer.cancel.addEventListener(t, e.onCancelClickDateTimePicker)
                        })
                    }
                }, {
                    key: "id",
                    get: function () {
                        return this._id
                    }
                }, {
                    key: "lang",
                    set: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : "en";
                        try {
                            this._locale = n(84)("./" + e)
                        } catch (t) {
                            e = "en", this._locale = n(84)("./" + e)
                        } finally {
                            return this._lang = e, this.datePicker.lang = e, this.timePicker.lang = e, this
                        }
                    },
                    get: function () {
                        return this._lang
                    }
                }, {
                    key: "locale",
                    get: function () {
                        return this._locale
                    }
                }, {
                    key: "format",
                    set: function (e) {
                        return this._format = e, this
                    },
                    get: function () {
                        return this._format
                    }
                }, {
                    key: "date",
                    set: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : null;
                        return this.datePicker.date = e, this
                    },
                    get: function () {
                        return this.datePicker.date
                    }
                }, {
                    key: "startDate",
                    set: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : void 0;
                        return this.datePicker.start = s.a.parse(e, this.dateFormat), this
                    },
                    get: function () {
                        return this.datePicker.start
                    }
                }, {
                    key: "endDate",
                    set: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : void 0;
                        return this.datePicker.end = s.a.parse(e, this.dateFormat), this
                    },
                    get: function () {
                        return this.datePicker.end
                    }
                }, {
                    key: "minDate",
                    set: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : void 0;
                        return this.datePicker.minDate = s.a.parse(e, this.dateFormat), this
                    },
                    get: function () {
                        return this.datePicker.minDate
                    }
                }, {
                    key: "maxDate",
                    set: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : void 0;
                        return this.datePicker.maxDate = s.a.parse(e, this.dateFormat), this
                    },
                    get: function () {
                        return this.datePicker.maxDate
                    }
                }, {
                    key: "dateFormat",
                    set: function (e) {
                        return this.datePicker.dateFormat = e, this
                    },
                    get: function () {
                        return this.datePicker.dateFormat
                    }
                }, {
                    key: "time",
                    set: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : null;
                        return this.timePicker.time = e, this
                    },
                    get: function () {
                        return this.timePicker.time
                    }
                }, {
                    key: "startTime",
                    set: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : void 0;
                        return this.timePicker.start = e, this
                    },
                    get: function () {
                        return this.timePicker.start
                    }
                }, {
                    key: "endTime",
                    set: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : void 0;
                        return this.timePicker.end = e, this
                    },
                    get: function () {
                        return this.timePicker.end
                    }
                }, {
                    key: "minTime",
                    set: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : void 0;
                        return this.timePicker.minTime = e, this
                    },
                    get: function () {
                        return this.timePicker.minTime
                    }
                }, {
                    key: "maxTime",
                    set: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : void 0;
                        return this.timePicker.maxTime = e, this
                    },
                    get: function () {
                        return this.timePicker.maxTime
                    }
                }, {
                    key: "timeFormat",
                    set: function (e) {
                        return this.timePicker.dateFormat = e, this
                    },
                    get: function () {
                        return this.timePicker.timeFormat
                    }
                }], [{
                    key: "attach",
                    value: function () {
                        var e = this,
                            n = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : 'input[type="date"]',
                            o = 1 < arguments.length && void 0 !== arguments[1] ? arguments[1] : {},
                            r = new Array,
                            a = i.e(n) ? document.querySelectorAll(n) : Array.isArray(n) ? n : [n];
                        return [].forEach.call(a, function (n) {
                            if (void 0 === n[e.constructor.name]) {
                                var i = new t(n, o);
                                n.bulmaCalendar = i, r.push(i)
                            } else r.push(n[e.constructor.name])
                        }), r
                    }
                }]), t
            }();
        t.default = g
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t, n, i) {
            var r = o(e).getTime(),
                a = o(t).getTime(),
                s = o(n).getTime(),
                u = o(i).getTime();
            if (a < r || u < s) throw new Error("The start of the range cannot be after the end of the range");
            return r < u && s < a
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            if (!(t instanceof Array)) throw new TypeError(toString.call(t) + " is not an instance of Array");
            var n, i, r = o(e).getTime();
            return t.forEach(function (e, t) {
                var a = o(e),
                    s = Math.abs(r - a.getTime());
                (void 0 === n || s < i) && (n = t, i = s)
            }), n
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            if (!(t instanceof Array)) throw new TypeError(toString.call(t) + " is not an instance of Array");
            var n, i, r = o(e).getTime();
            return t.forEach(function (e) {
                var t = o(e),
                    a = Math.abs(r - t.getTime());
                (void 0 === n || a < i) && (n = t, i = a)
            }), n
        }
    }, function (e, t, n) {
        var o = n(4);
        e.exports = function (e, t) {
            var n = o(e),
                i = o(t),
                r = n.getTime() - 6e4 * n.getTimezoneOffset(),
                a = i.getTime() - 6e4 * i.getTimezoneOffset();
            return Math.round((r - a) / 6048e5)
        }
    }, function (e, t, n) {
        var o = n(139),
            i = n(0);
        e.exports = function (e, t) {
            var n = i(e),
                r = i(t);
            return 4 * (n.getFullYear() - r.getFullYear()) + (o(n) - o(r))
        }
    }, function (e, t, n) {
        var o = n(80);
        e.exports = function (e, t, n) {
            var i = o(e, n),
                r = o(t, n),
                a = i.getTime() - 6e4 * i.getTimezoneOffset(),
                s = r.getTime() - 6e4 * r.getTimezoneOffset();
            return Math.round((a - s) / 6048e5)
        }
    }, function (e, t, n) {
        var o = n(83);
        e.exports = function (e, t) {
            var n = o(e, t) / 36e5;
            return 0 < n ? Math.floor(n) : Math.ceil(n)
        }
    }, function (e, t, n) {
        var o = n(0),
            i = n(137),
            r = n(11),
            a = n(142);
        e.exports = function (e, t) {
            var n = o(e),
                s = o(t),
                u = r(n, s),
                c = Math.abs(i(n, s));
            return n = a(n, u * c), u * (c - (r(n, s) === -u))
        }
    }, function (e, t, n) {
        var o = n(83);
        e.exports = function (e, t) {
            var n = o(e, t) / 6e4;
            return 0 < n ? Math.floor(n) : Math.ceil(n)
        }
    }, function (e, t, n) {
        var o = n(124);
        e.exports = function (e, t) {
            var n = o(e, t) / 3;
            return 0 < n ? Math.floor(n) : Math.ceil(n)
        }
    }, function (e, t, n) {
        var o = n(141);
        e.exports = function (e, t) {
            var n = o(e, t) / 7;
            return 0 < n ? Math.floor(n) : Math.ceil(n)
        }
    }, function (e, t, n) {
        var o = n(0),
            i = n(140),
            r = n(11);
        e.exports = function (e, t) {
            var n = o(e),
                a = o(t),
                s = r(n, a),
                u = Math.abs(i(n, a));
            return n.setFullYear(n.getFullYear() - s * u), s * (u - (r(n, a) === -s))
        }
    }, function (e, t, n) {
        var o = n(123),
            i = n(0),
            r = n(125),
            a = n(6);
        e.exports = function (e, t, n) {
            var s = n || {},
                u = o(e, t),
                c = s.locale,
                d = a.distanceInWords.localize;
            c && c.distanceInWords && c.distanceInWords.localize && (d = c.distanceInWords.localize);
            var l, f, h, m = {
                addSuffix: Boolean(s.addSuffix),
                comparison: u
            };
            f = 0 < u ? (l = i(e), i(t)) : (l = i(t), i(e));
            var p = Math[s.partialMethod ? String(s.partialMethod) : "floor"],
                v = r(f, l),
                g = f.getTimezoneOffset() - l.getTimezoneOffset(),
                _ = p(v / 60) - g;
            if ("s" === (h = s.unit ? String(s.unit) : _ < 1 ? "s" : _ < 60 ? "m" : _ < 1440 ? "h" : _ < 43200 ? "d" : _ < 525600 ? "M" : "Y")) return d("xSeconds", v, m);
            if ("m" === h) return d("xMinutes", _, m);
            if ("h" === h) return d("xHours", p(_ / 60), m);
            if ("d" === h) return d("xDays", p(_ / 1440), m);
            if ("M" === h) return d("xMonths", p(_ / 43200), m);
            if ("Y" === h) return d("xYears", p(_ / 525600), m);
            throw new Error("Unknown unit: " + h)
        }
    }, function (e, t, n) {
        var o = n(143);
        e.exports = function (e, t) {
            return o(Date.now(), e, t)
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t, n) {
            var i = o(e),
                r = void 0 !== n ? n : 1,
                a = o(t).getTime();
            if (i.getTime() > a) throw new Error("The first date cannot be after the second date");
            var s = [],
                u = i;
            for (u.setHours(0, 0, 0, 0); u.getTime() <= a;) s.push(o(u)), u.setDate(u.getDate() + r);
            return s
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e);
            return t.setMinutes(59, 59, 999), t
        }
    }, function (e, t, n) {
        var o = n(144);
        e.exports = function (e) {
            return o(e, {
                weekStartsOn: 1
            })
        }
    }, function (e, t, n) {
        var o = n(3),
            i = n(4);
        e.exports = function (e) {
            var t = o(e),
                n = new Date(0);
            n.setFullYear(t + 1, 0, 4), n.setHours(0, 0, 0, 0);
            var r = i(n);
            return r.setMilliseconds(r.getMilliseconds() - 1), r
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e);
            return t.setSeconds(59, 999), t
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e),
                n = t.getMonth(),
                i = n - n % 3 + 3;
            return t.setMonth(i, 0), t.setHours(23, 59, 59, 999), t
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e);
            return t.setMilliseconds(999), t
        }
    }, function (e, t, n) {
        var o = n(126);
        e.exports = function () {
            return o(new Date)
        }
    }, function (e, t) {
        e.exports = function () {
            var e = new Date,
                t = e.getFullYear(),
                n = e.getMonth(),
                o = e.getDate(),
                i = new Date(0);
            return i.setFullYear(t, n, o + 1), i.setHours(23, 59, 59, 999), i
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e),
                n = t.getFullYear();
            return t.setFullYear(n + 1, 0, 0), t.setHours(23, 59, 59, 999), t
        }
    }, function (e, t) {
        e.exports = function () {
            var e = new Date,
                t = e.getFullYear(),
                n = e.getMonth(),
                o = e.getDate(),
                i = new Date(0);
            return i.setFullYear(t, n, o - 1), i.setHours(23, 59, 59, 999), i
        }
    }, function (e, t, n) {
        var o = n(146),
            i = n(127),
            r = n(3),
            a = n(0),
            s = n(148),
            u = n(6),
            c = {
                M: function (e) {
                    return e.getMonth() + 1
                },
                MM: function (e) {
                    return l(e.getMonth() + 1, 2)
                },
                Q: function (e) {
                    return Math.ceil((e.getMonth() + 1) / 3)
                },
                D: function (e) {
                    return e.getDate()
                },
                DD: function (e) {
                    return l(e.getDate(), 2)
                },
                DDD: function (e) {
                    return o(e)
                },
                DDDD: function (e) {
                    return l(o(e), 3)
                },
                d: function (e) {
                    return e.getDay()
                },
                E: function (e) {
                    return e.getDay() || 7
                },
                W: function (e) {
                    return i(e)
                },
                WW: function (e) {
                    return l(i(e), 2)
                },
                YY: function (e) {
                    return l(e.getFullYear(), 4).substr(2)
                },
                YYYY: function (e) {
                    return l(e.getFullYear(), 4)
                },
                GG: function (e) {
                    return String(r(e)).substr(2)
                },
                GGGG: function (e) {
                    return r(e)
                },
                H: function (e) {
                    return e.getHours()
                },
                HH: function (e) {
                    return l(e.getHours(), 2)
                },
                h: function (e) {
                    var t = e.getHours();
                    return 0 === t ? 12 : 12 < t ? t % 12 : t
                },
                hh: function (e) {
                    return l(c.h(e), 2)
                },
                m: function (e) {
                    return e.getMinutes()
                },
                mm: function (e) {
                    return l(e.getMinutes(), 2)
                },
                s: function (e) {
                    return e.getSeconds()
                },
                ss: function (e) {
                    return l(e.getSeconds(), 2)
                },
                S: function (e) {
                    return Math.floor(e.getMilliseconds() / 100)
                },
                SS: function (e) {
                    return l(Math.floor(e.getMilliseconds() / 10), 2)
                },
                SSS: function (e) {
                    return l(e.getMilliseconds(), 3)
                },
                Z: function (e) {
                    return d(e.getTimezoneOffset(), ":")
                },
                ZZ: function (e) {
                    return d(e.getTimezoneOffset())
                },
                X: function (e) {
                    return Math.floor(e.getTime() / 1e3)
                },
                x: function (e) {
                    return e.getTime()
                }
            };

        function d(e, t) {
            t = t || "";
            var n = 0 < e ? "-" : "+",
                o = Math.abs(e),
                i = o % 60;
            return n + l(Math.floor(o / 60), 2) + t + l(i, 2)
        }

        function l(e, t) {
            for (var n = Math.abs(e).toString(); n.length < t;) n = "0" + n;
            return n
        }
        e.exports = function (e, t, n) {
            var o = t ? String(t) : "YYYY-MM-DDTHH:mm:ss.SSSZ",
                i = (n || {}).locale,
                r = u.format.formatters,
                d = u.format.formattingTokensRegExp;
            i && i.format && i.format.formatters && (r = i.format.formatters, i.format.formattingTokensRegExp && (d = i.format.formattingTokensRegExp));
            var l = a(e);
            return s(l) ? function (e, t, n) {
                var o, i, r, a = e.match(n),
                    s = a.length;
                for (o = 0; o < s; o++) i = t[a[o]] || c[a[o]], a[o] = i || ((r = a[o]).match(/\[[\s\S]/) ? r.replace(/^\[|]$/g, "") : r.replace(/\\/g, ""));
                return function (e) {
                    for (var t = "", n = 0; n < s; n++) a[n] instanceof Function ? t += a[n](e, c) : t += a[n];
                    return t
                }
            }(o, r, d)(l) : "Invalid Date"
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            return o(e).getDate()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            return o(e).getDay()
        }
    }, function (e, t, n) {
        var o = n(149);
        e.exports = function (e) {
            return o(e) ? 366 : 365
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            return o(e).getHours()
        }
    }, function (e, t, n) {
        var o = n(10),
            i = n(122);
        e.exports = function (e) {
            var t = o(e),
                n = o(i(t, 60)).valueOf() - t.valueOf();
            return Math.round(n / 6048e5)
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            return o(e).getMilliseconds()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            return o(e).getMinutes()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            return o(e).getMonth()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t, n, i) {
            var r = o(e).getTime(),
                a = o(t).getTime(),
                s = o(n).getTime(),
                u = o(i).getTime();
            if (a < r || u < s) throw new Error("The start of the range cannot be after the end of the range");
            if (!(r < u && s < a)) return 0;
            var c = (a < u ? a : u) - (s < r ? r : s);
            return Math.ceil(c / 864e5)
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            return o(e).getSeconds()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            return o(e).getTime()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            return o(e).getFullYear()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = o(e),
                i = o(t);
            return n.getTime() > i.getTime()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = o(e),
                i = o(t);
            return n.getTime() < i.getTime()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = o(e),
                i = o(t);
            return n.getTime() === i.getTime()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            return 1 === o(e).getDate()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            return 5 === o(e).getDay()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            return o(e).getTime() > (new Date).getTime()
        }
    }, function (e, t, n) {
        var o = n(0),
            i = n(126),
            r = n(145);
        e.exports = function (e) {
            var t = o(e);
            return i(t).getTime() === r(t).getTime()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            return 1 === o(e).getDay()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            return o(e).getTime() < (new Date).getTime()
        }
    }, function (e, t, n) {
        var o = n(5);
        e.exports = function (e, t) {
            var n = o(e),
                i = o(t);
            return n.getTime() === i.getTime()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            return 6 === o(e).getDay()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            return 0 === o(e).getDay()
        }
    }, function (e, t, n) {
        var o = n(151);
        e.exports = function (e) {
            return o(new Date, e)
        }
    }, function (e, t, n) {
        var o = n(153);
        e.exports = function (e) {
            return o(new Date, e)
        }
    }, function (e, t, n) {
        var o = n(154);
        e.exports = function (e) {
            return o(new Date, e)
        }
    }, function (e, t, n) {
        var o = n(155);
        e.exports = function (e) {
            return o(new Date, e)
        }
    }, function (e, t, n) {
        var o = n(157);
        e.exports = function (e) {
            return o(new Date, e)
        }
    }, function (e, t, n) {
        var o = n(158);
        e.exports = function (e) {
            return o(new Date, e)
        }
    }, function (e, t, n) {
        var o = n(160);
        e.exports = function (e) {
            return o(new Date, e)
        }
    }, function (e, t, n) {
        var o = n(128);
        e.exports = function (e, t) {
            return o(new Date, e, t)
        }
    }, function (e, t, n) {
        var o = n(162);
        e.exports = function (e) {
            return o(new Date, e)
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            return 4 === o(e).getDay()
        }
    }, function (e, t, n) {
        var o = n(5);
        e.exports = function (e) {
            return o(e).getTime() === o(new Date).getTime()
        }
    }, function (e, t, n) {
        var o = n(5);
        e.exports = function (e) {
            var t = new Date;
            return t.setDate(t.getDate() + 1), o(e).getTime() === o(t).getTime()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            return 2 === o(e).getDay()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            return 3 === o(e).getDay()
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e).getDay();
            return 0 === t || 6 === t
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t, n) {
            var i = o(e).getTime(),
                r = o(t).getTime(),
                a = o(n).getTime();
            if (a < r) throw new Error("The start of the range cannot be after the end of the range");
            return r <= i && i <= a
        }
    }, function (e, t, n) {
        var o = n(5);
        e.exports = function (e) {
            var t = new Date;
            return t.setDate(t.getDate() - 1), o(e).getTime() === o(t).getTime()
        }
    }, function (e, t, n) {
        var o = n(163);
        e.exports = function (e) {
            return o(e, {
                weekStartsOn: 1
            })
        }
    }, function (e, t, n) {
        var o = n(3),
            i = n(4);
        e.exports = function (e) {
            var t = o(e),
                n = new Date(0);
            n.setFullYear(t + 1, 0, 4), n.setHours(0, 0, 0, 0);
            var r = i(n);
            return r.setDate(r.getDate() - 1), r
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e),
                n = t.getMonth();
            return t.setFullYear(t.getFullYear(), n + 1, 0), t.setHours(0, 0, 0, 0), t
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e),
                n = t.getMonth(),
                i = n - n % 3 + 3;
            return t.setMonth(i, 0), t.setHours(0, 0, 0, 0), t
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e),
                n = t.getFullYear();
            return t.setFullYear(n + 1, 0, 0), t.setHours(0, 0, 0, 0), t
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function () {
            var e = Array.prototype.slice.call(arguments).map(function (e) {
                    return o(e)
                }),
                t = Math.max.apply(null, e);
            return new Date(t)
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function () {
            var e = Array.prototype.slice.call(arguments).map(function (e) {
                    return o(e)
                }),
                t = Math.min.apply(null, e);
            return new Date(t)
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = o(e),
                i = Number(t);
            return n.setDate(i), n
        }
    }, function (e, t, n) {
        var o = n(0),
            i = n(8);
        e.exports = function (e, t, n) {
            var r = n && Number(n.weekStartsOn) || 0,
                a = o(e),
                s = Number(t),
                u = a.getDay();
            return i(a, ((s % 7 + 7) % 7 < r ? 7 : 0) + s - u)
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = o(e),
                i = Number(t);
            return n.setMonth(0), n.setDate(i), n
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = o(e),
                i = Number(t);
            return n.setHours(i), n
        }
    }, function (e, t, n) {
        var o = n(0),
            i = n(8),
            r = n(150);
        e.exports = function (e, t) {
            var n = o(e),
                a = Number(t),
                s = r(n);
            return i(n, a - s)
        }
    }, function (e, t, n) {
        var o = n(0),
            i = n(127);
        e.exports = function (e, t) {
            var n = o(e),
                r = Number(t),
                a = i(n) - r;
            return n.setDate(n.getDate() - 7 * a), n
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = o(e),
                i = Number(t);
            return n.setMilliseconds(i), n
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = o(e),
                i = Number(t);
            return n.setMinutes(i), n
        }
    }, function (e, t, n) {
        var o = n(0),
            i = n(164);
        e.exports = function (e, t) {
            var n = o(e),
                r = Number(t) - (Math.floor(n.getMonth() / 3) + 1);
            return i(n, n.getMonth() + 3 * r)
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = o(e),
                i = Number(t);
            return n.setSeconds(i), n
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e, t) {
            var n = o(e),
                i = Number(t);
            return n.setFullYear(i), n
        }
    }, function (e, t, n) {
        var o = n(0);
        e.exports = function (e) {
            var t = o(e);
            return t.setDate(1), t.setHours(0, 0, 0, 0), t
        }
    }, function (e, t, n) {
        var o = n(5);
        e.exports = function () {
            return o(new Date)
        }
    }, function (e, t) {
        e.exports = function () {
            var e = new Date,
                t = e.getFullYear(),
                n = e.getMonth(),
                o = e.getDate(),
                i = new Date(0);
            return i.setFullYear(t, n, o + 1), i.setHours(0, 0, 0, 0), i
        }
    }, function (e, t) {
        e.exports = function () {
            var e = new Date,
                t = e.getFullYear(),
                n = e.getMonth(),
                o = e.getDate(),
                i = new Date(0);
            return i.setFullYear(t, n, o - 1), i.setHours(0, 0, 0, 0), i
        }
    }, function (e, t, n) {
        var o = n(8);
        e.exports = function (e, t) {
            var n = Number(t);
            return o(e, -n)
        }
    }, function (e, t, n) {
        var o = n(130);
        e.exports = function (e, t) {
            var n = Number(t);
            return o(e, -n)
        }
    }, function (e, t, n) {
        var o = n(9);
        e.exports = function (e, t) {
            var n = Number(t);
            return o(e, -n)
        }
    }, function (e, t, n) {
        var o = n(133);
        e.exports = function (e, t) {
            var n = Number(t);
            return o(e, -n)
        }
    }, function (e, t, n) {
        var o = n(82);
        e.exports = function (e, t) {
            var n = Number(t);
            return o(e, -n)
        }
    }, function (e, t, n) {
        var o = n(134);
        e.exports = function (e, t) {
            var n = Number(t);
            return o(e, -n)
        }
    }, function (e, t, n) {
        var o = n(135);
        e.exports = function (e, t) {
            var n = Number(t);
            return o(e, -n)
        }
    }, function (e, t, n) {
        var o = n(122);
        e.exports = function (e, t) {
            var n = Number(t);
            return o(e, -n)
        }
    }, function (e, t, n) {
        var o = n(136);
        e.exports = function (e, t) {
            var n = Number(t);
            return o(e, -n)
        }
    }, function (e, t, n) {
        var o = {
            "./ar": 165,
            "./ar.js": 165,
            "./az": 166,
            "./az.js": 166,
            "./bn": 167,
            "./bn.js": 167,
            "./cs": 168,
            "./cs.js": 168,
            "./de": 169,
            "./de.js": 169,
            "./el": 170,
            "./el.js": 170,
            "./es": 171,
            "./es.js": 171,
            "./fa": 172,
            "./fa.js": 172,
            "./fr": 173,
            "./fr.js": 173,
            "./hi": 174,
            "./hi.js": 174,
            "./hu": 175,
            "./hu.js": 175,
            "./id": 176,
            "./id.js": 176,
            "./it": 177,
            "./it.js": 177,
            "./ja": 178,
            "./ja.js": 178,
            "./jv": 179,
            "./jv.js": 179,
            "./ko": 180,
            "./ko.js": 180,
            "./my": 181,
            "./my.js": 181,
            "./nl": 182,
            "./nl.js": 182,
            "./pa-in": 183,
            "./pa-in.js": 183,
            "./pl": 184,
            "./pl.js": 184,
            "./pt": 185,
            "./pt.js": 185,
            "./ro": 186,
            "./ro.js": 186,
            "./ru": 187,
            "./ru.js": 187,
            "./sr": 188,
            "./sr.js": 188,
            "./th": 189,
            "./th.js": 189,
            "./tr": 190,
            "./tr.js": 190,
            "./uk": 191,
            "./uk.js": 191,
            "./uz": 192,
            "./uz.js": 192,
            "./vi": 193,
            "./vi.js": 193,
            "./zh-cn": 194,
            "./zh-cn.js": 194,
            "./zh-tw": 195,
            "./zh-tw.js": 195
        };

        function i(e) {
            return n(r(e))
        }

        function r(e) {
            var t = o[e];
            if (!(t + 1)) throw new Error("Cannot find module '" + e + "'.");
            return t
        }
        i.keys = function () {
            return Object.keys(o)
        }, i.resolve = r, (e.exports = i).id = 331
    }, function (e, t, n) {
        "use strict";
        var o = n(118),
            i = n(119),
            r = n(7),
            a = (n.n(r), n(129)),
            s = n(333),
            u = n(334),
            c = n(335),
            d = n(336),
            l = n(337),
            f = n(338),
            h = Object.assign || function (e) {
                for (var t = 1; t < arguments.length; t++) {
                    var n = arguments[t];
                    for (var o in n) Object.prototype.hasOwnProperty.call(n, o) && (e[o] = n[o])
                }
                return e
            },
            m = function () {
                function e(e, t) {
                    for (var n = 0; n < t.length; n++) {
                        var o = t[n];
                        o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, o.key, o)
                    }
                }
                return function (t, n, o) {
                    return n && e(t.prototype, n), o && e(t, o), t
                }
            }(),
            p = function (e) {
                function t() {
                    var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : {};
                    ! function (e, t) {
                        if (!(e instanceof t)) throw new TypeError("Cannot call a class as a function")
                    }(this, t);
                    var n = function (e, t) {
                        if (!e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
                        return !t || "object" != typeof t && "function" != typeof t ? e : t
                    }(this, (t.__proto__ || Object.getPrototypeOf(t)).call(this));
                    return n.options = h({}, f.a, e), n._clickEvents = ["click", "touch"], n._supportsPassive = o.a(), n._id = o.b("datePicker"), n.node = null, n.onPreviousDatePicker = n.onPreviousDatePicker.bind(n), n.onNextDatePicker = n.onNextDatePicker.bind(n), n.onSelectMonthDatePicker = n.onSelectMonthDatePicker.bind(n), n.onMonthClickDatePicker = n.onMonthClickDatePicker.bind(n), n.onSelectYearDatePicker = n.onSelectYearDatePicker.bind(n), n.onYearClickDatePicker = n.onYearClickDatePicker.bind(n), n.onDateClickDatePicker = n.onDateClickDatePicker.bind(n), n._init(), n
                }
                return function (e, t) {
                    if ("function" != typeof t && null !== t) throw new TypeError("Super expression must either be null or a function, not " + typeof t);
                    e.prototype = Object.create(t && t.prototype, {
                        constructor: {
                            value: e,
                            enumerable: !1,
                            writable: !0,
                            configurable: !0
                        }
                    }), t && (Object.setPrototypeOf ? Object.setPrototypeOf(e, t) : e.__proto__ = t)
                }(t, a.a), m(t, [{
                    key: "onPreviousDatePicker",
                    value: function (e) {
                        this._supportsPassive || e.preventDefault(), e.stopPropagation();
                        var t = r.lastDayOfMonth(r.subMonths(new Date(r.getYear(this._visibleDate), r.getMonth(this._visibleDate)), 1)),
                            n = Math.min(r.getDaysInMonth(t), r.getDate(this._visibleDate));
                        this._visibleDate = this.min ? r.max(r.setDate(t, n), this.min) : r.setDate(t, n), this.refresh()
                    }
                }, {
                    key: "onNextDatePicker",
                    value: function (e) {
                        this._supportsPassive || e.preventDefault(), e.stopPropagation();
                        var t = r.addMonths(this._visibleDate, 1),
                            n = Math.min(r.getDaysInMonth(t), r.getDate(this._visibleDate));
                        this._visibleDate = this.max ? r.min(r.setDate(t, n), this.max) : r.setDate(t, n), this.refresh()
                    }
                }, {
                    key: "onSelectMonthDatePicker",
                    value: function (e) {
                        e.stopPropagation(), this.options.enableMonthSwitch && (this._ui.body.dates.classList.remove("is-active"), this._ui.body.years.classList.remove("is-active"), this._ui.body.months.classList.add("is-active"), this._ui.navigation.previous.setAttribute("disabled", "disabled"), this._ui.navigation.next.setAttribute("disabled", "disabled"))
                    }
                }, {
                    key: "onSelectYearDatePicker",
                    value: function (e) {
                        if (e.stopPropagation(), this.options.enableYearSwitch) {
                            this._ui.body.dates.classList.remove("is-active"), this._ui.body.months.classList.remove("is-active"), this._ui.body.years.classList.add("is-active"), this._ui.navigation.previous.setAttribute("disabled", "disabled"), this._ui.navigation.next.setAttribute("disabled", "disabled");
                            var t = this._ui.body.years.querySelector(".calendar-year.is-active");
                            t && (this._ui.body.years.scrollTop = t.offsetTop - this._ui.body.years.offsetTop - this._ui.body.years.clientHeight / 2)
                        }
                    }
                }, {
                    key: "onMonthClickDatePicker",
                    value: function (e) {
                        this._supportsPassive || e.preventDefault(), e.stopPropagation();
                        var t = r.setMonth(this._visibleDate, parseInt(e.currentTarget.dataset.month) - 1);
                        this._visibleDate = this.min ? r.max(t, this.min) : t, this._visibleDate = this.max ? r.min(this._visibleDate, this.max) : this._visibleDate, this.refresh()
                    }
                }, {
                    key: "onYearClickDatePicker",
                    value: function (e) {
                        this._supportsPassive || e.preventDefault(), e.stopPropagation();
                        var t = r.setYear(this._visibleDate, parseInt(e.currentTarget.dataset.year));
                        this._visibleDate = this.min ? r.max(t, this.min) : t, this._visibleDate = this.max ? r.min(this._visibleDate, this.max) : this._visibleDate, this.refresh()
                    }
                }, {
                    key: "onDateClickDatePicker",
                    value: function (e) {
                        this._supportsPassive || e.preventDefault(), e.stopPropagation(), e.currentTarget.classList.contains("is-disabled") || (this._select(e.currentTarget.dataset.date), this.refresh())
                    }
                }, {
                    key: "isRange",
                    value: function () {
                        return this.options.isRange
                    }
                }, {
                    key: "enableDate",
                    value: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : void 0,
                            t = this.disabledDates.findIndex(function (t) {
                                return r.isEqual(t, e)
                            }); - 1 < t && unset(this.disabledDates[t])
                    }
                }, {
                    key: "disableDate",
                    value: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : void 0; - 1 < this.disabledDates.findIndex(function (t) {
                            return r.isEqual(t, e)
                        }) && this.disabledDates.push(e)
                    }
                }, {
                    key: "enableWeekDay",
                    value: function (e) {
                        var t = this.disabledWeekDays.findIndex(function (t) {
                            return r.isEqual(t, e)
                        }); - 1 < t && unset(this.disabledWeekDays[t])
                    }
                }, {
                    key: "disableWeekDay",
                    value: function (e) {
                        -1 < this.disabledWeekDays.findIndex(function (e) {
                            return r.isEqual(e, date)
                        }) && this.disabledWeekDays.push(e)
                    }
                }, {
                    key: "show",
                    value: function () {
                        this._open || (this._ui.body.dates.classList.add("is-active"), this._ui.body.months.classList.remove("is-active"), this._ui.body.years.classList.remove("is-active"), this._ui.navigation.previous.removeAttribute("disabled"), this._ui.navigation.next.removeAttribute("disabled"), this._ui.container.classList.add("is-active"), this._open = !0, this._focus = !0, this.emit("show", this))
                    }
                }, {
                    key: "hide",
                    value: function () {
                        this._open && (this._open = !1, this._focus = !1, this._ui.container.classList.remove("is-active"), this.emit("hide", this))
                    }
                }, {
                    key: "toggle",
                    value: function () {
                        this._open ? this.hide() : this.show()
                    }
                }, {
                    key: "value",
                    value: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : null;
                        if (!e) {
                            var t = this.start && this._isValidDate(this.start) ? r.format(this.start, this.format, {
                                locale: this.locale
                            }) : "";
                            return this.options.isRange && this.end && this._isValidDate(this.end) && (t += " - " + r.format(this.end, this.format, {
                                locale: this.locale
                            })), t
                        }
                        if (this.options.isRange) {
                            if (i.e(e)) {
                                var n = e.split(" - ");
                                n.length && (this.start = r.format(new Date(n[0]), this.format, {
                                    locale: this.locale
                                })), 2 === n.length && (this.end = r.format(new Date(n[1]), this.format, {
                                    locale: this.locale
                                }))
                            }(i.d(e) || i.b(e)) && this._select(e)
                        } else this._select(e)
                    }
                }, {
                    key: "refresh",
                    value: function () {
                        var e = this;
                        this._ui.body.dates.innerHTML = "";
                        var t = new Array(12).fill(r.startOfWeek(this._visibleDate)).map(function (t, n) {
                            return r.format(r.addMonths(t, n), "MM", {
                                locale: e.locale
                            })
                        });
                        this._ui.body.months.innerHTML = "", this._ui.body.months.appendChild(document.createRange().createContextualFragment(Object(d.a)({
                            months: t
                        }))), (this._ui.body.months.querySelectorAll(".datepicker-month") || []).forEach(function (t) {
                            e._clickEvents.forEach(function (n) {
                                t.addEventListener(n, e.onMonthClickDatePicker)
                            }), t.classList.remove("is-active"), t.dataset.month === r.format(e._visibleDate, "MM", {
                                locale: e.locale
                            }) && t.classList.add("is-active")
                        });
                        var n = new Array(100).fill(r.subYears(this._visibleDate, 50)).map(function (t, n) {
                            return r.format(r.addYears(t, n), "YYYY", {
                                locale: e.locale
                            })
                        });
                        this._ui.body.years.innerHTML = "", this._ui.body.years.appendChild(document.createRange().createContextualFragment(Object(l.a)({
                            visibleDate: this._visibleDate,
                            years: n
                        }))), (this._ui.body.years.querySelectorAll(".datepicker-year") || []).forEach(function (t) {
                            e._clickEvents.forEach(function (n) {
                                t.addEventListener(n, e.onYearClickDatePicker)
                            }), t.classList.remove("is-active"), t.dataset.year === r.format(e._visibleDate, "YYYY", {
                                locale: e.locale
                            }) && t.classList.add("is-active")
                        });
                        var o = new Array(7).fill(r.startOfWeek(this._visibleDate)).map(function (t, n) {
                            return r.format(r.addDays(t, n + e.options.weekStart), "ddd", {
                                locale: e.locale
                            })
                        });
                        return this._ui.body.dates.appendChild(document.createRange().createContextualFragment(Object(c.a)({
                            weekdays: o
                        }))), this.min && 0 === r.differenceInMonths(this._visibleDate, this.min) ? this._togglePreviousButton(!1) : this._togglePreviousButton(), this.max && 0 === r.differenceInMonths(this._visibleDate, this.max) ? this._toggleNextButton(!1) : this._toggleNextButton(), this._ui.navigation.month.innerHTML = r.format(this._visibleDate, "MMMM", {
                            locale: this.locale
                        }), this._ui.navigation.year.innerHTML = r.format(this._visibleDate, "YYYY", {
                            locale: this.locale
                        }), this._renderDays(), this._ui.body.dates.classList.add("is-active"), this._ui.body.months.classList.remove("is-active"), this._ui.body.years.classList.remove("is-active"), this._ui.navigation.previous.removeAttribute("disabled"), this._ui.navigation.next.removeAttribute("disabled"), this
                    }
                }, {
                    key: "clear",
                    value: function () {
                        var e = new Date;
                        this._date = {
                            start: void 0,
                            end: void 0
                        }, this._visibleDate = this._isValidDate(e, this.min, this.max) ? e : this.min, this.refresh()
                    }
                }, {
                    key: "snapshot",
                    value: function () {
                        this._snapshots.push(h({}, this._date))
                    }
                }, {
                    key: "render",
                    value: function () {
                        return this.refresh(), this.node
                    }
                }, {
                    key: "_init",
                    value: function () {
                        var e = new Date;
                        this._open = !1, this._snapshots = [], this.lang = this.options.lang, this.format = this.options.dateFormat || "MM/DD/YYYY", this.disabledDates = Array.isArray(this.options.disabledDates) ? this.options.disabledDates : [];
                        for (var t = 0; t < this.disabledDates.length; t++) this.disabledDates[t] = r.format(this.disabledDates[t], this.format, {
                            locale: this.locale
                        });
                        this.disabledWeekDays = i.e(this.options.disabledWeekDays) ? this.options.disabledWeekDays.split(",") : Array.isArray(this.options.disabledWeekDays) ? this.options.disabledWeekDays : [], this.min = this.options.minDate, this.max = this.options.maxDate, this._date = {
                            start: this.options.startDate,
                            end: this.options.isRange ? this.options.endDate : void 0
                        }, this._visibleDate = this._isValidDate(this.start) ? this.start : this._isValidDate(e, this.min, this.max) ? e : this.min, this._build(), this._bindEvents(), this.emit("ready", this)
                    }
                }, {
                    key: "_build",
                    value: function () {
                        this.node = document.createRange().createContextualFragment(Object(s.a)({
                            locale: this.locale,
                            visibleDate: this._visibleDate,
                            icons: this.options.icons
                        })), this._ui = {
                            container: this.node.firstChild,
                            navigation: {
                                container: this.node.querySelector(".datepicker-nav"),
                                previous: this.node.querySelector(".datepicker-nav-previous"),
                                next: this.node.querySelector(".datepicker-nav-next"),
                                month: this.node.querySelector(".datepicker-nav-month"),
                                year: this.node.querySelector(".datepicker-nav-year")
                            },
                            body: {
                                dates: this.node.querySelector(".datepicker-dates"),
                                days: this.node.querySelector(".datepicker-days"),
                                weekdays: this.node.querySelector(".datepicker-weekdays"),
                                months: this.node.querySelector(".datepicker-months"),
                                years: this.node.querySelector(".datepicker-years")
                            }
                        }
                    }
                }, {
                    key: "_bindEvents",
                    value: function () {
                        var e = this;
                        document.addEventListener("keydown", function (t) {
                            if (e._focus) switch (t.keyCode || t.which) {
                                case 37:
                                    e.onPreviousDatePicker(t);
                                    break;
                                case 39:
                                    e.onNextDatePicker(t)
                            }
                        }), this._ui.navigation.previous && this._clickEvents.forEach(function (t) {
                            e._ui.navigation.previous.addEventListener(t, e.onPreviousDatePicker)
                        }), this._ui.navigation.next && this._clickEvents.forEach(function (t) {
                            e._ui.navigation.next.addEventListener(t, e.onNextDatePicker)
                        }), this._ui.navigation.month && this._clickEvents.forEach(function (t) {
                            e._ui.navigation.month.addEventListener(t, e.onSelectMonthDatePicker)
                        }), this._ui.navigation.year && this._clickEvents.forEach(function (t) {
                            e._ui.navigation.year.addEventListener(t, e.onSelectYearDatePicker)
                        }), (this._ui.body.months.querySelectorAll(".calendar-month") || []).forEach(function (t) {
                            e._clickEvents.forEach(function (n) {
                                t.addEventListener(n, e.onMonthClickDatePicker)
                            })
                        }), (this._ui.body.years.querySelectorAll(".calendar-year") || []).forEach(function (t) {
                            e._clickEvents.forEach(function (n) {
                                t.addEventListener(n, e.onYearClickDatePicker)
                            })
                        })
                    }
                }, {
                    key: "_bindDaysEvents",
                    value: function () {
                        var e = this;
                        [].forEach.call(this._ui.days, function (t) {
                            e._clickEvents.forEach(function (n) {
                                var o = e._isValidDate(new Date(t.dataset.date), e.min, e.max) ? e.onDateClickDatePicker : null;
                                t.addEventListener(n, o)
                            }), t.addEventListener("hover", function (e) {
                                e.preventDEfault()
                            })
                        })
                    }
                }, {
                    key: "_renderDays",
                    value: function () {
                        var e = this,
                            t = r.startOfWeek(r.startOfMonth(this._visibleDate)),
                            n = r.endOfWeek(r.endOfMonth(this._visibleDate)),
                            o = new Array(r.differenceInDays(n, t) + 1).fill(t).map(function (t, n) {
                                var o = r.startOfDay(r.addDays(t, n + e.options.weekStart)),
                                    a = r.isSameMonth(e._visibleDate, o),
                                    s = e.options.isRange && r.isWithinRange(o, r.startOfDay(e.start), r.endOfDay(e.end)),
                                    u = !!e.max && r.isAfter(r.startOfDay(o), r.endOfDay(e.max));
                                if (u = !u && e.min ? r.isBefore(r.startOfDay(o), r.startOfDay(e.min)) : u, e.disabledDates)
                                    for (var c = 0; c < e.disabledDates.length; c++) {
                                        var d = e.disabledDates[c];
                                        i.c(d) && (d = d(e)), r.getTime(o) == r.getTime(d) && (u = !0)
                                    }
                                return e.disabledWeekDays && e.disabledWeekDays.forEach(function (t) {
                                    i.c(t) && (t = t(e)), r.getDay(o) == t && (u = !0)
                                }), {
                                    date: o,
                                    isRange: e.options.isRange,
                                    isToday: r.isToday(o),
                                    isStartDate: r.isEqual(r.startOfDay(e.start), o),
                                    isEndDate: r.isEqual(r.startOfDay(e.end), o),
                                    isDisabled: u,
                                    isThisMonth: a,
                                    isInRange: s
                                }
                            });
                        this._ui.body.dates.appendChild(document.createRange().createContextualFragment(Object(u.a)(o))), this._ui.days = this._ui.body.dates.querySelectorAll(".datepicker-date"), this._bindDaysEvents()
                    }
                }, {
                    key: "_select",
                    value: function () {
                        var e = this,
                            t = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : void 0;
                        this.snapshot(), t = i.b(t) ? t : new Date(t), this.options.isRange && (!this._isValidDate(this.start) || this._isValidDate(this.start) && this._isValidDate(this.end)) ? (this.start = t, this.end = void 0, this.emit("select:start", this)) : this.options.isRange && !this._isValidDate(this.end) ? r.isBefore(t, this.start) ? (this.end = this.start, this.start = t, this.emit("select", this)) : r.isAfter(t, this.start) ? (this.end = t, this.emit("select", this)) : this.options.allowSameDayRange ? (this.end = t, this.emit("select", this)) : (this.start = t, this.end = void 0, this.emit("select:start", this)) : (this.start = t, this.end = void 0, this.emit("select", this)), this._visibleDate = this._isValidDate(this.start) ? this.start : this._visibleDate, this.options.isRange && this._isValidDate(this.start) && this._isValidDate(this.end) && new Array(r.differenceInDays(this.end, this.start) + 1).fill(this.start).map(function (t, n) {
                            var o = r.addDays(t, n),
                                i = e._ui.body.dates.querySelector('.datepicker-date[data-date="' + o.toString() + '"]');
                            i && (r.isEqual(e.start, o) && i.classList.add("datepicker-range-start"), r.isEqual(e.end, o) && i.classList.add("datepicker-range-end"), i.classList.add("datepicker-range"))
                        })
                    }
                }, {
                    key: "_isValidDate",
                    value: function (e, t, n) {
                        try {
                            return !!e && !!r.isValid(e) && (!t && !n || (t && n ? r.isWithinRange(e, t, n) : n ? r.isBefore(e, n) || r.isEqual(e, n) : r.isAfter(e, t) || r.isEqual(e, t)))
                        } catch (e) {
                            return !1
                        }
                    }
                }, {
                    key: "_togglePreviousButton",
                    value: function () {
                        0 < arguments.length && void 0 !== arguments[0] && !arguments[0] ? this._ui.navigation.previous.setAttribute("disabled", "disabled") : this._ui.navigation.previous.removeAttribute("disabled")
                    }
                }, {
                    key: "_toggleNextButton",
                    value: function () {
                        0 < arguments.length && void 0 !== arguments[0] && !arguments[0] ? this._ui.navigation.next.setAttribute("disabled", "disabled") : this._ui.navigation.next.removeAttribute("disabled")
                    }
                }, {
                    key: "id",
                    get: function () {
                        return this._id
                    }
                }, {
                    key: "date",
                    set: function (e) {
                        return i.d(e) && e.start && e.end && (this._date = e), this
                    },
                    get: function () {
                        return this._date || {
                            start: void 0,
                            end: void 0
                        }
                    }
                }, {
                    key: "lang",
                    set: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : "en";
                        return this._lang = e, this._locale = n(84)("./" + e), this
                    },
                    get: function () {
                        return this._lang
                    }
                }, {
                    key: "locale",
                    get: function () {
                        return this._locale
                    }
                }, {
                    key: "start",
                    set: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : void 0;
                        return e ? (i.b(e) && (this._date.start = this._isValidDate(e, this.min, this.max) ? r.startOfDay(e) : this._date.start), i.e(e) && (this._date.start = this._isValidDate(r.parse(e), this.min, this.max) ? r.startOfDay(r.parse(e)) : this._date.start)) : this._date.start = void 0, this
                    },
                    get: function () {
                        return this._date.start
                    }
                }, {
                    key: "end",
                    set: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : void 0;
                        return e ? (i.b(e) && (this._date.end = this._isValidDate(e, this.min, this.max) ? r.startOfDay(e) : this._date.end), i.e(e) && (this._date.end = this._isValidDate(r.parse(e), this.min, this.max) ? r.startOfDay(r.parse(e)) : this._date.end)) : this._date.end = void 0, this
                    },
                    get: function () {
                        return this._date.end
                    }
                }, {
                    key: "min",
                    set: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : void 0;
                        return e && (i.b(e) && (this._min = this._isValidDate(e) ? r.startOfDay(e) : this._min), i.e(e) && (this._min = this._isValidDate(r.parse(e)) ? r.startOfDay(e) : this._min)), this
                    },
                    get: function () {
                        return this._min
                    }
                }, {
                    key: "max",
                    set: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : null;
                        return e && (i.b(e) && (this._max = this._isValidDate(e) ? r.startOfDay(e) : this._max), i.e(e) && (this._max = this._isValidDate(r.parse(e)) ? r.startOfDay(e) : this._max)), this
                    },
                    get: function () {
                        return this._max
                    }
                }, {
                    key: "format",
                    set: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : "MM/DD/YYYY";
                        return this._format = e, this
                    },
                    get: function () {
                        return this._format
                    }
                }]), t
            }();
        t.a = p
    }, function (e, t, n) {
        "use strict";
        t.a = function (e) {
            return '<div class="datepicker">\n    <div class="datepicker-nav">\n        <button type="button" class="datepicker-nav-previous button is-small is-text">' + e.icons.previous + '</button>\n        <div class="datepicker-nav-month-year">\n          <div class="datepicker-nav-month"></div>\n          &nbsp;\n          <div class="datepicker-nav-year"></div>\n        </div>\n        <button type="button" class="datepicker-nav-next button is-small is-text">' + e.icons.next + '</button>\n      </div>\n      <div class="datepicker-body">\n        <div class="datepicker-dates is-active"></div>\n        <div class="datepicker-months"></div>\n        <div class="datepicker-years"></div>\n      </div>\n    </div>'
        }
    }, function (e, t, n) {
        "use strict";
        t.a = function (e) {
            return '<div class="datepicker-days">' + e.map(function (e) {
                return '<div data-date="' + e.date.toString() + '" class="datepicker-date' + (e.isThisMonth ? " is-current-month" : "") + (e.isDisabled ? " is-disabled" : "") + (e.isRange && e.isInRange ? " datepicker-range" : "") + (e.isStartDate ? " datepicker-range-start" : "") + (e.isEndDate ? " datepicker-range-end" : "") + '">\n      <button class="date-item' + (e.isToday ? " is-today" : "") + (e.isStartDate ? " is-active" : "") + '" type="button">' + e.date.getDate() + "</button>\n  </div>"
            }).join("") + "</div>"
        }
    }, function (e, t, n) {
        "use strict";
        t.a = function (e) {
            return '<div class="datepicker-weekdays">\n\t\t' + e.weekdays.map(function (e) {
                return '<div class="datepicker-date">' + e + "</div>"
            }).join("") + "\n\t</div>"
        }
    }, function (e, t, n) {
        "use strict";
        var o = n(7);
        n.n(o), t.a = function (e) {
            return "" + e.months.map(function (t, n) {
                return '<div class="datepicker-month" data-month="' + Object(o.format)(Object(o.addMonths)(t, n), "MM", {
                    locale: e.locale
                }) + '">' + Object(o.format)(Object(o.addMonths)(t, n), "MMM", {
                    locale: e.locale
                }) + "</div>"
            }).join("")
        }
    }, function (e, t, n) {
        "use strict";
        var o = n(7);
        n.n(o), t.a = function (e) {
            return "" + e.years.map(function (t) {
                return '<div class="datepicker-year' + (t === Object(o.getMonth)(e.visibleDate) ? " is-active" : "") + '" data-year="' + t + '"><span class="item">' + t + "</span></div>"
            }).join("")
        }
    }, function (e, t, n) {
        "use strict";
        t.a = {
            color: "primary",
            isRange: !1,
            allowSameDayRange: !0,
            lang: "en",
            startDate: void 0,
            endDate: void 0,
            minDate: null,
            maxDate: null,
            disabledDates: [],
            disabledWeekDays: void 0,
            weekStart: 0,
            dateFormat: "MM/DD/YYYY",
            enableMonthSwitch: !0,
            enableYearSwitch: !0
        }
    }, function (e, t, n) {
        "use strict";
        var o = n(118),
            i = n(119),
            r = n(7),
            a = (n.n(r), n(129)),
            s = n(340),
            u = n(341),
            c = Object.assign || function (e) {
                for (var t = 1; t < arguments.length; t++) {
                    var n = arguments[t];
                    for (var o in n) Object.prototype.hasOwnProperty.call(n, o) && (e[o] = n[o])
                }
                return e
            },
            d = function () {
                function e(e, t) {
                    for (var n = 0; n < t.length; n++) {
                        var o = t[n];
                        o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, o.key, o)
                    }
                }
                return function (t, n, o) {
                    return n && e(t.prototype, n), o && e(t, o), t
                }
            }(),
            l = function (e) {
                function t() {
                    var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : {};
                    ! function (e, t) {
                        if (!(e instanceof t)) throw new TypeError("Cannot call a class as a function")
                    }(this, t);
                    var n = function (e, t) {
                        if (!e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
                        return !t || "object" != typeof t && "function" != typeof t ? e : t
                    }(this, (t.__proto__ || Object.getPrototypeOf(t)).call(this));
                    return n.options = c({}, u.a, e), n._clickEvents = ["click", "touch"], n._supportsPassive = o.a(), n._id = o.b("timePicker"), n.node = null, n.onPreviousHourStartTimePicker = n.onPreviousHourStartTimePicker.bind(n), n.onNextHourStartTimePicker = n.onNextHourStartTimePicker.bind(n), n.onPreviousMinuteStartTimePicker = n.onPreviousMinuteStartTimePicker.bind(n), n.onNextMinuteStartTimePicker = n.onNextMinuteStartTimePicker.bind(n), n.onPreviousHourEndTimePicker = n.onPreviousHourEndTimePicker.bind(n), n.onNextHourEndTimePicker = n.onNextHourEndTimePicker.bind(n), n.onPreviousMinuteEndTimePicker = n.onPreviousMinuteEndTimePicker.bind(n), n.onNextMinuteEndTimePicker = n.onNextMinuteEndTimePicker.bind(n), n._init(), n
                }
                return function (e, t) {
                    if ("function" != typeof t && null !== t) throw new TypeError("Super expression must either be null or a function, not " + typeof t);
                    e.prototype = Object.create(t && t.prototype, {
                        constructor: {
                            value: e,
                            enumerable: !1,
                            writable: !0,
                            configurable: !0
                        }
                    }), t && (Object.setPrototypeOf ? Object.setPrototypeOf(e, t) : e.__proto__ = t)
                }(t, a.a), d(t, [{
                    key: "_init",
                    value: function () {
                        this._open = !1, this._snapshots = [], this.lang = this.options.lang, this.format = this.options.format || "HH:mm", this.min = this.options.min, this.max = this.options.max, this._time = {
                            start: r.startOfToday(),
                            end: r.endOfToday()
                        }, this.start = this.options.start || r.startOfToday(), this.end = this.options.isRange ? this.options.end : r.endOfToday(), this._build(), this._bindEvents(), this.emit("ready", this)
                    }
                }, {
                    key: "_build",
                    value: function () {
                        this.node = document.createRange().createContextualFragment(Object(s.a)({
                            locale: this.locale,
                            isRange: this.options.isRange,
                            icons: this.options.icons
                        })), this._ui = {
                            container: this.node.firstChild,
                            start: {
                                container: this.node.querySelector(".timepicker-start"),
                                hours: {
                                    container: this.node.querySelector(".timepicker-start .timepicker-hours"),
                                    input: this.node.querySelector(".timepicker-start .timepicker-hours input"),
                                    number: this.node.querySelector(".timepicker-start .timepicker-hours .timepicker-input-number"),
                                    previous: this.node.querySelector(".timepicker-start .timepicker-hours .timepicker-previous"),
                                    next: this.node.querySelector(".timepicker-start .timepicker-hours .timepicker-next")
                                },
                                minutes: {
                                    container: this.node.querySelector(".timepicker-start .timepicker-minutes"),
                                    input: this.node.querySelector(".timepicker-start .timepicker-minutes input"),
                                    number: this.node.querySelector(".timepicker-start .timepicker-minutes .timepicker-input-number"),
                                    previous: this.node.querySelector(".timepicker-start .timepicker-minutes .timepicker-previous"),
                                    next: this.node.querySelector(".timepicker-start .timepicker-minutes .timepicker-next")
                                }
                            },
                            end: {
                                container: this.node.querySelector(".timepicker-end"),
                                hours: {
                                    container: this.node.querySelector(".timepicker-end .timepicker-hours"),
                                    input: this.node.querySelector(".timepicker-end .timepicker-hours input"),
                                    number: this.node.querySelector(".timepicker-end .timepicker-hours .timepicker-input-number"),
                                    previous: this.node.querySelector(".timepicker-end .timepicker-hours .timepicker-previous"),
                                    next: this.node.querySelector(".timepicker-end .timepicker-hours .timepicker-next")
                                },
                                minutes: {
                                    container: this.node.querySelector(".timepicker-end .timepicker-minutes"),
                                    input: this.node.querySelector(".timepicker-end .timepicker-minutes input"),
                                    number: this.node.querySelector(".timepicker-end .timepicker-minutes .timepicker-input-number"),
                                    previous: this.node.querySelector(".timepicker-end .timepicker-minutes .timepicker-previous"),
                                    next: this.node.querySelector(".timepicker-end .timepicker-minutes .timepicker-next")
                                }
                            }
                        }
                    }
                }, {
                    key: "_bindEvents",
                    value: function () {
                        var e = this;
                        this._clickEvents.forEach(function (t) {
                            e._ui.start.hours.previous.addEventListener(t, e.onPreviousHourStartTimePicker), e._ui.start.hours.next.addEventListener(t, e.onNextHourStartTimePicker), e._ui.start.minutes.previous.addEventListener(t, e.onPreviousMinuteStartTimePicker), e._ui.start.minutes.next.addEventListener(t, e.onNextMinuteStartTimePicker), e.options.isRange && (e._ui.end.hours.previous.addEventListener(t, e.onPreviousHourEndTimePicker), e._ui.end.hours.next.addEventListener(t, e.onNextHourEndTimePicker), e._ui.end.minutes.previous.addEventListener(t, e.onPreviousMinuteEndTimePicker), e._ui.end.minutes.next.addEventListener(t, e.onNextMinuteEndTimePicker))
                        })
                    }
                }, {
                    key: "_select",
                    value: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : void 0;
                        this.snapshot(), e = i.b(e) ? e : new Date(e), this.options.isRange && (!this._isValidTime(this.start) || this._isValidTime(this.start) && this._isValidTime(this.end)) ? (this.start = e, this.end = r.endOfToday(), this.emit("select:start", this)) : this.options.isRange && !this._isValidTime(this.end) ? r.isBefore(e, this.start) ? (this.end = this.start, this.start = r.endOfToday(), this.emit("select", this)) : r.isAfter(e, this.start) ? (this.end = e, this.emit("select", this)) : (this.start = e, this.end = r.endOfToday(), this.emit("select:start", this)) : (this.start = e, this.end = r.endOfToday(), this.emit("select", this))
                    }
                }, {
                    key: "_isValidTime",
                    value: function (e, t, n) {
                        try {
                            return !!e && !!r.isValid(e) && (!t && !n || (t && n ? r.isWithinRange(e, t, n) : n ? r.isBefore(e, n) || r.isEqual(e, n) : r.isAfter(e, t) || r.isEqual(e, t)))
                        } catch (e) {
                            return !1
                        }
                    }
                }, {
                    key: "onPreviousHourStartTimePicker",
                    value: function (e) {
                        var t = this;
                        this._supportsPassive || e.preventDefault(), e.stopPropagation(), this.start = r.subHours(this.start, 1), setTimeout(function () {
                            t._ui.start.hours.number.classList.add("is-decrement-hide"), setTimeout(function () {
                                t._ui.start.hours.number.innerText = r.format(t.start, "HH"), t._ui.start.hours.input.value = r.format(t.start, "HH"), t._ui.start.hours.number.classList.add("is-decrement-visible")
                            }, 100), setTimeout(function () {
                                t._ui.start.hours.number.classList.remove("is-decrement-hide"), t._ui.start.hours.number.classList.remove("is-decrement-visible")
                            }, 1100)
                        }, 100)
                    }
                }, {
                    key: "onNextHourStartTimePicker",
                    value: function (e) {
                        var t = this;
                        this._supportsPassive || e.preventDefault(), e.stopPropagation(), this.start = r.addHours(this.start, 1), setTimeout(function () {
                            t._ui.start.hours.number.classList.add("is-increment-hide"), setTimeout(function () {
                                t._ui.start.hours.number.innerText = r.format(t.start, "HH"), t._ui.start.hours.input.value = r.format(t.start, "HH"), t._ui.start.hours.number.classList.add("is-increment-visible")
                            }, 100), setTimeout(function () {
                                t._ui.start.hours.number.classList.remove("is-increment-hide"), t._ui.start.hours.number.classList.remove("is-increment-visible")
                            }, 1100)
                        }, 100)
                    }
                }, {
                    key: "onPreviousMinuteStartTimePicker",
                    value: function (e) {
                        var t = this;
                        this._supportsPassive || e.preventDefault(), e.stopPropagation(), this.start = r.subMinutes(this.start, this.options.minuteSteps), setTimeout(function () {
                            t._ui.start.minutes.number.classList.add("is-decrement-hide"), setTimeout(function () {
                                t._ui.start.minutes.number.innerText = r.format(t.start, "mm"), t._ui.start.minutes.input.value = r.format(t.start, "mm"), t._ui.start.minutes.number.classList.add("is-decrement-visible"), r.format(t.start, "HH") !== t._ui.start.hours.input.value && (t._ui.start.hours.number.innerText = r.format(t.start, "HH"), t._ui.start.hours.input.value = r.format(t.start, "HH"), t._ui.start.hours.number.classList.add("is-decrement-visible"))
                            }, 100), setTimeout(function () {
                                t._ui.start.minutes.number.classList.remove("is-decrement-hide"), t._ui.start.minutes.number.classList.remove("is-decrement-visible"), t._ui.start.hours.number.classList.remove("is-decrement-hide"), t._ui.start.hours.number.classList.remove("is-decrement-visible")
                            }, 1100)
                        }, 100)
                    }
                }, {
                    key: "onNextMinuteStartTimePicker",
                    value: function (e) {
                        var t = this;
                        this._supportsPassive || e.preventDefault(), e.stopPropagation(), this.start = r.addMinutes(this.start, this.options.minuteSteps), setTimeout(function () {
                            t._ui.start.minutes.number.classList.add("is-increment-hide"), setTimeout(function () {
                                t._ui.start.minutes.number.innerText = r.format(t.start, "mm"), t._ui.start.minutes.input.value = r.format(t.start, "mm"), t._ui.start.minutes.number.classList.add("is-increment-visible"), r.format(t.start, "HH") !== t._ui.start.hours.input.value && (t._ui.start.hours.number.innerText = r.format(t.start, "HH"), t._ui.start.hours.input.value = r.format(t.start, "HH"), t._ui.start.hours.number.classList.add("is-increment-visible"))
                            }, 100), setTimeout(function () {
                                t._ui.start.minutes.number.classList.remove("is-increment-hide"), t._ui.start.minutes.number.classList.remove("is-increment-visible"), t._ui.start.hours.number.classList.remove("is-increment-hide"), t._ui.start.hours.number.classList.remove("is-increment-visible")
                            }, 1100)
                        }, 100)
                    }
                }, {
                    key: "onPreviousHourEndTimePicker",
                    value: function (e) {
                        var t = this;
                        this._supportsPassive || e.preventDefault(), e.stopPropagation(), this.end = r.subHours(this.end, 1), setTimeout(function () {
                            t._ui.end.hours.number.classList.add("is-decrement-hide"), setTimeout(function () {
                                t._ui.end.hours.number.innerText = r.format(t.end, "HH"), t._ui.end.hours.input.value = r.format(t.end, "HH"), t._ui.end.hours.number.classList.add("is-decrement-visible")
                            }, 100), setTimeout(function () {
                                t._ui.end.hours.number.classList.remove("is-decrement-hide"), t._ui.end.hours.number.classList.remove("is-decrement-visible")
                            }, 1100)
                        }, 100)
                    }
                }, {
                    key: "onNextHourEndTimePicker",
                    value: function (e) {
                        var t = this;
                        this._supportsPassive || e.preventDefault(), e.stopPropagation(), this.end = r.addHours(this.end, 1), setTimeout(function () {
                            t._ui.end.hours.number.classList.add("is-increment-hide"), setTimeout(function () {
                                t._ui.end.hours.number.innerText = r.format(t.end, "HH"), t._ui.end.hours.input.value = r.format(t.end, "HH"), t._ui.end.hours.number.classList.add("is-increment-visible")
                            }, 100), setTimeout(function () {
                                t._ui.end.hours.number.classList.remove("is-increment-hide"), t._ui.end.hours.number.classList.remove("is-increment-visible")
                            }, 1100)
                        }, 100)
                    }
                }, {
                    key: "onPreviousMinuteEndTimePicker",
                    value: function (e) {
                        var t = this;
                        this._supportsPassive || e.preventDefault(), e.stopPropagation(), this.end = r.subMinutes(this.end, this.options.minuteSteps), setTimeout(function () {
                            t._ui.end.minutes.number.classList.add("is-decrement-hide"), setTimeout(function () {
                                t._ui.end.minutes.number.innerText = r.format(t.end, "mm"), t._ui.end.minutes.input.value = r.format(t.end, "mm"), t._ui.end.minutes.number.classList.add("is-decrement-visible"), r.format(t.end, "HH") !== t._ui.end.hours.input.value && (t._ui.end.hours.number.innerText = r.format(t.end, "HH"), t._ui.end.hours.input.value = r.format(t.end, "HH"), t._ui.end.hours.number.classList.add("is-decrement-visible"))
                            }, 100), setTimeout(function () {
                                t._ui.end.minutes.number.classList.remove("is-decrement-hide"), t._ui.end.minutes.number.classList.remove("is-decrement-visible")
                            }, 1100)
                        }, 100)
                    }
                }, {
                    key: "onNextMinuteEndTimePicker",
                    value: function (e) {
                        var t = this;
                        this._supportsPassive || e.preventDefault(), e.stopPropagation(), this.end = r.addMinutes(this.end, this.options.minuteSteps), setTimeout(function () {
                            t._ui.end.minutes.number.classList.add("is-increment-hide"), setTimeout(function () {
                                t._ui.end.minutes.number.innerText = r.format(t.end, "mm"), t._ui.end.minutes.input.value = r.format(t.end, "mm"), t._ui.end.minutes.number.classList.add("is-increment-visible"), r.format(t.end, "HH") !== t._ui.end.hours.input.value && (t._ui.end.hours.number.innerText = r.format(t.end, "HH"), t._ui.end.hours.input.value = r.format(t.end, "HH"), t._ui.end.hours.number.classList.add("is-increment-visible"))
                            }, 100), setTimeout(function () {
                                t._ui.end.minutes.number.classList.remove("is-increment-hide"), t._ui.end.minutes.number.classList.remove("is-increment-visible")
                            }, 1100)
                        }, 100)
                    }
                }, {
                    key: "isRange",
                    value: function () {
                        return this.options.isRange
                    }
                }, {
                    key: "show",
                    value: function () {
                        this._open || (this._ui.container.classList.add("is-active"), this._open = !0, this._focus = !0, this.emit("show", this))
                    }
                }, {
                    key: "hide",
                    value: function () {
                        this._open = !1, this._focus = !1, this._ui.container.classList.remove("is-active"), this.emit("hide", this)
                    }
                }, {
                    key: "toggle",
                    value: function () {
                        this._open ? this.hide() : this.show()
                    }
                }, {
                    key: "value",
                    value: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : null;
                        if (!e) {
                            var t = this.start && this._isValidTime(this.start) ? r.format(this.start, this.format, {
                                locale: this.locale
                            }) : "";
                            return this.options.isRange && this.end && this._isValidTime(this.end) && (t += " - " + r.format(this.end, this.format, {
                                locale: this.locale
                            })), t
                        }
                        if (this.options.isRange) {
                            if (i.e(e)) {
                                var n = e.split(" - ");
                                n.length && (this.start = r.format(new Date(n[0]), this.format, {
                                    locale: this.locale
                                })), 2 === n.length && (this.end = r.format(new Date(n[1]), this.format, {
                                    locale: this.locale
                                }))
                            }(i.d(e) || i.b(e)) && this._select(e)
                        } else this._select(e)
                    }
                }, {
                    key: "refresh",
                    value: function () {
                        return this._ui.start.hours.input.value = r.format(this.start, "HH"), this._ui.start.hours.number.innerText = r.format(this.start, "HH"), this._ui.start.minutes.input.value = r.format(this.start, "mm"), this._ui.start.minutes.number.innerText = r.format(this.start, "mm"), this.options.isRange && (this._ui.end.hours.input.value = r.format(this.end, "HH"), this._ui.end.hours.number.innerText = r.format(this.end, "HH"), this._ui.end.minutes.input.value = r.format(this.end, "mm"), this._ui.end.minutes.number.innerText = r.format(this.end, "mm")), this
                    }
                }, {
                    key: "clear",
                    value: function () {
                        this.time = {
                            start: r.startOfToday(),
                            end: r.endOfToday()
                        }, this.refresh()
                    }
                }, {
                    key: "snapshot",
                    value: function () {
                        this._snapshots.push(c({}, this._time))
                    }
                }, {
                    key: "render",
                    value: function () {
                        return this.refresh(), this.node
                    }
                }, {
                    key: "id",
                    get: function () {
                        return this._id
                    }
                }, {
                    key: "time",
                    set: function (e) {
                        return i.d(e) && e.start && e.end && (this._time = e), this
                    },
                    get: function () {
                        return this._time || {
                            start: void 0,
                            end: void 0
                        }
                    }
                }, {
                    key: "lang",
                    set: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : "en";
                        return this._lang = e, this._locale = n(84)("./" + e), this
                    },
                    get: function () {
                        return this._lang
                    }
                }, {
                    key: "locale",
                    get: function () {
                        return this._locale
                    }
                }, {
                    key: "start",
                    set: function (e) {
                        return this._time.start = e ? this._isValidTime(e, this.min, this.max) ? e : this._time.start : r.startOfToday(), this
                    },
                    get: function () {
                        return this._time.start
                    }
                }, {
                    key: "end",
                    set: function (e) {
                        return this._time.end = e ? this._isValidTime(e, this.min, this.max) ? e : this._time.end : r.endOfToday(), this
                    },
                    get: function () {
                        return this._time.end
                    }
                }, {
                    key: "min",
                    set: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : void 0;
                        return this._min = e ? this._isValidTime(e) ? e : this._min : void 0, this
                    },
                    get: function () {
                        return this._min
                    }
                }, {
                    key: "max",
                    set: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : null;
                        return this._max = e ? this._isValidTime(e) ? e : this._max : void 0, this
                    },
                    get: function () {
                        return this._max
                    }
                }, {
                    key: "format",
                    set: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : "HH:mm";
                        return this._format = e, this
                    },
                    get: function () {
                        return this._format
                    }
                }]), t
            }();
        t.a = l
    }, function (e, t, n) {
        "use strict";
        t.a = function (e) {
            return '<div class="timepicker">\n    <div class="timepicker-start">\n      <div class="timepicker-hours">\n        <span class="timepicker-next">+</span>\n        <div class="timepicker-input">\n          <input type="number">\n          <div class="timepicker-input-number"></div>\n        </div>\n        <span class="timepicker-previous">-</span>\n      </div>\n      <div class="timepicker-time-divider">:</div>\n      <div class="timepicker-minutes">\n        <span class="timepicker-next">+</span>\n        <div class="timepicker-input">\n          <input type="number">\n          <div class="timepicker-input-number"></div>\n        </div>\n        <span class="timepicker-previous">-</span>\n      </div>\n    </div>\n    ' + (e.isRange ? '<div class="timepicker-end">\n      <div class="timepicker-hours">\n        <span class="timepicker-next">+</span>\n        <div class="timepicker-input">\n          <input type="number">\n          <div class="timepicker-input-number"></div>\n        </div>\n        <span class="timepicker-previous">-</span>\n      </div>\n      <div class="timepicker-time-divider">:</div>\n      <div class="timepicker-minutes">\n        <span class="timepicker-next">+</span>\n        <div class="timepicker-input">\n          <input type="number">\n          <div class="timepicker-input-number"></div>\n        </div>\n        <span class="timepicker-previous">-</span>\n      </div>\n    </div>' : "") + "\n  </div>"
        }
    }, function (e, t, n) {
        "use strict";
        t.a = {
            timeFormat: "HH:mm",
            color: "primary",
            isRange: !1,
            lang: "en",
            startTime: void 0,
            endTime: void 0,
            minTime: null,
            maxTime: null,
            minuteSteps: 5
        }
    }, function (e, t, n) {
        "use strict";
        var o = {
            type: void 0,
            color: "primary",
            isRange: !1,
            allowSameDayRange: !0,
            lang: navigator.language.substring(0, 2) || "en",
            dateFormat: "MM/DD/YYYY",
            timeFormat: "HH:mm",
            displayMode: "default",
            position: "auto",
            showHeader: !0,
            headerPosition: "top",
            showFooter: !0,
            showButtons: !0,
            showTodayButton: !0,
            showClearButton: !0,
            cancelLabel: "Cancel",
            clearLabel: "Clear",
            todayLabel: "Today",
            nowLabel: "Now",
            validateLabel: "Validate",
            enableMonthSwitch: !0,
            enableYearSwitch: !0,
            startDate: void 0,
            endDate: void 0,
            minDate: null,
            maxDate: null,
            disabledDates: [],
            disabledWeekDays: void 0,
            weekStart: 0,
            startTime: void 0,
            endTime: void 0,
            minuteSteps: 5,
            labelFrom: "",
            labelTo: "",
            closeOnOverlayClick: !0,
            closeOnSelect: !0,
            toggleOnInputClick: !0,
            onReady: null,
            icons: {
                previous: '<svg viewBox="0 0 50 80" xml:space="preserve">\n      <polyline fill="none" stroke-width=".5em" stroke-linecap="round" stroke-linejoin="round" points="45.63,75.8 0.375,38.087 45.63,0.375 "/>\n    </svg>',
                next: '<svg viewBox="0 0 50 80" xml:space="preserve">\n      <polyline fill="none" stroke-width=".5em" stroke-linecap="round" stroke-linejoin="round" points="0.375,0.375 45.63,38.087 0.375,75.8 "/>\n    </svg>',
                time: '<svg version="1.1" x="0px" y="0px" viewBox="0 0 60 60" xml:space="preserve">\n      <g>\n        <path fill="currentcolor" d="M30,0C13.458,0,0,13.458,0,30s13.458,30,30,30s30-13.458,30-30S46.542,0,30,0z M30,58C14.561,58,2,45.439,2,30S14.561,2,30,2s28,12.561,28,28S45.439,58,30,58z"/>\n\t      <path fill="currentcolor" d="M30,6c-0.552,0-1,0.447-1,1v23H14c-0.552,0-1,0.447-1,1s0.448,1,1,1h16c0.552,0,1-0.447,1-1V7C31,6.447,30.552,6,30,6z"/>\n      </g>\n    </svg>',
                date: '<svg version="1.1" x="0px" y="0px" viewBox="0 0 60 60" xml:space="preserve">\n      <g>\n        <path d="M57,4h-7V1c0-0.553-0.447-1-1-1h-7c-0.553,0-1,0.447-1,1v3H19V1c0-0.553-0.447-1-1-1h-7c-0.553,0-1,0.447-1,1v3H3C2.447,4,2,4.447,2,5v11v43c0,0.553,0.447,1,1,1h54c0.553,0,1-0.447,1-1V16V5C58,4.447,57.553,4,57,4z M43,2h5v3v3h-5V5V2z M12,2h5v3v3h-5V5V2z M4,6h6v3c0,0.553,0.447,1,1,1h7c0.553,0,1-0.447,1-1V6h22v3c0,0.553,0.447,1,1,1h7c0.553,0,1-0.447,1-1V6h6v9H4V6zM4,58V17h52v41H4z"/>\n        <path d="M38,23h-7h-2h-7h-2h-9v9v2v7v2v9h9h2h7h2h7h2h9v-9v-2v-7v-2v-9h-9H38z M31,25h7v7h-7V25z M38,41h-7v-7h7V41z M22,34h7v7h-7V34z M22,25h7v7h-7V25z M13,25h7v7h-7V25z M13,34h7v7h-7V34z M20,50h-7v-7h7V50z M29,50h-7v-7h7V50z M38,50h-7v-7h7V50z M47,50h-7v-7h7V50z M47,41h-7v-7h7V41z M47,25v7h-7v-7H47z"/>\n      </g>\n    </svg>'
            }
        };
        t.a = o
    }, function (e, t, n) {
        "use strict";
        t.a = function (e) {
            return "<div id='" + e.id + '\'>\n    <div class="datetimepicker-dummy is-hidden">\n      <div class="datetimepicker-dummy-wrapper">\n        <input placeholder="' + e.labelFrom + '" readonly="readonly" class="datetimepicker-dummy-input' + (e.isRange ? " is-datetimepicker-range" : "") + '" type="text">\n        ' + (e.isRange ? '<input placeholder="' + e.labelTo + '" readonly="readonly" class="datetimepicker-dummy-input" type="text">' : "") + '\n      </div>\n      <button class="datetimepicker-clear-button">＋</button>\n    </div>\n    <div class="datetimepicker-wrapper' + ("dialog" === e.displayMode ? " modal" : "") + '">\n        <div class="modal-background' + ("dialog" === e.displayMode ? "" : " is-hidden") + '"></div>\n        <div class="datetimepicker">\n          <div class="datetimepicker-container' + ("top" === e.headerPosition ? "" : " has-header-bottom") + '"></div>\n        </div>\n    </div>\n  </div>'
        }
    }, function (e, t, n) {
        "use strict";
        t.a = function (e) {
            return '<div class="datetimepicker-header' + ("time" === e.type ? " is-hidden" : "") + ("date" === e.type ? " is-date-only" : "") + '">\n\t\t<div class="datetimepicker-selection-details">\n\t\t\t<div class="datetimepicker-selection-from' + ("" === e.labelFrom ? " is-hidden" : "") + '">' + e.labelFrom + '</div>\n\t\t\t<div class="datetimepicker-selection-start' + (e.isRange ? "" : " is-centered") + '">\n\t\t\t\t<div class="datetimepicker-selection-wrapper">\n\t\t\t\t\t<div class="datetimepicker-selection-day"></div>\n\t\t\t\t\t<div class="datetimepicker-selection-date">\n\t\t\t\t\t\t<div class="datetimepicker-selection-month"></div>\n\t\t\t\t\t\t<div class="datetimepicker-selection-weekday"></div>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t\t' + ("date" !== e.type ? '<div class="datetimepicker-selection-time">\n\t\t\t\t\t<div class="datetimepicker-selection-time-icon">\n\t\t\t\t\t\t<figure class="image is-16x16">\n\t\t\t\t\t\t\t' + (e.icons ? e.icons.time : "") + '\n\t\t\t\t\t\t</figure>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class="datetimepicker-selection-hour"></div>\n\t\t\t\t</div>' : "") + "\n\t\t\t</div>\n\t\t</div>\n\t\t" + (e.isRange ? '\n\t\t<div class="datetimepicker-selection-details">\n\t\t\t<div class="datetimepicker-selection-to' + ("" === e.labelTo ? " is-hidden" : "") + '">' + e.labelTo + '</div>\n\t\t\t<div class="datetimepicker-selection-end">\n\t\t\t\t<div class="datetimepicker-selection-wrapper">\n\t\t\t\t\t<div class="datetimepicker-selection-day"></div>\n\t\t\t\t\t<div class="datetimepicker-selection-date">\n\t\t\t\t\t\t<div class="datetimepicker-selection-month"></div>\n\t\t\t\t\t\t<div class="datetimepicker-selection-weekday"></div>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t\t' + ("date" !== e.type ? '<div class="datetimepicker-selection-time">\n\t\t\t\t\t<div class="datetimepicker-selection-time-icon">\n\t\t\t\t\t\t<figure class="image is-16x16">\n\t\t\t\t\t\t\t' + (e.icons ? e.icons.time : "") + '\n\t\t\t\t\t\t</figure>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class="datetimepicker-selection-hour"></div>\n\t\t\t\t</div>' : "") + "\n\t\t\t</div>\n\t\t</div>" : "") + "\n\t</div>"
        }
    }, function (e, t, n) {
        "use strict";
        t.a = function (e) {
            return '<div class="datetimepicker-footer">\n\t\t<button type="button" class="datetimepicker-footer-validate has-text-success button is-small is-text ' + ("inline" === e.displayMode ? "is-hidden" : "") + '">' + (e.icons.validate ? e.icons.validate : "") + e.validateLabel + ' </button>\n\t\t<button type="button" class="datetimepicker-footer-today has-text-warning button is-small is-text">' + (e.icons.today ? e.icons.today : "") + e.todayLabel + '</button>\n\t\t<button type="button" class="datetimepicker-footer-clear has-text-danger button is-small is-text">' + (e.icons.clear ? e.icons.clear : "") + e.clearLabel + '</button>\n\t\t<button type="button" class="datetimepicker-footer-cancel button is-small is-text ' + ("inline" === e.displayMode ? "is-hidden" : "") + '">' + (e.icons.cancel ? e.icons.cancel : "") + e.cancelLabel + "</button>\n\t</div>"
        }
    }]).default
});
! function (e, t) {
    "object" == typeof exports && "object" == typeof module ? module.exports = t() : "function" == typeof define && define.amd ? define([], t) : "object" == typeof exports ? exports.bulmaIconpicker = t() : e.bulmaIconpicker = t()
}("undefined" != typeof self ? self : this, function () {
    return function (e) {
        var t = {};

        function n(i) {
            if (t[i]) return t[i].exports;
            var r = t[i] = {
                i: i,
                l: !1,
                exports: {}
            };
            return e[i].call(r.exports, r, r.exports, n), r.l = !0, r.exports
        }
        return n.m = e, n.c = t, n.d = function (e, t, i) {
            n.o(e, t) || Object.defineProperty(e, t, {
                configurable: !1,
                enumerable: !0,
                get: i
            })
        }, n.n = function (e) {
            var t = e && e.__esModule ? function () {
                return e.default
            } : function () {
                return e
            };
            return n.d(t, "a", t), t
        }, n.o = function (e, t) {
            return Object.prototype.hasOwnProperty.call(e, t)
        }, n.p = "", n(n.s = 0)
    }([function (e, t, n) {
        "use strict";
        Object.defineProperty(t, "__esModule", {
            value: !0
        });
        var i = n(1),
            r = n(2),
            a = function () {
                return function (e, t) {
                    if (Array.isArray(e)) return e;
                    if (Symbol.iterator in Object(e)) return function (e, t) {
                        var n = [],
                            i = !0,
                            r = !1,
                            a = void 0;
                        try {
                            for (var o, s = e[Symbol.iterator](); !(i = (o = s.next()).done) && (n.push(o.value), !t || n.length !== t); i = !0);
                        } catch (e) {
                            r = !0, a = e
                        } finally {
                            try {
                                !i && s.return && s.return()
                            } finally {
                                if (r) throw a
                            }
                        }
                        return n
                    }(e, t);
                    throw new TypeError("Invalid attempt to destructure non-iterable instance")
                }
            }(),
            o = Object.assign || function (e) {
                for (var t = 1; t < arguments.length; t++) {
                    var n = arguments[t];
                    for (var i in n) Object.prototype.hasOwnProperty.call(n, i) && (e[i] = n[i])
                }
                return e
            },
            s = function () {
                function e(e, t) {
                    for (var n = 0; n < t.length; n++) {
                        var i = t[n];
                        i.enumerable = i.enumerable || !1, i.configurable = !0, "value" in i && (i.writable = !0), Object.defineProperty(e, i.key, i)
                    }
                }
                return function (t, n, i) {
                    return n && e(t.prototype, n), i && e(t, i), t
                }
            }();
        var c = function (e) {
            function t(e) {
                var n = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
                ! function (e, t) {
                    if (!(e instanceof t)) throw new TypeError("Cannot call a class as a function")
                }(this, t);
                var i = function (e, t) {
                    if (!e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
                    return !t || "object" != typeof t && "function" != typeof t ? e : t
                }(this, (t.__proto__ || Object.getPrototypeOf(t)).call(this));
                if (i.element = "string" == typeof e ? document.querySelector(e) : e, !i.element) throw new Error("An invalid selector or non-DOM node has been provided.");
                return i._clickEvents = ["click"], i.options = o({}, r.a, n), i.icons = [], i.id = "iconPicker" + (new Date).getTime(), i.init(), i
            }
            return function (e, t) {
                if ("function" != typeof t && null !== t) throw new TypeError("Super expression must either be null or a function, not " + typeof t);
                e.prototype = Object.create(t && t.prototype, {
                    constructor: {
                        value: e,
                        enumerable: !1,
                        writable: !0,
                        configurable: !0
                    }
                }), t && (Object.setPrototypeOf ? Object.setPrototypeOf(e, t) : e.__proto__ = t)
            }(t, i["a"]), s(t, [{
                key: "init",
                value: function () {
                    var e = this;
                    this.createModal(), this.createPreview(), this.options.iconSets.forEach(function (t) {
                        var n;
                        n = t.css, new Promise(function (e, t) {
                            var i = document.createElement("link");
                            i.type = "text/css", i.rel = "stylesheet", i.onload = function () {
                                e()
                            }, i.href = n, document.querySelector('link[href="' + n + '"]') || document.querySelector("head").append(i)
                        }), fetch(t.css, {
                            mode: "cors"
                        }).then(function (e) {
                            return e.text()
                        }).then(function (n) {
                            e.icons[t.name] = e.parseCSS(n, t.prefix || "fa-", t.displayPrefix || ""), e.modalSetTabs.querySelector("a").click();
                            var i = new Event("touchstart");
                            e.modalSetTabs.querySelector("a").dispatchEvent(i)
                        })
                    })
                }
            }, {
                key: "createPreview",
                value: function () {
                    var e = this;
                    this.preview = document.createElement("div"), this.preview.className = "icon is-large", this.preview.classList.add("iconpicker-preview");
                    var t = document.createElement("i");
                    (t.className = "iconpicker-icon-preview", this.element.value.length) && this.element.value.split(" ").forEach(function (e) {
                        t.classList.add(e)
                    });
                    this.preview.appendChild(t), this._clickEvents.forEach(function (t) {
                        e.preview.addEventListener(t, function (t) {
                            t.preventDefault(), e.modal.classList.add("is-active")
                        })
                    }), this.element.parentNode.insertBefore(this.preview, this.element.nextSibling)
                }
            }, {
                key: "parseCSS",
                value: function (e) {
                    for (var t = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : "fa-", n = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : "", i = new RegExp("\\." + t + "([^\\.!:]*)::?before\\s*{\\s*content:\\s*[\"|']\\\\[^'|\"]*[\"|'];?\\s*}", "g"), r = [], a = void 0, o = void 0; o = i.exec(e);) a = {
                        prefix: t,
                        selector: t + o[1].trim(":"),
                        name: this.ucwords(o[1]).trim(":"),
                        filter: o[1].trim(":"),
                        displayPrefix: n
                    }, r[o[1]] = a;
                    return 0 == Object.getOwnPropertyNames(this.icons).length && console.warn("No icons found in CSS file"), r
                }
            }, {
                key: "ucwords",
                value: function (e) {
                    return (e + "").replace(/^(.)|\s+(.)/g, function (e) {
                        return e.toUpperCase()
                    })
                }
            }, {
                key: "drawIcons",
                value: function (e) {
                    if (this.iconsList.innerHTML = "", e) {
                        var t = !0,
                            n = !1,
                            i = void 0;
                        try {
                            for (var r, o = Object.entries(e)[Symbol.iterator](); !(t = (r = o.next()).done); t = !0) {
                                var s = r.value,
                                    c = a(s, 2),
                                    l = (c[0], c[1]);
                                this.iconsList.appendChild(this.createIconPreview(l))
                            }
                        } catch (e) {
                            n = !0, i = e
                        } finally {
                            try {
                                !t && o.return && o.return()
                            } finally {
                                if (n) throw i
                            }
                        }
                    }
                }
            }, {
                key: "createIconPreview",
                value: function (e) {
                    var t = this,
                        n = (arguments.length > 1 && void 0 !== arguments[1] && arguments[1], document.createElement("a"));
                    n.dataset.title = e.name, n.setAttribute("title", e.name), n.dataset.icon = e.selector, n.dataset.filter = e.filter;
                    var i = document.createElement("i");
                    return i.className = "iconpicker-icon-preview", e.displayPrefix.length && e.displayPrefix.split(" ").forEach(function (e) {
                        i.classList.add(e)
                    }), i.classList.add(e.selector), n.appendChild(i), this._clickEvents.forEach(function (e) {
                        n.addEventListener(e, function (e) {
                            e.preventDefault(), t.preview.innerHTML = "", t.element.value = e.target.classList, t.preview.appendChild(e.target.cloneNode(!0)), t.modal.classList.remove("is-active")
                        })
                    }), n
                }
            }, {
                key: "createModal",
                value: function () {
                    var e = this;
                    this.modal = document.createElement("div"), this.modal.className = "modal", this.modal.classList.add("iconpicker-modal"), this.modal.id = this.id;
                    var t = document.createElement("div");
                    t.className = "modal-background";
                    var n = document.createElement("div");
                    n.className = "modal-card";
                    var i = document.createElement("header");
                    i.className = "modal-card-head";
                    var r = document.createElement("p");
                    r.className = "modal-card-title", r.innerHTML = "iconPicker", this.modalHeaderSearch = document.createElement("input"), this.modalHeaderSearch.setAttribute("type", "search"), this.modalHeaderSearch.setAttribute("placeholder", "Search"), this.modalHeaderSearch.className = "iconpicker-search", this.modalHeaderSearch.addEventListener("input", function (t) {
                        e.filter(t.target.value)
                    });
                    var a = document.createElement("button");
                    if (a.className = "delete", this._clickEvents.forEach(function (t) {
                            a.addEventListener(t, function (t) {
                                t.preventDefault(), e.modal.classList.remove("is-active")
                            })
                        }), n.appendChild(i), this.modalBody = document.createElement("section"), this.modalBody.className = "modal-card-body", this.options.iconSets.length >= 1) {
                        var o = document.createElement("div");
                        o.className = "iconpicker-sets", o.classList.add("tabs"), this.modalSetTabs = document.createElement("ul"), this.options.iconSets.forEach(function (t) {
                            var n = document.createElement("li"),
                                i = document.createElement("a");
                            i.dataset.iconset = t.name, i.innerHTML = t.name, e._clickEvents.forEach(function (t) {
                                i.addEventListener(t, function (t) {
                                    t.preventDefault();
                                    var n = e.modalSetTabs.querySelectorAll(".is-active");
                                    [].forEach.call(n, function (e) {
                                        e.classList.remove("is-active")
                                    }), t.target.parentNode.classList.add("is-active"), e.drawIcons(e.icons[t.target.dataset.iconset]), e.filter(e.modalHeaderSearch.value)
                                })
                            }), n.appendChild(i), e.modalSetTabs.appendChild(n)
                        }), o.appendChild(this.modalSetTabs), n.appendChild(o)
                    }
                    this.iconsList = document.createElement("div"), this.iconsList.className = "iconpicker-icons", i.appendChild(r), i.appendChild(this.modalHeaderSearch), i.appendChild(a), this.modalBody.appendChild(this.iconsList), n.appendChild(this.modalBody), this.modal.appendChild(t), this.modal.appendChild(n), document.body.appendChild(this.modal)
                }
            }, {
                key: "filter",
                value: function () {
                    var e = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : "";
                    "" !== e ? (this.iconsList.querySelectorAll("[data-filter]").forEach(function (e) {
                        e.classList.remove("is-hidden")
                    }), this.iconsList.querySelectorAll('[data-filter]:not([data-filter*="' + e + '"])').forEach(function (e) {
                        e.classList.add("is-hidden")
                    })) : this.iconsList.querySelectorAll("[data-filter]").forEach(function (e) {
                        e.classList.remove("is-hidden")
                    })
                }
            }], [{
                key: "attach",
                value: function () {
                    var e = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : '[data-action="iconPicker"]',
                        n = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {},
                        i = new Array,
                        r = document.querySelectorAll(e);
                    return [].forEach.call(r, function (e) {
                        setTimeout(function () {
                            i.push(new t(e, n))
                        }, 100)
                    }), i
                }
            }]), t
        }();
        t.default = c
    }, function (e, t, n) {
        "use strict";
        var i = function () {
            function e(e, t) {
                for (var n = 0; n < t.length; n++) {
                    var i = t[n];
                    i.enumerable = i.enumerable || !1, i.configurable = !0, "value" in i && (i.writable = !0), Object.defineProperty(e, i.key, i)
                }
            }
            return function (t, n, i) {
                return n && e(t.prototype, n), i && e(t, i), t
            }
        }();
        var r = function () {
            function e() {
                var t = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : [];
                ! function (e, t) {
                    if (!(e instanceof t)) throw new TypeError("Cannot call a class as a function")
                }(this, e), this._listeners = new Map(t), this._middlewares = new Map
            }
            return i(e, [{
                key: "listenerCount",
                value: function (e) {
                    return this._listeners.has(e) ? this._listeners.get(e).length : 0
                }
            }, {
                key: "removeListeners",
                value: function () {
                    var e = this,
                        t = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : null,
                        n = arguments.length > 1 && void 0 !== arguments[1] && arguments[1];
                    null !== t ? Array.isArray(t) ? name.forEach(function (t) {
                        return e.removeListeners(t, n)
                    }) : (this._listeners.delete(t), n && this.removeMiddleware(t)) : this._listeners = new Map
                }
            }, {
                key: "middleware",
                value: function (e, t) {
                    var n = this;
                    Array.isArray(e) ? name.forEach(function (e) {
                        return n.middleware(e, t)
                    }) : (Array.isArray(this._middlewares.get(e)) || this._middlewares.set(e, []), this._middlewares.get(e).push(t))
                }
            }, {
                key: "removeMiddleware",
                value: function () {
                    var e = this,
                        t = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : null;
                    null !== t ? Array.isArray(t) ? name.forEach(function (t) {
                        return e.removeMiddleware(t)
                    }) : this._middlewares.delete(t) : this._middlewares = new Map
                }
            }, {
                key: "on",
                value: function (e, t) {
                    var n = this,
                        i = arguments.length > 2 && void 0 !== arguments[2] && arguments[2];
                    if (Array.isArray(e)) e.forEach(function (e) {
                        return n.on(e, t)
                    });
                    else {
                        var r = (e = e.toString()).split(/,|, | /);
                        r.length > 1 ? r.forEach(function (e) {
                            return n.on(e, t)
                        }) : (Array.isArray(this._listeners.get(e)) || this._listeners.set(e, []), this._listeners.get(e).push({
                            once: i,
                            callback: t
                        }))
                    }
                }
            }, {
                key: "once",
                value: function (e, t) {
                    this.on(e, t, !0)
                }
            }, {
                key: "emit",
                value: function (e, t) {
                    var n = this,
                        i = arguments.length > 2 && void 0 !== arguments[2] && arguments[2];
                    e = e.toString();
                    var r = this._listeners.get(e),
                        a = null,
                        o = 0,
                        s = i;
                    if (Array.isArray(r))
                        for (r.forEach(function (c, l) {
                                i || (a = n._middlewares.get(e), Array.isArray(a) ? (a.forEach(function (n) {
                                    n(t, function () {
                                        var e = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : null;
                                        null !== e && (t = e), o++
                                    }, e)
                                }), o >= a.length && (s = !0)) : s = !0), s && (c.once && (r[l] = null), c.callback(t))
                            }); - 1 !== r.indexOf(null);) r.splice(r.indexOf(null), 1)
                }
            }]), e
        }();
        t.a = r
    }, function (e, t, n) {
        "use strict";
        t.a = {
            iconSets: [{
                name: "simpleLine",
                css: "https://cdnjs.cloudflare.com/ajax/libs/simple-line-icons/2.4.1/css/simple-line-icons.css",
                prefix: "icon-",
                displayPrefix: ""
            }, {
                name: "Linearicons",
                css: "https://cdn.linearicons.com/free/1.0.0/icon-font.min.css",
                prefix: "lnr",
                displayPrefix: "lnr lnr-icon"
            }]
        }
    }]).default
});
! function (t, e) {
    "object" == typeof exports && "object" == typeof module ? module.exports = e() : "function" == typeof define && define.amd ? define([], e) : "object" == typeof exports ? exports.bulmaSteps = e() : t.bulmaSteps = e()
}("undefined" != typeof self ? self : this, function () {
    return function (t) {
        var e = {};

        function n(s) {
            if (e[s]) return e[s].exports;
            var i = e[s] = {
                i: s,
                l: !1,
                exports: {}
            };
            return t[s].call(i.exports, i, i.exports, n), i.l = !0, i.exports
        }
        return n.m = t, n.c = e, n.d = function (t, e, s) {
            n.o(t, e) || Object.defineProperty(t, e, {
                configurable: !1,
                enumerable: !0,
                get: s
            })
        }, n.n = function (t) {
            var e = t && t.__esModule ? function () {
                return t.default
            } : function () {
                return t
            };
            return n.d(e, "a", e), e
        }, n.o = function (t, e) {
            return Object.prototype.hasOwnProperty.call(t, e)
        }, n.p = "", n(n.s = 0)
    }([function (t, e, n) {
        "use strict";
        Object.defineProperty(e, "__esModule", {
            value: !0
        });
        var s = n(1),
            i = n(2),
            o = Object.assign || function (t) {
                for (var e = 1; e < arguments.length; e++) {
                    var n = arguments[e];
                    for (var s in n) Object.prototype.hasOwnProperty.call(n, s) && (t[s] = n[s])
                }
                return t
            },
            r = function () {
                function t(t, e) {
                    for (var n = 0; n < e.length; n++) {
                        var s = e[n];
                        s.enumerable = s.enumerable || !1, s.configurable = !0, "value" in s && (s.writable = !0), Object.defineProperty(t, s.key, s)
                    }
                }
                return function (e, n, s) {
                    return n && t(e.prototype, n), s && t(e, s), e
                }
            }(),
            l = Symbol("onStepsPrevious"),
            a = Symbol("onStepsNext"),
            u = function (t) {
                function e(t) {
                    var n = 1 < arguments.length && void 0 !== arguments[1] ? arguments[1] : {};
                    ! function (t, n) {
                        if (!(t instanceof e)) throw new TypeError("Cannot call a class as a function")
                    }(this);
                    var s = function (t, e) {
                        if (!t) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
                        return !e || "object" != typeof e && "function" != typeof e ? t : e
                    }(this, (e.__proto__ || Object.getPrototypeOf(e)).call(this));
                    if (s.element = "string" == typeof t ? document.querySelector(t) : t, !s.element) throw new Error("An invalid selector or non-DOM node has been provided.");
                    return s._clickEvents = ["click"], s.options = o({}, i.a, n), s[l] = s[l].bind(s), s[a] = s[a].bind(s), s.init(), s
                }
                return function (t, e) {
                    if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function, not " + typeof e);
                    t.prototype = Object.create(e && e.prototype, {
                        constructor: {
                            value: t,
                            enumerable: !1,
                            writable: !0,
                            configurable: !0
                        }
                    }), e && (Object.setPrototypeOf ? Object.setPrototypeOf(t, e) : t.__proto__ = e)
                }(e, s.a), r(e, [{
                    key: "init",
                    value: function () {
                        this._id = "bulmaSteps" + (new Date).getTime() + Math.floor(Math.random() * Math.floor(9999)), this.steps = this.element.querySelectorAll(this.options.selector), this.contents = this.element.querySelectorAll(this.options.selector_content), this.previous_btn = this.element.querySelector(this.options.previous_selector), this.next_btn = this.element.querySelector(this.options.next_selector), [].forEach.call(this.steps, function (t, e) {
                            t.setAttribute("data-step-id", e)
                        }), this.steps && this.steps.length && (this.activate_step(0), this.updateActions(this.steps[0])), this._bindEvents(), this.emit("bulmasteps:ready", this.element.value)
                    }
                }, {
                    key: "_bindEvents",
                    value: function () {
                        var t = this;
                        null != this.previous_btn && this._clickEvents.forEach(function (e) {
                            t.previous_btn.addEventListener(e, t[l], !1)
                        }), null != this.next_btn && this._clickEvents.forEach(function (e) {
                            t.next_btn.addEventListener(e, t[a], !1)
                        }), this.options.stepClickable && [].forEach.call(this.steps, function (e, n) {
                            t._clickEvents.forEach(function (e) {
                                for (; n > t.current_id;) t[a](e);
                                for (; n < t.current_id;) t[l](e)
                            })
                        })
                    }
                }, {
                    key: l,
                    value: function (t) {
                        t.preventDefault(), t.target.getAttribute("disabled") || this.previous_step()
                    }
                }, {
                    key: a,
                    value: function (t) {
                        t.preventDefault(), t.target.getAttribute("disabled") || this.next_step()
                    }
                }, {
                    key: "get_current_step_id",
                    value: function () {
                        for (var t = 0; t < this.steps.length; t++) {
                            var e = this.steps[t];
                            if (e.classList.contains(this.options.active_class)) return parseInt(e.getAttribute("data-step-id"))
                        }
                        return null
                    }
                }, {
                    key: "updateActions",
                    value: function (t) {
                        var e = parseInt(t.getAttribute("data-step-id"));
                        0 == e ? (null != this.previous_btn && this.previous_btn.setAttribute("disabled", "disabled"), null != this.next_btn && this.next_btn.removeAttribute("disabled", "disabled")) : e == this.steps.length - 1 ? (null != this.previous_btn && this.previous_btn.removeAttribute("disabled", "disabled"), null != this.next_btn && this.next_btn.setAttribute("disabled", "disabled")) : (null != this.previous_btn && this.previous_btn.removeAttribute("disabled", "disabled"), null != this.next_btn && this.next_btn.removeAttribute("disabled", "disabled"))
                    }
                }, {
                    key: "next_step",
                    value: function () {
                        var t = this.get_current_step_id();
                        if (null != t) {
                            var e = t + 1,
                                n = [];
                            if (void 0 !== this.options.beforeNext && null != this.options.beforeNext && this.options.beforeNext && (n = this.options.beforeNext(t)), this.emit("bulmasteps:before:next", t), void 0 === n && (n = []), 0 < n.length) {
                                this.emit("bulmasteps:errors", n);
                                for (var s = 0; s < n.length; s++) void 0 !== this.options.onError && null != this.options.onError && this.options.onError && this.options.onError(n[s])
                            } else e >= this.steps.length - 1 && (void 0 !== this.options.onFinish && null != this.options.onFinish && this.options.onFinish && this.options.onFinish(t), this.emit("bulmasteps:finish", t)), e < this.steps.length && (this.complete_step(t), this.activate_step(e))
                        }
                    }
                }, {
                    key: "previous_step",
                    value: function () {
                        var t = this.get_current_step_id();
                        null != t && (this.uncomplete_step(t - 1), this.activate_step(t - 1))
                    }
                }, {
                    key: "activate_step",
                    value: function (t) {
                        this.updateActions(this.steps[t]);
                        for (var e = 0; e < this.steps.length; e++) this.steps[e] != this.steps[t] && this.deactivate_step(e);
                        this.steps[t].classList.add(this.options.active_class), void 0 !== this.contents[t] && this.contents[t].classList.add(this.options.active_class), void 0 !== this.options.onShow && null != this.options.onShow && this.options.onShow && this.options.onShow(t), this.emit("bulmasteps:step:show", t)
                    }
                }, {
                    key: "complete_step",
                    value: function (t) {
                        this.steps[t].classList.add(this.options.completed_class), this.emit("bulmasteps:step:completed", t)
                    }
                }, {
                    key: "uncomplete_step",
                    value: function (t) {
                        this.steps[t].classList.remove(this.options.completed_class), this.emit("bulmasteps:step:uncompleted", t)
                    }
                }, {
                    key: "deactivate_step",
                    value: function (t) {
                        this.steps[t].classList.remove(this.options.active_class), void 0 !== this.contents[t] && this.contents[t].classList.remove(this.options.active_class)
                    }
                }], [{
                    key: "attach",
                    value: function () {
                        var t = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : ".steps",
                            n = 1 < arguments.length && void 0 !== arguments[1] ? arguments[1] : {},
                            s = new Array,
                            i = document.querySelectorAll(t);
                        return [].forEach.call(i, function (t) {
                            setTimeout(function () {
                                s.push(new e(t, n))
                            }, 100)
                        }), s
                    }
                }]), e
            }();
        e.default = u
    }, function (t, e, n) {
        "use strict";
        var s = function () {
                function t(t, e) {
                    for (var n = 0; n < e.length; n++) {
                        var s = e[n];
                        s.enumerable = s.enumerable || !1, s.configurable = !0, "value" in s && (s.writable = !0), Object.defineProperty(t, s.key, s)
                    }
                }
                return function (e, n, s) {
                    return n && t(e.prototype, n), s && t(e, s), e
                }
            }(),
            i = function () {
                function t() {
                    var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : [];
                    ! function (t, e) {
                        if (!(t instanceof e)) throw new TypeError("Cannot call a class as a function")
                    }(this, t), this._listeners = new Map(e), this._middlewares = new Map
                }
                return s(t, [{
                    key: "listenerCount",
                    value: function (t) {
                        return this._listeners.has(t) ? this._listeners.get(t).length : 0
                    }
                }, {
                    key: "removeListeners",
                    value: function () {
                        var t = this,
                            e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : null,
                            n = 1 < arguments.length && void 0 !== arguments[1] && arguments[1];
                        null !== e ? Array.isArray(e) ? name.forEach(function (e) {
                            return t.removeListeners(e, n)
                        }) : (this._listeners.delete(e), n && this.removeMiddleware(e)) : this._listeners = new Map
                    }
                }, {
                    key: "middleware",
                    value: function (t, e) {
                        var n = this;
                        Array.isArray(t) ? name.forEach(function (t) {
                            return n.middleware(t, e)
                        }) : (Array.isArray(this._middlewares.get(t)) || this._middlewares.set(t, []), this._middlewares.get(t).push(e))
                    }
                }, {
                    key: "removeMiddleware",
                    value: function () {
                        var t = this,
                            e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : null;
                        null !== e ? Array.isArray(e) ? name.forEach(function (e) {
                            return t.removeMiddleware(e)
                        }) : this._middlewares.delete(e) : this._middlewares = new Map
                    }
                }, {
                    key: "on",
                    value: function (t, e) {
                        var n = this,
                            s = 2 < arguments.length && void 0 !== arguments[2] && arguments[2];
                        if (Array.isArray(t)) t.forEach(function (t) {
                            return n.on(t, e)
                        });
                        else {
                            var i = (t = t.toString()).split(/,|, | /);
                            1 < i.length ? i.forEach(function (t) {
                                return n.on(t, e)
                            }) : (Array.isArray(this._listeners.get(t)) || this._listeners.set(t, []), this._listeners.get(t).push({
                                once: s,
                                callback: e
                            }))
                        }
                    }
                }, {
                    key: "once",
                    value: function (t, e) {
                        this.on(t, e, !0)
                    }
                }, {
                    key: "emit",
                    value: function (t, e) {
                        var n = this,
                            s = 2 < arguments.length && void 0 !== arguments[2] && arguments[2];
                        t = t.toString();
                        var i = this._listeners.get(t),
                            o = null,
                            r = 0,
                            l = s;
                        if (Array.isArray(i))
                            for (i.forEach(function (a, u) {
                                    s || (o = n._middlewares.get(t), Array.isArray(o) ? (o.forEach(function (n) {
                                        n(e, function () {
                                            var t = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : null;
                                            null !== t && (e = t), r++
                                        }, t)
                                    }), r >= o.length && (l = !0)) : l = !0), l && (a.once && (i[u] = null), a.callback(e))
                                }); - 1 !== i.indexOf(null);) i.splice(i.indexOf(null), 1)
                    }
                }]), t
            }();
        e.a = i
    }, function (t, e, n) {
        "use strict";
        e.a = {
            selector: ".step-item",
            selector_content: ".step-content",
            previous_selector: '[data-nav="previous"]',
            next_selector: '[data-nav="next"]',
            active_class: "is-active",
            completed_class: "is-completed",
            stepClickable: !1,
            beforeNext: null,
            onShow: null,
            onFinish: null,
            onError: null
        }
    }]).default
});
! function (e, t) {
    "object" == typeof exports && "object" == typeof module ? module.exports = t() : "function" == typeof define && define.amd ? define([], t) : "object" == typeof exports ? exports.bulmaTagsinput = t() : e.bulmaTagsinput = t()
}("undefined" != typeof self ? self : this, function () {
    return function (e) {
        var t = {};

        function n(i) {
            if (t[i]) return t[i].exports;
            var r = t[i] = {
                i: i,
                l: !1,
                exports: {}
            };
            return e[i].call(r.exports, r, r.exports, n), r.l = !0, r.exports
        }
        return n.m = e, n.c = t, n.d = function (e, t, i) {
            n.o(e, t) || Object.defineProperty(e, t, {
                configurable: !1,
                enumerable: !0,
                get: i
            })
        }, n.n = function (e) {
            var t = e && e.__esModule ? function () {
                return e.default
            } : function () {
                return e
            };
            return n.d(t, "a", t), t
        }, n.o = function (e, t) {
            return Object.prototype.hasOwnProperty.call(e, t)
        }, n.p = "", n(n.s = 0)
    }([function (e, t, n) {
        "use strict";
        Object.defineProperty(t, "__esModule", {
            value: !0
        });
        var i = n(1),
            r = n(2),
            a = n(3),
            s = Object.assign || function (e) {
                for (var t = 1; t < arguments.length; t++) {
                    var n = arguments[t];
                    for (var i in n) Object.prototype.hasOwnProperty.call(n, i) && (e[i] = n[i])
                }
                return e
            },
            o = function () {
                function e(e, t) {
                    for (var n = 0; n < t.length; n++) {
                        var i = t[n];
                        i.enumerable = i.enumerable || !1, i.configurable = !0, "value" in i && (i.writable = !0), Object.defineProperty(e, i.key, i)
                    }
                }
                return function (t, n, i) {
                    return n && e(t.prototype, n), i && e(t, i), t
                }
            }(),
            l = function (e) {
                function t(e) {
                    var n = 1 < arguments.length && void 0 !== arguments[1] ? arguments[1] : {};
                    ! function (e, n) {
                        if (!(e instanceof t)) throw new TypeError("Cannot call a class as a function")
                    }(this);
                    var i = function (e, t) {
                        if (!e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
                        return !t || "object" != typeof t && "function" != typeof t ? e : t
                    }(this, (t.__proto__ || Object.getPrototypeOf(t)).call(this));
                    if (i.element = a.a(e) ? document.querySelector(e) : e, !i.element) throw new Error("An invalid selector or non-DOM node has been provided.");
                    return i._clickEvents = ["click"], i.options = s({}, r.a, n), i.element.dataset.hasOwnProperty("lowercase") && (i.options.lowercase = i.element.dataset("lowercase")), i.element.dataset.hasOwnProperty("uppercase") && (i.options.lowercase = i.element.dataset("uppercase")), i.element.dataset.hasOwnProperty("duplicates") && (i.options.lowercase = i.element.dataset("duplicates")), i.init(), i
                }
                return function (e, t) {
                    if ("function" != typeof t && null !== t) throw new TypeError("Super expression must either be null or a function, not " + typeof t);
                    e.prototype = Object.create(t && t.prototype, {
                        constructor: {
                            value: e,
                            enumerable: !1,
                            writable: !0,
                            configurable: !0
                        }
                    }), t && (Object.setPrototypeOf ? Object.setPrototypeOf(e, t) : e.__proto__ = t)
                }(t, i.a), o(t, [{
                    key: "init",
                    value: function () {
                        if (!this.options.disabled) {
                            this.tags = [], this.container = document.createElement("div"), this.container.className = "tagsinput", this.container.classList.add("field"), this.container.classList.add("is-grouped"), this.container.classList.add("is-grouped-multiline"), this.container.classList.add("input");
                            var e = this.element.getAttribute("type");
                            e && "tags" !== e || (e = "text"), this.input = document.createElement("input"), this.input.setAttribute("type", e), this.element.getAttribute("placeholder") ? this.input.setAttribute("placeholder", this.element.getAttribute("placeholder")) : this.input.setAttribute("placeholder", "Add a Tag"), this.container.appendChild(this.input);
                            var t = this.element.nextSibling;
                            this.element.parentNode[t ? "insertBefore" : "appendChild"](this.container, t), this.element.style.cssText = "position:absolute;left:0;top:0;width:1px;height:1px;opacity:0.01;", this.element.tabIndex = -1, this.enable()
                        }
                    }
                }, {
                    key: "enable",
                    value: function () {
                        var e = this;
                        this.enabled || this.options.disabled || (this.element.addEventListener("focus", function () {
                            e.container.classList.add("is-focused"), e.select(Array.prototype.slice.call(e.container.querySelectorAll(".tag:not(.is-delete)")).pop())
                        }), this.input.addEventListener("focus", function () {
                            e.container.classList.add("is-focused"), e.select(Array.prototype.slice.call(e.container.querySelectorAll(".tag:not(.is-delete)")).pop())
                        }), this.input.addEventListener("blur", function () {
                            e.container.classList.remove("is-focused"), e.select(Array.prototype.slice.call(e.container.querySelectorAll(".tag:not(.is-delete)")).pop()), e.savePartial()
                        }), this.input.addEventListener("keydown", function (t) {
                            var n = t.charCode || t.keyCode || t.which,
                                i = void 0,
                                r = e.container.querySelector(".tag.is-active"),
                                a = Array.prototype.slice.call(e.container.querySelectorAll(".tag:not(.is-delete)")).pop(),
                                s = e.caretAtStart(e.input);
                            if (r && (i = e.container.querySelector('[data-tag="' + r.innerHTML.trim() + '"]')), e.setInputWidth(), 13 === n || n === e.options.delimiter.charCodeAt(0) || 188 === n || 9 === n) {
                                if (!e.input.value && (n !== e.options.delimiter.charCodeAt(0) || 188 === n)) return;
                                e.savePartial()
                            } else if (46 === n && i) i.nextSibling ? e.select(i.nextSibling.querySelector(".tag")) : i.previousSibling && e.select(i.previousSibling.querySelector(".tag")), e.container.removeChild(i), e.tags.splice(e.tags.indexOf(i.getAttribute("data-tag")), 1), e.setInputWidth(), e.save();
                            else if (8 === n)
                                if (i) i.previousSibling ? e.select(i.previousSibling.querySelector(".tag")) : i.nextSibling && e.select(i.nextSibling.querySelector(".tag")), e.container.removeChild(i), e.tags.splice(e.tags.indexOf(i.getAttribute("data-tag")), 1), e.setInputWidth(), e.save();
                                else {
                                    if (!a || !s) return;
                                    e.select(a)
                                }
                            else if (37 === n)
                                if (i) i.previousSibling && e.select(i.previousSibling.querySelector(".tag"));
                                else {
                                    if (!s) return;
                                    e.select(a)
                                }
                            else {
                                if (39 !== n) return e.select();
                                if (!i) return;
                                e.select(i.nextSibling.querySelector(".tag"))
                            }
                            return t.preventDefault(), !1
                        }), this.input.addEventListener("input", function () {
                            e.element.value = e.getValue(), e.element.dispatchEvent(new Event("input"))
                        }), this.input.addEventListener("paste", function () {
                            return setTimeout(savePartial, 0)
                        }), this.container.addEventListener("mousedown", function (t) {
                            e.refocus(t)
                        }), this.container.addEventListener("touchstart", function (t) {
                            e.refocus(t)
                        }), this.savePartial(this.element.value), this.enabled = !0)
                    }
                }, {
                    key: "disable",
                    value: function () {
                        this.enabled && !this.options.disabled && (this.reset(), this.enabled = !1)
                    }
                }, {
                    key: "select",
                    value: function (e) {
                        var t = this.container.querySelector(".is-active");
                        t && t.classList.remove("is-active"), e && e.classList.add("is-active")
                    }
                }, {
                    key: "addTag",
                    value: function (e) {
                        var t = this;
                        if (~e.indexOf(this.options.delimiter) && (e = e.split(this.options.delimiter)), Array.isArray(e)) return e.forEach(function (e) {
                            t.addTag(e)
                        });
                        var n = e && e.trim();
                        if (!n) return !1;
                        if ("true" == this.options.lowercase && (n = n.toLowerCase()), "true" == this.options.uppercase && (n = n.toUpperCase()), this.options.duplicates || -1 === this.tags.indexOf(n)) {
                            this.tags.push(n);
                            var i = document.createElement("div");
                            i.className = "control", i.setAttribute("data-tag", n);
                            var r = document.createElement("div");
                            r.className = "tags", r.classList.add("has-addons");
                            var a = document.createElement("span");
                            if (a.className = "tag", a.classList.add("is-active"), this.select(a), a.innerHTML = n, r.appendChild(a), this.options.allowDelete) {
                                var s = document.createElement("a");
                                s.className = "tag", s.classList.add("is-delete"), this._clickEvents.forEach(function (e) {
                                    s.addEventListener(e, function (e) {
                                        var n = void 0,
                                            i = e.target.parentNode,
                                            r = Array.prototype.slice.call(t.container.querySelectorAll(".tag")).pop(),
                                            a = t.caretAtStart(t.input);
                                        if (i && (n = t.container.querySelector('[data-tag="' + i.innerText.trim() + '"]')), n) t.select(n.previousSibling), t.container.removeChild(n), t.tags.splice(t.tags.indexOf(n.getAttribute("data-tag")), 1), t.setInputWidth(), t.save();
                                        else {
                                            if (!r || !a) return;
                                            t.select(r)
                                        }
                                    })
                                }), r.appendChild(s)
                            }
                            i.appendChild(r), this.container.insertBefore(i, this.input)
                        }
                    }
                }, {
                    key: "getValue",
                    value: function () {
                        return this.tags.join(this.options.delimiter)
                    }
                }, {
                    key: "setValue",
                    value: function (e) {
                        var t = this;
                        Array.prototype.slice.call(this.container.querySelectorAll(".tag")).forEach(function (e) {
                            t.tags.splice(t.tags.indexOf(e.innerHTML), 1), t.container.removeChild(e)
                        }), this.savePartial(e)
                    }
                }, {
                    key: "setInputWidth",
                    value: function () {
                        var e = Array.prototype.slice.call(this.container.querySelectorAll(".control")).pop();
                        this.container.offsetWidth && (this.input.style.width = Math.max(this.container.offsetWidth - (e ? e.offsetLeft + e.offsetWidth : 30) - 30, this.container.offsetWidth / 4) + "px")
                    }
                }, {
                    key: "savePartial",
                    value: function (e) {
                        "string" == typeof e || Array.isArray(e) || (e = this.input.value), !1 !== this.addTag(e) && (this.input.value = "", this.save(), this.setInputWidth())
                    }
                }, {
                    key: "save",
                    value: function () {
                        this.element.value = this.tags.join(this.options.delimiter), this.element.dispatchEvent(new Event("change"))
                    }
                }, {
                    key: "caretAtStart",
                    value: function (e) {
                        try {
                            return 0 === e.selectionStart && 0 === e.selectionEnd
                        } catch (t) {
                            return "" === e.value
                        }
                    }
                }, {
                    key: "refocus",
                    value: function (e) {
                        return e.target.classList.contains("tag") && this.select(e.target), e.target === this.input ? this.select() : (this.input.focus(), e.preventDefault(), !1)
                    }
                }, {
                    key: "reset",
                    value: function () {
                        this.tags = []
                    }
                }, {
                    key: "destroy",
                    value: function () {
                        this.disable(), this.reset(), this.element = null
                    }
                }], [{
                    key: "attach",
                    value: function () {
                        var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : 'input[type="tags"]',
                            n = 1 < arguments.length && void 0 !== arguments[1] ? arguments[1] : {},
                            i = new Array,
                            r = document.querySelectorAll(e);
                        return [].forEach.call(r, function (e) {
                            setTimeout(function () {
                                i.push(new t(e, n))
                            }, 100)
                        }), i
                    }
                }]), t
            }();
        t.default = l
    }, function (e, t, n) {
        "use strict";
        var i = function () {
                function e(e, t) {
                    for (var n = 0; n < t.length; n++) {
                        var i = t[n];
                        i.enumerable = i.enumerable || !1, i.configurable = !0, "value" in i && (i.writable = !0), Object.defineProperty(e, i.key, i)
                    }
                }
                return function (t, n, i) {
                    return n && e(t.prototype, n), i && e(t, i), t
                }
            }(),
            r = function () {
                function e() {
                    var t = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : [];
                    ! function (e, t) {
                        if (!(e instanceof t)) throw new TypeError("Cannot call a class as a function")
                    }(this, e), this._listeners = new Map(t), this._middlewares = new Map
                }
                return i(e, [{
                    key: "listenerCount",
                    value: function (e) {
                        return this._listeners.has(e) ? this._listeners.get(e).length : 0
                    }
                }, {
                    key: "removeListeners",
                    value: function () {
                        var e = this,
                            t = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : null,
                            n = 1 < arguments.length && void 0 !== arguments[1] && arguments[1];
                        null !== t ? Array.isArray(t) ? name.forEach(function (t) {
                            return e.removeListeners(t, n)
                        }) : (this._listeners.delete(t), n && this.removeMiddleware(t)) : this._listeners = new Map
                    }
                }, {
                    key: "middleware",
                    value: function (e, t) {
                        var n = this;
                        Array.isArray(e) ? name.forEach(function (e) {
                            return n.middleware(e, t)
                        }) : (Array.isArray(this._middlewares.get(e)) || this._middlewares.set(e, []), this._middlewares.get(e).push(t))
                    }
                }, {
                    key: "removeMiddleware",
                    value: function () {
                        var e = this,
                            t = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : null;
                        null !== t ? Array.isArray(t) ? name.forEach(function (t) {
                            return e.removeMiddleware(t)
                        }) : this._middlewares.delete(t) : this._middlewares = new Map
                    }
                }, {
                    key: "on",
                    value: function (e, t) {
                        var n = this,
                            i = 2 < arguments.length && void 0 !== arguments[2] && arguments[2];
                        if (Array.isArray(e)) e.forEach(function (e) {
                            return n.on(e, t)
                        });
                        else {
                            var r = (e = e.toString()).split(/,|, | /);
                            1 < r.length ? r.forEach(function (e) {
                                return n.on(e, t)
                            }) : (Array.isArray(this._listeners.get(e)) || this._listeners.set(e, []), this._listeners.get(e).push({
                                once: i,
                                callback: t
                            }))
                        }
                    }
                }, {
                    key: "once",
                    value: function (e, t) {
                        this.on(e, t, !0)
                    }
                }, {
                    key: "emit",
                    value: function (e, t) {
                        var n = this,
                            i = 2 < arguments.length && void 0 !== arguments[2] && arguments[2];
                        e = e.toString();
                        var r = this._listeners.get(e),
                            a = null,
                            s = 0,
                            o = i;
                        if (Array.isArray(r))
                            for (r.forEach(function (l, c) {
                                    i || (a = n._middlewares.get(e), Array.isArray(a) ? (a.forEach(function (n) {
                                        n(t, function () {
                                            var e = 0 < arguments.length && void 0 !== arguments[0] ? arguments[0] : null;
                                            null !== e && (t = e), s++
                                        }, e)
                                    }), s >= a.length && (o = !0)) : o = !0), o && (l.once && (r[c] = null), l.callback(t))
                                }); - 1 !== r.indexOf(null);) r.splice(r.indexOf(null), 1)
                    }
                }]), e
            }();
        t.a = r
    }, function (e, t, n) {
        "use strict";
        t.a = {
            disabled: !1,
            delimiter: ",",
            allowDelete: !0,
            lowercase: !1,
            uppercase: !1,
            duplicates: !0
        }
    }, function (e, t, n) {
        "use strict";
        n.d(t, "a", function () {
            return r
        });
        var i = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (e) {
                return typeof e
            } : function (e) {
                return e && "function" == typeof Symbol && e.constructor === Symbol && e !== Symbol.prototype ? "symbol" : typeof e
            },
            r = function (e) {
                return "string" == typeof e || !!e && "object" === (void 0 === e ? "undefined" : i(e)) && "[object String]" === Object.prototype.toString.call(e)
            }
    }]).default
});
"use strict";
initPageLoader(), $(document).ready(function (i) {
    const n = document.querySelectorAll("[data-lazy-load]");
    lozad(n, {
        loaded: function (i) {
            i.parentNode.classList.add("loaded")
        }
    }).observe(), "development" === env && changeDemoImages(), feather.replace(), initNavbar(), initLandingNavbar(), initMobileMenu(), initLandingMobileMenu(), initEcommerceNavbar(), initNavbarDropdown(), initSidebar(), initThemeSwitcher(), initBackgroundImages(), initSlider(), initDropdowns(), initTabsNav(), initNavigationTabs(), initVerticalTabs(), initMediaCards(), initTiltCards(), initPopovers(), initTooltips(), initModals(), initCounters(), initSimpleAccordion(), initAccordions(), initToasts(), initCountdown(), initBasicCarousel(), initVerticalCarousel(), initFlatCarousel(), initImageCarousel(), initSingleImageCarousel(), initMultipleImagesCarousel(), initDatepicker(), initTimepicker(), initDatepickerAlt(), initChosenSelects(), initMaterialSelect(), initAutocompletes(), initFileInputs(), initRangeInput(), initRangeInputs(), initJqueryTagInput(), initBulmaTags(), initBulmaSteps(), initBulmaIconpicker(), initBulmaCalendar(), initComboBox(), initImageComboBox(), initStackedComboBox(), initFileUploader(), initVideoEmbed(), initBackgroundVideo(), initPlayers(), initDemo(), initScrollspyNav(), initParallax(), initBackToTop(), initGitem(), initAnchorScroll(), initQuickview(), initScrollReveal(), initMarquee(), initMockup(), initClientsCarousel(), initPeopleCarousel(), initCustomCarousel(), initCarousel(), initLandingCarousel(), initTestimonials(), initCharacterTestimonials(), initPricing(), initPricingCarousel(), initTabbedPricing(), initFreelancerPricing(), initSwitchPricing(), initBoxedPricing(), initOnePagePricing(), initSearchBox(), initNavigationDots(), initFaq(), initAuth(), initAnimations(), initCanvas(), initParticles(), initAnimatedSvg(), initChatWidget(), initContactToggler(), initGoogleMap(), initMapBox(), initCodeTabs()
});
//# sourceMappingURL=core.js.map
