@extends('backend.layouts.master')

@section('title')
{{ __('Contacts') }}
@endsection


@section('css')

@endsection

@section('content')

<div class="nk-block nk-block-lg">
    <div class="card card-preview">
        <div class="card-inner">
            <ul class="preview-list ">
                <li class="preview-item">
                    <button type="button" class="btn btn-secondary" data-toggle="modal" data-target="#modalForm"><em
                            class="icon ni ni-users mr-2"></em>{{ __('Add New Contact') }}</button>
                </li>
                <li class="preview-item">
                    <button type="button" class="btn btn-secondary" data-toggle="modal" data-target="#modalTabs">
                        <em class="icon ni ni-file-text mr-2"></em>
                        {{ __('Bulk Export & Import') }}
                    </button>
                </li>
                <li class="preview-item">
                    <a href="{{ route('dashboard.contact.export') }}"
                        class="btn btn-md btn-secondary">
                        <em class="icon ni ni-download mr-2"></em>
                        {{ __('Quick Export') }}
                    </a>
                </li>
                <li class="preview-item d-none">
                    <button type="button" class="btn btn-secondary" data-toggle="modal" data-target="#csv_viewer"><em
                            class="icon ni ni-file mr-2"></em>{{ __('CSV Viewer') }}</button>
                </li>
            </ul>
        </div>
    </div><!-- .card-preview -->

    <div class="card card-preview">
        <div class="card-inner">

            <table class="datatable-init nowrap nk-tb-list nk-tb-ulist" data-auto-responsive="false">
                <thead>
                    <tr class="nk-tb-item nk-tb-head">
                        <th class="nk-tb-col"><span class="sub-text">{{ __('NAME') }}</span></th>
                        <th class="nk-tb-col tb-col-mb"><span
                                class="sub-text">{{ __('PHONE') }}</span></th>
                        <th class="nk-tb-col tb-col-md"><span
                                class="sub-text">{{ __('COUNTRY') }}</span></th>
                        <th class="nk-tb-col tb-col-lg"><span
                                class="sub-text">{{ __('OTHERS') }}</span></th>
                        <th class="nk-tb-col nk-tb-col-tools text-right">
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse(allContacts() as $contact)
                        <tr class="nk-tb-item">
                            <td class="nk-tb-col">
                                <div class="user-card">
                                    <div class="user-info">
                                        <span class="tb-lead">{{ $contact->name }}</span>
                                    </div>
                                </div>
                            </td>
                            <td class="nk-tb-col tb-col-mb" data-order="{{ $contact->phone }}">
                                <span class="tb-amount">{{ $contact->phone }}</span>
                            </td>
                            <td class="nk-tb-col tb-col-md">
                                <span class="tb-lead">{{ $contact->country != null ? Str::upper($contact->country) : '--' }}</span>
                            </td>
                            <td class="nk-tb-col tb-col-lg">
                                <ul>
                                    <li><span class="tb-lead">{{ $contact->gender != null ? $contact->gender : '--' }}</span></li>
                                    <li><span class="tb-lead">{{ $contact->dob != null ? $contact->dob : '--' }}</span></li>
                                    <li><span class="tb-lead">{{ $contact->profession != null ? $contact->profession : '--' }}</span></li>
                                    <li><span class="tb-lead">{{ $contact->reference != null ? $contact->reference : '--' }}</span></li> 
                                </ul>
                            </td>

                            <td class="nk-tb-col nk-tb-col-tools">
                                <ul class="nk-tb-actions gx-1">
                                    <li>
                                        <div class="drodown">
                                            <a href="javascript:;" class="dropdown-toggle btn btn-icon btn-trigger"
                                                data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                            <div class="dropdown-menu dropdown-menu-right">
                                                <ul class="link-list-opt no-bdr">
                                                    <li>
                                                        <a
                                                            href="{{ route('dashboard.contact.show', [$contact->id, Str::slug($contact->name)]) }}">
                                                            <em class="icon ni ni-pen"></em>
                                                            <span>{{ __('Edit') }}</span>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a
                                                            href="{{ route('dashboard.contact.delete', [$contact->id, Str::slug($contact->name)]) }}">
                                                            <em class="icon ni ni-trash"></em>
                                                            <span>{{ __('Remove') }}</span>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </li>
                                </ul>
                            </td>
                        </tr><!-- .nk-tb-item  -->
                    @empty

                    @endforelse
                </tbody>
            </table>

        </div>
    </div><!-- .card-preview -->

</div>
<!-- END: Large Slide Over Toggle -->

<!-- Modal Form -->
<div class="modal fade" tabindex="-1" id="modalForm">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">{{ __('Add New Contact') }}</h4>
                <a href="javascript:;" class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </a>
            </div>
            <div class="modal-body modal-body-lg">
                <form action="{{ route('dashboard.contact.store') }}" class="form-validate is-alter"
                    method="POST" enctype="multipart/form-data">
                    @csrf

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label" for="account_sid">{{ __('Full Name') }}
                                    *</label>
                                <span
                                    class="form-note">{{ __('Specify the full name of the contact') }}.</span>
                            </div>
                        </div>

                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control" id="account_sid" name="name"
                                        value="{{ old('name') }}" placeholder="Full Name" required="">
                                </div>
                            </div>
                        </div>

                    </div>

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label" for="phone">{{ __('Phone Number') }}
                                    *</label>
                                <span
                                    class="form-note">{{ __('Specify the phone number') }}.</span>
                            </div>
                        </div>

                        <div class="col-lg-7">
                            <div class="form-group">
                                <div class="form-control-wrap">
                                    <input type="text" class="form-control" id="phone" name="phone"
                                        value="{{ old('phone') }}" placeholder="Phone Number"
                                        required="">
                                    <small>{{ __('Please provide country code with the phone number') }}</small>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label" for="name">{{ __('Country') }} *</label>
                                <span class="form-note">{{ __('Specify the country') }}.</span>
                            </div>
                        </div>

                        <div class="col-lg-7">
                            <select class="form-select" single="single" data-placeholder="Select Country"
                                name="country">
                                <option value="">{{ __('Select Country') }}</option>
                                @foreach(getCountry() as $key => $country)
                                    <option value="{{ Str::lower($country) }}">
                                        {{ Str::upper($country) }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                    </div>

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label" for="name">{{ __('Gender') }} *</label>
                                <span
                                    class="form-note">{{ __('Specify the contact gender') }}.</span>
                            </div>
                        </div>

                        <div class="col-lg-7">
                            <select class="form-select" single="single" data-placeholder="Select Gender" name="gender">
                                <option value="">{{ __('Select Gender') }}</option>
                                <option value="male">{{ Str::upper('Male') }}</option>
                                <option value="female">{{ Str::upper('Female') }}</option>
                            </select>
                        </div>

                    </div>

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label" for="name">{{ __('Profession') }} *</label>
                                <span
                                    class="form-note">{{ __('Specify the contact profession') }}.</span>
                            </div>
                        </div>

                        <div class="col-lg-7">
                            <select class="form-select" single="single" data-placeholder="Select Profession"
                                name="profession">
                                <option value="">{{ __('Select Profession') }}</option>
                                @foreach(professionList() as $profession)
                                    <option value="{{ Str::lower($profession) }}">{{ Str::upper($profession) }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                    </div>

                    <div class="row g-3 align-center">
                        <div class="col-lg-5">
                            <div class="form-group">
                                <label class="form-label" for="dob">{{ __('Date Of Birth') }}
                                    *</label>
                                <span
                                    class="form-note">{{ __('Specify the name of the provider name') }}.</span>
                            </div>
                        </div>

                        <div class="col-lg-7">
                            <input type="text" class="form-control date-picker" name="dob" id="dob"
                                placeholder="Date of birth">
                        </div>

                    </div>

                    @if(allGroups()->count() > 0)

                        <div class="row g-3 align-center">
                            <div class="col-lg-5">
                                <div class="form-group">
                                    <label class="form-label"
                                        for="name">{{ __('Assign To Groups') }}</label>
                                    <span
                                        class="form-note">{{ __('Specify the group of the contact') }}.</span>
                                </div>
                            </div>

                            <div class="col-lg-7">
                                <select class="form-select" multiple="multiple" data-placeholder="Select Groups"
                                    name="groups_ids[]">
                                    @foreach(allGroups() as $group)
                                        <option value="{{ $group->id }}">{{ Str::upper($group->name) }}</option>
                                    @endforeach
                                </select>
                            </div>

                        </div>

                    @endif


                    <div class="row g-3">
                        <div class="col-lg-7 offset-lg-5">
                            <div class="form-group mt-2">
                                <button type="submit"
                                    class="btn btn-lg btn-secondary">{{ __('Save') }}</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Modal Form -->
<div class="modal fade" tabindex="-1" id="csv_viewer">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">{{ __('Upload CSV To View') }}</h4>
                <a href="javascript:;" class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </a>
            </div>
            <div class="modal-body modal-body-lg">
                <div class="form-control-wrap">
                    <div class="custom-file">
                        <input type="file" class="custom-file-input" id="input-file" accept=".csv">
                        <label class="custom-file-label"
                            for="customFile">{{ __('Choose file') }}</label>
                    </div>
                </div>
                <div class="container-fluid mt-2">
                    <div id="handsontable-container" style="overflow: hidden; height: 350px;"></div>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Export Import -->
<div class="modal fade" tabindex="-1" role="dialog" id="modalTabs">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <a href="javascript:;" class="close" data-dismiss="modal"><em class="icon ni ni-cross-sm"></em></a>
            <div class="modal-body modal-body-md">
                <h4 class="title">{{ __('Export & Import Contacts') }}</h4>
                <ul class="nk-nav nav nav-tabs">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="tab"
                            href="#tabItem1">{{ __('Import Contacts') }}</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="tab"
                            href="#tabItem2">{{ __('Export Contacts') }}</a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="tabItem1">
                        <form action="{{ route('dashboard.contact.import') }}"
                            class="form-validate is-alter" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row g-3 align-center">
                                <div class="col-lg-5">
                                    <div class="form-group">
                                        <label class="form-label"
                                            for="customFile">{{ __('Contacts CSV File') }}</label>
                                        <span
                                            class="form-note">{{ __('Specify the csv file') }}.</span>
                                    </div>
                                </div>

                                <div class="col-lg-7">
                                    <div class="form-group">
                                        <div class="form-control-wrap">
                                            <div class="custom-file">
                                                <input type="file" single="" class="custom-file-input" id="customFile"
                                                    name="csv">
                                                <label class="custom-file-label"
                                                    for="customFile">{{ __('Choose file') }}</label>
                                            </div>
                                            <small>{{ __('only .csv file is applicable') }}</small>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row g-3">
                                <div class="col-lg-7 offset-lg-5">
                                    <div class="form-group mt-2">
                                        <button type="submit" class="btn btn-md btn-secondary"><em
                                                class="icon ni ni-upload mr-2"></em>{{ __('Upload') }}</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="tab-pane" id="tabItem2">
                        <a href="{{ route('dashboard.contact.export') }}"
                            class="btn btn-round btn-md btn-secondary">
                            <em class="icon ni ni-download mr-2"></em>
                            {{ __('Export Contacts As CSV File Format') }}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> <!-- .modal -->

@endsection

@section('js')

@endsection
