@extends('backend.layouts.master')

@section('title')
    {{ __('SMTP Settings') }}
@endsection

@section('css')
    
@endsection
    
@section('content')

<div class="card card-bordered">
                    <div class="card-inner">
                        <form action="{{ route('dashboard.smtp.store') }}" class="gy-3 form-validate is-alter" method="GET">
                            <div class="row g-3 align-center">
                                <div class="col-lg-5">
                                    <div class="form-group">
                                        <label class="form-label">{{ __('SMTP Driver') }}</label>
                                        <span class="form-note">{{ __('Choose mail driver') }}. {{ __('Ex: smtp, sendmail') }}</span>
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group">
                                        <div class="form-control-wrap">
                                            <input type="text" class="form-control" name="driver" id="site-email" value="{{ env('MAIL_MAILER') }}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row g-3 align-center">
                                <div class="col-lg-5">
                                    <div class="form-group">
                                        <label class="form-label">{{ __('Host') }}</label>
                                        <span class="form-note">{{ __('According to your server mail client') }}.</span>
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group">
                                        <div class="form-control-wrap">
                                            <input type="text" class="form-control" name="host" id="site-copyright" value="{{ env('MAIL_HOST') }}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row g-3 align-center">
                                <div class="col-lg-5">
                                    <div class="form-group">
                                        <label class="form-label">{{ __('Port') }}</label>
                                        <span class="form-note">{{ __('Mail port as') }} 587, 465, 25, 2525.</span>
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group">
                                        <div class="form-control-wrap">
                                            <input type="text" class="form-control" name="port" id="site-copyright" value="{{ env('MAIL_PORT') }}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row g-3 align-center">
                                <div class="col-lg-5">
                                    <div class="form-group">
                                        <label class="form-label">{{ __('Username') }}</label>
                                        <span class="form-note">{{ __('Mail account username') }}.</span>
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group">
                                        <div class="form-control-wrap">
                                            <input type="text" class="form-control" name="username" id="site-copyright" value="{{ env('MAIL_USERNAME') }}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row g-3 align-center">
                                <div class="col-lg-5">
                                    <div class="form-group">
                                        <label class="form-label">{{ __('Password') }}</label>
                                        <span class="form-note">{{ __('Mail account password') }}.</span>
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group">
                                        <div class="form-control-wrap">
                                            <input type="text" class="form-control" name="password" id="site-copyright" value="{{ env('MAIL_PASSWORD') }}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row g-3 align-center">
                                <div class="col-lg-5">
                                    <div class="form-group">
                                        <label class="form-label">{{ __('Email From Address') }}</label>
                                        <span class="form-note">{{ __('Set sender email address') }}.</span>
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group">
                                        <div class="form-control-wrap">
                                            <input type="text" class="form-control" name="from" id="site-copyright" value="{{ env('MAIL_FROM_ADDRESS') }}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row g-3 align-center">
                                <div class="col-lg-5">
                                    <div class="form-group">
                                        <label class="form-label">{{ __('Email From Name') }}</label>
                                        <span class="form-note">{{ __('Set sender name as email heading') }}.</span>
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group">
                                        <div class="form-control-wrap">
                                            <input type="text" class="form-control" name="from_name" id="site-copyright" value="{{ env('MAIL_FROM_NAME') }}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                          
                          
                            <div class="row g-3 align-center">
                                <div class="col-lg-5">
                                    <div class="form-group">
                                        <label class="form-label">{{ __('Encryption') }}</label>
                                        <span class="form-note">{{ __('Mail encryption as') }} 'ssl' {{ __('if you face issue with') }} 'tls'.</span>
                                    </div>
                                </div>
                                <div class="col-lg-7">
                                    <div class="form-group">
                                        <div class="form-control-wrap">
                                            <select class="form-select" single="single" data-placeholder="Select Encryption Type" name="encryption">
                                                <option value="" {{ env('MAIL_ENCRYPTION') === '' ? 'selected' : null }}>{{ __('No Encryption') }}</option>
                                                <option value="tls" {{ env('MAIL_ENCRYPTION') === 'tls' ? 'selected' : null }}>{{ __('TLS') }}</option>
                                                <option value="ssl" {{ env('MAIL_ENCRYPTION') === 'ssl' ? 'selected' : null }}>{{ __('SSL') }}</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                         
                            <div class="row g-3">
                                <div class="col-lg-7 offset-lg-5">
                                    <div class="form-group mt-2">
                                        <button type="submit" class="btn btn-lg btn-secondary">{{ __('Submit') }}</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div><!-- card -->
            
@endsection

@section('js')
    
@endsection