<?php

use App\Http\Controllers\IvrController;
use Illuminate\Support\Facades\Route;

Route::group(['middleware' => ['auth', 'otp.verified', 'kyc.verified'], 'prefix' => 'dashboard'], function () {
    Route::get('/ivr', [IvrController::class, 'index'])->name('dashboard.ivr.index'); // Route name: dashboard.ivr.index
    Route::get('/ivr/create', [IvrController::class, 'create'])->name('dashboard.ivr.create'); // Route name: dashboard.ivr.create
    Route::post('/ivr/store', [IvrController::class, 'store'])->name('dashboard.ivr.store'); // Route name: dashboard.ivr.store
    Route::get('/ivr/show/{id}', [IvrController::class, 'show'])->name('dashboard.ivr.show'); // Route name: dashboard.ivr.show
    Route::post('/ivr/update/{id}', [IvrController::class, 'update'])->name('dashboard.ivr.update'); // Route name: dashboard.ivr.update
    Route::post('/ivr/destroy/{id}', [IvrController::class, 'destroy'])->name('dashboard.ivr.destroy'); // Route name: dashboard.ivr.destroy

    // calling
    Route::get('/ivr/calling/{campaign_id}/{user_id}/{campaign_slug}', [IvrController::class, 'calling'])->name('dashboard.ivr.calling'); // Route name: dashboard.ivr.calling
});

Route::get('/ivr/log/{digit?}', [IvrController::class, 'response_log'])->name('dashboard.ivr.response_log'); // Route name: dashboard.ivr.log